#ifndef HC06_BLUETOOTH_H
#define HC06_BLUETOOTH_H

Serial bt(PTE16, PTE17);

char bt_c;
char bt_buffer[80];
char bt_name[80];
int bt_pin;
int bt_count;
int i;
int action;
int bt_baud[10]={0,1200,2400,4800,9600,19200,38400,57600,115200,230400};
int bt_baud_select=4;

int bt_baud_decode(int baud)
{
    int target_baud;
    target_baud=0;
    if(baud >= 1 && baud <= 9)
    {
        target_baud=baud;
    }
    else
    {
        for(int i = 1; i <=9, i++)
        {
            if(baud ==  bt_baud(i))
            {
                target_baud=baud;           
            }
        }
    }
    if(target_baud >0)
    {
        return(bt_baud(target_baud));
    }
    else
    {
        return(-1);   
    }    
}

int bt_baud(int baud);
{
    int target_baud;
    target_baud=bt_baud_decode(baud);
    if(target_baud > 0)
    {
        bt.baud(bt_baud(target_baud));
        return(bt_baud(target_baud));
    }
    else
    {
        return(-1);   
    }     
}

int bt_find_baud()
{
    
    for(bt_baud_select=1; bt_baud_select<=9; bt_baud_select++)
    {
//        pc.printf("Trying case %1i: %i baud\n",bt_baud_select,bt_baud[bt_baud_select]);
        bt.baud(bt_baud[bt_baud_select]);
//        pc.printf("Sending \"AT\"\n");
        bt_count=0;
        bt_buffer[0]=0;
        bt_buffer[1]=0;
        bt.printf("AT");  /*ask bluetooth for response, expect "OK" */
//        bt.printf("AT\r\n");  /*ask bluetooth for response, expect "OK" */

        for( i=0; i<10000000; i++)
        {
            if(bt.readable())
            {
                bt_buffer[bt_count]=bt.getc();
                pc.putc(bt_buffer[bt_count]);
                if(bt_count==0 && bt_buffer[0]=='O')
                    {bt_count++;}
                if(bt_count==1 && bt_buffer[1]=='K')
                    {bt_count++; break;}
            }
        }
        if(bt_buffer[0]=='O' && bt_buffer[1]=='K')
        {
//            pc.printf("\nReceived \"OK\" at case %1i: %i baud\n",bt_baud_select,bt_baud[bt_baud_select]);
            break;
        }
        else
        {
//             pc.printf("\nFailed to receive \"OK\" at case %1i: %i baud\n",bt_baud_select,bt_baud[bt_baud_select]);
        }           
    }
    if(bt_baud_select > 9)
    {
//        pc.printf("Unable to identify HC-06 Bluetooth baud rate.\nShutting down.\n");
        return(-1);
    }
    else
    {
        return(bt_baud[bt_baud_select]);
    }        
}

int bt_default_baud(int baud);
{
    int target_baud;
    target_baud=lcd_baud_decode(baud);
    if(target_baud < 0)
    {
        return(-1);   
    }  
    bt_baud(bt_find_baud());
    bt.printf("AT+BAUD%1i",target_baud);
    bt_baud(target_baud);
    for( i=0; i<10000000; i++)
    {
        if(bt.readable())
        {
            bt.getc();
        }
    } 
    return(bt_baud[target_baud]);
}

int bt_device_name(char bt_name[])
{
    bt.printf("AT+NAME%s",bt_name);
    for( i=0; i<10000000; i++)
    {
        if(bt.readable())
        {
            bt.getc();
        }
    }        
}

int bt_set_pin(int bt_pin)
{
    if(bt_pin < 0 || bt_pin > 9999) {return(-1);}
    bt.printf("AT+PIN%04i",bt_pin);
    for( i=0; i<10000000; i++)
    {
        if(bt.readable())
        {
            bt.getc();
        }
    }  

}


#endif //HC06_BLUETOOTH_H