/*
ES200 3321 Project 2 Team Crab Race
MIDN 3/c Pak, Tamas, etc
*/
#include "mbed.h"
#include "stdio.h"
#include "Motor.h"
#include "Servo.h"

// declare global hardware objects
Serial pc(USBTX,USBRX); // for printing out stuff during debugging
Motor knife_motor(p26, p30, p29);
Servo finish_servo(p22);
Servo start_servo(p21);

// where are your switches?  you need a few
DigitalIn start_sw(p19);

// need LEDs (they're supposed to be external LEDs!)
DigitalOut led[4]= {LED1, LED2, LED3, LED4};





int main(void)
{
    int x; // for random outcome of race
    int i; // a counter variable

    // setup
    pc.printf("ES200 3321 Project 2 Team Crab Race\r\n");
    pc.printf("main() thread running\r\n");
    pc.printf("main() thread calibrating servos\r\n");
    start_servo.calibrate(0.0009, 90.0); // HiTec HS422 servos for ES200/202
    finish_servo.calibrate(0.0009, 90.0);
    start_servo.write(0.0);  // set start gate initial position
    finish_servo.write(0.5);  // set finish gate initial position
    knife_motor.speed(0.0); // stop knife motor

    // main loop
    while(1) {

        // STATE: IDLE
        pc.printf("main() thread idle state\r\n");
        start_servo.write(0.0);
        finish_servo.write(0.5);
        while (!start_sw.read()) {
            ThisThread::sleep_for(200); // works like wait()
        }


        // STATE: START RACE
        x = (rand()%10)+1;
        pc.printf("main() thread starting a race, x = %d\r\n",x);
        start_servo.write(0.25); // lower start gate to begin race
        ThisThread::sleep_for(1000); //gives time for crab to get down track


        // STATE: END RACE depending on value of x
        pc.printf("main() thread preparing to end race\r\n");
        start_servo.write(0.0); //set initial start gate position
        if (x <= 7) {
            pc.printf("main() thread for x = %d, victory display\r\n",x);
            finish_servo = 1.0; //gate has a 70% chance to go one way
            pc.printf("main() thread waiting for start_sw to stop display\r\n");
            while (start_sw.read()) {
                for (i=0; i<5; i++) {
                    // blink lights for victory display
                    led[i] = 1;
                    ThisThread::sleep_for(150);
                    led[i]=0;
                } // for
            } // while(start_sw.read())
        } // if (x<=7)
        else { //30% chance the gate will go the other way
            pc.printf("main() thread for x = %d, fatality display\r\n",x);
            finish_servo.write(0.0);
            pc.printf("main() thread waiting for start_sw to stop display\r\n");
            while (start_sw.read()) {
                knife_motor.speed (0.5);
                ThisThread::sleep_for(500);
                knife_motor.speed (-0.5);
                ThisThread::sleep_for(500);
            } // while(start_sw.read())
            knife_motor.speed(0); // stop knife
        }
        pc.printf("main() thread returning to idle state, reset the racer positions\r\n");
        finish_servo.write(0.5); //set finish gate to halfway point


    } // while(1)
} // main()