#include "mbed.h"
#include "keypad.h"
#include "TextLCD.h"
#include "stdlib.h" //opcional

/*******************ELECTROVALVULAS********************/

DigitalOut E_1(D8,0);             //Control de electrovalvula 1
DigitalOut E_2(D9,0);             //Control de electrovalvula 2
DigitalOut E_3(D10,0);             //Control de electrovalvula 3
DigitalOut E_4(D12,0);             //Control de electrovalvula 4
AnalogIn sensor_level(A0);      //Sensor nivel tanque 1
PwmOut motor(PA_5);             //variable temporal para el motor (se cambiará después)
/*****************************************************/



/*******************INTERRUPCIONES********************/

InterruptIn button(USER_BUTTON);
Ticker check_level;
Ticker up;
Ticker down;

Timeout t_1;
Timeout t_2;
Timeout t_3;
Timeout t_4;

//tiempos de usuario
int temp_user_1=5;                      //tiempo tope de electrocoagulacion
int temp_user_2=5;                      //tiempo tope de reposo de la vinaza
int temp_user_3=5;                      //tiempo tope de vaciado del agua en el tanque 2
int temp_user_4=5;                      //tiempo tope de vaciado de residuos en el tanque 2
int pwm=5;


//timers
Timer timer_1;
Timer timer_2;
Timer timer_3;

/********************TECLADO Y LCD***********************/

//          rs, e,d4,d5,d6,d7
TextLCD lcd(PC_8,PC_9,PC_10,PC_11,PC_12,PD_2);


Keypad keypad(D3, D2, D1, D0, D7, D6, D5, D4);
float num=0;
char cadena[3]= {' ',' ',' '};
int llena=0; //verificar que la entrada es de 3 numeros
int blinker = 1;

/*********************FUNCIONES**************************/

void stop()  //STOP
{
    while(1) {
        lcd.cls();
        lcd.printf("      STOP!");
        lcd.locate(0,1);
        lcd.printf("  PLEASE RESET");
        wait_ms(150);
    }
}

void level()
{
    if(sensor_level>=3) {
        E_1=0;
    }
}

void electro_1()
{
    E_1=!E_1;
}

void electro_2()
{
    E_2=!E_2;
}

void electro_3()
{
    E_3=!E_3;
}

void electro_4()
{
    E_4=!E_4;
}

void printLCD(){
    while(1){
        lcd.cls();
        lcd.locate(0,0);
            lcd.printf("t1=%d",temp_user_1);
        lcd.locate(6,0);
            lcd.printf("t2=%d",temp_user_2);
        lcd.locate(0,1);
            lcd.printf("t3=%d",temp_user_3);
        lcd.locate(6,1);
            lcd.printf("t4=%d",temp_user_4);
        lcd.locate(12,0);
            lcd.printf("PWM");
        lcd.locate(12,1);
            lcd.printf("%d",pwm);
        wait_ms(350);
        switch(blinker){
            case  1:
                lcd.locate(0,0);
                lcd.printf("t1=   ",temp_user_1); break;
            case  2:
                lcd.locate(6,0);
                lcd.printf("t2=   ",temp_user_2); break;
            case  3:
                lcd.locate(0,1);
                lcd.printf("t3=   ",temp_user_3); break;
            case  4:
                lcd.locate(6,1);
                lcd.printf("t4=   ",temp_user_4); break;       
            case  5:
                lcd.locate(12,1);
                lcd.printf("   ");
            default: ; break;
        }
        wait_ms(350);    
    }   
}

int getNum(){
    while(1){
        char key = keypad.getKey();
        switch(key) {
            case '0': return 0;
            case '1': return 1;
            case '2': return 2;
            case '3': return 3;
            case '4': return 4;
            case '5': return 5;
            case '6': return 6;
            case '7': return 7;
            case '8': return 8;
            case '9': return 9;
            case 'A': 
                blinker++;
                if(blinker==6) blinker=1; return -1;
            default: ; break;
        }
        wait_ms(100);
    }
}            

/***********************MAIN***************************/

int main()
{
    button.rise(&stop);
    keypad.enablePullUp();
    wait(1);
    lcd.locate(0,0);
    lcd.printf("  Control para\n");
    lcd.locate(0,1);
    lcd.printf("electrocoagular\n");
    wait(1.5);
    lcd.cls();
    int a=0;
    int b=0;
    int c=0;

    Thread lcdprint;
    lcdprint.start(printLCD);
    
    while(1) {      
        setvalue:
        a=100*getNum();
        wait_ms(250);
        if(a<0)goto setvalue;
        b=10*getNum();
        wait_ms(250);
        if(b<0)goto setvalue;
        c=getNum(); 
        wait_ms(250);
        if(c<0)goto setvalue;
        
        switch(blinker){
        case 1:
            temp_user_1=a+b+c; break;
        case 2:
            temp_user_2=a+b+c; break;
        case 3:
            temp_user_3=a+b+c; break;
        case 4:
            temp_user_4=a+b+c; break;
        case 5:
            pwm=a+b+c;         break;
        }
        wait_ms(150);

    }//termina while de main
}//termina main
