/*
** ###################################################################
**     Compilers:           Keil ARM C/C++ Compiler
**                          Freescale C/C++ for Embedded ARM
**                          GNU C Compiler
**                          IAR ANSI C/C++ Compiler for ARM
**
**     Reference manual:    K64P144M120SF5RM, Rev.2, January 2014
**     Version:             rev. 2.5, 2014-02-10
**     Build:               b140604
**
**     Abstract:
**         Extension to the CMSIS register access layer header.
**
**     Copyright (c) 2014 Freescale Semiconductor, Inc.
**     All rights reserved.
**
**     Redistribution and use in source and binary forms, with or without modification,
**     are permitted provided that the following conditions are met:
**
**     o Redistributions of source code must retain the above copyright notice, this list
**       of conditions and the following disclaimer.
**
**     o Redistributions in binary form must reproduce the above copyright notice, this
**       list of conditions and the following disclaimer in the documentation and/or
**       other materials provided with the distribution.
**
**     o Neither the name of Freescale Semiconductor, Inc. nor the names of its
**       contributors may be used to endorse or promote products derived from this
**       software without specific prior written permission.
**
**     THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
**     ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
**     WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
**     DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
**     ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
**     (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
**     LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
**     ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
**     (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
**     SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
**     http:                 www.freescale.com
**     mail:                 support@freescale.com
**
**     Revisions:
**     - rev. 1.0 (2013-08-12)
**         Initial version.
**     - rev. 2.0 (2013-10-29)
**         Register accessor macros added to the memory map.
**         Symbols for Processor Expert memory map compatibility added to the memory map.
**         Startup file for gcc has been updated according to CMSIS 3.2.
**         System initialization updated.
**         MCG - registers updated.
**         PORTA, PORTB, PORTC, PORTE - registers for digital filter removed.
**     - rev. 2.1 (2013-10-30)
**         Definition of BITBAND macros updated to support peripherals with 32-bit acces disabled.
**     - rev. 2.2 (2013-12-09)
**         DMA - EARS register removed.
**         AIPS0, AIPS1 - MPRA register updated.
**     - rev. 2.3 (2014-01-24)
**         Update according to reference manual rev. 2
**         ENET, MCG, MCM, SIM, USB - registers updated
**     - rev. 2.4 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK64F12.h
**         Update of SystemInit() and SystemCoreClockUpdate() functions.
**     - rev. 2.5 (2014-02-10)
**         The declaration of clock configurations has been moved to separate header file system_MK64F12.h
**         Update of SystemInit() and SystemCoreClockUpdate() functions.
**         Module access macro module_BASES replaced by module_BASE_PTRS.
**
** ###################################################################
*/

/*
 * WARNING! DO NOT EDIT THIS FILE DIRECTLY!
 *
 * This file was generated automatically and any changes may be lost.
 */
#ifndef __HW_DMA_REGISTERS_H__
#define __HW_DMA_REGISTERS_H__

#include "MK64F12.h"
#include "fsl_bitaccess.h"

/*
 * MK64F12 DMA
 *
 * Enhanced direct memory access controller
 *
 * Registers defined in this header file:
 * - HW_DMA_CR - Control Register
 * - HW_DMA_ES - Error Status Register
 * - HW_DMA_ERQ - Enable Request Register
 * - HW_DMA_EEI - Enable Error Interrupt Register
 * - HW_DMA_CEEI - Clear Enable Error Interrupt Register
 * - HW_DMA_SEEI - Set Enable Error Interrupt Register
 * - HW_DMA_CERQ - Clear Enable Request Register
 * - HW_DMA_SERQ - Set Enable Request Register
 * - HW_DMA_CDNE - Clear DONE Status Bit Register
 * - HW_DMA_SSRT - Set START Bit Register
 * - HW_DMA_CERR - Clear Error Register
 * - HW_DMA_CINT - Clear Interrupt Request Register
 * - HW_DMA_INT - Interrupt Request Register
 * - HW_DMA_ERR - Error Register
 * - HW_DMA_HRS - Hardware Request Status Register
 * - HW_DMA_DCHPRIn - Channel n Priority Register
 * - HW_DMA_TCDn_SADDR - TCD Source Address
 * - HW_DMA_TCDn_SOFF - TCD Signed Source Address Offset
 * - HW_DMA_TCDn_ATTR - TCD Transfer Attributes
 * - HW_DMA_TCDn_NBYTES_MLNO - TCD Minor Byte Count (Minor Loop Disabled)
 * - HW_DMA_TCDn_NBYTES_MLOFFNO - TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled)
 * - HW_DMA_TCDn_NBYTES_MLOFFYES - TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled)
 * - HW_DMA_TCDn_SLAST - TCD Last Source Address Adjustment
 * - HW_DMA_TCDn_DADDR - TCD Destination Address
 * - HW_DMA_TCDn_DOFF - TCD Signed Destination Address Offset
 * - HW_DMA_TCDn_CITER_ELINKNO - TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
 * - HW_DMA_TCDn_CITER_ELINKYES - TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled)
 * - HW_DMA_TCDn_DLASTSGA - TCD Last Destination Address Adjustment/Scatter Gather Address
 * - HW_DMA_TCDn_CSR - TCD Control and Status
 * - HW_DMA_TCDn_BITER_ELINKNO - TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
 * - HW_DMA_TCDn_BITER_ELINKYES - TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled)
 *
 * - hw_dma_t - Struct containing all module registers.
 */

#define HW_DMA_INSTANCE_COUNT (1U) /*!< Number of instances of the DMA module. */

/*******************************************************************************
 * HW_DMA_CR - Control Register
 ******************************************************************************/

/*!
 * @brief HW_DMA_CR - Control Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The CR defines the basic operating configuration of the DMA. Arbitration can
 * be configured to use either a fixed-priority or a round-robin scheme. For
 * fixed-priority arbitration, the highest priority channel requesting service is
 * selected to execute. The channel priority registers assign the priorities; see
 * the DCHPRIn registers. For round-robin arbitration, the channel priorities are
 * ignored and channels are cycled through (from high to low channel number)
 * without regard to priority. For correct operation, writes to the CR register must
 * be performed only when the DMA channels are inactive; that is, when
 * TCDn_CSR[ACTIVE] bits are cleared. Minor loop offsets are address offset values added to
 * the final source address (TCDn_SADDR) or destination address (TCDn_DADDR) upon
 * minor loop completion. When minor loop offsets are enabled, the minor loop
 * offset (MLOFF) is added to the final source address (TCDn_SADDR), to the final
 * destination address (TCDn_DADDR), or to both prior to the addresses being
 * written back into the TCD. If the major loop is complete, the minor loop offset is
 * ignored and the major loop address offsets (TCDn_SLAST and TCDn_DLAST_SGA) are
 * used to compute the next TCDn_SADDR and TCDn_DADDR values. When minor loop
 * mapping is enabled (EMLM is 1), TCDn word2 is redefined. A portion of TCDn word2
 * is used to specify multiple fields: a source enable bit (SMLOE) to specify
 * the minor loop offset should be applied to the source address (TCDn_SADDR) upon
 * minor loop completion, a destination enable bit (DMLOE) to specify the minor
 * loop offset should be applied to the destination address (TCDn_DADDR) upon
 * minor loop completion, and the sign extended minor loop offset value (MLOFF). The
 * same offset value (MLOFF) is used for both source and destination minor loop
 * offsets. When either minor loop offset is enabled (SMLOE set or DMLOE set), the
 * NBYTES field is reduced to 10 bits. When both minor loop offsets are disabled
 * (SMLOE cleared and DMLOE cleared), the NBYTES field is a 30-bit vector. When
 * minor loop mapping is disabled (EMLM is 0), all 32 bits of TCDn word2 are
 * assigned to the NBYTES field.
 */
typedef union _hw_dma_cr
{
    uint32_t U;
    struct _hw_dma_cr_bitfields
    {
        uint32_t RESERVED0 : 1;        /*!< [0] Reserved. */
        uint32_t EDBG : 1;             /*!< [1] Enable Debug */
        uint32_t ERCA : 1;             /*!< [2] Enable Round Robin Channel Arbitration */
        uint32_t RESERVED1 : 1;        /*!< [3] Reserved. */
        uint32_t HOE : 1;              /*!< [4] Halt On Error */
        uint32_t HALT : 1;             /*!< [5] Halt DMA Operations */
        uint32_t CLM : 1;              /*!< [6] Continuous Link Mode */
        uint32_t EMLM : 1;             /*!< [7] Enable Minor Loop Mapping */
        uint32_t RESERVED2 : 8;        /*!< [15:8]  */
        uint32_t ECX : 1;              /*!< [16] Error Cancel Transfer */
        uint32_t CX : 1;               /*!< [17] Cancel Transfer */
        uint32_t RESERVED3 : 14;       /*!< [31:18]  */
    } B;
} hw_dma_cr_t;

/*!
 * @name Constants and macros for entire DMA_CR register
 */
/*@{*/
#define HW_DMA_CR_ADDR(x)        ((x) + 0x0U)

#define HW_DMA_CR(x)             (*(__IO hw_dma_cr_t *) HW_DMA_CR_ADDR(x))
#define HW_DMA_CR_RD(x)          (HW_DMA_CR(x).U)
#define HW_DMA_CR_WR(x, v)       (HW_DMA_CR(x).U = (v))
#define HW_DMA_CR_SET(x, v)      (HW_DMA_CR_WR(x, HW_DMA_CR_RD(x) |  (v)))
#define HW_DMA_CR_CLR(x, v)      (HW_DMA_CR_WR(x, HW_DMA_CR_RD(x) & ~(v)))
#define HW_DMA_CR_TOG(x, v)      (HW_DMA_CR_WR(x, HW_DMA_CR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DMA_CR bitfields
 */

/*!
 * @name Register DMA_CR, field EDBG[1] (RW)
 *
 * Values:
 * - 0 - When in debug mode, the DMA continues to operate.
 * - 1 - When in debug mode, the DMA stalls the start of a new channel.
 *     Executing channels are allowed to complete. Channel execution resumes when the
 *     system exits debug mode or the EDBG bit is cleared.
 */
/*@{*/
#define BP_DMA_CR_EDBG       (1U)          /*!< Bit position for DMA_CR_EDBG. */
#define BM_DMA_CR_EDBG       (0x00000002U) /*!< Bit mask for DMA_CR_EDBG. */
#define BS_DMA_CR_EDBG       (1U)          /*!< Bit field size in bits for DMA_CR_EDBG. */

/*! @brief Read current value of the DMA_CR_EDBG field. */
#define BR_DMA_CR_EDBG(x)    (BITBAND_ACCESS32(HW_DMA_CR_ADDR(x), BP_DMA_CR_EDBG))

/*! @brief Format value for bitfield DMA_CR_EDBG. */
#define BF_DMA_CR_EDBG(v)    ((uint32_t)((uint32_t)(v) << BP_DMA_CR_EDBG) & BM_DMA_CR_EDBG)

/*! @brief Set the EDBG field to a new value. */
#define BW_DMA_CR_EDBG(x, v) (BITBAND_ACCESS32(HW_DMA_CR_ADDR(x), BP_DMA_CR_EDBG) = (v))
/*@}*/

/*!
 * @name Register DMA_CR, field ERCA[2] (RW)
 *
 * Values:
 * - 0 - Fixed priority arbitration is used for channel selection .
 * - 1 - Round robin arbitration is used for channel selection .
 */
/*@{*/
#define BP_DMA_CR_ERCA       (2U)          /*!< Bit position for DMA_CR_ERCA. */
#define BM_DMA_CR_ERCA       (0x00000004U) /*!< Bit mask for DMA_CR_ERCA. */
#define BS_DMA_CR_ERCA       (1U)          /*!< Bit field size in bits for DMA_CR_ERCA. */

/*! @brief Read current value of the DMA_CR_ERCA field. */
#define BR_DMA_CR_ERCA(x)    (BITBAND_ACCESS32(HW_DMA_CR_ADDR(x), BP_DMA_CR_ERCA))

/*! @brief Format value for bitfield DMA_CR_ERCA. */
#define BF_DMA_CR_ERCA(v)    ((uint32_t)((uint32_t)(v) << BP_DMA_CR_ERCA) & BM_DMA_CR_ERCA)

/*! @brief Set the ERCA field to a new value. */
#define BW_DMA_CR_ERCA(x, v) (BITBAND_ACCESS32(HW_DMA_CR_ADDR(x), BP_DMA_CR_ERCA) = (v))
/*@}*/

/*!
 * @name Register DMA_CR, field HOE[4] (RW)
 *
 * Values:
 * - 0 - Normal operation
 * - 1 - Any error causes the HALT bit to set. Subsequently, all service
 *     requests are ignored until the HALT bit is cleared.
 */
/*@{*/
#define BP_DMA_CR_HOE        (4U)          /*!< Bit position for DMA_CR_HOE. */
#define BM_DMA_CR_HOE        (0x00000010U) /*!< Bit mask for DMA_CR_HOE. */
#define BS_DMA_CR_HOE        (1U)          /*!< Bit field size in bits for DMA_CR_HOE. */

/*! @brief Read current value of the DMA_CR_HOE field. */
#define BR_DMA_CR_HOE(x)     (BITBAND_ACCESS32(HW_DMA_CR_ADDR(x), BP_DMA_CR_HOE))

/*! @brief Format value for bitfield DMA_CR_HOE. */
#define BF_DMA_CR_HOE(v)     ((uint32_t)((uint32_t)(v) << BP_DMA_CR_HOE) & BM_DMA_CR_HOE)

/*! @brief Set the HOE field to a new value. */
#define BW_DMA_CR_HOE(x, v)  (BITBAND_ACCESS32(HW_DMA_CR_ADDR(x), BP_DMA_CR_HOE) = (v))
/*@}*/

/*!
 * @name Register DMA_CR, field HALT[5] (RW)
 *
 * Values:
 * - 0 - Normal operation
 * - 1 - Stall the start of any new channels. Executing channels are allowed to
 *     complete. Channel execution resumes when this bit is cleared.
 */
/*@{*/
#define BP_DMA_CR_HALT       (5U)          /*!< Bit position for DMA_CR_HALT. */
#define BM_DMA_CR_HALT       (0x00000020U) /*!< Bit mask for DMA_CR_HALT. */
#define BS_DMA_CR_HALT       (1U)          /*!< Bit field size in bits for DMA_CR_HALT. */

/*! @brief Read current value of the DMA_CR_HALT field. */
#define BR_DMA_CR_HALT(x)    (BITBAND_ACCESS32(HW_DMA_CR_ADDR(x), BP_DMA_CR_HALT))

/*! @brief Format value for bitfield DMA_CR_HALT. */
#define BF_DMA_CR_HALT(v)    ((uint32_t)((uint32_t)(v) << BP_DMA_CR_HALT) & BM_DMA_CR_HALT)

/*! @brief Set the HALT field to a new value. */
#define BW_DMA_CR_HALT(x, v) (BITBAND_ACCESS32(HW_DMA_CR_ADDR(x), BP_DMA_CR_HALT) = (v))
/*@}*/

/*!
 * @name Register DMA_CR, field CLM[6] (RW)
 *
 * Values:
 * - 0 - A minor loop channel link made to itself goes through channel
 *     arbitration before being activated again.
 * - 1 - A minor loop channel link made to itself does not go through channel
 *     arbitration before being activated again. Upon minor loop completion, the
 *     channel activates again if that channel has a minor loop channel link
 *     enabled and the link channel is itself. This effectively applies the minor loop
 *     offsets and restarts the next minor loop.
 */
/*@{*/
#define BP_DMA_CR_CLM        (6U)          /*!< Bit position for DMA_CR_CLM. */
#define BM_DMA_CR_CLM        (0x00000040U) /*!< Bit mask for DMA_CR_CLM. */
#define BS_DMA_CR_CLM        (1U)          /*!< Bit field size in bits for DMA_CR_CLM. */

/*! @brief Read current value of the DMA_CR_CLM field. */
#define BR_DMA_CR_CLM(x)     (BITBAND_ACCESS32(HW_DMA_CR_ADDR(x), BP_DMA_CR_CLM))

/*! @brief Format value for bitfield DMA_CR_CLM. */
#define BF_DMA_CR_CLM(v)     ((uint32_t)((uint32_t)(v) << BP_DMA_CR_CLM) & BM_DMA_CR_CLM)

/*! @brief Set the CLM field to a new value. */
#define BW_DMA_CR_CLM(x, v)  (BITBAND_ACCESS32(HW_DMA_CR_ADDR(x), BP_DMA_CR_CLM) = (v))
/*@}*/

/*!
 * @name Register DMA_CR, field EMLM[7] (RW)
 *
 * Values:
 * - 0 - Disabled. TCDn.word2 is defined as a 32-bit NBYTES field.
 * - 1 - Enabled. TCDn.word2 is redefined to include individual enable fields,
 *     an offset field, and the NBYTES field. The individual enable fields allow
 *     the minor loop offset to be applied to the source address, the destination
 *     address, or both. The NBYTES field is reduced when either offset is
 *     enabled.
 */
/*@{*/
#define BP_DMA_CR_EMLM       (7U)          /*!< Bit position for DMA_CR_EMLM. */
#define BM_DMA_CR_EMLM       (0x00000080U) /*!< Bit mask for DMA_CR_EMLM. */
#define BS_DMA_CR_EMLM       (1U)          /*!< Bit field size in bits for DMA_CR_EMLM. */

/*! @brief Read current value of the DMA_CR_EMLM field. */
#define BR_DMA_CR_EMLM(x)    (BITBAND_ACCESS32(HW_DMA_CR_ADDR(x), BP_DMA_CR_EMLM))

/*! @brief Format value for bitfield DMA_CR_EMLM. */
#define BF_DMA_CR_EMLM(v)    ((uint32_t)((uint32_t)(v) << BP_DMA_CR_EMLM) & BM_DMA_CR_EMLM)

/*! @brief Set the EMLM field to a new value. */
#define BW_DMA_CR_EMLM(x, v) (BITBAND_ACCESS32(HW_DMA_CR_ADDR(x), BP_DMA_CR_EMLM) = (v))
/*@}*/

/*!
 * @name Register DMA_CR, field ECX[16] (RW)
 *
 * Values:
 * - 0 - Normal operation
 * - 1 - Cancel the remaining data transfer in the same fashion as the CX bit.
 *     Stop the executing channel and force the minor loop to finish. The cancel
 *     takes effect after the last write of the current read/write sequence. The
 *     ECX bit clears itself after the cancel is honored. In addition to
 *     cancelling the transfer, ECX treats the cancel as an error condition, thus updating
 *     the Error Status register (DMAx_ES) and generating an optional error
 *     interrupt.
 */
/*@{*/
#define BP_DMA_CR_ECX        (16U)         /*!< Bit position for DMA_CR_ECX. */
#define BM_DMA_CR_ECX        (0x00010000U) /*!< Bit mask for DMA_CR_ECX. */
#define BS_DMA_CR_ECX        (1U)          /*!< Bit field size in bits for DMA_CR_ECX. */

/*! @brief Read current value of the DMA_CR_ECX field. */
#define BR_DMA_CR_ECX(x)     (BITBAND_ACCESS32(HW_DMA_CR_ADDR(x), BP_DMA_CR_ECX))

/*! @brief Format value for bitfield DMA_CR_ECX. */
#define BF_DMA_CR_ECX(v)     ((uint32_t)((uint32_t)(v) << BP_DMA_CR_ECX) & BM_DMA_CR_ECX)

/*! @brief Set the ECX field to a new value. */
#define BW_DMA_CR_ECX(x, v)  (BITBAND_ACCESS32(HW_DMA_CR_ADDR(x), BP_DMA_CR_ECX) = (v))
/*@}*/

/*!
 * @name Register DMA_CR, field CX[17] (RW)
 *
 * Values:
 * - 0 - Normal operation
 * - 1 - Cancel the remaining data transfer. Stop the executing channel and
 *     force the minor loop to finish. The cancel takes effect after the last write
 *     of the current read/write sequence. The CX bit clears itself after the
 *     cancel has been honored. This cancel retires the channel normally as if the
 *     minor loop was completed.
 */
/*@{*/
#define BP_DMA_CR_CX         (17U)         /*!< Bit position for DMA_CR_CX. */
#define BM_DMA_CR_CX         (0x00020000U) /*!< Bit mask for DMA_CR_CX. */
#define BS_DMA_CR_CX         (1U)          /*!< Bit field size in bits for DMA_CR_CX. */

/*! @brief Read current value of the DMA_CR_CX field. */
#define BR_DMA_CR_CX(x)      (BITBAND_ACCESS32(HW_DMA_CR_ADDR(x), BP_DMA_CR_CX))

/*! @brief Format value for bitfield DMA_CR_CX. */
#define BF_DMA_CR_CX(v)      ((uint32_t)((uint32_t)(v) << BP_DMA_CR_CX) & BM_DMA_CR_CX)

/*! @brief Set the CX field to a new value. */
#define BW_DMA_CR_CX(x, v)   (BITBAND_ACCESS32(HW_DMA_CR_ADDR(x), BP_DMA_CR_CX) = (v))
/*@}*/

/*******************************************************************************
 * HW_DMA_ES - Error Status Register
 ******************************************************************************/

/*!
 * @brief HW_DMA_ES - Error Status Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * The ES provides information concerning the last recorded channel error.
 * Channel errors can be caused by: A configuration error, that is: An illegal setting
 * in the transfer-control descriptor, or An illegal priority register setting
 * in fixed-arbitration An error termination to a bus master read or write cycle
 * See the Error Reporting and Handling section for more details.
 */
typedef union _hw_dma_es
{
    uint32_t U;
    struct _hw_dma_es_bitfields
    {
        uint32_t DBE : 1;              /*!< [0] Destination Bus Error */
        uint32_t SBE : 1;              /*!< [1] Source Bus Error */
        uint32_t SGE : 1;              /*!< [2] Scatter/Gather Configuration Error */
        uint32_t NCE : 1;              /*!< [3] NBYTES/CITER Configuration Error */
        uint32_t DOE : 1;              /*!< [4] Destination Offset Error */
        uint32_t DAE : 1;              /*!< [5] Destination Address Error */
        uint32_t SOE : 1;              /*!< [6] Source Offset Error */
        uint32_t SAE : 1;              /*!< [7] Source Address Error */
        uint32_t ERRCHN : 4;           /*!< [11:8] Error Channel Number or Canceled
                                        * Channel Number */
        uint32_t RESERVED0 : 2;        /*!< [13:12]  */
        uint32_t CPE : 1;              /*!< [14] Channel Priority Error */
        uint32_t RESERVED1 : 1;        /*!< [15]  */
        uint32_t ECX : 1;              /*!< [16] Transfer Canceled */
        uint32_t RESERVED2 : 14;       /*!< [30:17]  */
        uint32_t VLD : 1;              /*!< [31]  */
    } B;
} hw_dma_es_t;

/*!
 * @name Constants and macros for entire DMA_ES register
 */
/*@{*/
#define HW_DMA_ES_ADDR(x)        ((x) + 0x4U)

#define HW_DMA_ES(x)             (*(__I hw_dma_es_t *) HW_DMA_ES_ADDR(x))
#define HW_DMA_ES_RD(x)          (HW_DMA_ES(x).U)
/*@}*/

/*
 * Constants & macros for individual DMA_ES bitfields
 */

/*!
 * @name Register DMA_ES, field DBE[0] (RO)
 *
 * Values:
 * - 0 - No destination bus error
 * - 1 - The last recorded error was a bus error on a destination write
 */
/*@{*/
#define BP_DMA_ES_DBE        (0U)          /*!< Bit position for DMA_ES_DBE. */
#define BM_DMA_ES_DBE        (0x00000001U) /*!< Bit mask for DMA_ES_DBE. */
#define BS_DMA_ES_DBE        (1U)          /*!< Bit field size in bits for DMA_ES_DBE. */

/*! @brief Read current value of the DMA_ES_DBE field. */
#define BR_DMA_ES_DBE(x)     (BITBAND_ACCESS32(HW_DMA_ES_ADDR(x), BP_DMA_ES_DBE))
/*@}*/

/*!
 * @name Register DMA_ES, field SBE[1] (RO)
 *
 * Values:
 * - 0 - No source bus error
 * - 1 - The last recorded error was a bus error on a source read
 */
/*@{*/
#define BP_DMA_ES_SBE        (1U)          /*!< Bit position for DMA_ES_SBE. */
#define BM_DMA_ES_SBE        (0x00000002U) /*!< Bit mask for DMA_ES_SBE. */
#define BS_DMA_ES_SBE        (1U)          /*!< Bit field size in bits for DMA_ES_SBE. */

/*! @brief Read current value of the DMA_ES_SBE field. */
#define BR_DMA_ES_SBE(x)     (BITBAND_ACCESS32(HW_DMA_ES_ADDR(x), BP_DMA_ES_SBE))
/*@}*/

/*!
 * @name Register DMA_ES, field SGE[2] (RO)
 *
 * Values:
 * - 0 - No scatter/gather configuration error
 * - 1 - The last recorded error was a configuration error detected in the
 *     TCDn_DLASTSGA field. This field is checked at the beginning of a scatter/gather
 *     operation after major loop completion if TCDn_CSR[ESG] is enabled.
 *     TCDn_DLASTSGA is not on a 32 byte boundary.
 */
/*@{*/
#define BP_DMA_ES_SGE        (2U)          /*!< Bit position for DMA_ES_SGE. */
#define BM_DMA_ES_SGE        (0x00000004U) /*!< Bit mask for DMA_ES_SGE. */
#define BS_DMA_ES_SGE        (1U)          /*!< Bit field size in bits for DMA_ES_SGE. */

/*! @brief Read current value of the DMA_ES_SGE field. */
#define BR_DMA_ES_SGE(x)     (BITBAND_ACCESS32(HW_DMA_ES_ADDR(x), BP_DMA_ES_SGE))
/*@}*/

/*!
 * @name Register DMA_ES, field NCE[3] (RO)
 *
 * Values:
 * - 0 - No NBYTES/CITER configuration error
 * - 1 - The last recorded error was a configuration error detected in the
 *     TCDn_NBYTES or TCDn_CITER fields. TCDn_NBYTES is not a multiple of
 *     TCDn_ATTR[SSIZE] and TCDn_ATTR[DSIZE], or TCDn_CITER[CITER] is equal to zero, or
 *     TCDn_CITER[ELINK] is not equal to TCDn_BITER[ELINK]
 */
/*@{*/
#define BP_DMA_ES_NCE        (3U)          /*!< Bit position for DMA_ES_NCE. */
#define BM_DMA_ES_NCE        (0x00000008U) /*!< Bit mask for DMA_ES_NCE. */
#define BS_DMA_ES_NCE        (1U)          /*!< Bit field size in bits for DMA_ES_NCE. */

/*! @brief Read current value of the DMA_ES_NCE field. */
#define BR_DMA_ES_NCE(x)     (BITBAND_ACCESS32(HW_DMA_ES_ADDR(x), BP_DMA_ES_NCE))
/*@}*/

/*!
 * @name Register DMA_ES, field DOE[4] (RO)
 *
 * Values:
 * - 0 - No destination offset configuration error
 * - 1 - The last recorded error was a configuration error detected in the
 *     TCDn_DOFF field. TCDn_DOFF is inconsistent with TCDn_ATTR[DSIZE].
 */
/*@{*/
#define BP_DMA_ES_DOE        (4U)          /*!< Bit position for DMA_ES_DOE. */
#define BM_DMA_ES_DOE        (0x00000010U) /*!< Bit mask for DMA_ES_DOE. */
#define BS_DMA_ES_DOE        (1U)          /*!< Bit field size in bits for DMA_ES_DOE. */

/*! @brief Read current value of the DMA_ES_DOE field. */
#define BR_DMA_ES_DOE(x)     (BITBAND_ACCESS32(HW_DMA_ES_ADDR(x), BP_DMA_ES_DOE))
/*@}*/

/*!
 * @name Register DMA_ES, field DAE[5] (RO)
 *
 * Values:
 * - 0 - No destination address configuration error
 * - 1 - The last recorded error was a configuration error detected in the
 *     TCDn_DADDR field. TCDn_DADDR is inconsistent with TCDn_ATTR[DSIZE].
 */
/*@{*/
#define BP_DMA_ES_DAE        (5U)          /*!< Bit position for DMA_ES_DAE. */
#define BM_DMA_ES_DAE        (0x00000020U) /*!< Bit mask for DMA_ES_DAE. */
#define BS_DMA_ES_DAE        (1U)          /*!< Bit field size in bits for DMA_ES_DAE. */

/*! @brief Read current value of the DMA_ES_DAE field. */
#define BR_DMA_ES_DAE(x)     (BITBAND_ACCESS32(HW_DMA_ES_ADDR(x), BP_DMA_ES_DAE))
/*@}*/

/*!
 * @name Register DMA_ES, field SOE[6] (RO)
 *
 * Values:
 * - 0 - No source offset configuration error
 * - 1 - The last recorded error was a configuration error detected in the
 *     TCDn_SOFF field. TCDn_SOFF is inconsistent with TCDn_ATTR[SSIZE].
 */
/*@{*/
#define BP_DMA_ES_SOE        (6U)          /*!< Bit position for DMA_ES_SOE. */
#define BM_DMA_ES_SOE        (0x00000040U) /*!< Bit mask for DMA_ES_SOE. */
#define BS_DMA_ES_SOE        (1U)          /*!< Bit field size in bits for DMA_ES_SOE. */

/*! @brief Read current value of the DMA_ES_SOE field. */
#define BR_DMA_ES_SOE(x)     (BITBAND_ACCESS32(HW_DMA_ES_ADDR(x), BP_DMA_ES_SOE))
/*@}*/

/*!
 * @name Register DMA_ES, field SAE[7] (RO)
 *
 * Values:
 * - 0 - No source address configuration error.
 * - 1 - The last recorded error was a configuration error detected in the
 *     TCDn_SADDR field. TCDn_SADDR is inconsistent with TCDn_ATTR[SSIZE].
 */
/*@{*/
#define BP_DMA_ES_SAE        (7U)          /*!< Bit position for DMA_ES_SAE. */
#define BM_DMA_ES_SAE        (0x00000080U) /*!< Bit mask for DMA_ES_SAE. */
#define BS_DMA_ES_SAE        (1U)          /*!< Bit field size in bits for DMA_ES_SAE. */

/*! @brief Read current value of the DMA_ES_SAE field. */
#define BR_DMA_ES_SAE(x)     (BITBAND_ACCESS32(HW_DMA_ES_ADDR(x), BP_DMA_ES_SAE))
/*@}*/

/*!
 * @name Register DMA_ES, field ERRCHN[11:8] (RO)
 *
 * The channel number of the last recorded error (excluding CPE errors) or last
 * recorded error canceled transfer.
 */
/*@{*/
#define BP_DMA_ES_ERRCHN     (8U)          /*!< Bit position for DMA_ES_ERRCHN. */
#define BM_DMA_ES_ERRCHN     (0x00000F00U) /*!< Bit mask for DMA_ES_ERRCHN. */
#define BS_DMA_ES_ERRCHN     (4U)          /*!< Bit field size in bits for DMA_ES_ERRCHN. */

/*! @brief Read current value of the DMA_ES_ERRCHN field. */
#define BR_DMA_ES_ERRCHN(x)  (HW_DMA_ES(x).B.ERRCHN)
/*@}*/

/*!
 * @name Register DMA_ES, field CPE[14] (RO)
 *
 * Values:
 * - 0 - No channel priority error
 * - 1 - The last recorded error was a configuration error in the channel
 *     priorities . Channel priorities are not unique.
 */
/*@{*/
#define BP_DMA_ES_CPE        (14U)         /*!< Bit position for DMA_ES_CPE. */
#define BM_DMA_ES_CPE        (0x00004000U) /*!< Bit mask for DMA_ES_CPE. */
#define BS_DMA_ES_CPE        (1U)          /*!< Bit field size in bits for DMA_ES_CPE. */

/*! @brief Read current value of the DMA_ES_CPE field. */
#define BR_DMA_ES_CPE(x)     (BITBAND_ACCESS32(HW_DMA_ES_ADDR(x), BP_DMA_ES_CPE))
/*@}*/

/*!
 * @name Register DMA_ES, field ECX[16] (RO)
 *
 * Values:
 * - 0 - No canceled transfers
 * - 1 - The last recorded entry was a canceled transfer by the error cancel
 *     transfer input
 */
/*@{*/
#define BP_DMA_ES_ECX        (16U)         /*!< Bit position for DMA_ES_ECX. */
#define BM_DMA_ES_ECX        (0x00010000U) /*!< Bit mask for DMA_ES_ECX. */
#define BS_DMA_ES_ECX        (1U)          /*!< Bit field size in bits for DMA_ES_ECX. */

/*! @brief Read current value of the DMA_ES_ECX field. */
#define BR_DMA_ES_ECX(x)     (BITBAND_ACCESS32(HW_DMA_ES_ADDR(x), BP_DMA_ES_ECX))
/*@}*/

/*!
 * @name Register DMA_ES, field VLD[31] (RO)
 *
 * Logical OR of all ERR status bits
 *
 * Values:
 * - 0 - No ERR bits are set
 * - 1 - At least one ERR bit is set indicating a valid error exists that has
 *     not been cleared
 */
/*@{*/
#define BP_DMA_ES_VLD        (31U)         /*!< Bit position for DMA_ES_VLD. */
#define BM_DMA_ES_VLD        (0x80000000U) /*!< Bit mask for DMA_ES_VLD. */
#define BS_DMA_ES_VLD        (1U)          /*!< Bit field size in bits for DMA_ES_VLD. */

/*! @brief Read current value of the DMA_ES_VLD field. */
#define BR_DMA_ES_VLD(x)     (BITBAND_ACCESS32(HW_DMA_ES_ADDR(x), BP_DMA_ES_VLD))
/*@}*/

/*******************************************************************************
 * HW_DMA_ERQ - Enable Request Register
 ******************************************************************************/

/*!
 * @brief HW_DMA_ERQ - Enable Request Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The ERQ register provides a bit map for the 16 implemented channels to enable
 * the request signal for each channel. The state of any given channel enable is
 * directly affected by writes to this register; it is also affected by writes
 * to the SERQ and CERQ. The {S,C}ERQ registers are provided so the request enable
 * for a single channel can easily be modified without needing to perform a
 * read-modify-write sequence to the ERQ. DMA request input signals and this enable
 * request flag must be asserted before a channel's hardware service request is
 * accepted. The state of the DMA enable request flag does not affect a channel
 * service request made explicitly through software or a linked channel request.
 */
typedef union _hw_dma_erq
{
    uint32_t U;
    struct _hw_dma_erq_bitfields
    {
        uint32_t ERQ0 : 1;             /*!< [0] Enable DMA Request 0 */
        uint32_t ERQ1 : 1;             /*!< [1] Enable DMA Request 1 */
        uint32_t ERQ2 : 1;             /*!< [2] Enable DMA Request 2 */
        uint32_t ERQ3 : 1;             /*!< [3] Enable DMA Request 3 */
        uint32_t ERQ4 : 1;             /*!< [4] Enable DMA Request 4 */
        uint32_t ERQ5 : 1;             /*!< [5] Enable DMA Request 5 */
        uint32_t ERQ6 : 1;             /*!< [6] Enable DMA Request 6 */
        uint32_t ERQ7 : 1;             /*!< [7] Enable DMA Request 7 */
        uint32_t ERQ8 : 1;             /*!< [8] Enable DMA Request 8 */
        uint32_t ERQ9 : 1;             /*!< [9] Enable DMA Request 9 */
        uint32_t ERQ10 : 1;            /*!< [10] Enable DMA Request 10 */
        uint32_t ERQ11 : 1;            /*!< [11] Enable DMA Request 11 */
        uint32_t ERQ12 : 1;            /*!< [12] Enable DMA Request 12 */
        uint32_t ERQ13 : 1;            /*!< [13] Enable DMA Request 13 */
        uint32_t ERQ14 : 1;            /*!< [14] Enable DMA Request 14 */
        uint32_t ERQ15 : 1;            /*!< [15] Enable DMA Request 15 */
        uint32_t RESERVED0 : 16;       /*!< [31:16]  */
    } B;
} hw_dma_erq_t;

/*!
 * @name Constants and macros for entire DMA_ERQ register
 */
/*@{*/
#define HW_DMA_ERQ_ADDR(x)       ((x) + 0xCU)

#define HW_DMA_ERQ(x)            (*(__IO hw_dma_erq_t *) HW_DMA_ERQ_ADDR(x))
#define HW_DMA_ERQ_RD(x)         (HW_DMA_ERQ(x).U)
#define HW_DMA_ERQ_WR(x, v)      (HW_DMA_ERQ(x).U = (v))
#define HW_DMA_ERQ_SET(x, v)     (HW_DMA_ERQ_WR(x, HW_DMA_ERQ_RD(x) |  (v)))
#define HW_DMA_ERQ_CLR(x, v)     (HW_DMA_ERQ_WR(x, HW_DMA_ERQ_RD(x) & ~(v)))
#define HW_DMA_ERQ_TOG(x, v)     (HW_DMA_ERQ_WR(x, HW_DMA_ERQ_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DMA_ERQ bitfields
 */

/*!
 * @name Register DMA_ERQ, field ERQ0[0] (RW)
 *
 * Values:
 * - 0 - The DMA request signal for the corresponding channel is disabled
 * - 1 - The DMA request signal for the corresponding channel is enabled
 */
/*@{*/
#define BP_DMA_ERQ_ERQ0      (0U)          /*!< Bit position for DMA_ERQ_ERQ0. */
#define BM_DMA_ERQ_ERQ0      (0x00000001U) /*!< Bit mask for DMA_ERQ_ERQ0. */
#define BS_DMA_ERQ_ERQ0      (1U)          /*!< Bit field size in bits for DMA_ERQ_ERQ0. */

/*! @brief Read current value of the DMA_ERQ_ERQ0 field. */
#define BR_DMA_ERQ_ERQ0(x)   (BITBAND_ACCESS32(HW_DMA_ERQ_ADDR(x), BP_DMA_ERQ_ERQ0))

/*! @brief Format value for bitfield DMA_ERQ_ERQ0. */
#define BF_DMA_ERQ_ERQ0(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_ERQ_ERQ0) & BM_DMA_ERQ_ERQ0)

/*! @brief Set the ERQ0 field to a new value. */
#define BW_DMA_ERQ_ERQ0(x, v) (BITBAND_ACCESS32(HW_DMA_ERQ_ADDR(x), BP_DMA_ERQ_ERQ0) = (v))
/*@}*/

/*!
 * @name Register DMA_ERQ, field ERQ1[1] (RW)
 *
 * Values:
 * - 0 - The DMA request signal for the corresponding channel is disabled
 * - 1 - The DMA request signal for the corresponding channel is enabled
 */
/*@{*/
#define BP_DMA_ERQ_ERQ1      (1U)          /*!< Bit position for DMA_ERQ_ERQ1. */
#define BM_DMA_ERQ_ERQ1      (0x00000002U) /*!< Bit mask for DMA_ERQ_ERQ1. */
#define BS_DMA_ERQ_ERQ1      (1U)          /*!< Bit field size in bits for DMA_ERQ_ERQ1. */

/*! @brief Read current value of the DMA_ERQ_ERQ1 field. */
#define BR_DMA_ERQ_ERQ1(x)   (BITBAND_ACCESS32(HW_DMA_ERQ_ADDR(x), BP_DMA_ERQ_ERQ1))

/*! @brief Format value for bitfield DMA_ERQ_ERQ1. */
#define BF_DMA_ERQ_ERQ1(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_ERQ_ERQ1) & BM_DMA_ERQ_ERQ1)

/*! @brief Set the ERQ1 field to a new value. */
#define BW_DMA_ERQ_ERQ1(x, v) (BITBAND_ACCESS32(HW_DMA_ERQ_ADDR(x), BP_DMA_ERQ_ERQ1) = (v))
/*@}*/

/*!
 * @name Register DMA_ERQ, field ERQ2[2] (RW)
 *
 * Values:
 * - 0 - The DMA request signal for the corresponding channel is disabled
 * - 1 - The DMA request signal for the corresponding channel is enabled
 */
/*@{*/
#define BP_DMA_ERQ_ERQ2      (2U)          /*!< Bit position for DMA_ERQ_ERQ2. */
#define BM_DMA_ERQ_ERQ2      (0x00000004U) /*!< Bit mask for DMA_ERQ_ERQ2. */
#define BS_DMA_ERQ_ERQ2      (1U)          /*!< Bit field size in bits for DMA_ERQ_ERQ2. */

/*! @brief Read current value of the DMA_ERQ_ERQ2 field. */
#define BR_DMA_ERQ_ERQ2(x)   (BITBAND_ACCESS32(HW_DMA_ERQ_ADDR(x), BP_DMA_ERQ_ERQ2))

/*! @brief Format value for bitfield DMA_ERQ_ERQ2. */
#define BF_DMA_ERQ_ERQ2(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_ERQ_ERQ2) & BM_DMA_ERQ_ERQ2)

/*! @brief Set the ERQ2 field to a new value. */
#define BW_DMA_ERQ_ERQ2(x, v) (BITBAND_ACCESS32(HW_DMA_ERQ_ADDR(x), BP_DMA_ERQ_ERQ2) = (v))
/*@}*/

/*!
 * @name Register DMA_ERQ, field ERQ3[3] (RW)
 *
 * Values:
 * - 0 - The DMA request signal for the corresponding channel is disabled
 * - 1 - The DMA request signal for the corresponding channel is enabled
 */
/*@{*/
#define BP_DMA_ERQ_ERQ3      (3U)          /*!< Bit position for DMA_ERQ_ERQ3. */
#define BM_DMA_ERQ_ERQ3      (0x00000008U) /*!< Bit mask for DMA_ERQ_ERQ3. */
#define BS_DMA_ERQ_ERQ3      (1U)          /*!< Bit field size in bits for DMA_ERQ_ERQ3. */

/*! @brief Read current value of the DMA_ERQ_ERQ3 field. */
#define BR_DMA_ERQ_ERQ3(x)   (BITBAND_ACCESS32(HW_DMA_ERQ_ADDR(x), BP_DMA_ERQ_ERQ3))

/*! @brief Format value for bitfield DMA_ERQ_ERQ3. */
#define BF_DMA_ERQ_ERQ3(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_ERQ_ERQ3) & BM_DMA_ERQ_ERQ3)

/*! @brief Set the ERQ3 field to a new value. */
#define BW_DMA_ERQ_ERQ3(x, v) (BITBAND_ACCESS32(HW_DMA_ERQ_ADDR(x), BP_DMA_ERQ_ERQ3) = (v))
/*@}*/

/*!
 * @name Register DMA_ERQ, field ERQ4[4] (RW)
 *
 * Values:
 * - 0 - The DMA request signal for the corresponding channel is disabled
 * - 1 - The DMA request signal for the corresponding channel is enabled
 */
/*@{*/
#define BP_DMA_ERQ_ERQ4      (4U)          /*!< Bit position for DMA_ERQ_ERQ4. */
#define BM_DMA_ERQ_ERQ4      (0x00000010U) /*!< Bit mask for DMA_ERQ_ERQ4. */
#define BS_DMA_ERQ_ERQ4      (1U)          /*!< Bit field size in bits for DMA_ERQ_ERQ4. */

/*! @brief Read current value of the DMA_ERQ_ERQ4 field. */
#define BR_DMA_ERQ_ERQ4(x)   (BITBAND_ACCESS32(HW_DMA_ERQ_ADDR(x), BP_DMA_ERQ_ERQ4))

/*! @brief Format value for bitfield DMA_ERQ_ERQ4. */
#define BF_DMA_ERQ_ERQ4(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_ERQ_ERQ4) & BM_DMA_ERQ_ERQ4)

/*! @brief Set the ERQ4 field to a new value. */
#define BW_DMA_ERQ_ERQ4(x, v) (BITBAND_ACCESS32(HW_DMA_ERQ_ADDR(x), BP_DMA_ERQ_ERQ4) = (v))
/*@}*/

/*!
 * @name Register DMA_ERQ, field ERQ5[5] (RW)
 *
 * Values:
 * - 0 - The DMA request signal for the corresponding channel is disabled
 * - 1 - The DMA request signal for the corresponding channel is enabled
 */
/*@{*/
#define BP_DMA_ERQ_ERQ5      (5U)          /*!< Bit position for DMA_ERQ_ERQ5. */
#define BM_DMA_ERQ_ERQ5      (0x00000020U) /*!< Bit mask for DMA_ERQ_ERQ5. */
#define BS_DMA_ERQ_ERQ5      (1U)          /*!< Bit field size in bits for DMA_ERQ_ERQ5. */

/*! @brief Read current value of the DMA_ERQ_ERQ5 field. */
#define BR_DMA_ERQ_ERQ5(x)   (BITBAND_ACCESS32(HW_DMA_ERQ_ADDR(x), BP_DMA_ERQ_ERQ5))

/*! @brief Format value for bitfield DMA_ERQ_ERQ5. */
#define BF_DMA_ERQ_ERQ5(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_ERQ_ERQ5) & BM_DMA_ERQ_ERQ5)

/*! @brief Set the ERQ5 field to a new value. */
#define BW_DMA_ERQ_ERQ5(x, v) (BITBAND_ACCESS32(HW_DMA_ERQ_ADDR(x), BP_DMA_ERQ_ERQ5) = (v))
/*@}*/

/*!
 * @name Register DMA_ERQ, field ERQ6[6] (RW)
 *
 * Values:
 * - 0 - The DMA request signal for the corresponding channel is disabled
 * - 1 - The DMA request signal for the corresponding channel is enabled
 */
/*@{*/
#define BP_DMA_ERQ_ERQ6      (6U)          /*!< Bit position for DMA_ERQ_ERQ6. */
#define BM_DMA_ERQ_ERQ6      (0x00000040U) /*!< Bit mask for DMA_ERQ_ERQ6. */
#define BS_DMA_ERQ_ERQ6      (1U)          /*!< Bit field size in bits for DMA_ERQ_ERQ6. */

/*! @brief Read current value of the DMA_ERQ_ERQ6 field. */
#define BR_DMA_ERQ_ERQ6(x)   (BITBAND_ACCESS32(HW_DMA_ERQ_ADDR(x), BP_DMA_ERQ_ERQ6))

/*! @brief Format value for bitfield DMA_ERQ_ERQ6. */
#define BF_DMA_ERQ_ERQ6(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_ERQ_ERQ6) & BM_DMA_ERQ_ERQ6)

/*! @brief Set the ERQ6 field to a new value. */
#define BW_DMA_ERQ_ERQ6(x, v) (BITBAND_ACCESS32(HW_DMA_ERQ_ADDR(x), BP_DMA_ERQ_ERQ6) = (v))
/*@}*/

/*!
 * @name Register DMA_ERQ, field ERQ7[7] (RW)
 *
 * Values:
 * - 0 - The DMA request signal for the corresponding channel is disabled
 * - 1 - The DMA request signal for the corresponding channel is enabled
 */
/*@{*/
#define BP_DMA_ERQ_ERQ7      (7U)          /*!< Bit position for DMA_ERQ_ERQ7. */
#define BM_DMA_ERQ_ERQ7      (0x00000080U) /*!< Bit mask for DMA_ERQ_ERQ7. */
#define BS_DMA_ERQ_ERQ7      (1U)          /*!< Bit field size in bits for DMA_ERQ_ERQ7. */

/*! @brief Read current value of the DMA_ERQ_ERQ7 field. */
#define BR_DMA_ERQ_ERQ7(x)   (BITBAND_ACCESS32(HW_DMA_ERQ_ADDR(x), BP_DMA_ERQ_ERQ7))

/*! @brief Format value for bitfield DMA_ERQ_ERQ7. */
#define BF_DMA_ERQ_ERQ7(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_ERQ_ERQ7) & BM_DMA_ERQ_ERQ7)

/*! @brief Set the ERQ7 field to a new value. */
#define BW_DMA_ERQ_ERQ7(x, v) (BITBAND_ACCESS32(HW_DMA_ERQ_ADDR(x), BP_DMA_ERQ_ERQ7) = (v))
/*@}*/

/*!
 * @name Register DMA_ERQ, field ERQ8[8] (RW)
 *
 * Values:
 * - 0 - The DMA request signal for the corresponding channel is disabled
 * - 1 - The DMA request signal for the corresponding channel is enabled
 */
/*@{*/
#define BP_DMA_ERQ_ERQ8      (8U)          /*!< Bit position for DMA_ERQ_ERQ8. */
#define BM_DMA_ERQ_ERQ8      (0x00000100U) /*!< Bit mask for DMA_ERQ_ERQ8. */
#define BS_DMA_ERQ_ERQ8      (1U)          /*!< Bit field size in bits for DMA_ERQ_ERQ8. */

/*! @brief Read current value of the DMA_ERQ_ERQ8 field. */
#define BR_DMA_ERQ_ERQ8(x)   (BITBAND_ACCESS32(HW_DMA_ERQ_ADDR(x), BP_DMA_ERQ_ERQ8))

/*! @brief Format value for bitfield DMA_ERQ_ERQ8. */
#define BF_DMA_ERQ_ERQ8(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_ERQ_ERQ8) & BM_DMA_ERQ_ERQ8)

/*! @brief Set the ERQ8 field to a new value. */
#define BW_DMA_ERQ_ERQ8(x, v) (BITBAND_ACCESS32(HW_DMA_ERQ_ADDR(x), BP_DMA_ERQ_ERQ8) = (v))
/*@}*/

/*!
 * @name Register DMA_ERQ, field ERQ9[9] (RW)
 *
 * Values:
 * - 0 - The DMA request signal for the corresponding channel is disabled
 * - 1 - The DMA request signal for the corresponding channel is enabled
 */
/*@{*/
#define BP_DMA_ERQ_ERQ9      (9U)          /*!< Bit position for DMA_ERQ_ERQ9. */
#define BM_DMA_ERQ_ERQ9      (0x00000200U) /*!< Bit mask for DMA_ERQ_ERQ9. */
#define BS_DMA_ERQ_ERQ9      (1U)          /*!< Bit field size in bits for DMA_ERQ_ERQ9. */

/*! @brief Read current value of the DMA_ERQ_ERQ9 field. */
#define BR_DMA_ERQ_ERQ9(x)   (BITBAND_ACCESS32(HW_DMA_ERQ_ADDR(x), BP_DMA_ERQ_ERQ9))

/*! @brief Format value for bitfield DMA_ERQ_ERQ9. */
#define BF_DMA_ERQ_ERQ9(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_ERQ_ERQ9) & BM_DMA_ERQ_ERQ9)

/*! @brief Set the ERQ9 field to a new value. */
#define BW_DMA_ERQ_ERQ9(x, v) (BITBAND_ACCESS32(HW_DMA_ERQ_ADDR(x), BP_DMA_ERQ_ERQ9) = (v))
/*@}*/

/*!
 * @name Register DMA_ERQ, field ERQ10[10] (RW)
 *
 * Values:
 * - 0 - The DMA request signal for the corresponding channel is disabled
 * - 1 - The DMA request signal for the corresponding channel is enabled
 */
/*@{*/
#define BP_DMA_ERQ_ERQ10     (10U)         /*!< Bit position for DMA_ERQ_ERQ10. */
#define BM_DMA_ERQ_ERQ10     (0x00000400U) /*!< Bit mask for DMA_ERQ_ERQ10. */
#define BS_DMA_ERQ_ERQ10     (1U)          /*!< Bit field size in bits for DMA_ERQ_ERQ10. */

/*! @brief Read current value of the DMA_ERQ_ERQ10 field. */
#define BR_DMA_ERQ_ERQ10(x)  (BITBAND_ACCESS32(HW_DMA_ERQ_ADDR(x), BP_DMA_ERQ_ERQ10))

/*! @brief Format value for bitfield DMA_ERQ_ERQ10. */
#define BF_DMA_ERQ_ERQ10(v)  ((uint32_t)((uint32_t)(v) << BP_DMA_ERQ_ERQ10) & BM_DMA_ERQ_ERQ10)

/*! @brief Set the ERQ10 field to a new value. */
#define BW_DMA_ERQ_ERQ10(x, v) (BITBAND_ACCESS32(HW_DMA_ERQ_ADDR(x), BP_DMA_ERQ_ERQ10) = (v))
/*@}*/

/*!
 * @name Register DMA_ERQ, field ERQ11[11] (RW)
 *
 * Values:
 * - 0 - The DMA request signal for the corresponding channel is disabled
 * - 1 - The DMA request signal for the corresponding channel is enabled
 */
/*@{*/
#define BP_DMA_ERQ_ERQ11     (11U)         /*!< Bit position for DMA_ERQ_ERQ11. */
#define BM_DMA_ERQ_ERQ11     (0x00000800U) /*!< Bit mask for DMA_ERQ_ERQ11. */
#define BS_DMA_ERQ_ERQ11     (1U)          /*!< Bit field size in bits for DMA_ERQ_ERQ11. */

/*! @brief Read current value of the DMA_ERQ_ERQ11 field. */
#define BR_DMA_ERQ_ERQ11(x)  (BITBAND_ACCESS32(HW_DMA_ERQ_ADDR(x), BP_DMA_ERQ_ERQ11))

/*! @brief Format value for bitfield DMA_ERQ_ERQ11. */
#define BF_DMA_ERQ_ERQ11(v)  ((uint32_t)((uint32_t)(v) << BP_DMA_ERQ_ERQ11) & BM_DMA_ERQ_ERQ11)

/*! @brief Set the ERQ11 field to a new value. */
#define BW_DMA_ERQ_ERQ11(x, v) (BITBAND_ACCESS32(HW_DMA_ERQ_ADDR(x), BP_DMA_ERQ_ERQ11) = (v))
/*@}*/

/*!
 * @name Register DMA_ERQ, field ERQ12[12] (RW)
 *
 * Values:
 * - 0 - The DMA request signal for the corresponding channel is disabled
 * - 1 - The DMA request signal for the corresponding channel is enabled
 */
/*@{*/
#define BP_DMA_ERQ_ERQ12     (12U)         /*!< Bit position for DMA_ERQ_ERQ12. */
#define BM_DMA_ERQ_ERQ12     (0x00001000U) /*!< Bit mask for DMA_ERQ_ERQ12. */
#define BS_DMA_ERQ_ERQ12     (1U)          /*!< Bit field size in bits for DMA_ERQ_ERQ12. */

/*! @brief Read current value of the DMA_ERQ_ERQ12 field. */
#define BR_DMA_ERQ_ERQ12(x)  (BITBAND_ACCESS32(HW_DMA_ERQ_ADDR(x), BP_DMA_ERQ_ERQ12))

/*! @brief Format value for bitfield DMA_ERQ_ERQ12. */
#define BF_DMA_ERQ_ERQ12(v)  ((uint32_t)((uint32_t)(v) << BP_DMA_ERQ_ERQ12) & BM_DMA_ERQ_ERQ12)

/*! @brief Set the ERQ12 field to a new value. */
#define BW_DMA_ERQ_ERQ12(x, v) (BITBAND_ACCESS32(HW_DMA_ERQ_ADDR(x), BP_DMA_ERQ_ERQ12) = (v))
/*@}*/

/*!
 * @name Register DMA_ERQ, field ERQ13[13] (RW)
 *
 * Values:
 * - 0 - The DMA request signal for the corresponding channel is disabled
 * - 1 - The DMA request signal for the corresponding channel is enabled
 */
/*@{*/
#define BP_DMA_ERQ_ERQ13     (13U)         /*!< Bit position for DMA_ERQ_ERQ13. */
#define BM_DMA_ERQ_ERQ13     (0x00002000U) /*!< Bit mask for DMA_ERQ_ERQ13. */
#define BS_DMA_ERQ_ERQ13     (1U)          /*!< Bit field size in bits for DMA_ERQ_ERQ13. */

/*! @brief Read current value of the DMA_ERQ_ERQ13 field. */
#define BR_DMA_ERQ_ERQ13(x)  (BITBAND_ACCESS32(HW_DMA_ERQ_ADDR(x), BP_DMA_ERQ_ERQ13))

/*! @brief Format value for bitfield DMA_ERQ_ERQ13. */
#define BF_DMA_ERQ_ERQ13(v)  ((uint32_t)((uint32_t)(v) << BP_DMA_ERQ_ERQ13) & BM_DMA_ERQ_ERQ13)

/*! @brief Set the ERQ13 field to a new value. */
#define BW_DMA_ERQ_ERQ13(x, v) (BITBAND_ACCESS32(HW_DMA_ERQ_ADDR(x), BP_DMA_ERQ_ERQ13) = (v))
/*@}*/

/*!
 * @name Register DMA_ERQ, field ERQ14[14] (RW)
 *
 * Values:
 * - 0 - The DMA request signal for the corresponding channel is disabled
 * - 1 - The DMA request signal for the corresponding channel is enabled
 */
/*@{*/
#define BP_DMA_ERQ_ERQ14     (14U)         /*!< Bit position for DMA_ERQ_ERQ14. */
#define BM_DMA_ERQ_ERQ14     (0x00004000U) /*!< Bit mask for DMA_ERQ_ERQ14. */
#define BS_DMA_ERQ_ERQ14     (1U)          /*!< Bit field size in bits for DMA_ERQ_ERQ14. */

/*! @brief Read current value of the DMA_ERQ_ERQ14 field. */
#define BR_DMA_ERQ_ERQ14(x)  (BITBAND_ACCESS32(HW_DMA_ERQ_ADDR(x), BP_DMA_ERQ_ERQ14))

/*! @brief Format value for bitfield DMA_ERQ_ERQ14. */
#define BF_DMA_ERQ_ERQ14(v)  ((uint32_t)((uint32_t)(v) << BP_DMA_ERQ_ERQ14) & BM_DMA_ERQ_ERQ14)

/*! @brief Set the ERQ14 field to a new value. */
#define BW_DMA_ERQ_ERQ14(x, v) (BITBAND_ACCESS32(HW_DMA_ERQ_ADDR(x), BP_DMA_ERQ_ERQ14) = (v))
/*@}*/

/*!
 * @name Register DMA_ERQ, field ERQ15[15] (RW)
 *
 * Values:
 * - 0 - The DMA request signal for the corresponding channel is disabled
 * - 1 - The DMA request signal for the corresponding channel is enabled
 */
/*@{*/
#define BP_DMA_ERQ_ERQ15     (15U)         /*!< Bit position for DMA_ERQ_ERQ15. */
#define BM_DMA_ERQ_ERQ15     (0x00008000U) /*!< Bit mask for DMA_ERQ_ERQ15. */
#define BS_DMA_ERQ_ERQ15     (1U)          /*!< Bit field size in bits for DMA_ERQ_ERQ15. */

/*! @brief Read current value of the DMA_ERQ_ERQ15 field. */
#define BR_DMA_ERQ_ERQ15(x)  (BITBAND_ACCESS32(HW_DMA_ERQ_ADDR(x), BP_DMA_ERQ_ERQ15))

/*! @brief Format value for bitfield DMA_ERQ_ERQ15. */
#define BF_DMA_ERQ_ERQ15(v)  ((uint32_t)((uint32_t)(v) << BP_DMA_ERQ_ERQ15) & BM_DMA_ERQ_ERQ15)

/*! @brief Set the ERQ15 field to a new value. */
#define BW_DMA_ERQ_ERQ15(x, v) (BITBAND_ACCESS32(HW_DMA_ERQ_ADDR(x), BP_DMA_ERQ_ERQ15) = (v))
/*@}*/

/*******************************************************************************
 * HW_DMA_EEI - Enable Error Interrupt Register
 ******************************************************************************/

/*!
 * @brief HW_DMA_EEI - Enable Error Interrupt Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The EEI register provides a bit map for the 16 channels to enable the error
 * interrupt signal for each channel. The state of any given channel's error
 * interrupt enable is directly affected by writes to this register; it is also
 * affected by writes to the SEEI and CEEI. The {S,C}EEI are provided so the error
 * interrupt enable for a single channel can easily be modified without the need to
 * perform a read-modify-write sequence to the EEI register. The DMA error
 * indicator and the error interrupt enable flag must be asserted before an error
 * interrupt request for a given channel is asserted to the interrupt controller.
 */
typedef union _hw_dma_eei
{
    uint32_t U;
    struct _hw_dma_eei_bitfields
    {
        uint32_t EEI0 : 1;             /*!< [0] Enable Error Interrupt 0 */
        uint32_t EEI1 : 1;             /*!< [1] Enable Error Interrupt 1 */
        uint32_t EEI2 : 1;             /*!< [2] Enable Error Interrupt 2 */
        uint32_t EEI3 : 1;             /*!< [3] Enable Error Interrupt 3 */
        uint32_t EEI4 : 1;             /*!< [4] Enable Error Interrupt 4 */
        uint32_t EEI5 : 1;             /*!< [5] Enable Error Interrupt 5 */
        uint32_t EEI6 : 1;             /*!< [6] Enable Error Interrupt 6 */
        uint32_t EEI7 : 1;             /*!< [7] Enable Error Interrupt 7 */
        uint32_t EEI8 : 1;             /*!< [8] Enable Error Interrupt 8 */
        uint32_t EEI9 : 1;             /*!< [9] Enable Error Interrupt 9 */
        uint32_t EEI10 : 1;            /*!< [10] Enable Error Interrupt 10 */
        uint32_t EEI11 : 1;            /*!< [11] Enable Error Interrupt 11 */
        uint32_t EEI12 : 1;            /*!< [12] Enable Error Interrupt 12 */
        uint32_t EEI13 : 1;            /*!< [13] Enable Error Interrupt 13 */
        uint32_t EEI14 : 1;            /*!< [14] Enable Error Interrupt 14 */
        uint32_t EEI15 : 1;            /*!< [15] Enable Error Interrupt 15 */
        uint32_t RESERVED0 : 16;       /*!< [31:16]  */
    } B;
} hw_dma_eei_t;

/*!
 * @name Constants and macros for entire DMA_EEI register
 */
/*@{*/
#define HW_DMA_EEI_ADDR(x)       ((x) + 0x14U)

#define HW_DMA_EEI(x)            (*(__IO hw_dma_eei_t *) HW_DMA_EEI_ADDR(x))
#define HW_DMA_EEI_RD(x)         (HW_DMA_EEI(x).U)
#define HW_DMA_EEI_WR(x, v)      (HW_DMA_EEI(x).U = (v))
#define HW_DMA_EEI_SET(x, v)     (HW_DMA_EEI_WR(x, HW_DMA_EEI_RD(x) |  (v)))
#define HW_DMA_EEI_CLR(x, v)     (HW_DMA_EEI_WR(x, HW_DMA_EEI_RD(x) & ~(v)))
#define HW_DMA_EEI_TOG(x, v)     (HW_DMA_EEI_WR(x, HW_DMA_EEI_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DMA_EEI bitfields
 */

/*!
 * @name Register DMA_EEI, field EEI0[0] (RW)
 *
 * Values:
 * - 0 - The error signal for corresponding channel does not generate an error
 *     interrupt
 * - 1 - The assertion of the error signal for corresponding channel generates
 *     an error interrupt request
 */
/*@{*/
#define BP_DMA_EEI_EEI0      (0U)          /*!< Bit position for DMA_EEI_EEI0. */
#define BM_DMA_EEI_EEI0      (0x00000001U) /*!< Bit mask for DMA_EEI_EEI0. */
#define BS_DMA_EEI_EEI0      (1U)          /*!< Bit field size in bits for DMA_EEI_EEI0. */

/*! @brief Read current value of the DMA_EEI_EEI0 field. */
#define BR_DMA_EEI_EEI0(x)   (BITBAND_ACCESS32(HW_DMA_EEI_ADDR(x), BP_DMA_EEI_EEI0))

/*! @brief Format value for bitfield DMA_EEI_EEI0. */
#define BF_DMA_EEI_EEI0(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_EEI_EEI0) & BM_DMA_EEI_EEI0)

/*! @brief Set the EEI0 field to a new value. */
#define BW_DMA_EEI_EEI0(x, v) (BITBAND_ACCESS32(HW_DMA_EEI_ADDR(x), BP_DMA_EEI_EEI0) = (v))
/*@}*/

/*!
 * @name Register DMA_EEI, field EEI1[1] (RW)
 *
 * Values:
 * - 0 - The error signal for corresponding channel does not generate an error
 *     interrupt
 * - 1 - The assertion of the error signal for corresponding channel generates
 *     an error interrupt request
 */
/*@{*/
#define BP_DMA_EEI_EEI1      (1U)          /*!< Bit position for DMA_EEI_EEI1. */
#define BM_DMA_EEI_EEI1      (0x00000002U) /*!< Bit mask for DMA_EEI_EEI1. */
#define BS_DMA_EEI_EEI1      (1U)          /*!< Bit field size in bits for DMA_EEI_EEI1. */

/*! @brief Read current value of the DMA_EEI_EEI1 field. */
#define BR_DMA_EEI_EEI1(x)   (BITBAND_ACCESS32(HW_DMA_EEI_ADDR(x), BP_DMA_EEI_EEI1))

/*! @brief Format value for bitfield DMA_EEI_EEI1. */
#define BF_DMA_EEI_EEI1(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_EEI_EEI1) & BM_DMA_EEI_EEI1)

/*! @brief Set the EEI1 field to a new value. */
#define BW_DMA_EEI_EEI1(x, v) (BITBAND_ACCESS32(HW_DMA_EEI_ADDR(x), BP_DMA_EEI_EEI1) = (v))
/*@}*/

/*!
 * @name Register DMA_EEI, field EEI2[2] (RW)
 *
 * Values:
 * - 0 - The error signal for corresponding channel does not generate an error
 *     interrupt
 * - 1 - The assertion of the error signal for corresponding channel generates
 *     an error interrupt request
 */
/*@{*/
#define BP_DMA_EEI_EEI2      (2U)          /*!< Bit position for DMA_EEI_EEI2. */
#define BM_DMA_EEI_EEI2      (0x00000004U) /*!< Bit mask for DMA_EEI_EEI2. */
#define BS_DMA_EEI_EEI2      (1U)          /*!< Bit field size in bits for DMA_EEI_EEI2. */

/*! @brief Read current value of the DMA_EEI_EEI2 field. */
#define BR_DMA_EEI_EEI2(x)   (BITBAND_ACCESS32(HW_DMA_EEI_ADDR(x), BP_DMA_EEI_EEI2))

/*! @brief Format value for bitfield DMA_EEI_EEI2. */
#define BF_DMA_EEI_EEI2(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_EEI_EEI2) & BM_DMA_EEI_EEI2)

/*! @brief Set the EEI2 field to a new value. */
#define BW_DMA_EEI_EEI2(x, v) (BITBAND_ACCESS32(HW_DMA_EEI_ADDR(x), BP_DMA_EEI_EEI2) = (v))
/*@}*/

/*!
 * @name Register DMA_EEI, field EEI3[3] (RW)
 *
 * Values:
 * - 0 - The error signal for corresponding channel does not generate an error
 *     interrupt
 * - 1 - The assertion of the error signal for corresponding channel generates
 *     an error interrupt request
 */
/*@{*/
#define BP_DMA_EEI_EEI3      (3U)          /*!< Bit position for DMA_EEI_EEI3. */
#define BM_DMA_EEI_EEI3      (0x00000008U) /*!< Bit mask for DMA_EEI_EEI3. */
#define BS_DMA_EEI_EEI3      (1U)          /*!< Bit field size in bits for DMA_EEI_EEI3. */

/*! @brief Read current value of the DMA_EEI_EEI3 field. */
#define BR_DMA_EEI_EEI3(x)   (BITBAND_ACCESS32(HW_DMA_EEI_ADDR(x), BP_DMA_EEI_EEI3))

/*! @brief Format value for bitfield DMA_EEI_EEI3. */
#define BF_DMA_EEI_EEI3(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_EEI_EEI3) & BM_DMA_EEI_EEI3)

/*! @brief Set the EEI3 field to a new value. */
#define BW_DMA_EEI_EEI3(x, v) (BITBAND_ACCESS32(HW_DMA_EEI_ADDR(x), BP_DMA_EEI_EEI3) = (v))
/*@}*/

/*!
 * @name Register DMA_EEI, field EEI4[4] (RW)
 *
 * Values:
 * - 0 - The error signal for corresponding channel does not generate an error
 *     interrupt
 * - 1 - The assertion of the error signal for corresponding channel generates
 *     an error interrupt request
 */
/*@{*/
#define BP_DMA_EEI_EEI4      (4U)          /*!< Bit position for DMA_EEI_EEI4. */
#define BM_DMA_EEI_EEI4      (0x00000010U) /*!< Bit mask for DMA_EEI_EEI4. */
#define BS_DMA_EEI_EEI4      (1U)          /*!< Bit field size in bits for DMA_EEI_EEI4. */

/*! @brief Read current value of the DMA_EEI_EEI4 field. */
#define BR_DMA_EEI_EEI4(x)   (BITBAND_ACCESS32(HW_DMA_EEI_ADDR(x), BP_DMA_EEI_EEI4))

/*! @brief Format value for bitfield DMA_EEI_EEI4. */
#define BF_DMA_EEI_EEI4(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_EEI_EEI4) & BM_DMA_EEI_EEI4)

/*! @brief Set the EEI4 field to a new value. */
#define BW_DMA_EEI_EEI4(x, v) (BITBAND_ACCESS32(HW_DMA_EEI_ADDR(x), BP_DMA_EEI_EEI4) = (v))
/*@}*/

/*!
 * @name Register DMA_EEI, field EEI5[5] (RW)
 *
 * Values:
 * - 0 - The error signal for corresponding channel does not generate an error
 *     interrupt
 * - 1 - The assertion of the error signal for corresponding channel generates
 *     an error interrupt request
 */
/*@{*/
#define BP_DMA_EEI_EEI5      (5U)          /*!< Bit position for DMA_EEI_EEI5. */
#define BM_DMA_EEI_EEI5      (0x00000020U) /*!< Bit mask for DMA_EEI_EEI5. */
#define BS_DMA_EEI_EEI5      (1U)          /*!< Bit field size in bits for DMA_EEI_EEI5. */

/*! @brief Read current value of the DMA_EEI_EEI5 field. */
#define BR_DMA_EEI_EEI5(x)   (BITBAND_ACCESS32(HW_DMA_EEI_ADDR(x), BP_DMA_EEI_EEI5))

/*! @brief Format value for bitfield DMA_EEI_EEI5. */
#define BF_DMA_EEI_EEI5(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_EEI_EEI5) & BM_DMA_EEI_EEI5)

/*! @brief Set the EEI5 field to a new value. */
#define BW_DMA_EEI_EEI5(x, v) (BITBAND_ACCESS32(HW_DMA_EEI_ADDR(x), BP_DMA_EEI_EEI5) = (v))
/*@}*/

/*!
 * @name Register DMA_EEI, field EEI6[6] (RW)
 *
 * Values:
 * - 0 - The error signal for corresponding channel does not generate an error
 *     interrupt
 * - 1 - The assertion of the error signal for corresponding channel generates
 *     an error interrupt request
 */
/*@{*/
#define BP_DMA_EEI_EEI6      (6U)          /*!< Bit position for DMA_EEI_EEI6. */
#define BM_DMA_EEI_EEI6      (0x00000040U) /*!< Bit mask for DMA_EEI_EEI6. */
#define BS_DMA_EEI_EEI6      (1U)          /*!< Bit field size in bits for DMA_EEI_EEI6. */

/*! @brief Read current value of the DMA_EEI_EEI6 field. */
#define BR_DMA_EEI_EEI6(x)   (BITBAND_ACCESS32(HW_DMA_EEI_ADDR(x), BP_DMA_EEI_EEI6))

/*! @brief Format value for bitfield DMA_EEI_EEI6. */
#define BF_DMA_EEI_EEI6(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_EEI_EEI6) & BM_DMA_EEI_EEI6)

/*! @brief Set the EEI6 field to a new value. */
#define BW_DMA_EEI_EEI6(x, v) (BITBAND_ACCESS32(HW_DMA_EEI_ADDR(x), BP_DMA_EEI_EEI6) = (v))
/*@}*/

/*!
 * @name Register DMA_EEI, field EEI7[7] (RW)
 *
 * Values:
 * - 0 - The error signal for corresponding channel does not generate an error
 *     interrupt
 * - 1 - The assertion of the error signal for corresponding channel generates
 *     an error interrupt request
 */
/*@{*/
#define BP_DMA_EEI_EEI7      (7U)          /*!< Bit position for DMA_EEI_EEI7. */
#define BM_DMA_EEI_EEI7      (0x00000080U) /*!< Bit mask for DMA_EEI_EEI7. */
#define BS_DMA_EEI_EEI7      (1U)          /*!< Bit field size in bits for DMA_EEI_EEI7. */

/*! @brief Read current value of the DMA_EEI_EEI7 field. */
#define BR_DMA_EEI_EEI7(x)   (BITBAND_ACCESS32(HW_DMA_EEI_ADDR(x), BP_DMA_EEI_EEI7))

/*! @brief Format value for bitfield DMA_EEI_EEI7. */
#define BF_DMA_EEI_EEI7(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_EEI_EEI7) & BM_DMA_EEI_EEI7)

/*! @brief Set the EEI7 field to a new value. */
#define BW_DMA_EEI_EEI7(x, v) (BITBAND_ACCESS32(HW_DMA_EEI_ADDR(x), BP_DMA_EEI_EEI7) = (v))
/*@}*/

/*!
 * @name Register DMA_EEI, field EEI8[8] (RW)
 *
 * Values:
 * - 0 - The error signal for corresponding channel does not generate an error
 *     interrupt
 * - 1 - The assertion of the error signal for corresponding channel generates
 *     an error interrupt request
 */
/*@{*/
#define BP_DMA_EEI_EEI8      (8U)          /*!< Bit position for DMA_EEI_EEI8. */
#define BM_DMA_EEI_EEI8      (0x00000100U) /*!< Bit mask for DMA_EEI_EEI8. */
#define BS_DMA_EEI_EEI8      (1U)          /*!< Bit field size in bits for DMA_EEI_EEI8. */

/*! @brief Read current value of the DMA_EEI_EEI8 field. */
#define BR_DMA_EEI_EEI8(x)   (BITBAND_ACCESS32(HW_DMA_EEI_ADDR(x), BP_DMA_EEI_EEI8))

/*! @brief Format value for bitfield DMA_EEI_EEI8. */
#define BF_DMA_EEI_EEI8(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_EEI_EEI8) & BM_DMA_EEI_EEI8)

/*! @brief Set the EEI8 field to a new value. */
#define BW_DMA_EEI_EEI8(x, v) (BITBAND_ACCESS32(HW_DMA_EEI_ADDR(x), BP_DMA_EEI_EEI8) = (v))
/*@}*/

/*!
 * @name Register DMA_EEI, field EEI9[9] (RW)
 *
 * Values:
 * - 0 - The error signal for corresponding channel does not generate an error
 *     interrupt
 * - 1 - The assertion of the error signal for corresponding channel generates
 *     an error interrupt request
 */
/*@{*/
#define BP_DMA_EEI_EEI9      (9U)          /*!< Bit position for DMA_EEI_EEI9. */
#define BM_DMA_EEI_EEI9      (0x00000200U) /*!< Bit mask for DMA_EEI_EEI9. */
#define BS_DMA_EEI_EEI9      (1U)          /*!< Bit field size in bits for DMA_EEI_EEI9. */

/*! @brief Read current value of the DMA_EEI_EEI9 field. */
#define BR_DMA_EEI_EEI9(x)   (BITBAND_ACCESS32(HW_DMA_EEI_ADDR(x), BP_DMA_EEI_EEI9))

/*! @brief Format value for bitfield DMA_EEI_EEI9. */
#define BF_DMA_EEI_EEI9(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_EEI_EEI9) & BM_DMA_EEI_EEI9)

/*! @brief Set the EEI9 field to a new value. */
#define BW_DMA_EEI_EEI9(x, v) (BITBAND_ACCESS32(HW_DMA_EEI_ADDR(x), BP_DMA_EEI_EEI9) = (v))
/*@}*/

/*!
 * @name Register DMA_EEI, field EEI10[10] (RW)
 *
 * Values:
 * - 0 - The error signal for corresponding channel does not generate an error
 *     interrupt
 * - 1 - The assertion of the error signal for corresponding channel generates
 *     an error interrupt request
 */
/*@{*/
#define BP_DMA_EEI_EEI10     (10U)         /*!< Bit position for DMA_EEI_EEI10. */
#define BM_DMA_EEI_EEI10     (0x00000400U) /*!< Bit mask for DMA_EEI_EEI10. */
#define BS_DMA_EEI_EEI10     (1U)          /*!< Bit field size in bits for DMA_EEI_EEI10. */

/*! @brief Read current value of the DMA_EEI_EEI10 field. */
#define BR_DMA_EEI_EEI10(x)  (BITBAND_ACCESS32(HW_DMA_EEI_ADDR(x), BP_DMA_EEI_EEI10))

/*! @brief Format value for bitfield DMA_EEI_EEI10. */
#define BF_DMA_EEI_EEI10(v)  ((uint32_t)((uint32_t)(v) << BP_DMA_EEI_EEI10) & BM_DMA_EEI_EEI10)

/*! @brief Set the EEI10 field to a new value. */
#define BW_DMA_EEI_EEI10(x, v) (BITBAND_ACCESS32(HW_DMA_EEI_ADDR(x), BP_DMA_EEI_EEI10) = (v))
/*@}*/

/*!
 * @name Register DMA_EEI, field EEI11[11] (RW)
 *
 * Values:
 * - 0 - The error signal for corresponding channel does not generate an error
 *     interrupt
 * - 1 - The assertion of the error signal for corresponding channel generates
 *     an error interrupt request
 */
/*@{*/
#define BP_DMA_EEI_EEI11     (11U)         /*!< Bit position for DMA_EEI_EEI11. */
#define BM_DMA_EEI_EEI11     (0x00000800U) /*!< Bit mask for DMA_EEI_EEI11. */
#define BS_DMA_EEI_EEI11     (1U)          /*!< Bit field size in bits for DMA_EEI_EEI11. */

/*! @brief Read current value of the DMA_EEI_EEI11 field. */
#define BR_DMA_EEI_EEI11(x)  (BITBAND_ACCESS32(HW_DMA_EEI_ADDR(x), BP_DMA_EEI_EEI11))

/*! @brief Format value for bitfield DMA_EEI_EEI11. */
#define BF_DMA_EEI_EEI11(v)  ((uint32_t)((uint32_t)(v) << BP_DMA_EEI_EEI11) & BM_DMA_EEI_EEI11)

/*! @brief Set the EEI11 field to a new value. */
#define BW_DMA_EEI_EEI11(x, v) (BITBAND_ACCESS32(HW_DMA_EEI_ADDR(x), BP_DMA_EEI_EEI11) = (v))
/*@}*/

/*!
 * @name Register DMA_EEI, field EEI12[12] (RW)
 *
 * Values:
 * - 0 - The error signal for corresponding channel does not generate an error
 *     interrupt
 * - 1 - The assertion of the error signal for corresponding channel generates
 *     an error interrupt request
 */
/*@{*/
#define BP_DMA_EEI_EEI12     (12U)         /*!< Bit position for DMA_EEI_EEI12. */
#define BM_DMA_EEI_EEI12     (0x00001000U) /*!< Bit mask for DMA_EEI_EEI12. */
#define BS_DMA_EEI_EEI12     (1U)          /*!< Bit field size in bits for DMA_EEI_EEI12. */

/*! @brief Read current value of the DMA_EEI_EEI12 field. */
#define BR_DMA_EEI_EEI12(x)  (BITBAND_ACCESS32(HW_DMA_EEI_ADDR(x), BP_DMA_EEI_EEI12))

/*! @brief Format value for bitfield DMA_EEI_EEI12. */
#define BF_DMA_EEI_EEI12(v)  ((uint32_t)((uint32_t)(v) << BP_DMA_EEI_EEI12) & BM_DMA_EEI_EEI12)

/*! @brief Set the EEI12 field to a new value. */
#define BW_DMA_EEI_EEI12(x, v) (BITBAND_ACCESS32(HW_DMA_EEI_ADDR(x), BP_DMA_EEI_EEI12) = (v))
/*@}*/

/*!
 * @name Register DMA_EEI, field EEI13[13] (RW)
 *
 * Values:
 * - 0 - The error signal for corresponding channel does not generate an error
 *     interrupt
 * - 1 - The assertion of the error signal for corresponding channel generates
 *     an error interrupt request
 */
/*@{*/
#define BP_DMA_EEI_EEI13     (13U)         /*!< Bit position for DMA_EEI_EEI13. */
#define BM_DMA_EEI_EEI13     (0x00002000U) /*!< Bit mask for DMA_EEI_EEI13. */
#define BS_DMA_EEI_EEI13     (1U)          /*!< Bit field size in bits for DMA_EEI_EEI13. */

/*! @brief Read current value of the DMA_EEI_EEI13 field. */
#define BR_DMA_EEI_EEI13(x)  (BITBAND_ACCESS32(HW_DMA_EEI_ADDR(x), BP_DMA_EEI_EEI13))

/*! @brief Format value for bitfield DMA_EEI_EEI13. */
#define BF_DMA_EEI_EEI13(v)  ((uint32_t)((uint32_t)(v) << BP_DMA_EEI_EEI13) & BM_DMA_EEI_EEI13)

/*! @brief Set the EEI13 field to a new value. */
#define BW_DMA_EEI_EEI13(x, v) (BITBAND_ACCESS32(HW_DMA_EEI_ADDR(x), BP_DMA_EEI_EEI13) = (v))
/*@}*/

/*!
 * @name Register DMA_EEI, field EEI14[14] (RW)
 *
 * Values:
 * - 0 - The error signal for corresponding channel does not generate an error
 *     interrupt
 * - 1 - The assertion of the error signal for corresponding channel generates
 *     an error interrupt request
 */
/*@{*/
#define BP_DMA_EEI_EEI14     (14U)         /*!< Bit position for DMA_EEI_EEI14. */
#define BM_DMA_EEI_EEI14     (0x00004000U) /*!< Bit mask for DMA_EEI_EEI14. */
#define BS_DMA_EEI_EEI14     (1U)          /*!< Bit field size in bits for DMA_EEI_EEI14. */

/*! @brief Read current value of the DMA_EEI_EEI14 field. */
#define BR_DMA_EEI_EEI14(x)  (BITBAND_ACCESS32(HW_DMA_EEI_ADDR(x), BP_DMA_EEI_EEI14))

/*! @brief Format value for bitfield DMA_EEI_EEI14. */
#define BF_DMA_EEI_EEI14(v)  ((uint32_t)((uint32_t)(v) << BP_DMA_EEI_EEI14) & BM_DMA_EEI_EEI14)

/*! @brief Set the EEI14 field to a new value. */
#define BW_DMA_EEI_EEI14(x, v) (BITBAND_ACCESS32(HW_DMA_EEI_ADDR(x), BP_DMA_EEI_EEI14) = (v))
/*@}*/

/*!
 * @name Register DMA_EEI, field EEI15[15] (RW)
 *
 * Values:
 * - 0 - The error signal for corresponding channel does not generate an error
 *     interrupt
 * - 1 - The assertion of the error signal for corresponding channel generates
 *     an error interrupt request
 */
/*@{*/
#define BP_DMA_EEI_EEI15     (15U)         /*!< Bit position for DMA_EEI_EEI15. */
#define BM_DMA_EEI_EEI15     (0x00008000U) /*!< Bit mask for DMA_EEI_EEI15. */
#define BS_DMA_EEI_EEI15     (1U)          /*!< Bit field size in bits for DMA_EEI_EEI15. */

/*! @brief Read current value of the DMA_EEI_EEI15 field. */
#define BR_DMA_EEI_EEI15(x)  (BITBAND_ACCESS32(HW_DMA_EEI_ADDR(x), BP_DMA_EEI_EEI15))

/*! @brief Format value for bitfield DMA_EEI_EEI15. */
#define BF_DMA_EEI_EEI15(v)  ((uint32_t)((uint32_t)(v) << BP_DMA_EEI_EEI15) & BM_DMA_EEI_EEI15)

/*! @brief Set the EEI15 field to a new value. */
#define BW_DMA_EEI_EEI15(x, v) (BITBAND_ACCESS32(HW_DMA_EEI_ADDR(x), BP_DMA_EEI_EEI15) = (v))
/*@}*/

/*******************************************************************************
 * HW_DMA_CEEI - Clear Enable Error Interrupt Register
 ******************************************************************************/

/*!
 * @brief HW_DMA_CEEI - Clear Enable Error Interrupt Register (WO)
 *
 * Reset value: 0x00U
 *
 * The CEEI provides a simple memory-mapped mechanism to clear a given bit in
 * the EEI to disable the error interrupt for a given channel. The data value on a
 * register write causes the corresponding bit in the EEI to be cleared. Setting
 * the CAEE bit provides a global clear function, forcing the EEI contents to be
 * cleared, disabling all DMA request inputs. If the NOP bit is set, the command
 * is ignored. This allows you to write multiple-byte registers as a 32-bit word.
 * Reads of this register return all zeroes.
 */
typedef union _hw_dma_ceei
{
    uint8_t U;
    struct _hw_dma_ceei_bitfields
    {
        uint8_t CEEI : 4;              /*!< [3:0] Clear Enable Error Interrupt */
        uint8_t RESERVED0 : 2;         /*!< [5:4]  */
        uint8_t CAEE : 1;              /*!< [6] Clear All Enable Error Interrupts */
        uint8_t NOP : 1;               /*!< [7] No Op enable */
    } B;
} hw_dma_ceei_t;

/*!
 * @name Constants and macros for entire DMA_CEEI register
 */
/*@{*/
#define HW_DMA_CEEI_ADDR(x)      ((x) + 0x18U)

#define HW_DMA_CEEI(x)           (*(__O hw_dma_ceei_t *) HW_DMA_CEEI_ADDR(x))
#define HW_DMA_CEEI_RD(x)        (HW_DMA_CEEI(x).U)
#define HW_DMA_CEEI_WR(x, v)     (HW_DMA_CEEI(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual DMA_CEEI bitfields
 */

/*!
 * @name Register DMA_CEEI, field CEEI[3:0] (WORZ)
 *
 * Clears the corresponding bit in EEI
 */
/*@{*/
#define BP_DMA_CEEI_CEEI     (0U)          /*!< Bit position for DMA_CEEI_CEEI. */
#define BM_DMA_CEEI_CEEI     (0x0FU)       /*!< Bit mask for DMA_CEEI_CEEI. */
#define BS_DMA_CEEI_CEEI     (4U)          /*!< Bit field size in bits for DMA_CEEI_CEEI. */

/*! @brief Format value for bitfield DMA_CEEI_CEEI. */
#define BF_DMA_CEEI_CEEI(v)  ((uint8_t)((uint8_t)(v) << BP_DMA_CEEI_CEEI) & BM_DMA_CEEI_CEEI)

/*! @brief Set the CEEI field to a new value. */
#define BW_DMA_CEEI_CEEI(x, v) (HW_DMA_CEEI_WR(x, (HW_DMA_CEEI_RD(x) & ~BM_DMA_CEEI_CEEI) | BF_DMA_CEEI_CEEI(v)))
/*@}*/

/*!
 * @name Register DMA_CEEI, field CAEE[6] (WORZ)
 *
 * Values:
 * - 0 - Clear only the EEI bit specified in the CEEI field
 * - 1 - Clear all bits in EEI
 */
/*@{*/
#define BP_DMA_CEEI_CAEE     (6U)          /*!< Bit position for DMA_CEEI_CAEE. */
#define BM_DMA_CEEI_CAEE     (0x40U)       /*!< Bit mask for DMA_CEEI_CAEE. */
#define BS_DMA_CEEI_CAEE     (1U)          /*!< Bit field size in bits for DMA_CEEI_CAEE. */

/*! @brief Format value for bitfield DMA_CEEI_CAEE. */
#define BF_DMA_CEEI_CAEE(v)  ((uint8_t)((uint8_t)(v) << BP_DMA_CEEI_CAEE) & BM_DMA_CEEI_CAEE)

/*! @brief Set the CAEE field to a new value. */
#define BW_DMA_CEEI_CAEE(x, v) (BITBAND_ACCESS8(HW_DMA_CEEI_ADDR(x), BP_DMA_CEEI_CAEE) = (v))
/*@}*/

/*!
 * @name Register DMA_CEEI, field NOP[7] (WORZ)
 *
 * Values:
 * - 0 - Normal operation
 * - 1 - No operation, ignore the other bits in this register
 */
/*@{*/
#define BP_DMA_CEEI_NOP      (7U)          /*!< Bit position for DMA_CEEI_NOP. */
#define BM_DMA_CEEI_NOP      (0x80U)       /*!< Bit mask for DMA_CEEI_NOP. */
#define BS_DMA_CEEI_NOP      (1U)          /*!< Bit field size in bits for DMA_CEEI_NOP. */

/*! @brief Format value for bitfield DMA_CEEI_NOP. */
#define BF_DMA_CEEI_NOP(v)   ((uint8_t)((uint8_t)(v) << BP_DMA_CEEI_NOP) & BM_DMA_CEEI_NOP)

/*! @brief Set the NOP field to a new value. */
#define BW_DMA_CEEI_NOP(x, v) (BITBAND_ACCESS8(HW_DMA_CEEI_ADDR(x), BP_DMA_CEEI_NOP) = (v))
/*@}*/

/*******************************************************************************
 * HW_DMA_SEEI - Set Enable Error Interrupt Register
 ******************************************************************************/

/*!
 * @brief HW_DMA_SEEI - Set Enable Error Interrupt Register (WO)
 *
 * Reset value: 0x00U
 *
 * The SEEI provides a simple memory-mapped mechanism to set a given bit in the
 * EEI to enable the error interrupt for a given channel. The data value on a
 * register write causes the corresponding bit in the EEI to be set. Setting the
 * SAEE bit provides a global set function, forcing the entire EEI contents to be
 * set. If the NOP bit is set, the command is ignored. This allows you to write
 * multiple-byte registers as a 32-bit word. Reads of this register return all
 * zeroes.
 */
typedef union _hw_dma_seei
{
    uint8_t U;
    struct _hw_dma_seei_bitfields
    {
        uint8_t SEEI : 4;              /*!< [3:0] Set Enable Error Interrupt */
        uint8_t RESERVED0 : 2;         /*!< [5:4]  */
        uint8_t SAEE : 1;              /*!< [6] Sets All Enable Error Interrupts */
        uint8_t NOP : 1;               /*!< [7] No Op enable */
    } B;
} hw_dma_seei_t;

/*!
 * @name Constants and macros for entire DMA_SEEI register
 */
/*@{*/
#define HW_DMA_SEEI_ADDR(x)      ((x) + 0x19U)

#define HW_DMA_SEEI(x)           (*(__O hw_dma_seei_t *) HW_DMA_SEEI_ADDR(x))
#define HW_DMA_SEEI_RD(x)        (HW_DMA_SEEI(x).U)
#define HW_DMA_SEEI_WR(x, v)     (HW_DMA_SEEI(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual DMA_SEEI bitfields
 */

/*!
 * @name Register DMA_SEEI, field SEEI[3:0] (WORZ)
 *
 * Sets the corresponding bit in EEI
 */
/*@{*/
#define BP_DMA_SEEI_SEEI     (0U)          /*!< Bit position for DMA_SEEI_SEEI. */
#define BM_DMA_SEEI_SEEI     (0x0FU)       /*!< Bit mask for DMA_SEEI_SEEI. */
#define BS_DMA_SEEI_SEEI     (4U)          /*!< Bit field size in bits for DMA_SEEI_SEEI. */

/*! @brief Format value for bitfield DMA_SEEI_SEEI. */
#define BF_DMA_SEEI_SEEI(v)  ((uint8_t)((uint8_t)(v) << BP_DMA_SEEI_SEEI) & BM_DMA_SEEI_SEEI)

/*! @brief Set the SEEI field to a new value. */
#define BW_DMA_SEEI_SEEI(x, v) (HW_DMA_SEEI_WR(x, (HW_DMA_SEEI_RD(x) & ~BM_DMA_SEEI_SEEI) | BF_DMA_SEEI_SEEI(v)))
/*@}*/

/*!
 * @name Register DMA_SEEI, field SAEE[6] (WORZ)
 *
 * Values:
 * - 0 - Set only the EEI bit specified in the SEEI field.
 * - 1 - Sets all bits in EEI
 */
/*@{*/
#define BP_DMA_SEEI_SAEE     (6U)          /*!< Bit position for DMA_SEEI_SAEE. */
#define BM_DMA_SEEI_SAEE     (0x40U)       /*!< Bit mask for DMA_SEEI_SAEE. */
#define BS_DMA_SEEI_SAEE     (1U)          /*!< Bit field size in bits for DMA_SEEI_SAEE. */

/*! @brief Format value for bitfield DMA_SEEI_SAEE. */
#define BF_DMA_SEEI_SAEE(v)  ((uint8_t)((uint8_t)(v) << BP_DMA_SEEI_SAEE) & BM_DMA_SEEI_SAEE)

/*! @brief Set the SAEE field to a new value. */
#define BW_DMA_SEEI_SAEE(x, v) (BITBAND_ACCESS8(HW_DMA_SEEI_ADDR(x), BP_DMA_SEEI_SAEE) = (v))
/*@}*/

/*!
 * @name Register DMA_SEEI, field NOP[7] (WORZ)
 *
 * Values:
 * - 0 - Normal operation
 * - 1 - No operation, ignore the other bits in this register
 */
/*@{*/
#define BP_DMA_SEEI_NOP      (7U)          /*!< Bit position for DMA_SEEI_NOP. */
#define BM_DMA_SEEI_NOP      (0x80U)       /*!< Bit mask for DMA_SEEI_NOP. */
#define BS_DMA_SEEI_NOP      (1U)          /*!< Bit field size in bits for DMA_SEEI_NOP. */

/*! @brief Format value for bitfield DMA_SEEI_NOP. */
#define BF_DMA_SEEI_NOP(v)   ((uint8_t)((uint8_t)(v) << BP_DMA_SEEI_NOP) & BM_DMA_SEEI_NOP)

/*! @brief Set the NOP field to a new value. */
#define BW_DMA_SEEI_NOP(x, v) (BITBAND_ACCESS8(HW_DMA_SEEI_ADDR(x), BP_DMA_SEEI_NOP) = (v))
/*@}*/

/*******************************************************************************
 * HW_DMA_CERQ - Clear Enable Request Register
 ******************************************************************************/

/*!
 * @brief HW_DMA_CERQ - Clear Enable Request Register (WO)
 *
 * Reset value: 0x00U
 *
 * The CERQ provides a simple memory-mapped mechanism to clear a given bit in
 * the ERQ to disable the DMA request for a given channel. The data value on a
 * register write causes the corresponding bit in the ERQ to be cleared. Setting the
 * CAER bit provides a global clear function, forcing the entire contents of the
 * ERQ to be cleared, disabling all DMA request inputs. If NOP is set, the
 * command is ignored. This allows you to write multiple-byte registers as a 32-bit
 * word. Reads of this register return all zeroes.
 */
typedef union _hw_dma_cerq
{
    uint8_t U;
    struct _hw_dma_cerq_bitfields
    {
        uint8_t CERQ : 4;              /*!< [3:0] Clear Enable Request */
        uint8_t RESERVED0 : 2;         /*!< [5:4]  */
        uint8_t CAER : 1;              /*!< [6] Clear All Enable Requests */
        uint8_t NOP : 1;               /*!< [7] No Op enable */
    } B;
} hw_dma_cerq_t;

/*!
 * @name Constants and macros for entire DMA_CERQ register
 */
/*@{*/
#define HW_DMA_CERQ_ADDR(x)      ((x) + 0x1AU)

#define HW_DMA_CERQ(x)           (*(__O hw_dma_cerq_t *) HW_DMA_CERQ_ADDR(x))
#define HW_DMA_CERQ_RD(x)        (HW_DMA_CERQ(x).U)
#define HW_DMA_CERQ_WR(x, v)     (HW_DMA_CERQ(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual DMA_CERQ bitfields
 */

/*!
 * @name Register DMA_CERQ, field CERQ[3:0] (WORZ)
 *
 * Clears the corresponding bit in ERQ
 */
/*@{*/
#define BP_DMA_CERQ_CERQ     (0U)          /*!< Bit position for DMA_CERQ_CERQ. */
#define BM_DMA_CERQ_CERQ     (0x0FU)       /*!< Bit mask for DMA_CERQ_CERQ. */
#define BS_DMA_CERQ_CERQ     (4U)          /*!< Bit field size in bits for DMA_CERQ_CERQ. */

/*! @brief Format value for bitfield DMA_CERQ_CERQ. */
#define BF_DMA_CERQ_CERQ(v)  ((uint8_t)((uint8_t)(v) << BP_DMA_CERQ_CERQ) & BM_DMA_CERQ_CERQ)

/*! @brief Set the CERQ field to a new value. */
#define BW_DMA_CERQ_CERQ(x, v) (HW_DMA_CERQ_WR(x, (HW_DMA_CERQ_RD(x) & ~BM_DMA_CERQ_CERQ) | BF_DMA_CERQ_CERQ(v)))
/*@}*/

/*!
 * @name Register DMA_CERQ, field CAER[6] (WORZ)
 *
 * Values:
 * - 0 - Clear only the ERQ bit specified in the CERQ field
 * - 1 - Clear all bits in ERQ
 */
/*@{*/
#define BP_DMA_CERQ_CAER     (6U)          /*!< Bit position for DMA_CERQ_CAER. */
#define BM_DMA_CERQ_CAER     (0x40U)       /*!< Bit mask for DMA_CERQ_CAER. */
#define BS_DMA_CERQ_CAER     (1U)          /*!< Bit field size in bits for DMA_CERQ_CAER. */

/*! @brief Format value for bitfield DMA_CERQ_CAER. */
#define BF_DMA_CERQ_CAER(v)  ((uint8_t)((uint8_t)(v) << BP_DMA_CERQ_CAER) & BM_DMA_CERQ_CAER)

/*! @brief Set the CAER field to a new value. */
#define BW_DMA_CERQ_CAER(x, v) (BITBAND_ACCESS8(HW_DMA_CERQ_ADDR(x), BP_DMA_CERQ_CAER) = (v))
/*@}*/

/*!
 * @name Register DMA_CERQ, field NOP[7] (WORZ)
 *
 * Values:
 * - 0 - Normal operation
 * - 1 - No operation, ignore the other bits in this register
 */
/*@{*/
#define BP_DMA_CERQ_NOP      (7U)          /*!< Bit position for DMA_CERQ_NOP. */
#define BM_DMA_CERQ_NOP      (0x80U)       /*!< Bit mask for DMA_CERQ_NOP. */
#define BS_DMA_CERQ_NOP      (1U)          /*!< Bit field size in bits for DMA_CERQ_NOP. */

/*! @brief Format value for bitfield DMA_CERQ_NOP. */
#define BF_DMA_CERQ_NOP(v)   ((uint8_t)((uint8_t)(v) << BP_DMA_CERQ_NOP) & BM_DMA_CERQ_NOP)

/*! @brief Set the NOP field to a new value. */
#define BW_DMA_CERQ_NOP(x, v) (BITBAND_ACCESS8(HW_DMA_CERQ_ADDR(x), BP_DMA_CERQ_NOP) = (v))
/*@}*/

/*******************************************************************************
 * HW_DMA_SERQ - Set Enable Request Register
 ******************************************************************************/

/*!
 * @brief HW_DMA_SERQ - Set Enable Request Register (WO)
 *
 * Reset value: 0x00U
 *
 * The SERQ provides a simple memory-mapped mechanism to set a given bit in the
 * ERQ to enable the DMA request for a given channel. The data value on a
 * register write causes the corresponding bit in the ERQ to be set. Setting the SAER
 * bit provides a global set function, forcing the entire contents of ERQ to be
 * set. If the NOP bit is set, the command is ignored. This allows you to write
 * multiple-byte registers as a 32-bit word. Reads of this register return all zeroes.
 */
typedef union _hw_dma_serq
{
    uint8_t U;
    struct _hw_dma_serq_bitfields
    {
        uint8_t SERQ : 4;              /*!< [3:0] Set enable request */
        uint8_t RESERVED0 : 2;         /*!< [5:4]  */
        uint8_t SAER : 1;              /*!< [6] Set All Enable Requests */
        uint8_t NOP : 1;               /*!< [7] No Op enable */
    } B;
} hw_dma_serq_t;

/*!
 * @name Constants and macros for entire DMA_SERQ register
 */
/*@{*/
#define HW_DMA_SERQ_ADDR(x)      ((x) + 0x1BU)

#define HW_DMA_SERQ(x)           (*(__O hw_dma_serq_t *) HW_DMA_SERQ_ADDR(x))
#define HW_DMA_SERQ_RD(x)        (HW_DMA_SERQ(x).U)
#define HW_DMA_SERQ_WR(x, v)     (HW_DMA_SERQ(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual DMA_SERQ bitfields
 */

/*!
 * @name Register DMA_SERQ, field SERQ[3:0] (WORZ)
 *
 * Sets the corresponding bit in ERQ
 */
/*@{*/
#define BP_DMA_SERQ_SERQ     (0U)          /*!< Bit position for DMA_SERQ_SERQ. */
#define BM_DMA_SERQ_SERQ     (0x0FU)       /*!< Bit mask for DMA_SERQ_SERQ. */
#define BS_DMA_SERQ_SERQ     (4U)          /*!< Bit field size in bits for DMA_SERQ_SERQ. */

/*! @brief Format value for bitfield DMA_SERQ_SERQ. */
#define BF_DMA_SERQ_SERQ(v)  ((uint8_t)((uint8_t)(v) << BP_DMA_SERQ_SERQ) & BM_DMA_SERQ_SERQ)

/*! @brief Set the SERQ field to a new value. */
#define BW_DMA_SERQ_SERQ(x, v) (HW_DMA_SERQ_WR(x, (HW_DMA_SERQ_RD(x) & ~BM_DMA_SERQ_SERQ) | BF_DMA_SERQ_SERQ(v)))
/*@}*/

/*!
 * @name Register DMA_SERQ, field SAER[6] (WORZ)
 *
 * Values:
 * - 0 - Set only the ERQ bit specified in the SERQ field
 * - 1 - Set all bits in ERQ
 */
/*@{*/
#define BP_DMA_SERQ_SAER     (6U)          /*!< Bit position for DMA_SERQ_SAER. */
#define BM_DMA_SERQ_SAER     (0x40U)       /*!< Bit mask for DMA_SERQ_SAER. */
#define BS_DMA_SERQ_SAER     (1U)          /*!< Bit field size in bits for DMA_SERQ_SAER. */

/*! @brief Format value for bitfield DMA_SERQ_SAER. */
#define BF_DMA_SERQ_SAER(v)  ((uint8_t)((uint8_t)(v) << BP_DMA_SERQ_SAER) & BM_DMA_SERQ_SAER)

/*! @brief Set the SAER field to a new value. */
#define BW_DMA_SERQ_SAER(x, v) (BITBAND_ACCESS8(HW_DMA_SERQ_ADDR(x), BP_DMA_SERQ_SAER) = (v))
/*@}*/

/*!
 * @name Register DMA_SERQ, field NOP[7] (WORZ)
 *
 * Values:
 * - 0 - Normal operation
 * - 1 - No operation, ignore the other bits in this register
 */
/*@{*/
#define BP_DMA_SERQ_NOP      (7U)          /*!< Bit position for DMA_SERQ_NOP. */
#define BM_DMA_SERQ_NOP      (0x80U)       /*!< Bit mask for DMA_SERQ_NOP. */
#define BS_DMA_SERQ_NOP      (1U)          /*!< Bit field size in bits for DMA_SERQ_NOP. */

/*! @brief Format value for bitfield DMA_SERQ_NOP. */
#define BF_DMA_SERQ_NOP(v)   ((uint8_t)((uint8_t)(v) << BP_DMA_SERQ_NOP) & BM_DMA_SERQ_NOP)

/*! @brief Set the NOP field to a new value. */
#define BW_DMA_SERQ_NOP(x, v) (BITBAND_ACCESS8(HW_DMA_SERQ_ADDR(x), BP_DMA_SERQ_NOP) = (v))
/*@}*/

/*******************************************************************************
 * HW_DMA_CDNE - Clear DONE Status Bit Register
 ******************************************************************************/

/*!
 * @brief HW_DMA_CDNE - Clear DONE Status Bit Register (WO)
 *
 * Reset value: 0x00U
 *
 * The CDNE provides a simple memory-mapped mechanism to clear the DONE bit in
 * the TCD of the given channel. The data value on a register write causes the
 * DONE bit in the corresponding transfer control descriptor to be cleared. Setting
 * the CADN bit provides a global clear function, forcing all DONE bits to be
 * cleared. If the NOP bit is set, the command is ignored. This allows you to write
 * multiple-byte registers as a 32-bit word. Reads of this register return all
 * zeroes.
 */
typedef union _hw_dma_cdne
{
    uint8_t U;
    struct _hw_dma_cdne_bitfields
    {
        uint8_t CDNE : 4;              /*!< [3:0] Clear DONE Bit */
        uint8_t RESERVED0 : 2;         /*!< [5:4]  */
        uint8_t CADN : 1;              /*!< [6] Clears All DONE Bits */
        uint8_t NOP : 1;               /*!< [7] No Op enable */
    } B;
} hw_dma_cdne_t;

/*!
 * @name Constants and macros for entire DMA_CDNE register
 */
/*@{*/
#define HW_DMA_CDNE_ADDR(x)      ((x) + 0x1CU)

#define HW_DMA_CDNE(x)           (*(__O hw_dma_cdne_t *) HW_DMA_CDNE_ADDR(x))
#define HW_DMA_CDNE_RD(x)        (HW_DMA_CDNE(x).U)
#define HW_DMA_CDNE_WR(x, v)     (HW_DMA_CDNE(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual DMA_CDNE bitfields
 */

/*!
 * @name Register DMA_CDNE, field CDNE[3:0] (WORZ)
 *
 * Clears the corresponding bit in TCDn_CSR[DONE]
 */
/*@{*/
#define BP_DMA_CDNE_CDNE     (0U)          /*!< Bit position for DMA_CDNE_CDNE. */
#define BM_DMA_CDNE_CDNE     (0x0FU)       /*!< Bit mask for DMA_CDNE_CDNE. */
#define BS_DMA_CDNE_CDNE     (4U)          /*!< Bit field size in bits for DMA_CDNE_CDNE. */

/*! @brief Format value for bitfield DMA_CDNE_CDNE. */
#define BF_DMA_CDNE_CDNE(v)  ((uint8_t)((uint8_t)(v) << BP_DMA_CDNE_CDNE) & BM_DMA_CDNE_CDNE)

/*! @brief Set the CDNE field to a new value. */
#define BW_DMA_CDNE_CDNE(x, v) (HW_DMA_CDNE_WR(x, (HW_DMA_CDNE_RD(x) & ~BM_DMA_CDNE_CDNE) | BF_DMA_CDNE_CDNE(v)))
/*@}*/

/*!
 * @name Register DMA_CDNE, field CADN[6] (WORZ)
 *
 * Values:
 * - 0 - Clears only the TCDn_CSR[DONE] bit specified in the CDNE field
 * - 1 - Clears all bits in TCDn_CSR[DONE]
 */
/*@{*/
#define BP_DMA_CDNE_CADN     (6U)          /*!< Bit position for DMA_CDNE_CADN. */
#define BM_DMA_CDNE_CADN     (0x40U)       /*!< Bit mask for DMA_CDNE_CADN. */
#define BS_DMA_CDNE_CADN     (1U)          /*!< Bit field size in bits for DMA_CDNE_CADN. */

/*! @brief Format value for bitfield DMA_CDNE_CADN. */
#define BF_DMA_CDNE_CADN(v)  ((uint8_t)((uint8_t)(v) << BP_DMA_CDNE_CADN) & BM_DMA_CDNE_CADN)

/*! @brief Set the CADN field to a new value. */
#define BW_DMA_CDNE_CADN(x, v) (BITBAND_ACCESS8(HW_DMA_CDNE_ADDR(x), BP_DMA_CDNE_CADN) = (v))
/*@}*/

/*!
 * @name Register DMA_CDNE, field NOP[7] (WORZ)
 *
 * Values:
 * - 0 - Normal operation
 * - 1 - No operation, ignore the other bits in this register
 */
/*@{*/
#define BP_DMA_CDNE_NOP      (7U)          /*!< Bit position for DMA_CDNE_NOP. */
#define BM_DMA_CDNE_NOP      (0x80U)       /*!< Bit mask for DMA_CDNE_NOP. */
#define BS_DMA_CDNE_NOP      (1U)          /*!< Bit field size in bits for DMA_CDNE_NOP. */

/*! @brief Format value for bitfield DMA_CDNE_NOP. */
#define BF_DMA_CDNE_NOP(v)   ((uint8_t)((uint8_t)(v) << BP_DMA_CDNE_NOP) & BM_DMA_CDNE_NOP)

/*! @brief Set the NOP field to a new value. */
#define BW_DMA_CDNE_NOP(x, v) (BITBAND_ACCESS8(HW_DMA_CDNE_ADDR(x), BP_DMA_CDNE_NOP) = (v))
/*@}*/

/*******************************************************************************
 * HW_DMA_SSRT - Set START Bit Register
 ******************************************************************************/

/*!
 * @brief HW_DMA_SSRT - Set START Bit Register (WO)
 *
 * Reset value: 0x00U
 *
 * The SSRT provides a simple memory-mapped mechanism to set the START bit in
 * the TCD of the given channel. The data value on a register write causes the
 * START bit in the corresponding transfer control descriptor to be set. Setting the
 * SAST bit provides a global set function, forcing all START bits to be set. If
 * the NOP bit is set, the command is ignored. This allows you to write
 * multiple-byte registers as a 32-bit word. Reads of this register return all zeroes.
 */
typedef union _hw_dma_ssrt
{
    uint8_t U;
    struct _hw_dma_ssrt_bitfields
    {
        uint8_t SSRT : 4;              /*!< [3:0] Set START Bit */
        uint8_t RESERVED0 : 2;         /*!< [5:4]  */
        uint8_t SAST : 1;              /*!< [6] Set All START Bits (activates all
                                        * channels) */
        uint8_t NOP : 1;               /*!< [7] No Op enable */
    } B;
} hw_dma_ssrt_t;

/*!
 * @name Constants and macros for entire DMA_SSRT register
 */
/*@{*/
#define HW_DMA_SSRT_ADDR(x)      ((x) + 0x1DU)

#define HW_DMA_SSRT(x)           (*(__O hw_dma_ssrt_t *) HW_DMA_SSRT_ADDR(x))
#define HW_DMA_SSRT_RD(x)        (HW_DMA_SSRT(x).U)
#define HW_DMA_SSRT_WR(x, v)     (HW_DMA_SSRT(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual DMA_SSRT bitfields
 */

/*!
 * @name Register DMA_SSRT, field SSRT[3:0] (WORZ)
 *
 * Sets the corresponding bit in TCDn_CSR[START]
 */
/*@{*/
#define BP_DMA_SSRT_SSRT     (0U)          /*!< Bit position for DMA_SSRT_SSRT. */
#define BM_DMA_SSRT_SSRT     (0x0FU)       /*!< Bit mask for DMA_SSRT_SSRT. */
#define BS_DMA_SSRT_SSRT     (4U)          /*!< Bit field size in bits for DMA_SSRT_SSRT. */

/*! @brief Format value for bitfield DMA_SSRT_SSRT. */
#define BF_DMA_SSRT_SSRT(v)  ((uint8_t)((uint8_t)(v) << BP_DMA_SSRT_SSRT) & BM_DMA_SSRT_SSRT)

/*! @brief Set the SSRT field to a new value. */
#define BW_DMA_SSRT_SSRT(x, v) (HW_DMA_SSRT_WR(x, (HW_DMA_SSRT_RD(x) & ~BM_DMA_SSRT_SSRT) | BF_DMA_SSRT_SSRT(v)))
/*@}*/

/*!
 * @name Register DMA_SSRT, field SAST[6] (WORZ)
 *
 * Values:
 * - 0 - Set only the TCDn_CSR[START] bit specified in the SSRT field
 * - 1 - Set all bits in TCDn_CSR[START]
 */
/*@{*/
#define BP_DMA_SSRT_SAST     (6U)          /*!< Bit position for DMA_SSRT_SAST. */
#define BM_DMA_SSRT_SAST     (0x40U)       /*!< Bit mask for DMA_SSRT_SAST. */
#define BS_DMA_SSRT_SAST     (1U)          /*!< Bit field size in bits for DMA_SSRT_SAST. */

/*! @brief Format value for bitfield DMA_SSRT_SAST. */
#define BF_DMA_SSRT_SAST(v)  ((uint8_t)((uint8_t)(v) << BP_DMA_SSRT_SAST) & BM_DMA_SSRT_SAST)

/*! @brief Set the SAST field to a new value. */
#define BW_DMA_SSRT_SAST(x, v) (BITBAND_ACCESS8(HW_DMA_SSRT_ADDR(x), BP_DMA_SSRT_SAST) = (v))
/*@}*/

/*!
 * @name Register DMA_SSRT, field NOP[7] (WORZ)
 *
 * Values:
 * - 0 - Normal operation
 * - 1 - No operation, ignore the other bits in this register
 */
/*@{*/
#define BP_DMA_SSRT_NOP      (7U)          /*!< Bit position for DMA_SSRT_NOP. */
#define BM_DMA_SSRT_NOP      (0x80U)       /*!< Bit mask for DMA_SSRT_NOP. */
#define BS_DMA_SSRT_NOP      (1U)          /*!< Bit field size in bits for DMA_SSRT_NOP. */

/*! @brief Format value for bitfield DMA_SSRT_NOP. */
#define BF_DMA_SSRT_NOP(v)   ((uint8_t)((uint8_t)(v) << BP_DMA_SSRT_NOP) & BM_DMA_SSRT_NOP)

/*! @brief Set the NOP field to a new value. */
#define BW_DMA_SSRT_NOP(x, v) (BITBAND_ACCESS8(HW_DMA_SSRT_ADDR(x), BP_DMA_SSRT_NOP) = (v))
/*@}*/

/*******************************************************************************
 * HW_DMA_CERR - Clear Error Register
 ******************************************************************************/

/*!
 * @brief HW_DMA_CERR - Clear Error Register (WO)
 *
 * Reset value: 0x00U
 *
 * The CERR provides a simple memory-mapped mechanism to clear a given bit in
 * the ERR to disable the error condition flag for a given channel. The given value
 * on a register write causes the corresponding bit in the ERR to be cleared.
 * Setting the CAEI bit provides a global clear function, forcing the ERR contents
 * to be cleared, clearing all channel error indicators. If the NOP bit is set,
 * the command is ignored. This allows you to write multiple-byte registers as a
 * 32-bit word. Reads of this register return all zeroes.
 */
typedef union _hw_dma_cerr
{
    uint8_t U;
    struct _hw_dma_cerr_bitfields
    {
        uint8_t CERR : 4;              /*!< [3:0] Clear Error Indicator */
        uint8_t RESERVED0 : 2;         /*!< [5:4]  */
        uint8_t CAEI : 1;              /*!< [6] Clear All Error Indicators */
        uint8_t NOP : 1;               /*!< [7] No Op enable */
    } B;
} hw_dma_cerr_t;

/*!
 * @name Constants and macros for entire DMA_CERR register
 */
/*@{*/
#define HW_DMA_CERR_ADDR(x)      ((x) + 0x1EU)

#define HW_DMA_CERR(x)           (*(__O hw_dma_cerr_t *) HW_DMA_CERR_ADDR(x))
#define HW_DMA_CERR_RD(x)        (HW_DMA_CERR(x).U)
#define HW_DMA_CERR_WR(x, v)     (HW_DMA_CERR(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual DMA_CERR bitfields
 */

/*!
 * @name Register DMA_CERR, field CERR[3:0] (WORZ)
 *
 * Clears the corresponding bit in ERR
 */
/*@{*/
#define BP_DMA_CERR_CERR     (0U)          /*!< Bit position for DMA_CERR_CERR. */
#define BM_DMA_CERR_CERR     (0x0FU)       /*!< Bit mask for DMA_CERR_CERR. */
#define BS_DMA_CERR_CERR     (4U)          /*!< Bit field size in bits for DMA_CERR_CERR. */

/*! @brief Format value for bitfield DMA_CERR_CERR. */
#define BF_DMA_CERR_CERR(v)  ((uint8_t)((uint8_t)(v) << BP_DMA_CERR_CERR) & BM_DMA_CERR_CERR)

/*! @brief Set the CERR field to a new value. */
#define BW_DMA_CERR_CERR(x, v) (HW_DMA_CERR_WR(x, (HW_DMA_CERR_RD(x) & ~BM_DMA_CERR_CERR) | BF_DMA_CERR_CERR(v)))
/*@}*/

/*!
 * @name Register DMA_CERR, field CAEI[6] (WORZ)
 *
 * Values:
 * - 0 - Clear only the ERR bit specified in the CERR field
 * - 1 - Clear all bits in ERR
 */
/*@{*/
#define BP_DMA_CERR_CAEI     (6U)          /*!< Bit position for DMA_CERR_CAEI. */
#define BM_DMA_CERR_CAEI     (0x40U)       /*!< Bit mask for DMA_CERR_CAEI. */
#define BS_DMA_CERR_CAEI     (1U)          /*!< Bit field size in bits for DMA_CERR_CAEI. */

/*! @brief Format value for bitfield DMA_CERR_CAEI. */
#define BF_DMA_CERR_CAEI(v)  ((uint8_t)((uint8_t)(v) << BP_DMA_CERR_CAEI) & BM_DMA_CERR_CAEI)

/*! @brief Set the CAEI field to a new value. */
#define BW_DMA_CERR_CAEI(x, v) (BITBAND_ACCESS8(HW_DMA_CERR_ADDR(x), BP_DMA_CERR_CAEI) = (v))
/*@}*/

/*!
 * @name Register DMA_CERR, field NOP[7] (WORZ)
 *
 * Values:
 * - 0 - Normal operation
 * - 1 - No operation, ignore the other bits in this register
 */
/*@{*/
#define BP_DMA_CERR_NOP      (7U)          /*!< Bit position for DMA_CERR_NOP. */
#define BM_DMA_CERR_NOP      (0x80U)       /*!< Bit mask for DMA_CERR_NOP. */
#define BS_DMA_CERR_NOP      (1U)          /*!< Bit field size in bits for DMA_CERR_NOP. */

/*! @brief Format value for bitfield DMA_CERR_NOP. */
#define BF_DMA_CERR_NOP(v)   ((uint8_t)((uint8_t)(v) << BP_DMA_CERR_NOP) & BM_DMA_CERR_NOP)

/*! @brief Set the NOP field to a new value. */
#define BW_DMA_CERR_NOP(x, v) (BITBAND_ACCESS8(HW_DMA_CERR_ADDR(x), BP_DMA_CERR_NOP) = (v))
/*@}*/

/*******************************************************************************
 * HW_DMA_CINT - Clear Interrupt Request Register
 ******************************************************************************/

/*!
 * @brief HW_DMA_CINT - Clear Interrupt Request Register (WO)
 *
 * Reset value: 0x00U
 *
 * The CINT provides a simple, memory-mapped mechanism to clear a given bit in
 * the INT to disable the interrupt request for a given channel. The given value
 * on a register write causes the corresponding bit in the INT to be cleared.
 * Setting the CAIR bit provides a global clear function, forcing the entire contents
 * of the INT to be cleared, disabling all DMA interrupt requests. If the NOP
 * bit is set, the command is ignored. This allows you to write multiple-byte
 * registers as a 32-bit word. Reads of this register return all zeroes.
 */
typedef union _hw_dma_cint
{
    uint8_t U;
    struct _hw_dma_cint_bitfields
    {
        uint8_t CINT : 4;              /*!< [3:0] Clear Interrupt Request */
        uint8_t RESERVED0 : 2;         /*!< [5:4]  */
        uint8_t CAIR : 1;              /*!< [6] Clear All Interrupt Requests */
        uint8_t NOP : 1;               /*!< [7] No Op enable */
    } B;
} hw_dma_cint_t;

/*!
 * @name Constants and macros for entire DMA_CINT register
 */
/*@{*/
#define HW_DMA_CINT_ADDR(x)      ((x) + 0x1FU)

#define HW_DMA_CINT(x)           (*(__O hw_dma_cint_t *) HW_DMA_CINT_ADDR(x))
#define HW_DMA_CINT_RD(x)        (HW_DMA_CINT(x).U)
#define HW_DMA_CINT_WR(x, v)     (HW_DMA_CINT(x).U = (v))
/*@}*/

/*
 * Constants & macros for individual DMA_CINT bitfields
 */

/*!
 * @name Register DMA_CINT, field CINT[3:0] (WORZ)
 *
 * Clears the corresponding bit in INT
 */
/*@{*/
#define BP_DMA_CINT_CINT     (0U)          /*!< Bit position for DMA_CINT_CINT. */
#define BM_DMA_CINT_CINT     (0x0FU)       /*!< Bit mask for DMA_CINT_CINT. */
#define BS_DMA_CINT_CINT     (4U)          /*!< Bit field size in bits for DMA_CINT_CINT. */

/*! @brief Format value for bitfield DMA_CINT_CINT. */
#define BF_DMA_CINT_CINT(v)  ((uint8_t)((uint8_t)(v) << BP_DMA_CINT_CINT) & BM_DMA_CINT_CINT)

/*! @brief Set the CINT field to a new value. */
#define BW_DMA_CINT_CINT(x, v) (HW_DMA_CINT_WR(x, (HW_DMA_CINT_RD(x) & ~BM_DMA_CINT_CINT) | BF_DMA_CINT_CINT(v)))
/*@}*/

/*!
 * @name Register DMA_CINT, field CAIR[6] (WORZ)
 *
 * Values:
 * - 0 - Clear only the INT bit specified in the CINT field
 * - 1 - Clear all bits in INT
 */
/*@{*/
#define BP_DMA_CINT_CAIR     (6U)          /*!< Bit position for DMA_CINT_CAIR. */
#define BM_DMA_CINT_CAIR     (0x40U)       /*!< Bit mask for DMA_CINT_CAIR. */
#define BS_DMA_CINT_CAIR     (1U)          /*!< Bit field size in bits for DMA_CINT_CAIR. */

/*! @brief Format value for bitfield DMA_CINT_CAIR. */
#define BF_DMA_CINT_CAIR(v)  ((uint8_t)((uint8_t)(v) << BP_DMA_CINT_CAIR) & BM_DMA_CINT_CAIR)

/*! @brief Set the CAIR field to a new value. */
#define BW_DMA_CINT_CAIR(x, v) (BITBAND_ACCESS8(HW_DMA_CINT_ADDR(x), BP_DMA_CINT_CAIR) = (v))
/*@}*/

/*!
 * @name Register DMA_CINT, field NOP[7] (WORZ)
 *
 * Values:
 * - 0 - Normal operation
 * - 1 - No operation, ignore the other bits in this register
 */
/*@{*/
#define BP_DMA_CINT_NOP      (7U)          /*!< Bit position for DMA_CINT_NOP. */
#define BM_DMA_CINT_NOP      (0x80U)       /*!< Bit mask for DMA_CINT_NOP. */
#define BS_DMA_CINT_NOP      (1U)          /*!< Bit field size in bits for DMA_CINT_NOP. */

/*! @brief Format value for bitfield DMA_CINT_NOP. */
#define BF_DMA_CINT_NOP(v)   ((uint8_t)((uint8_t)(v) << BP_DMA_CINT_NOP) & BM_DMA_CINT_NOP)

/*! @brief Set the NOP field to a new value. */
#define BW_DMA_CINT_NOP(x, v) (BITBAND_ACCESS8(HW_DMA_CINT_ADDR(x), BP_DMA_CINT_NOP) = (v))
/*@}*/

/*******************************************************************************
 * HW_DMA_INT - Interrupt Request Register
 ******************************************************************************/

/*!
 * @brief HW_DMA_INT - Interrupt Request Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The INT register provides a bit map for the 16 channels signaling the
 * presence of an interrupt request for each channel. Depending on the appropriate bit
 * setting in the transfer-control descriptors, the eDMA engine generates an
 * interrupt on data transfer completion. The outputs of this register are directly
 * routed to the interrupt controller (INTC). During the interrupt-service routine
 * associated with any given channel, it is the software's responsibility to
 * clear the appropriate bit, negating the interrupt request. Typically, a write to
 * the CINT register in the interrupt service routine is used for this purpose.
 * The state of any given channel's interrupt request is directly affected by
 * writes to this register; it is also affected by writes to the CINT register. On
 * writes to INT, a 1 in any bit position clears the corresponding channel's
 * interrupt request. A zero in any bit position has no affect on the corresponding
 * channel's current interrupt status. The CINT register is provided so the interrupt
 * request for a single channel can easily be cleared without the need to
 * perform a read-modify-write sequence to the INT register.
 */
typedef union _hw_dma_int
{
    uint32_t U;
    struct _hw_dma_int_bitfields
    {
        uint32_t INT0 : 1;             /*!< [0] Interrupt Request 0 */
        uint32_t INT1 : 1;             /*!< [1] Interrupt Request 1 */
        uint32_t INT2 : 1;             /*!< [2] Interrupt Request 2 */
        uint32_t INT3 : 1;             /*!< [3] Interrupt Request 3 */
        uint32_t INT4 : 1;             /*!< [4] Interrupt Request 4 */
        uint32_t INT5 : 1;             /*!< [5] Interrupt Request 5 */
        uint32_t INT6 : 1;             /*!< [6] Interrupt Request 6 */
        uint32_t INT7 : 1;             /*!< [7] Interrupt Request 7 */
        uint32_t INT8 : 1;             /*!< [8] Interrupt Request 8 */
        uint32_t INT9 : 1;             /*!< [9] Interrupt Request 9 */
        uint32_t INT10 : 1;            /*!< [10] Interrupt Request 10 */
        uint32_t INT11 : 1;            /*!< [11] Interrupt Request 11 */
        uint32_t INT12 : 1;            /*!< [12] Interrupt Request 12 */
        uint32_t INT13 : 1;            /*!< [13] Interrupt Request 13 */
        uint32_t INT14 : 1;            /*!< [14] Interrupt Request 14 */
        uint32_t INT15 : 1;            /*!< [15] Interrupt Request 15 */
        uint32_t RESERVED0 : 16;       /*!< [31:16]  */
    } B;
} hw_dma_int_t;

/*!
 * @name Constants and macros for entire DMA_INT register
 */
/*@{*/
#define HW_DMA_INT_ADDR(x)       ((x) + 0x24U)

#define HW_DMA_INT(x)            (*(__IO hw_dma_int_t *) HW_DMA_INT_ADDR(x))
#define HW_DMA_INT_RD(x)         (HW_DMA_INT(x).U)
#define HW_DMA_INT_WR(x, v)      (HW_DMA_INT(x).U = (v))
#define HW_DMA_INT_SET(x, v)     (HW_DMA_INT_WR(x, HW_DMA_INT_RD(x) |  (v)))
#define HW_DMA_INT_CLR(x, v)     (HW_DMA_INT_WR(x, HW_DMA_INT_RD(x) & ~(v)))
#define HW_DMA_INT_TOG(x, v)     (HW_DMA_INT_WR(x, HW_DMA_INT_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DMA_INT bitfields
 */

/*!
 * @name Register DMA_INT, field INT0[0] (W1C)
 *
 * Values:
 * - 0 - The interrupt request for corresponding channel is cleared
 * - 1 - The interrupt request for corresponding channel is active
 */
/*@{*/
#define BP_DMA_INT_INT0      (0U)          /*!< Bit position for DMA_INT_INT0. */
#define BM_DMA_INT_INT0      (0x00000001U) /*!< Bit mask for DMA_INT_INT0. */
#define BS_DMA_INT_INT0      (1U)          /*!< Bit field size in bits for DMA_INT_INT0. */

/*! @brief Read current value of the DMA_INT_INT0 field. */
#define BR_DMA_INT_INT0(x)   (BITBAND_ACCESS32(HW_DMA_INT_ADDR(x), BP_DMA_INT_INT0))

/*! @brief Format value for bitfield DMA_INT_INT0. */
#define BF_DMA_INT_INT0(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_INT_INT0) & BM_DMA_INT_INT0)

/*! @brief Set the INT0 field to a new value. */
#define BW_DMA_INT_INT0(x, v) (BITBAND_ACCESS32(HW_DMA_INT_ADDR(x), BP_DMA_INT_INT0) = (v))
/*@}*/

/*!
 * @name Register DMA_INT, field INT1[1] (W1C)
 *
 * Values:
 * - 0 - The interrupt request for corresponding channel is cleared
 * - 1 - The interrupt request for corresponding channel is active
 */
/*@{*/
#define BP_DMA_INT_INT1      (1U)          /*!< Bit position for DMA_INT_INT1. */
#define BM_DMA_INT_INT1      (0x00000002U) /*!< Bit mask for DMA_INT_INT1. */
#define BS_DMA_INT_INT1      (1U)          /*!< Bit field size in bits for DMA_INT_INT1. */

/*! @brief Read current value of the DMA_INT_INT1 field. */
#define BR_DMA_INT_INT1(x)   (BITBAND_ACCESS32(HW_DMA_INT_ADDR(x), BP_DMA_INT_INT1))

/*! @brief Format value for bitfield DMA_INT_INT1. */
#define BF_DMA_INT_INT1(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_INT_INT1) & BM_DMA_INT_INT1)

/*! @brief Set the INT1 field to a new value. */
#define BW_DMA_INT_INT1(x, v) (BITBAND_ACCESS32(HW_DMA_INT_ADDR(x), BP_DMA_INT_INT1) = (v))
/*@}*/

/*!
 * @name Register DMA_INT, field INT2[2] (W1C)
 *
 * Values:
 * - 0 - The interrupt request for corresponding channel is cleared
 * - 1 - The interrupt request for corresponding channel is active
 */
/*@{*/
#define BP_DMA_INT_INT2      (2U)          /*!< Bit position for DMA_INT_INT2. */
#define BM_DMA_INT_INT2      (0x00000004U) /*!< Bit mask for DMA_INT_INT2. */
#define BS_DMA_INT_INT2      (1U)          /*!< Bit field size in bits for DMA_INT_INT2. */

/*! @brief Read current value of the DMA_INT_INT2 field. */
#define BR_DMA_INT_INT2(x)   (BITBAND_ACCESS32(HW_DMA_INT_ADDR(x), BP_DMA_INT_INT2))

/*! @brief Format value for bitfield DMA_INT_INT2. */
#define BF_DMA_INT_INT2(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_INT_INT2) & BM_DMA_INT_INT2)

/*! @brief Set the INT2 field to a new value. */
#define BW_DMA_INT_INT2(x, v) (BITBAND_ACCESS32(HW_DMA_INT_ADDR(x), BP_DMA_INT_INT2) = (v))
/*@}*/

/*!
 * @name Register DMA_INT, field INT3[3] (W1C)
 *
 * Values:
 * - 0 - The interrupt request for corresponding channel is cleared
 * - 1 - The interrupt request for corresponding channel is active
 */
/*@{*/
#define BP_DMA_INT_INT3      (3U)          /*!< Bit position for DMA_INT_INT3. */
#define BM_DMA_INT_INT3      (0x00000008U) /*!< Bit mask for DMA_INT_INT3. */
#define BS_DMA_INT_INT3      (1U)          /*!< Bit field size in bits for DMA_INT_INT3. */

/*! @brief Read current value of the DMA_INT_INT3 field. */
#define BR_DMA_INT_INT3(x)   (BITBAND_ACCESS32(HW_DMA_INT_ADDR(x), BP_DMA_INT_INT3))

/*! @brief Format value for bitfield DMA_INT_INT3. */
#define BF_DMA_INT_INT3(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_INT_INT3) & BM_DMA_INT_INT3)

/*! @brief Set the INT3 field to a new value. */
#define BW_DMA_INT_INT3(x, v) (BITBAND_ACCESS32(HW_DMA_INT_ADDR(x), BP_DMA_INT_INT3) = (v))
/*@}*/

/*!
 * @name Register DMA_INT, field INT4[4] (W1C)
 *
 * Values:
 * - 0 - The interrupt request for corresponding channel is cleared
 * - 1 - The interrupt request for corresponding channel is active
 */
/*@{*/
#define BP_DMA_INT_INT4      (4U)          /*!< Bit position for DMA_INT_INT4. */
#define BM_DMA_INT_INT4      (0x00000010U) /*!< Bit mask for DMA_INT_INT4. */
#define BS_DMA_INT_INT4      (1U)          /*!< Bit field size in bits for DMA_INT_INT4. */

/*! @brief Read current value of the DMA_INT_INT4 field. */
#define BR_DMA_INT_INT4(x)   (BITBAND_ACCESS32(HW_DMA_INT_ADDR(x), BP_DMA_INT_INT4))

/*! @brief Format value for bitfield DMA_INT_INT4. */
#define BF_DMA_INT_INT4(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_INT_INT4) & BM_DMA_INT_INT4)

/*! @brief Set the INT4 field to a new value. */
#define BW_DMA_INT_INT4(x, v) (BITBAND_ACCESS32(HW_DMA_INT_ADDR(x), BP_DMA_INT_INT4) = (v))
/*@}*/

/*!
 * @name Register DMA_INT, field INT5[5] (W1C)
 *
 * Values:
 * - 0 - The interrupt request for corresponding channel is cleared
 * - 1 - The interrupt request for corresponding channel is active
 */
/*@{*/
#define BP_DMA_INT_INT5      (5U)          /*!< Bit position for DMA_INT_INT5. */
#define BM_DMA_INT_INT5      (0x00000020U) /*!< Bit mask for DMA_INT_INT5. */
#define BS_DMA_INT_INT5      (1U)          /*!< Bit field size in bits for DMA_INT_INT5. */

/*! @brief Read current value of the DMA_INT_INT5 field. */
#define BR_DMA_INT_INT5(x)   (BITBAND_ACCESS32(HW_DMA_INT_ADDR(x), BP_DMA_INT_INT5))

/*! @brief Format value for bitfield DMA_INT_INT5. */
#define BF_DMA_INT_INT5(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_INT_INT5) & BM_DMA_INT_INT5)

/*! @brief Set the INT5 field to a new value. */
#define BW_DMA_INT_INT5(x, v) (BITBAND_ACCESS32(HW_DMA_INT_ADDR(x), BP_DMA_INT_INT5) = (v))
/*@}*/

/*!
 * @name Register DMA_INT, field INT6[6] (W1C)
 *
 * Values:
 * - 0 - The interrupt request for corresponding channel is cleared
 * - 1 - The interrupt request for corresponding channel is active
 */
/*@{*/
#define BP_DMA_INT_INT6      (6U)          /*!< Bit position for DMA_INT_INT6. */
#define BM_DMA_INT_INT6      (0x00000040U) /*!< Bit mask for DMA_INT_INT6. */
#define BS_DMA_INT_INT6      (1U)          /*!< Bit field size in bits for DMA_INT_INT6. */

/*! @brief Read current value of the DMA_INT_INT6 field. */
#define BR_DMA_INT_INT6(x)   (BITBAND_ACCESS32(HW_DMA_INT_ADDR(x), BP_DMA_INT_INT6))

/*! @brief Format value for bitfield DMA_INT_INT6. */
#define BF_DMA_INT_INT6(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_INT_INT6) & BM_DMA_INT_INT6)

/*! @brief Set the INT6 field to a new value. */
#define BW_DMA_INT_INT6(x, v) (BITBAND_ACCESS32(HW_DMA_INT_ADDR(x), BP_DMA_INT_INT6) = (v))
/*@}*/

/*!
 * @name Register DMA_INT, field INT7[7] (W1C)
 *
 * Values:
 * - 0 - The interrupt request for corresponding channel is cleared
 * - 1 - The interrupt request for corresponding channel is active
 */
/*@{*/
#define BP_DMA_INT_INT7      (7U)          /*!< Bit position for DMA_INT_INT7. */
#define BM_DMA_INT_INT7      (0x00000080U) /*!< Bit mask for DMA_INT_INT7. */
#define BS_DMA_INT_INT7      (1U)          /*!< Bit field size in bits for DMA_INT_INT7. */

/*! @brief Read current value of the DMA_INT_INT7 field. */
#define BR_DMA_INT_INT7(x)   (BITBAND_ACCESS32(HW_DMA_INT_ADDR(x), BP_DMA_INT_INT7))

/*! @brief Format value for bitfield DMA_INT_INT7. */
#define BF_DMA_INT_INT7(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_INT_INT7) & BM_DMA_INT_INT7)

/*! @brief Set the INT7 field to a new value. */
#define BW_DMA_INT_INT7(x, v) (BITBAND_ACCESS32(HW_DMA_INT_ADDR(x), BP_DMA_INT_INT7) = (v))
/*@}*/

/*!
 * @name Register DMA_INT, field INT8[8] (W1C)
 *
 * Values:
 * - 0 - The interrupt request for corresponding channel is cleared
 * - 1 - The interrupt request for corresponding channel is active
 */
/*@{*/
#define BP_DMA_INT_INT8      (8U)          /*!< Bit position for DMA_INT_INT8. */
#define BM_DMA_INT_INT8      (0x00000100U) /*!< Bit mask for DMA_INT_INT8. */
#define BS_DMA_INT_INT8      (1U)          /*!< Bit field size in bits for DMA_INT_INT8. */

/*! @brief Read current value of the DMA_INT_INT8 field. */
#define BR_DMA_INT_INT8(x)   (BITBAND_ACCESS32(HW_DMA_INT_ADDR(x), BP_DMA_INT_INT8))

/*! @brief Format value for bitfield DMA_INT_INT8. */
#define BF_DMA_INT_INT8(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_INT_INT8) & BM_DMA_INT_INT8)

/*! @brief Set the INT8 field to a new value. */
#define BW_DMA_INT_INT8(x, v) (BITBAND_ACCESS32(HW_DMA_INT_ADDR(x), BP_DMA_INT_INT8) = (v))
/*@}*/

/*!
 * @name Register DMA_INT, field INT9[9] (W1C)
 *
 * Values:
 * - 0 - The interrupt request for corresponding channel is cleared
 * - 1 - The interrupt request for corresponding channel is active
 */
/*@{*/
#define BP_DMA_INT_INT9      (9U)          /*!< Bit position for DMA_INT_INT9. */
#define BM_DMA_INT_INT9      (0x00000200U) /*!< Bit mask for DMA_INT_INT9. */
#define BS_DMA_INT_INT9      (1U)          /*!< Bit field size in bits for DMA_INT_INT9. */

/*! @brief Read current value of the DMA_INT_INT9 field. */
#define BR_DMA_INT_INT9(x)   (BITBAND_ACCESS32(HW_DMA_INT_ADDR(x), BP_DMA_INT_INT9))

/*! @brief Format value for bitfield DMA_INT_INT9. */
#define BF_DMA_INT_INT9(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_INT_INT9) & BM_DMA_INT_INT9)

/*! @brief Set the INT9 field to a new value. */
#define BW_DMA_INT_INT9(x, v) (BITBAND_ACCESS32(HW_DMA_INT_ADDR(x), BP_DMA_INT_INT9) = (v))
/*@}*/

/*!
 * @name Register DMA_INT, field INT10[10] (W1C)
 *
 * Values:
 * - 0 - The interrupt request for corresponding channel is cleared
 * - 1 - The interrupt request for corresponding channel is active
 */
/*@{*/
#define BP_DMA_INT_INT10     (10U)         /*!< Bit position for DMA_INT_INT10. */
#define BM_DMA_INT_INT10     (0x00000400U) /*!< Bit mask for DMA_INT_INT10. */
#define BS_DMA_INT_INT10     (1U)          /*!< Bit field size in bits for DMA_INT_INT10. */

/*! @brief Read current value of the DMA_INT_INT10 field. */
#define BR_DMA_INT_INT10(x)  (BITBAND_ACCESS32(HW_DMA_INT_ADDR(x), BP_DMA_INT_INT10))

/*! @brief Format value for bitfield DMA_INT_INT10. */
#define BF_DMA_INT_INT10(v)  ((uint32_t)((uint32_t)(v) << BP_DMA_INT_INT10) & BM_DMA_INT_INT10)

/*! @brief Set the INT10 field to a new value. */
#define BW_DMA_INT_INT10(x, v) (BITBAND_ACCESS32(HW_DMA_INT_ADDR(x), BP_DMA_INT_INT10) = (v))
/*@}*/

/*!
 * @name Register DMA_INT, field INT11[11] (W1C)
 *
 * Values:
 * - 0 - The interrupt request for corresponding channel is cleared
 * - 1 - The interrupt request for corresponding channel is active
 */
/*@{*/
#define BP_DMA_INT_INT11     (11U)         /*!< Bit position for DMA_INT_INT11. */
#define BM_DMA_INT_INT11     (0x00000800U) /*!< Bit mask for DMA_INT_INT11. */
#define BS_DMA_INT_INT11     (1U)          /*!< Bit field size in bits for DMA_INT_INT11. */

/*! @brief Read current value of the DMA_INT_INT11 field. */
#define BR_DMA_INT_INT11(x)  (BITBAND_ACCESS32(HW_DMA_INT_ADDR(x), BP_DMA_INT_INT11))

/*! @brief Format value for bitfield DMA_INT_INT11. */
#define BF_DMA_INT_INT11(v)  ((uint32_t)((uint32_t)(v) << BP_DMA_INT_INT11) & BM_DMA_INT_INT11)

/*! @brief Set the INT11 field to a new value. */
#define BW_DMA_INT_INT11(x, v) (BITBAND_ACCESS32(HW_DMA_INT_ADDR(x), BP_DMA_INT_INT11) = (v))
/*@}*/

/*!
 * @name Register DMA_INT, field INT12[12] (W1C)
 *
 * Values:
 * - 0 - The interrupt request for corresponding channel is cleared
 * - 1 - The interrupt request for corresponding channel is active
 */
/*@{*/
#define BP_DMA_INT_INT12     (12U)         /*!< Bit position for DMA_INT_INT12. */
#define BM_DMA_INT_INT12     (0x00001000U) /*!< Bit mask for DMA_INT_INT12. */
#define BS_DMA_INT_INT12     (1U)          /*!< Bit field size in bits for DMA_INT_INT12. */

/*! @brief Read current value of the DMA_INT_INT12 field. */
#define BR_DMA_INT_INT12(x)  (BITBAND_ACCESS32(HW_DMA_INT_ADDR(x), BP_DMA_INT_INT12))

/*! @brief Format value for bitfield DMA_INT_INT12. */
#define BF_DMA_INT_INT12(v)  ((uint32_t)((uint32_t)(v) << BP_DMA_INT_INT12) & BM_DMA_INT_INT12)

/*! @brief Set the INT12 field to a new value. */
#define BW_DMA_INT_INT12(x, v) (BITBAND_ACCESS32(HW_DMA_INT_ADDR(x), BP_DMA_INT_INT12) = (v))
/*@}*/

/*!
 * @name Register DMA_INT, field INT13[13] (W1C)
 *
 * Values:
 * - 0 - The interrupt request for corresponding channel is cleared
 * - 1 - The interrupt request for corresponding channel is active
 */
/*@{*/
#define BP_DMA_INT_INT13     (13U)         /*!< Bit position for DMA_INT_INT13. */
#define BM_DMA_INT_INT13     (0x00002000U) /*!< Bit mask for DMA_INT_INT13. */
#define BS_DMA_INT_INT13     (1U)          /*!< Bit field size in bits for DMA_INT_INT13. */

/*! @brief Read current value of the DMA_INT_INT13 field. */
#define BR_DMA_INT_INT13(x)  (BITBAND_ACCESS32(HW_DMA_INT_ADDR(x), BP_DMA_INT_INT13))

/*! @brief Format value for bitfield DMA_INT_INT13. */
#define BF_DMA_INT_INT13(v)  ((uint32_t)((uint32_t)(v) << BP_DMA_INT_INT13) & BM_DMA_INT_INT13)

/*! @brief Set the INT13 field to a new value. */
#define BW_DMA_INT_INT13(x, v) (BITBAND_ACCESS32(HW_DMA_INT_ADDR(x), BP_DMA_INT_INT13) = (v))
/*@}*/

/*!
 * @name Register DMA_INT, field INT14[14] (W1C)
 *
 * Values:
 * - 0 - The interrupt request for corresponding channel is cleared
 * - 1 - The interrupt request for corresponding channel is active
 */
/*@{*/
#define BP_DMA_INT_INT14     (14U)         /*!< Bit position for DMA_INT_INT14. */
#define BM_DMA_INT_INT14     (0x00004000U) /*!< Bit mask for DMA_INT_INT14. */
#define BS_DMA_INT_INT14     (1U)          /*!< Bit field size in bits for DMA_INT_INT14. */

/*! @brief Read current value of the DMA_INT_INT14 field. */
#define BR_DMA_INT_INT14(x)  (BITBAND_ACCESS32(HW_DMA_INT_ADDR(x), BP_DMA_INT_INT14))

/*! @brief Format value for bitfield DMA_INT_INT14. */
#define BF_DMA_INT_INT14(v)  ((uint32_t)((uint32_t)(v) << BP_DMA_INT_INT14) & BM_DMA_INT_INT14)

/*! @brief Set the INT14 field to a new value. */
#define BW_DMA_INT_INT14(x, v) (BITBAND_ACCESS32(HW_DMA_INT_ADDR(x), BP_DMA_INT_INT14) = (v))
/*@}*/

/*!
 * @name Register DMA_INT, field INT15[15] (W1C)
 *
 * Values:
 * - 0 - The interrupt request for corresponding channel is cleared
 * - 1 - The interrupt request for corresponding channel is active
 */
/*@{*/
#define BP_DMA_INT_INT15     (15U)         /*!< Bit position for DMA_INT_INT15. */
#define BM_DMA_INT_INT15     (0x00008000U) /*!< Bit mask for DMA_INT_INT15. */
#define BS_DMA_INT_INT15     (1U)          /*!< Bit field size in bits for DMA_INT_INT15. */

/*! @brief Read current value of the DMA_INT_INT15 field. */
#define BR_DMA_INT_INT15(x)  (BITBAND_ACCESS32(HW_DMA_INT_ADDR(x), BP_DMA_INT_INT15))

/*! @brief Format value for bitfield DMA_INT_INT15. */
#define BF_DMA_INT_INT15(v)  ((uint32_t)((uint32_t)(v) << BP_DMA_INT_INT15) & BM_DMA_INT_INT15)

/*! @brief Set the INT15 field to a new value. */
#define BW_DMA_INT_INT15(x, v) (BITBAND_ACCESS32(HW_DMA_INT_ADDR(x), BP_DMA_INT_INT15) = (v))
/*@}*/

/*******************************************************************************
 * HW_DMA_ERR - Error Register
 ******************************************************************************/

/*!
 * @brief HW_DMA_ERR - Error Register (RW)
 *
 * Reset value: 0x00000000U
 *
 * The ERR provides a bit map for the 16 channels, signaling the presence of an
 * error for each channel. The eDMA engine signals the occurrence of an error
 * condition by setting the appropriate bit in this register. The outputs of this
 * register are enabled by the contents of the EEI, and then routed to the
 * interrupt controller. During the execution of the interrupt-service routine associated
 * with any DMA errors, it is software's responsibility to clear the appropriate
 * bit, negating the error-interrupt request. Typically, a write to the CERR in
 * the interrupt-service routine is used for this purpose. The normal DMA channel
 * completion indicators (setting the transfer control descriptor DONE flag and
 * the possible assertion of an interrupt request) are not affected when an error
 * is detected. The contents of this register can also be polled because a
 * non-zero value indicates the presence of a channel error regardless of the state of
 * the EEI. The state of any given channel's error indicators is affected by
 * writes to this register; it is also affected by writes to the CERR. On writes to
 * the ERR, a one in any bit position clears the corresponding channel's error
 * status. A zero in any bit position has no affect on the corresponding channel's
 * current error status. The CERR is provided so the error indicator for a single
 * channel can easily be cleared.
 */
typedef union _hw_dma_err
{
    uint32_t U;
    struct _hw_dma_err_bitfields
    {
        uint32_t ERR0 : 1;             /*!< [0] Error In Channel 0 */
        uint32_t ERR1 : 1;             /*!< [1] Error In Channel 1 */
        uint32_t ERR2 : 1;             /*!< [2] Error In Channel 2 */
        uint32_t ERR3 : 1;             /*!< [3] Error In Channel 3 */
        uint32_t ERR4 : 1;             /*!< [4] Error In Channel 4 */
        uint32_t ERR5 : 1;             /*!< [5] Error In Channel 5 */
        uint32_t ERR6 : 1;             /*!< [6] Error In Channel 6 */
        uint32_t ERR7 : 1;             /*!< [7] Error In Channel 7 */
        uint32_t ERR8 : 1;             /*!< [8] Error In Channel 8 */
        uint32_t ERR9 : 1;             /*!< [9] Error In Channel 9 */
        uint32_t ERR10 : 1;            /*!< [10] Error In Channel 10 */
        uint32_t ERR11 : 1;            /*!< [11] Error In Channel 11 */
        uint32_t ERR12 : 1;            /*!< [12] Error In Channel 12 */
        uint32_t ERR13 : 1;            /*!< [13] Error In Channel 13 */
        uint32_t ERR14 : 1;            /*!< [14] Error In Channel 14 */
        uint32_t ERR15 : 1;            /*!< [15] Error In Channel 15 */
        uint32_t RESERVED0 : 16;       /*!< [31:16]  */
    } B;
} hw_dma_err_t;

/*!
 * @name Constants and macros for entire DMA_ERR register
 */
/*@{*/
#define HW_DMA_ERR_ADDR(x)       ((x) + 0x2CU)

#define HW_DMA_ERR(x)            (*(__IO hw_dma_err_t *) HW_DMA_ERR_ADDR(x))
#define HW_DMA_ERR_RD(x)         (HW_DMA_ERR(x).U)
#define HW_DMA_ERR_WR(x, v)      (HW_DMA_ERR(x).U = (v))
#define HW_DMA_ERR_SET(x, v)     (HW_DMA_ERR_WR(x, HW_DMA_ERR_RD(x) |  (v)))
#define HW_DMA_ERR_CLR(x, v)     (HW_DMA_ERR_WR(x, HW_DMA_ERR_RD(x) & ~(v)))
#define HW_DMA_ERR_TOG(x, v)     (HW_DMA_ERR_WR(x, HW_DMA_ERR_RD(x) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DMA_ERR bitfields
 */

/*!
 * @name Register DMA_ERR, field ERR0[0] (W1C)
 *
 * Values:
 * - 0 - An error in the corresponding channel has not occurred
 * - 1 - An error in the corresponding channel has occurred
 */
/*@{*/
#define BP_DMA_ERR_ERR0      (0U)          /*!< Bit position for DMA_ERR_ERR0. */
#define BM_DMA_ERR_ERR0      (0x00000001U) /*!< Bit mask for DMA_ERR_ERR0. */
#define BS_DMA_ERR_ERR0      (1U)          /*!< Bit field size in bits for DMA_ERR_ERR0. */

/*! @brief Read current value of the DMA_ERR_ERR0 field. */
#define BR_DMA_ERR_ERR0(x)   (BITBAND_ACCESS32(HW_DMA_ERR_ADDR(x), BP_DMA_ERR_ERR0))

/*! @brief Format value for bitfield DMA_ERR_ERR0. */
#define BF_DMA_ERR_ERR0(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_ERR_ERR0) & BM_DMA_ERR_ERR0)

/*! @brief Set the ERR0 field to a new value. */
#define BW_DMA_ERR_ERR0(x, v) (BITBAND_ACCESS32(HW_DMA_ERR_ADDR(x), BP_DMA_ERR_ERR0) = (v))
/*@}*/

/*!
 * @name Register DMA_ERR, field ERR1[1] (W1C)
 *
 * Values:
 * - 0 - An error in the corresponding channel has not occurred
 * - 1 - An error in the corresponding channel has occurred
 */
/*@{*/
#define BP_DMA_ERR_ERR1      (1U)          /*!< Bit position for DMA_ERR_ERR1. */
#define BM_DMA_ERR_ERR1      (0x00000002U) /*!< Bit mask for DMA_ERR_ERR1. */
#define BS_DMA_ERR_ERR1      (1U)          /*!< Bit field size in bits for DMA_ERR_ERR1. */

/*! @brief Read current value of the DMA_ERR_ERR1 field. */
#define BR_DMA_ERR_ERR1(x)   (BITBAND_ACCESS32(HW_DMA_ERR_ADDR(x), BP_DMA_ERR_ERR1))

/*! @brief Format value for bitfield DMA_ERR_ERR1. */
#define BF_DMA_ERR_ERR1(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_ERR_ERR1) & BM_DMA_ERR_ERR1)

/*! @brief Set the ERR1 field to a new value. */
#define BW_DMA_ERR_ERR1(x, v) (BITBAND_ACCESS32(HW_DMA_ERR_ADDR(x), BP_DMA_ERR_ERR1) = (v))
/*@}*/

/*!
 * @name Register DMA_ERR, field ERR2[2] (W1C)
 *
 * Values:
 * - 0 - An error in the corresponding channel has not occurred
 * - 1 - An error in the corresponding channel has occurred
 */
/*@{*/
#define BP_DMA_ERR_ERR2      (2U)          /*!< Bit position for DMA_ERR_ERR2. */
#define BM_DMA_ERR_ERR2      (0x00000004U) /*!< Bit mask for DMA_ERR_ERR2. */
#define BS_DMA_ERR_ERR2      (1U)          /*!< Bit field size in bits for DMA_ERR_ERR2. */

/*! @brief Read current value of the DMA_ERR_ERR2 field. */
#define BR_DMA_ERR_ERR2(x)   (BITBAND_ACCESS32(HW_DMA_ERR_ADDR(x), BP_DMA_ERR_ERR2))

/*! @brief Format value for bitfield DMA_ERR_ERR2. */
#define BF_DMA_ERR_ERR2(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_ERR_ERR2) & BM_DMA_ERR_ERR2)

/*! @brief Set the ERR2 field to a new value. */
#define BW_DMA_ERR_ERR2(x, v) (BITBAND_ACCESS32(HW_DMA_ERR_ADDR(x), BP_DMA_ERR_ERR2) = (v))
/*@}*/

/*!
 * @name Register DMA_ERR, field ERR3[3] (W1C)
 *
 * Values:
 * - 0 - An error in the corresponding channel has not occurred
 * - 1 - An error in the corresponding channel has occurred
 */
/*@{*/
#define BP_DMA_ERR_ERR3      (3U)          /*!< Bit position for DMA_ERR_ERR3. */
#define BM_DMA_ERR_ERR3      (0x00000008U) /*!< Bit mask for DMA_ERR_ERR3. */
#define BS_DMA_ERR_ERR3      (1U)          /*!< Bit field size in bits for DMA_ERR_ERR3. */

/*! @brief Read current value of the DMA_ERR_ERR3 field. */
#define BR_DMA_ERR_ERR3(x)   (BITBAND_ACCESS32(HW_DMA_ERR_ADDR(x), BP_DMA_ERR_ERR3))

/*! @brief Format value for bitfield DMA_ERR_ERR3. */
#define BF_DMA_ERR_ERR3(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_ERR_ERR3) & BM_DMA_ERR_ERR3)

/*! @brief Set the ERR3 field to a new value. */
#define BW_DMA_ERR_ERR3(x, v) (BITBAND_ACCESS32(HW_DMA_ERR_ADDR(x), BP_DMA_ERR_ERR3) = (v))
/*@}*/

/*!
 * @name Register DMA_ERR, field ERR4[4] (W1C)
 *
 * Values:
 * - 0 - An error in the corresponding channel has not occurred
 * - 1 - An error in the corresponding channel has occurred
 */
/*@{*/
#define BP_DMA_ERR_ERR4      (4U)          /*!< Bit position for DMA_ERR_ERR4. */
#define BM_DMA_ERR_ERR4      (0x00000010U) /*!< Bit mask for DMA_ERR_ERR4. */
#define BS_DMA_ERR_ERR4      (1U)          /*!< Bit field size in bits for DMA_ERR_ERR4. */

/*! @brief Read current value of the DMA_ERR_ERR4 field. */
#define BR_DMA_ERR_ERR4(x)   (BITBAND_ACCESS32(HW_DMA_ERR_ADDR(x), BP_DMA_ERR_ERR4))

/*! @brief Format value for bitfield DMA_ERR_ERR4. */
#define BF_DMA_ERR_ERR4(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_ERR_ERR4) & BM_DMA_ERR_ERR4)

/*! @brief Set the ERR4 field to a new value. */
#define BW_DMA_ERR_ERR4(x, v) (BITBAND_ACCESS32(HW_DMA_ERR_ADDR(x), BP_DMA_ERR_ERR4) = (v))
/*@}*/

/*!
 * @name Register DMA_ERR, field ERR5[5] (W1C)
 *
 * Values:
 * - 0 - An error in the corresponding channel has not occurred
 * - 1 - An error in the corresponding channel has occurred
 */
/*@{*/
#define BP_DMA_ERR_ERR5      (5U)          /*!< Bit position for DMA_ERR_ERR5. */
#define BM_DMA_ERR_ERR5      (0x00000020U) /*!< Bit mask for DMA_ERR_ERR5. */
#define BS_DMA_ERR_ERR5      (1U)          /*!< Bit field size in bits for DMA_ERR_ERR5. */

/*! @brief Read current value of the DMA_ERR_ERR5 field. */
#define BR_DMA_ERR_ERR5(x)   (BITBAND_ACCESS32(HW_DMA_ERR_ADDR(x), BP_DMA_ERR_ERR5))

/*! @brief Format value for bitfield DMA_ERR_ERR5. */
#define BF_DMA_ERR_ERR5(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_ERR_ERR5) & BM_DMA_ERR_ERR5)

/*! @brief Set the ERR5 field to a new value. */
#define BW_DMA_ERR_ERR5(x, v) (BITBAND_ACCESS32(HW_DMA_ERR_ADDR(x), BP_DMA_ERR_ERR5) = (v))
/*@}*/

/*!
 * @name Register DMA_ERR, field ERR6[6] (W1C)
 *
 * Values:
 * - 0 - An error in the corresponding channel has not occurred
 * - 1 - An error in the corresponding channel has occurred
 */
/*@{*/
#define BP_DMA_ERR_ERR6      (6U)          /*!< Bit position for DMA_ERR_ERR6. */
#define BM_DMA_ERR_ERR6      (0x00000040U) /*!< Bit mask for DMA_ERR_ERR6. */
#define BS_DMA_ERR_ERR6      (1U)          /*!< Bit field size in bits for DMA_ERR_ERR6. */

/*! @brief Read current value of the DMA_ERR_ERR6 field. */
#define BR_DMA_ERR_ERR6(x)   (BITBAND_ACCESS32(HW_DMA_ERR_ADDR(x), BP_DMA_ERR_ERR6))

/*! @brief Format value for bitfield DMA_ERR_ERR6. */
#define BF_DMA_ERR_ERR6(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_ERR_ERR6) & BM_DMA_ERR_ERR6)

/*! @brief Set the ERR6 field to a new value. */
#define BW_DMA_ERR_ERR6(x, v) (BITBAND_ACCESS32(HW_DMA_ERR_ADDR(x), BP_DMA_ERR_ERR6) = (v))
/*@}*/

/*!
 * @name Register DMA_ERR, field ERR7[7] (W1C)
 *
 * Values:
 * - 0 - An error in the corresponding channel has not occurred
 * - 1 - An error in the corresponding channel has occurred
 */
/*@{*/
#define BP_DMA_ERR_ERR7      (7U)          /*!< Bit position for DMA_ERR_ERR7. */
#define BM_DMA_ERR_ERR7      (0x00000080U) /*!< Bit mask for DMA_ERR_ERR7. */
#define BS_DMA_ERR_ERR7      (1U)          /*!< Bit field size in bits for DMA_ERR_ERR7. */

/*! @brief Read current value of the DMA_ERR_ERR7 field. */
#define BR_DMA_ERR_ERR7(x)   (BITBAND_ACCESS32(HW_DMA_ERR_ADDR(x), BP_DMA_ERR_ERR7))

/*! @brief Format value for bitfield DMA_ERR_ERR7. */
#define BF_DMA_ERR_ERR7(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_ERR_ERR7) & BM_DMA_ERR_ERR7)

/*! @brief Set the ERR7 field to a new value. */
#define BW_DMA_ERR_ERR7(x, v) (BITBAND_ACCESS32(HW_DMA_ERR_ADDR(x), BP_DMA_ERR_ERR7) = (v))
/*@}*/

/*!
 * @name Register DMA_ERR, field ERR8[8] (W1C)
 *
 * Values:
 * - 0 - An error in the corresponding channel has not occurred
 * - 1 - An error in the corresponding channel has occurred
 */
/*@{*/
#define BP_DMA_ERR_ERR8      (8U)          /*!< Bit position for DMA_ERR_ERR8. */
#define BM_DMA_ERR_ERR8      (0x00000100U) /*!< Bit mask for DMA_ERR_ERR8. */
#define BS_DMA_ERR_ERR8      (1U)          /*!< Bit field size in bits for DMA_ERR_ERR8. */

/*! @brief Read current value of the DMA_ERR_ERR8 field. */
#define BR_DMA_ERR_ERR8(x)   (BITBAND_ACCESS32(HW_DMA_ERR_ADDR(x), BP_DMA_ERR_ERR8))

/*! @brief Format value for bitfield DMA_ERR_ERR8. */
#define BF_DMA_ERR_ERR8(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_ERR_ERR8) & BM_DMA_ERR_ERR8)

/*! @brief Set the ERR8 field to a new value. */
#define BW_DMA_ERR_ERR8(x, v) (BITBAND_ACCESS32(HW_DMA_ERR_ADDR(x), BP_DMA_ERR_ERR8) = (v))
/*@}*/

/*!
 * @name Register DMA_ERR, field ERR9[9] (W1C)
 *
 * Values:
 * - 0 - An error in the corresponding channel has not occurred
 * - 1 - An error in the corresponding channel has occurred
 */
/*@{*/
#define BP_DMA_ERR_ERR9      (9U)          /*!< Bit position for DMA_ERR_ERR9. */
#define BM_DMA_ERR_ERR9      (0x00000200U) /*!< Bit mask for DMA_ERR_ERR9. */
#define BS_DMA_ERR_ERR9      (1U)          /*!< Bit field size in bits for DMA_ERR_ERR9. */

/*! @brief Read current value of the DMA_ERR_ERR9 field. */
#define BR_DMA_ERR_ERR9(x)   (BITBAND_ACCESS32(HW_DMA_ERR_ADDR(x), BP_DMA_ERR_ERR9))

/*! @brief Format value for bitfield DMA_ERR_ERR9. */
#define BF_DMA_ERR_ERR9(v)   ((uint32_t)((uint32_t)(v) << BP_DMA_ERR_ERR9) & BM_DMA_ERR_ERR9)

/*! @brief Set the ERR9 field to a new value. */
#define BW_DMA_ERR_ERR9(x, v) (BITBAND_ACCESS32(HW_DMA_ERR_ADDR(x), BP_DMA_ERR_ERR9) = (v))
/*@}*/

/*!
 * @name Register DMA_ERR, field ERR10[10] (W1C)
 *
 * Values:
 * - 0 - An error in the corresponding channel has not occurred
 * - 1 - An error in the corresponding channel has occurred
 */
/*@{*/
#define BP_DMA_ERR_ERR10     (10U)         /*!< Bit position for DMA_ERR_ERR10. */
#define BM_DMA_ERR_ERR10     (0x00000400U) /*!< Bit mask for DMA_ERR_ERR10. */
#define BS_DMA_ERR_ERR10     (1U)          /*!< Bit field size in bits for DMA_ERR_ERR10. */

/*! @brief Read current value of the DMA_ERR_ERR10 field. */
#define BR_DMA_ERR_ERR10(x)  (BITBAND_ACCESS32(HW_DMA_ERR_ADDR(x), BP_DMA_ERR_ERR10))

/*! @brief Format value for bitfield DMA_ERR_ERR10. */
#define BF_DMA_ERR_ERR10(v)  ((uint32_t)((uint32_t)(v) << BP_DMA_ERR_ERR10) & BM_DMA_ERR_ERR10)

/*! @brief Set the ERR10 field to a new value. */
#define BW_DMA_ERR_ERR10(x, v) (BITBAND_ACCESS32(HW_DMA_ERR_ADDR(x), BP_DMA_ERR_ERR10) = (v))
/*@}*/

/*!
 * @name Register DMA_ERR, field ERR11[11] (W1C)
 *
 * Values:
 * - 0 - An error in the corresponding channel has not occurred
 * - 1 - An error in the corresponding channel has occurred
 */
/*@{*/
#define BP_DMA_ERR_ERR11     (11U)         /*!< Bit position for DMA_ERR_ERR11. */
#define BM_DMA_ERR_ERR11     (0x00000800U) /*!< Bit mask for DMA_ERR_ERR11. */
#define BS_DMA_ERR_ERR11     (1U)          /*!< Bit field size in bits for DMA_ERR_ERR11. */

/*! @brief Read current value of the DMA_ERR_ERR11 field. */
#define BR_DMA_ERR_ERR11(x)  (BITBAND_ACCESS32(HW_DMA_ERR_ADDR(x), BP_DMA_ERR_ERR11))

/*! @brief Format value for bitfield DMA_ERR_ERR11. */
#define BF_DMA_ERR_ERR11(v)  ((uint32_t)((uint32_t)(v) << BP_DMA_ERR_ERR11) & BM_DMA_ERR_ERR11)

/*! @brief Set the ERR11 field to a new value. */
#define BW_DMA_ERR_ERR11(x, v) (BITBAND_ACCESS32(HW_DMA_ERR_ADDR(x), BP_DMA_ERR_ERR11) = (v))
/*@}*/

/*!
 * @name Register DMA_ERR, field ERR12[12] (W1C)
 *
 * Values:
 * - 0 - An error in the corresponding channel has not occurred
 * - 1 - An error in the corresponding channel has occurred
 */
/*@{*/
#define BP_DMA_ERR_ERR12     (12U)         /*!< Bit position for DMA_ERR_ERR12. */
#define BM_DMA_ERR_ERR12     (0x00001000U) /*!< Bit mask for DMA_ERR_ERR12. */
#define BS_DMA_ERR_ERR12     (1U)          /*!< Bit field size in bits for DMA_ERR_ERR12. */

/*! @brief Read current value of the DMA_ERR_ERR12 field. */
#define BR_DMA_ERR_ERR12(x)  (BITBAND_ACCESS32(HW_DMA_ERR_ADDR(x), BP_DMA_ERR_ERR12))

/*! @brief Format value for bitfield DMA_ERR_ERR12. */
#define BF_DMA_ERR_ERR12(v)  ((uint32_t)((uint32_t)(v) << BP_DMA_ERR_ERR12) & BM_DMA_ERR_ERR12)

/*! @brief Set the ERR12 field to a new value. */
#define BW_DMA_ERR_ERR12(x, v) (BITBAND_ACCESS32(HW_DMA_ERR_ADDR(x), BP_DMA_ERR_ERR12) = (v))
/*@}*/

/*!
 * @name Register DMA_ERR, field ERR13[13] (W1C)
 *
 * Values:
 * - 0 - An error in the corresponding channel has not occurred
 * - 1 - An error in the corresponding channel has occurred
 */
/*@{*/
#define BP_DMA_ERR_ERR13     (13U)         /*!< Bit position for DMA_ERR_ERR13. */
#define BM_DMA_ERR_ERR13     (0x00002000U) /*!< Bit mask for DMA_ERR_ERR13. */
#define BS_DMA_ERR_ERR13     (1U)          /*!< Bit field size in bits for DMA_ERR_ERR13. */

/*! @brief Read current value of the DMA_ERR_ERR13 field. */
#define BR_DMA_ERR_ERR13(x)  (BITBAND_ACCESS32(HW_DMA_ERR_ADDR(x), BP_DMA_ERR_ERR13))

/*! @brief Format value for bitfield DMA_ERR_ERR13. */
#define BF_DMA_ERR_ERR13(v)  ((uint32_t)((uint32_t)(v) << BP_DMA_ERR_ERR13) & BM_DMA_ERR_ERR13)

/*! @brief Set the ERR13 field to a new value. */
#define BW_DMA_ERR_ERR13(x, v) (BITBAND_ACCESS32(HW_DMA_ERR_ADDR(x), BP_DMA_ERR_ERR13) = (v))
/*@}*/

/*!
 * @name Register DMA_ERR, field ERR14[14] (W1C)
 *
 * Values:
 * - 0 - An error in the corresponding channel has not occurred
 * - 1 - An error in the corresponding channel has occurred
 */
/*@{*/
#define BP_DMA_ERR_ERR14     (14U)         /*!< Bit position for DMA_ERR_ERR14. */
#define BM_DMA_ERR_ERR14     (0x00004000U) /*!< Bit mask for DMA_ERR_ERR14. */
#define BS_DMA_ERR_ERR14     (1U)          /*!< Bit field size in bits for DMA_ERR_ERR14. */

/*! @brief Read current value of the DMA_ERR_ERR14 field. */
#define BR_DMA_ERR_ERR14(x)  (BITBAND_ACCESS32(HW_DMA_ERR_ADDR(x), BP_DMA_ERR_ERR14))

/*! @brief Format value for bitfield DMA_ERR_ERR14. */
#define BF_DMA_ERR_ERR14(v)  ((uint32_t)((uint32_t)(v) << BP_DMA_ERR_ERR14) & BM_DMA_ERR_ERR14)

/*! @brief Set the ERR14 field to a new value. */
#define BW_DMA_ERR_ERR14(x, v) (BITBAND_ACCESS32(HW_DMA_ERR_ADDR(x), BP_DMA_ERR_ERR14) = (v))
/*@}*/

/*!
 * @name Register DMA_ERR, field ERR15[15] (W1C)
 *
 * Values:
 * - 0 - An error in the corresponding channel has not occurred
 * - 1 - An error in the corresponding channel has occurred
 */
/*@{*/
#define BP_DMA_ERR_ERR15     (15U)         /*!< Bit position for DMA_ERR_ERR15. */
#define BM_DMA_ERR_ERR15     (0x00008000U) /*!< Bit mask for DMA_ERR_ERR15. */
#define BS_DMA_ERR_ERR15     (1U)          /*!< Bit field size in bits for DMA_ERR_ERR15. */

/*! @brief Read current value of the DMA_ERR_ERR15 field. */
#define BR_DMA_ERR_ERR15(x)  (BITBAND_ACCESS32(HW_DMA_ERR_ADDR(x), BP_DMA_ERR_ERR15))

/*! @brief Format value for bitfield DMA_ERR_ERR15. */
#define BF_DMA_ERR_ERR15(v)  ((uint32_t)((uint32_t)(v) << BP_DMA_ERR_ERR15) & BM_DMA_ERR_ERR15)

/*! @brief Set the ERR15 field to a new value. */
#define BW_DMA_ERR_ERR15(x, v) (BITBAND_ACCESS32(HW_DMA_ERR_ADDR(x), BP_DMA_ERR_ERR15) = (v))
/*@}*/

/*******************************************************************************
 * HW_DMA_HRS - Hardware Request Status Register
 ******************************************************************************/

/*!
 * @brief HW_DMA_HRS - Hardware Request Status Register (RO)
 *
 * Reset value: 0x00000000U
 *
 * The HRS register provides a bit map for the DMA channels, signaling the
 * presence of a hardware request for each channel. The hardware request status bits
 * reflect the current state of the register and qualified (via the ERQ fields)
 * DMA request signals as seen by the DMA's arbitration logic. This view into the
 * hardware request signals may be used for debug purposes. These bits reflect the
 * state of the request as seen by the arbitration logic. Therefore, this status
 * is affected by the ERQ bits.
 */
typedef union _hw_dma_hrs
{
    uint32_t U;
    struct _hw_dma_hrs_bitfields
    {
        uint32_t HRS0 : 1;             /*!< [0] Hardware Request Status Channel 0 */
        uint32_t HRS1 : 1;             /*!< [1] Hardware Request Status Channel 1 */
        uint32_t HRS2 : 1;             /*!< [2] Hardware Request Status Channel 2 */
        uint32_t HRS3 : 1;             /*!< [3] Hardware Request Status Channel 3 */
        uint32_t HRS4 : 1;             /*!< [4] Hardware Request Status Channel 4 */
        uint32_t HRS5 : 1;             /*!< [5] Hardware Request Status Channel 5 */
        uint32_t HRS6 : 1;             /*!< [6] Hardware Request Status Channel 6 */
        uint32_t HRS7 : 1;             /*!< [7] Hardware Request Status Channel 7 */
        uint32_t HRS8 : 1;             /*!< [8] Hardware Request Status Channel 8 */
        uint32_t HRS9 : 1;             /*!< [9] Hardware Request Status Channel 9 */
        uint32_t HRS10 : 1;            /*!< [10] Hardware Request Status Channel 10 */
        uint32_t HRS11 : 1;            /*!< [11] Hardware Request Status Channel 11 */
        uint32_t HRS12 : 1;            /*!< [12] Hardware Request Status Channel 12 */
        uint32_t HRS13 : 1;            /*!< [13] Hardware Request Status Channel 13 */
        uint32_t HRS14 : 1;            /*!< [14] Hardware Request Status Channel 14 */
        uint32_t HRS15 : 1;            /*!< [15] Hardware Request Status Channel 15 */
        uint32_t RESERVED0 : 16;       /*!< [31:16] Reserved */
    } B;
} hw_dma_hrs_t;

/*!
 * @name Constants and macros for entire DMA_HRS register
 */
/*@{*/
#define HW_DMA_HRS_ADDR(x)       ((x) + 0x34U)

#define HW_DMA_HRS(x)            (*(__I hw_dma_hrs_t *) HW_DMA_HRS_ADDR(x))
#define HW_DMA_HRS_RD(x)         (HW_DMA_HRS(x).U)
/*@}*/

/*
 * Constants & macros for individual DMA_HRS bitfields
 */

/*!
 * @name Register DMA_HRS, field HRS0[0] (RO)
 *
 * The HRS bit for its respective channel remains asserted for the period when a
 * Hardware Request is Present on the Channel. After the Request is completed
 * and Channel is free , the HRS bit is automatically cleared by hardware.
 *
 * Values:
 * - 0 - A hardware service request for channel 0 is not present
 * - 1 - A hardware service request for channel 0 is present
 */
/*@{*/
#define BP_DMA_HRS_HRS0      (0U)          /*!< Bit position for DMA_HRS_HRS0. */
#define BM_DMA_HRS_HRS0      (0x00000001U) /*!< Bit mask for DMA_HRS_HRS0. */
#define BS_DMA_HRS_HRS0      (1U)          /*!< Bit field size in bits for DMA_HRS_HRS0. */

/*! @brief Read current value of the DMA_HRS_HRS0 field. */
#define BR_DMA_HRS_HRS0(x)   (BITBAND_ACCESS32(HW_DMA_HRS_ADDR(x), BP_DMA_HRS_HRS0))
/*@}*/

/*!
 * @name Register DMA_HRS, field HRS1[1] (RO)
 *
 * The HRS bit for its respective channel remains asserted for the period when a
 * Hardware Request is Present on the Channel. After the Request is completed
 * and Channel is free , the HRS bit is automatically cleared by hardware.
 *
 * Values:
 * - 0 - A hardware service request for channel 1 is not present
 * - 1 - A hardware service request for channel 1 is present
 */
/*@{*/
#define BP_DMA_HRS_HRS1      (1U)          /*!< Bit position for DMA_HRS_HRS1. */
#define BM_DMA_HRS_HRS1      (0x00000002U) /*!< Bit mask for DMA_HRS_HRS1. */
#define BS_DMA_HRS_HRS1      (1U)          /*!< Bit field size in bits for DMA_HRS_HRS1. */

/*! @brief Read current value of the DMA_HRS_HRS1 field. */
#define BR_DMA_HRS_HRS1(x)   (BITBAND_ACCESS32(HW_DMA_HRS_ADDR(x), BP_DMA_HRS_HRS1))
/*@}*/

/*!
 * @name Register DMA_HRS, field HRS2[2] (RO)
 *
 * The HRS bit for its respective channel remains asserted for the period when a
 * Hardware Request is Present on the Channel. After the Request is completed
 * and Channel is free , the HRS bit is automatically cleared by hardware.
 *
 * Values:
 * - 0 - A hardware service request for channel 2 is not present
 * - 1 - A hardware service request for channel 2 is present
 */
/*@{*/
#define BP_DMA_HRS_HRS2      (2U)          /*!< Bit position for DMA_HRS_HRS2. */
#define BM_DMA_HRS_HRS2      (0x00000004U) /*!< Bit mask for DMA_HRS_HRS2. */
#define BS_DMA_HRS_HRS2      (1U)          /*!< Bit field size in bits for DMA_HRS_HRS2. */

/*! @brief Read current value of the DMA_HRS_HRS2 field. */
#define BR_DMA_HRS_HRS2(x)   (BITBAND_ACCESS32(HW_DMA_HRS_ADDR(x), BP_DMA_HRS_HRS2))
/*@}*/

/*!
 * @name Register DMA_HRS, field HRS3[3] (RO)
 *
 * The HRS bit for its respective channel remains asserted for the period when a
 * Hardware Request is Present on the Channel. After the Request is completed
 * and Channel is free , the HRS bit is automatically cleared by hardware.
 *
 * Values:
 * - 0 - A hardware service request for channel 3 is not present
 * - 1 - A hardware service request for channel 3 is present
 */
/*@{*/
#define BP_DMA_HRS_HRS3      (3U)          /*!< Bit position for DMA_HRS_HRS3. */
#define BM_DMA_HRS_HRS3      (0x00000008U) /*!< Bit mask for DMA_HRS_HRS3. */
#define BS_DMA_HRS_HRS3      (1U)          /*!< Bit field size in bits for DMA_HRS_HRS3. */

/*! @brief Read current value of the DMA_HRS_HRS3 field. */
#define BR_DMA_HRS_HRS3(x)   (BITBAND_ACCESS32(HW_DMA_HRS_ADDR(x), BP_DMA_HRS_HRS3))
/*@}*/

/*!
 * @name Register DMA_HRS, field HRS4[4] (RO)
 *
 * The HRS bit for its respective channel remains asserted for the period when a
 * Hardware Request is Present on the Channel. After the Request is completed
 * and Channel is free , the HRS bit is automatically cleared by hardware.
 *
 * Values:
 * - 0 - A hardware service request for channel 4 is not present
 * - 1 - A hardware service request for channel 4 is present
 */
/*@{*/
#define BP_DMA_HRS_HRS4      (4U)          /*!< Bit position for DMA_HRS_HRS4. */
#define BM_DMA_HRS_HRS4      (0x00000010U) /*!< Bit mask for DMA_HRS_HRS4. */
#define BS_DMA_HRS_HRS4      (1U)          /*!< Bit field size in bits for DMA_HRS_HRS4. */

/*! @brief Read current value of the DMA_HRS_HRS4 field. */
#define BR_DMA_HRS_HRS4(x)   (BITBAND_ACCESS32(HW_DMA_HRS_ADDR(x), BP_DMA_HRS_HRS4))
/*@}*/

/*!
 * @name Register DMA_HRS, field HRS5[5] (RO)
 *
 * The HRS bit for its respective channel remains asserted for the period when a
 * Hardware Request is Present on the Channel. After the Request is completed
 * and Channel is free , the HRS bit is automatically cleared by hardware.
 *
 * Values:
 * - 0 - A hardware service request for channel 5 is not present
 * - 1 - A hardware service request for channel 5 is present
 */
/*@{*/
#define BP_DMA_HRS_HRS5      (5U)          /*!< Bit position for DMA_HRS_HRS5. */
#define BM_DMA_HRS_HRS5      (0x00000020U) /*!< Bit mask for DMA_HRS_HRS5. */
#define BS_DMA_HRS_HRS5      (1U)          /*!< Bit field size in bits for DMA_HRS_HRS5. */

/*! @brief Read current value of the DMA_HRS_HRS5 field. */
#define BR_DMA_HRS_HRS5(x)   (BITBAND_ACCESS32(HW_DMA_HRS_ADDR(x), BP_DMA_HRS_HRS5))
/*@}*/

/*!
 * @name Register DMA_HRS, field HRS6[6] (RO)
 *
 * The HRS bit for its respective channel remains asserted for the period when a
 * Hardware Request is Present on the Channel. After the Request is completed
 * and Channel is free , the HRS bit is automatically cleared by hardware.
 *
 * Values:
 * - 0 - A hardware service request for channel 6 is not present
 * - 1 - A hardware service request for channel 6 is present
 */
/*@{*/
#define BP_DMA_HRS_HRS6      (6U)          /*!< Bit position for DMA_HRS_HRS6. */
#define BM_DMA_HRS_HRS6      (0x00000040U) /*!< Bit mask for DMA_HRS_HRS6. */
#define BS_DMA_HRS_HRS6      (1U)          /*!< Bit field size in bits for DMA_HRS_HRS6. */

/*! @brief Read current value of the DMA_HRS_HRS6 field. */
#define BR_DMA_HRS_HRS6(x)   (BITBAND_ACCESS32(HW_DMA_HRS_ADDR(x), BP_DMA_HRS_HRS6))
/*@}*/

/*!
 * @name Register DMA_HRS, field HRS7[7] (RO)
 *
 * The HRS bit for its respective channel remains asserted for the period when a
 * Hardware Request is Present on the Channel. After the Request is completed
 * and Channel is free , the HRS bit is automatically cleared by hardware.
 *
 * Values:
 * - 0 - A hardware service request for channel 7 is not present
 * - 1 - A hardware service request for channel 7 is present
 */
/*@{*/
#define BP_DMA_HRS_HRS7      (7U)          /*!< Bit position for DMA_HRS_HRS7. */
#define BM_DMA_HRS_HRS7      (0x00000080U) /*!< Bit mask for DMA_HRS_HRS7. */
#define BS_DMA_HRS_HRS7      (1U)          /*!< Bit field size in bits for DMA_HRS_HRS7. */

/*! @brief Read current value of the DMA_HRS_HRS7 field. */
#define BR_DMA_HRS_HRS7(x)   (BITBAND_ACCESS32(HW_DMA_HRS_ADDR(x), BP_DMA_HRS_HRS7))
/*@}*/

/*!
 * @name Register DMA_HRS, field HRS8[8] (RO)
 *
 * The HRS bit for its respective channel remains asserted for the period when a
 * Hardware Request is Present on the Channel. After the Request is completed
 * and Channel is free , the HRS bit is automatically cleared by hardware.
 *
 * Values:
 * - 0 - A hardware service request for channel 8 is not present
 * - 1 - A hardware service request for channel 8 is present
 */
/*@{*/
#define BP_DMA_HRS_HRS8      (8U)          /*!< Bit position for DMA_HRS_HRS8. */
#define BM_DMA_HRS_HRS8      (0x00000100U) /*!< Bit mask for DMA_HRS_HRS8. */
#define BS_DMA_HRS_HRS8      (1U)          /*!< Bit field size in bits for DMA_HRS_HRS8. */

/*! @brief Read current value of the DMA_HRS_HRS8 field. */
#define BR_DMA_HRS_HRS8(x)   (BITBAND_ACCESS32(HW_DMA_HRS_ADDR(x), BP_DMA_HRS_HRS8))
/*@}*/

/*!
 * @name Register DMA_HRS, field HRS9[9] (RO)
 *
 * The HRS bit for its respective channel remains asserted for the period when a
 * Hardware Request is Present on the Channel. After the Request is completed
 * and Channel is free , the HRS bit is automatically cleared by hardware.
 *
 * Values:
 * - 0 - A hardware service request for channel 9 is not present
 * - 1 - A hardware service request for channel 9 is present
 */
/*@{*/
#define BP_DMA_HRS_HRS9      (9U)          /*!< Bit position for DMA_HRS_HRS9. */
#define BM_DMA_HRS_HRS9      (0x00000200U) /*!< Bit mask for DMA_HRS_HRS9. */
#define BS_DMA_HRS_HRS9      (1U)          /*!< Bit field size in bits for DMA_HRS_HRS9. */

/*! @brief Read current value of the DMA_HRS_HRS9 field. */
#define BR_DMA_HRS_HRS9(x)   (BITBAND_ACCESS32(HW_DMA_HRS_ADDR(x), BP_DMA_HRS_HRS9))
/*@}*/

/*!
 * @name Register DMA_HRS, field HRS10[10] (RO)
 *
 * The HRS bit for its respective channel remains asserted for the period when a
 * Hardware Request is Present on the Channel. After the Request is completed
 * and Channel is free , the HRS bit is automatically cleared by hardware.
 *
 * Values:
 * - 0 - A hardware service request for channel 10 is not present
 * - 1 - A hardware service request for channel 10 is present
 */
/*@{*/
#define BP_DMA_HRS_HRS10     (10U)         /*!< Bit position for DMA_HRS_HRS10. */
#define BM_DMA_HRS_HRS10     (0x00000400U) /*!< Bit mask for DMA_HRS_HRS10. */
#define BS_DMA_HRS_HRS10     (1U)          /*!< Bit field size in bits for DMA_HRS_HRS10. */

/*! @brief Read current value of the DMA_HRS_HRS10 field. */
#define BR_DMA_HRS_HRS10(x)  (BITBAND_ACCESS32(HW_DMA_HRS_ADDR(x), BP_DMA_HRS_HRS10))
/*@}*/

/*!
 * @name Register DMA_HRS, field HRS11[11] (RO)
 *
 * The HRS bit for its respective channel remains asserted for the period when a
 * Hardware Request is Present on the Channel. After the Request is completed
 * and Channel is free , the HRS bit is automatically cleared by hardware.
 *
 * Values:
 * - 0 - A hardware service request for channel 11 is not present
 * - 1 - A hardware service request for channel 11 is present
 */
/*@{*/
#define BP_DMA_HRS_HRS11     (11U)         /*!< Bit position for DMA_HRS_HRS11. */
#define BM_DMA_HRS_HRS11     (0x00000800U) /*!< Bit mask for DMA_HRS_HRS11. */
#define BS_DMA_HRS_HRS11     (1U)          /*!< Bit field size in bits for DMA_HRS_HRS11. */

/*! @brief Read current value of the DMA_HRS_HRS11 field. */
#define BR_DMA_HRS_HRS11(x)  (BITBAND_ACCESS32(HW_DMA_HRS_ADDR(x), BP_DMA_HRS_HRS11))
/*@}*/

/*!
 * @name Register DMA_HRS, field HRS12[12] (RO)
 *
 * The HRS bit for its respective channel remains asserted for the period when a
 * Hardware Request is Present on the Channel. After the Request is completed
 * and Channel is free , the HRS bit is automatically cleared by hardware.
 *
 * Values:
 * - 0 - A hardware service request for channel 12 is not present
 * - 1 - A hardware service request for channel 12 is present
 */
/*@{*/
#define BP_DMA_HRS_HRS12     (12U)         /*!< Bit position for DMA_HRS_HRS12. */
#define BM_DMA_HRS_HRS12     (0x00001000U) /*!< Bit mask for DMA_HRS_HRS12. */
#define BS_DMA_HRS_HRS12     (1U)          /*!< Bit field size in bits for DMA_HRS_HRS12. */

/*! @brief Read current value of the DMA_HRS_HRS12 field. */
#define BR_DMA_HRS_HRS12(x)  (BITBAND_ACCESS32(HW_DMA_HRS_ADDR(x), BP_DMA_HRS_HRS12))
/*@}*/

/*!
 * @name Register DMA_HRS, field HRS13[13] (RO)
 *
 * The HRS bit for its respective channel remains asserted for the period when a
 * Hardware Request is Present on the Channel. After the Request is completed
 * and Channel is free , the HRS bit is automatically cleared by hardware.
 *
 * Values:
 * - 0 - A hardware service request for channel 13 is not present
 * - 1 - A hardware service request for channel 13 is present
 */
/*@{*/
#define BP_DMA_HRS_HRS13     (13U)         /*!< Bit position for DMA_HRS_HRS13. */
#define BM_DMA_HRS_HRS13     (0x00002000U) /*!< Bit mask for DMA_HRS_HRS13. */
#define BS_DMA_HRS_HRS13     (1U)          /*!< Bit field size in bits for DMA_HRS_HRS13. */

/*! @brief Read current value of the DMA_HRS_HRS13 field. */
#define BR_DMA_HRS_HRS13(x)  (BITBAND_ACCESS32(HW_DMA_HRS_ADDR(x), BP_DMA_HRS_HRS13))
/*@}*/

/*!
 * @name Register DMA_HRS, field HRS14[14] (RO)
 *
 * The HRS bit for its respective channel remains asserted for the period when a
 * Hardware Request is Present on the Channel. After the Request is completed
 * and Channel is free , the HRS bit is automatically cleared by hardware.
 *
 * Values:
 * - 0 - A hardware service request for channel 14 is not present
 * - 1 - A hardware service request for channel 14 is present
 */
/*@{*/
#define BP_DMA_HRS_HRS14     (14U)         /*!< Bit position for DMA_HRS_HRS14. */
#define BM_DMA_HRS_HRS14     (0x00004000U) /*!< Bit mask for DMA_HRS_HRS14. */
#define BS_DMA_HRS_HRS14     (1U)          /*!< Bit field size in bits for DMA_HRS_HRS14. */

/*! @brief Read current value of the DMA_HRS_HRS14 field. */
#define BR_DMA_HRS_HRS14(x)  (BITBAND_ACCESS32(HW_DMA_HRS_ADDR(x), BP_DMA_HRS_HRS14))
/*@}*/

/*!
 * @name Register DMA_HRS, field HRS15[15] (RO)
 *
 * The HRS bit for its respective channel remains asserted for the period when a
 * Hardware Request is Present on the Channel. After the Request is completed
 * and Channel is free , the HRS bit is automatically cleared by hardware.
 *
 * Values:
 * - 0 - A hardware service request for channel 15 is not present
 * - 1 - A hardware service request for channel 15 is present
 */
/*@{*/
#define BP_DMA_HRS_HRS15     (15U)         /*!< Bit position for DMA_HRS_HRS15. */
#define BM_DMA_HRS_HRS15     (0x00008000U) /*!< Bit mask for DMA_HRS_HRS15. */
#define BS_DMA_HRS_HRS15     (1U)          /*!< Bit field size in bits for DMA_HRS_HRS15. */

/*! @brief Read current value of the DMA_HRS_HRS15 field. */
#define BR_DMA_HRS_HRS15(x)  (BITBAND_ACCESS32(HW_DMA_HRS_ADDR(x), BP_DMA_HRS_HRS15))
/*@}*/

/*******************************************************************************
 * HW_DMA_DCHPRIn - Channel n Priority Register
 ******************************************************************************/

/*!
 * @brief HW_DMA_DCHPRIn - Channel n Priority Register (RW)
 *
 * Reset value: 0x00U
 *
 * When fixed-priority channel arbitration is enabled (CR[ERCA] = 0), the
 * contents of these registers define the unique priorities associated with each
 * channel . The channel priorities are evaluated by numeric value; for example, 0 is
 * the lowest priority, 1 is the next priority, then 2, 3, etc. Software must
 * program the channel priorities with unique values; otherwise, a configuration
 * error is reported. The range of the priority value is limited to the values of 0
 * through 15.
 */
typedef union _hw_dma_dchprin
{
    uint8_t U;
    struct _hw_dma_dchprin_bitfields
    {
        uint8_t CHPRI : 4;             /*!< [3:0] Channel n Arbitration Priority */
        uint8_t RESERVED0 : 2;         /*!< [5:4]  */
        uint8_t DPA : 1;               /*!< [6] Disable Preempt Ability */
        uint8_t ECP : 1;               /*!< [7] Enable Channel Preemption */
    } B;
} hw_dma_dchprin_t;

/*!
 * @name Constants and macros for entire DMA_DCHPRIn register
 */
/*@{*/
#define HW_DMA_DCHPRIn_COUNT (16U)

#define HW_DMA_DCHPRIn_ADDR(x, n) ((x) + 0x100U + (0x1U * (n)))

/* DMA channel index to DMA channel priority register array index conversion macro */
#define HW_DMA_DCHPRIn_CHANNEL(n) (((n) & ~0x03U) | (3 - ((n) & 0x03U)))

#define HW_DMA_DCHPRIn(x, n)     (*(__IO hw_dma_dchprin_t *) HW_DMA_DCHPRIn_ADDR(x, n))
#define HW_DMA_DCHPRIn_RD(x, n)  (HW_DMA_DCHPRIn(x, n).U)
#define HW_DMA_DCHPRIn_WR(x, n, v) (HW_DMA_DCHPRIn(x, n).U = (v))
#define HW_DMA_DCHPRIn_SET(x, n, v) (HW_DMA_DCHPRIn_WR(x, n, HW_DMA_DCHPRIn_RD(x, n) |  (v)))
#define HW_DMA_DCHPRIn_CLR(x, n, v) (HW_DMA_DCHPRIn_WR(x, n, HW_DMA_DCHPRIn_RD(x, n) & ~(v)))
#define HW_DMA_DCHPRIn_TOG(x, n, v) (HW_DMA_DCHPRIn_WR(x, n, HW_DMA_DCHPRIn_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DMA_DCHPRIn bitfields
 */

/*!
 * @name Register DMA_DCHPRIn, field CHPRI[3:0] (RW)
 *
 * Channel priority when fixed-priority arbitration is enabled Reset value for
 * the channel priority fields, CHPRI, is equal to the corresponding channel
 * number for each priority register, i.e., DCHPRI15[CHPRI] equals 0b1111.
 */
/*@{*/
#define BP_DMA_DCHPRIn_CHPRI (0U)          /*!< Bit position for DMA_DCHPRIn_CHPRI. */
#define BM_DMA_DCHPRIn_CHPRI (0x0FU)       /*!< Bit mask for DMA_DCHPRIn_CHPRI. */
#define BS_DMA_DCHPRIn_CHPRI (4U)          /*!< Bit field size in bits for DMA_DCHPRIn_CHPRI. */

/*! @brief Read current value of the DMA_DCHPRIn_CHPRI field. */
#define BR_DMA_DCHPRIn_CHPRI(x, n) (HW_DMA_DCHPRIn(x, n).B.CHPRI)

/*! @brief Format value for bitfield DMA_DCHPRIn_CHPRI. */
#define BF_DMA_DCHPRIn_CHPRI(v) ((uint8_t)((uint8_t)(v) << BP_DMA_DCHPRIn_CHPRI) & BM_DMA_DCHPRIn_CHPRI)

/*! @brief Set the CHPRI field to a new value. */
#define BW_DMA_DCHPRIn_CHPRI(x, n, v) (HW_DMA_DCHPRIn_WR(x, n, (HW_DMA_DCHPRIn_RD(x, n) & ~BM_DMA_DCHPRIn_CHPRI) | BF_DMA_DCHPRIn_CHPRI(v)))
/*@}*/

/*!
 * @name Register DMA_DCHPRIn, field DPA[6] (RW)
 *
 * Values:
 * - 0 - Channel n can suspend a lower priority channel
 * - 1 - Channel n cannot suspend any channel, regardless of channel priority
 */
/*@{*/
#define BP_DMA_DCHPRIn_DPA   (6U)          /*!< Bit position for DMA_DCHPRIn_DPA. */
#define BM_DMA_DCHPRIn_DPA   (0x40U)       /*!< Bit mask for DMA_DCHPRIn_DPA. */
#define BS_DMA_DCHPRIn_DPA   (1U)          /*!< Bit field size in bits for DMA_DCHPRIn_DPA. */

/*! @brief Read current value of the DMA_DCHPRIn_DPA field. */
#define BR_DMA_DCHPRIn_DPA(x, n) (BITBAND_ACCESS8(HW_DMA_DCHPRIn_ADDR(x, n), BP_DMA_DCHPRIn_DPA))

/*! @brief Format value for bitfield DMA_DCHPRIn_DPA. */
#define BF_DMA_DCHPRIn_DPA(v) ((uint8_t)((uint8_t)(v) << BP_DMA_DCHPRIn_DPA) & BM_DMA_DCHPRIn_DPA)

/*! @brief Set the DPA field to a new value. */
#define BW_DMA_DCHPRIn_DPA(x, n, v) (BITBAND_ACCESS8(HW_DMA_DCHPRIn_ADDR(x, n), BP_DMA_DCHPRIn_DPA) = (v))
/*@}*/

/*!
 * @name Register DMA_DCHPRIn, field ECP[7] (RW)
 *
 * Values:
 * - 0 - Channel n cannot be suspended by a higher priority channel's service
 *     request
 * - 1 - Channel n can be temporarily suspended by the service request of a
 *     higher priority channel
 */
/*@{*/
#define BP_DMA_DCHPRIn_ECP   (7U)          /*!< Bit position for DMA_DCHPRIn_ECP. */
#define BM_DMA_DCHPRIn_ECP   (0x80U)       /*!< Bit mask for DMA_DCHPRIn_ECP. */
#define BS_DMA_DCHPRIn_ECP   (1U)          /*!< Bit field size in bits for DMA_DCHPRIn_ECP. */

/*! @brief Read current value of the DMA_DCHPRIn_ECP field. */
#define BR_DMA_DCHPRIn_ECP(x, n) (BITBAND_ACCESS8(HW_DMA_DCHPRIn_ADDR(x, n), BP_DMA_DCHPRIn_ECP))

/*! @brief Format value for bitfield DMA_DCHPRIn_ECP. */
#define BF_DMA_DCHPRIn_ECP(v) ((uint8_t)((uint8_t)(v) << BP_DMA_DCHPRIn_ECP) & BM_DMA_DCHPRIn_ECP)

/*! @brief Set the ECP field to a new value. */
#define BW_DMA_DCHPRIn_ECP(x, n, v) (BITBAND_ACCESS8(HW_DMA_DCHPRIn_ADDR(x, n), BP_DMA_DCHPRIn_ECP) = (v))
/*@}*/

/*******************************************************************************
 * HW_DMA_TCDn_SADDR - TCD Source Address
 ******************************************************************************/

/*!
 * @brief HW_DMA_TCDn_SADDR - TCD Source Address (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_dma_tcdn_saddr
{
    uint32_t U;
    struct _hw_dma_tcdn_saddr_bitfields
    {
        uint32_t SADDR : 32;           /*!< [31:0] Source Address */
    } B;
} hw_dma_tcdn_saddr_t;

/*!
 * @name Constants and macros for entire DMA_TCDn_SADDR register
 */
/*@{*/
#define HW_DMA_TCDn_SADDR_COUNT (16U)

#define HW_DMA_TCDn_SADDR_ADDR(x, n) ((x) + 0x1000U + (0x20U * (n)))

#define HW_DMA_TCDn_SADDR(x, n)  (*(__IO hw_dma_tcdn_saddr_t *) HW_DMA_TCDn_SADDR_ADDR(x, n))
#define HW_DMA_TCDn_SADDR_RD(x, n) (HW_DMA_TCDn_SADDR(x, n).U)
#define HW_DMA_TCDn_SADDR_WR(x, n, v) (HW_DMA_TCDn_SADDR(x, n).U = (v))
#define HW_DMA_TCDn_SADDR_SET(x, n, v) (HW_DMA_TCDn_SADDR_WR(x, n, HW_DMA_TCDn_SADDR_RD(x, n) |  (v)))
#define HW_DMA_TCDn_SADDR_CLR(x, n, v) (HW_DMA_TCDn_SADDR_WR(x, n, HW_DMA_TCDn_SADDR_RD(x, n) & ~(v)))
#define HW_DMA_TCDn_SADDR_TOG(x, n, v) (HW_DMA_TCDn_SADDR_WR(x, n, HW_DMA_TCDn_SADDR_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DMA_TCDn_SADDR bitfields
 */

/*!
 * @name Register DMA_TCDn_SADDR, field SADDR[31:0] (RW)
 *
 * Memory address pointing to the source data.
 */
/*@{*/
#define BP_DMA_TCDn_SADDR_SADDR (0U)       /*!< Bit position for DMA_TCDn_SADDR_SADDR. */
#define BM_DMA_TCDn_SADDR_SADDR (0xFFFFFFFFU) /*!< Bit mask for DMA_TCDn_SADDR_SADDR. */
#define BS_DMA_TCDn_SADDR_SADDR (32U)      /*!< Bit field size in bits for DMA_TCDn_SADDR_SADDR. */

/*! @brief Read current value of the DMA_TCDn_SADDR_SADDR field. */
#define BR_DMA_TCDn_SADDR_SADDR(x, n) (HW_DMA_TCDn_SADDR(x, n).U)

/*! @brief Format value for bitfield DMA_TCDn_SADDR_SADDR. */
#define BF_DMA_TCDn_SADDR_SADDR(v) ((uint32_t)((uint32_t)(v) << BP_DMA_TCDn_SADDR_SADDR) & BM_DMA_TCDn_SADDR_SADDR)

/*! @brief Set the SADDR field to a new value. */
#define BW_DMA_TCDn_SADDR_SADDR(x, n, v) (HW_DMA_TCDn_SADDR_WR(x, n, v))
/*@}*/
/*******************************************************************************
 * HW_DMA_TCDn_SOFF - TCD Signed Source Address Offset
 ******************************************************************************/

/*!
 * @brief HW_DMA_TCDn_SOFF - TCD Signed Source Address Offset (RW)
 *
 * Reset value: 0x0000U
 */
typedef union _hw_dma_tcdn_soff
{
    uint16_t U;
    struct _hw_dma_tcdn_soff_bitfields
    {
        uint16_t SOFF : 16;            /*!< [15:0] Source address signed offset */
    } B;
} hw_dma_tcdn_soff_t;

/*!
 * @name Constants and macros for entire DMA_TCDn_SOFF register
 */
/*@{*/
#define HW_DMA_TCDn_SOFF_COUNT (16U)

#define HW_DMA_TCDn_SOFF_ADDR(x, n) ((x) + 0x1004U + (0x20U * (n)))

#define HW_DMA_TCDn_SOFF(x, n)   (*(__IO hw_dma_tcdn_soff_t *) HW_DMA_TCDn_SOFF_ADDR(x, n))
#define HW_DMA_TCDn_SOFF_RD(x, n) (HW_DMA_TCDn_SOFF(x, n).U)
#define HW_DMA_TCDn_SOFF_WR(x, n, v) (HW_DMA_TCDn_SOFF(x, n).U = (v))
#define HW_DMA_TCDn_SOFF_SET(x, n, v) (HW_DMA_TCDn_SOFF_WR(x, n, HW_DMA_TCDn_SOFF_RD(x, n) |  (v)))
#define HW_DMA_TCDn_SOFF_CLR(x, n, v) (HW_DMA_TCDn_SOFF_WR(x, n, HW_DMA_TCDn_SOFF_RD(x, n) & ~(v)))
#define HW_DMA_TCDn_SOFF_TOG(x, n, v) (HW_DMA_TCDn_SOFF_WR(x, n, HW_DMA_TCDn_SOFF_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DMA_TCDn_SOFF bitfields
 */

/*!
 * @name Register DMA_TCDn_SOFF, field SOFF[15:0] (RW)
 *
 * Sign-extended offset applied to the current source address to form the
 * next-state value as each source read is completed.
 */
/*@{*/
#define BP_DMA_TCDn_SOFF_SOFF (0U)         /*!< Bit position for DMA_TCDn_SOFF_SOFF. */
#define BM_DMA_TCDn_SOFF_SOFF (0xFFFFU)    /*!< Bit mask for DMA_TCDn_SOFF_SOFF. */
#define BS_DMA_TCDn_SOFF_SOFF (16U)        /*!< Bit field size in bits for DMA_TCDn_SOFF_SOFF. */

/*! @brief Read current value of the DMA_TCDn_SOFF_SOFF field. */
#define BR_DMA_TCDn_SOFF_SOFF(x, n) (HW_DMA_TCDn_SOFF(x, n).U)

/*! @brief Format value for bitfield DMA_TCDn_SOFF_SOFF. */
#define BF_DMA_TCDn_SOFF_SOFF(v) ((uint16_t)((uint16_t)(v) << BP_DMA_TCDn_SOFF_SOFF) & BM_DMA_TCDn_SOFF_SOFF)

/*! @brief Set the SOFF field to a new value. */
#define BW_DMA_TCDn_SOFF_SOFF(x, n, v) (HW_DMA_TCDn_SOFF_WR(x, n, v))
/*@}*/
/*******************************************************************************
 * HW_DMA_TCDn_ATTR - TCD Transfer Attributes
 ******************************************************************************/

/*!
 * @brief HW_DMA_TCDn_ATTR - TCD Transfer Attributes (RW)
 *
 * Reset value: 0x0000U
 */
typedef union _hw_dma_tcdn_attr
{
    uint16_t U;
    struct _hw_dma_tcdn_attr_bitfields
    {
        uint16_t DSIZE : 3;            /*!< [2:0] Destination Data Transfer Size */
        uint16_t DMOD : 5;             /*!< [7:3] Destination Address Modulo */
        uint16_t SSIZE : 3;            /*!< [10:8] Source data transfer size */
        uint16_t SMOD : 5;             /*!< [15:11] Source Address Modulo. */
    } B;
} hw_dma_tcdn_attr_t;

/*!
 * @name Constants and macros for entire DMA_TCDn_ATTR register
 */
/*@{*/
#define HW_DMA_TCDn_ATTR_COUNT (16U)

#define HW_DMA_TCDn_ATTR_ADDR(x, n) ((x) + 0x1006U + (0x20U * (n)))

#define HW_DMA_TCDn_ATTR(x, n)   (*(__IO hw_dma_tcdn_attr_t *) HW_DMA_TCDn_ATTR_ADDR(x, n))
#define HW_DMA_TCDn_ATTR_RD(x, n) (HW_DMA_TCDn_ATTR(x, n).U)
#define HW_DMA_TCDn_ATTR_WR(x, n, v) (HW_DMA_TCDn_ATTR(x, n).U = (v))
#define HW_DMA_TCDn_ATTR_SET(x, n, v) (HW_DMA_TCDn_ATTR_WR(x, n, HW_DMA_TCDn_ATTR_RD(x, n) |  (v)))
#define HW_DMA_TCDn_ATTR_CLR(x, n, v) (HW_DMA_TCDn_ATTR_WR(x, n, HW_DMA_TCDn_ATTR_RD(x, n) & ~(v)))
#define HW_DMA_TCDn_ATTR_TOG(x, n, v) (HW_DMA_TCDn_ATTR_WR(x, n, HW_DMA_TCDn_ATTR_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DMA_TCDn_ATTR bitfields
 */

/*!
 * @name Register DMA_TCDn_ATTR, field DSIZE[2:0] (RW)
 *
 * See the SSIZE definition
 */
/*@{*/
#define BP_DMA_TCDn_ATTR_DSIZE (0U)        /*!< Bit position for DMA_TCDn_ATTR_DSIZE. */
#define BM_DMA_TCDn_ATTR_DSIZE (0x0007U)   /*!< Bit mask for DMA_TCDn_ATTR_DSIZE. */
#define BS_DMA_TCDn_ATTR_DSIZE (3U)        /*!< Bit field size in bits for DMA_TCDn_ATTR_DSIZE. */

/*! @brief Read current value of the DMA_TCDn_ATTR_DSIZE field. */
#define BR_DMA_TCDn_ATTR_DSIZE(x, n) (HW_DMA_TCDn_ATTR(x, n).B.DSIZE)

/*! @brief Format value for bitfield DMA_TCDn_ATTR_DSIZE. */
#define BF_DMA_TCDn_ATTR_DSIZE(v) ((uint16_t)((uint16_t)(v) << BP_DMA_TCDn_ATTR_DSIZE) & BM_DMA_TCDn_ATTR_DSIZE)

/*! @brief Set the DSIZE field to a new value. */
#define BW_DMA_TCDn_ATTR_DSIZE(x, n, v) (HW_DMA_TCDn_ATTR_WR(x, n, (HW_DMA_TCDn_ATTR_RD(x, n) & ~BM_DMA_TCDn_ATTR_DSIZE) | BF_DMA_TCDn_ATTR_DSIZE(v)))
/*@}*/

/*!
 * @name Register DMA_TCDn_ATTR, field DMOD[7:3] (RW)
 *
 * See the SMOD definition
 */
/*@{*/
#define BP_DMA_TCDn_ATTR_DMOD (3U)         /*!< Bit position for DMA_TCDn_ATTR_DMOD. */
#define BM_DMA_TCDn_ATTR_DMOD (0x00F8U)    /*!< Bit mask for DMA_TCDn_ATTR_DMOD. */
#define BS_DMA_TCDn_ATTR_DMOD (5U)         /*!< Bit field size in bits for DMA_TCDn_ATTR_DMOD. */

/*! @brief Read current value of the DMA_TCDn_ATTR_DMOD field. */
#define BR_DMA_TCDn_ATTR_DMOD(x, n) (HW_DMA_TCDn_ATTR(x, n).B.DMOD)

/*! @brief Format value for bitfield DMA_TCDn_ATTR_DMOD. */
#define BF_DMA_TCDn_ATTR_DMOD(v) ((uint16_t)((uint16_t)(v) << BP_DMA_TCDn_ATTR_DMOD) & BM_DMA_TCDn_ATTR_DMOD)

/*! @brief Set the DMOD field to a new value. */
#define BW_DMA_TCDn_ATTR_DMOD(x, n, v) (HW_DMA_TCDn_ATTR_WR(x, n, (HW_DMA_TCDn_ATTR_RD(x, n) & ~BM_DMA_TCDn_ATTR_DMOD) | BF_DMA_TCDn_ATTR_DMOD(v)))
/*@}*/

/*!
 * @name Register DMA_TCDn_ATTR, field SSIZE[10:8] (RW)
 *
 * The attempted use of a Reserved encoding causes a configuration error.
 *
 * Values:
 * - 000 - 8-bit
 * - 001 - 16-bit
 * - 010 - 32-bit
 * - 011 - Reserved
 * - 100 - 16-byte
 * - 101 - 32-byte
 * - 110 - Reserved
 * - 111 - Reserved
 */
/*@{*/
#define BP_DMA_TCDn_ATTR_SSIZE (8U)        /*!< Bit position for DMA_TCDn_ATTR_SSIZE. */
#define BM_DMA_TCDn_ATTR_SSIZE (0x0700U)   /*!< Bit mask for DMA_TCDn_ATTR_SSIZE. */
#define BS_DMA_TCDn_ATTR_SSIZE (3U)        /*!< Bit field size in bits for DMA_TCDn_ATTR_SSIZE. */

/*! @brief Read current value of the DMA_TCDn_ATTR_SSIZE field. */
#define BR_DMA_TCDn_ATTR_SSIZE(x, n) (HW_DMA_TCDn_ATTR(x, n).B.SSIZE)

/*! @brief Format value for bitfield DMA_TCDn_ATTR_SSIZE. */
#define BF_DMA_TCDn_ATTR_SSIZE(v) ((uint16_t)((uint16_t)(v) << BP_DMA_TCDn_ATTR_SSIZE) & BM_DMA_TCDn_ATTR_SSIZE)

/*! @brief Set the SSIZE field to a new value. */
#define BW_DMA_TCDn_ATTR_SSIZE(x, n, v) (HW_DMA_TCDn_ATTR_WR(x, n, (HW_DMA_TCDn_ATTR_RD(x, n) & ~BM_DMA_TCDn_ATTR_SSIZE) | BF_DMA_TCDn_ATTR_SSIZE(v)))
/*@}*/

/*!
 * @name Register DMA_TCDn_ATTR, field SMOD[15:11] (RW)
 *
 * Values:
 * - 0 - Source address modulo feature is disabled
 */
/*@{*/
#define BP_DMA_TCDn_ATTR_SMOD (11U)        /*!< Bit position for DMA_TCDn_ATTR_SMOD. */
#define BM_DMA_TCDn_ATTR_SMOD (0xF800U)    /*!< Bit mask for DMA_TCDn_ATTR_SMOD. */
#define BS_DMA_TCDn_ATTR_SMOD (5U)         /*!< Bit field size in bits for DMA_TCDn_ATTR_SMOD. */

/*! @brief Read current value of the DMA_TCDn_ATTR_SMOD field. */
#define BR_DMA_TCDn_ATTR_SMOD(x, n) (HW_DMA_TCDn_ATTR(x, n).B.SMOD)

/*! @brief Format value for bitfield DMA_TCDn_ATTR_SMOD. */
#define BF_DMA_TCDn_ATTR_SMOD(v) ((uint16_t)((uint16_t)(v) << BP_DMA_TCDn_ATTR_SMOD) & BM_DMA_TCDn_ATTR_SMOD)

/*! @brief Set the SMOD field to a new value. */
#define BW_DMA_TCDn_ATTR_SMOD(x, n, v) (HW_DMA_TCDn_ATTR_WR(x, n, (HW_DMA_TCDn_ATTR_RD(x, n) & ~BM_DMA_TCDn_ATTR_SMOD) | BF_DMA_TCDn_ATTR_SMOD(v)))
/*@}*/
/*******************************************************************************
 * HW_DMA_TCDn_NBYTES_MLNO - TCD Minor Byte Count (Minor Loop Disabled)
 ******************************************************************************/

/*!
 * @brief HW_DMA_TCDn_NBYTES_MLNO - TCD Minor Byte Count (Minor Loop Disabled) (RW)
 *
 * Reset value: 0x00000000U
 *
 * This register, or one of the next two registers (TCD_NBYTES_MLOFFNO,
 * TCD_NBYTES_MLOFFYES), defines the number of bytes to transfer per request. Which
 * register to use depends on whether minor loop mapping is disabled, enabled but not
 * used for this channel, or enabled and used. TCD word 2 is defined as follows
 * if: Minor loop mapping is disabled (CR[EMLM] = 0) If minor loop mapping is
 * enabled, see the TCD_NBYTES_MLOFFNO and TCD_NBYTES_MLOFFYES register descriptions
 * for TCD word 2's definition.
 */
typedef union _hw_dma_tcdn_nbytes_mlno
{
    uint32_t U;
    struct _hw_dma_tcdn_nbytes_mlno_bitfields
    {
        uint32_t NBYTES : 32;          /*!< [31:0] Minor Byte Transfer Count */
    } B;
} hw_dma_tcdn_nbytes_mlno_t;

/*!
 * @name Constants and macros for entire DMA_TCDn_NBYTES_MLNO register
 */
/*@{*/
#define HW_DMA_TCDn_NBYTES_MLNO_COUNT (16U)

#define HW_DMA_TCDn_NBYTES_MLNO_ADDR(x, n) ((x) + 0x1008U + (0x20U * (n)))

#define HW_DMA_TCDn_NBYTES_MLNO(x, n) (*(__IO hw_dma_tcdn_nbytes_mlno_t *) HW_DMA_TCDn_NBYTES_MLNO_ADDR(x, n))
#define HW_DMA_TCDn_NBYTES_MLNO_RD(x, n) (HW_DMA_TCDn_NBYTES_MLNO(x, n).U)
#define HW_DMA_TCDn_NBYTES_MLNO_WR(x, n, v) (HW_DMA_TCDn_NBYTES_MLNO(x, n).U = (v))
#define HW_DMA_TCDn_NBYTES_MLNO_SET(x, n, v) (HW_DMA_TCDn_NBYTES_MLNO_WR(x, n, HW_DMA_TCDn_NBYTES_MLNO_RD(x, n) |  (v)))
#define HW_DMA_TCDn_NBYTES_MLNO_CLR(x, n, v) (HW_DMA_TCDn_NBYTES_MLNO_WR(x, n, HW_DMA_TCDn_NBYTES_MLNO_RD(x, n) & ~(v)))
#define HW_DMA_TCDn_NBYTES_MLNO_TOG(x, n, v) (HW_DMA_TCDn_NBYTES_MLNO_WR(x, n, HW_DMA_TCDn_NBYTES_MLNO_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DMA_TCDn_NBYTES_MLNO bitfields
 */

/*!
 * @name Register DMA_TCDn_NBYTES_MLNO, field NBYTES[31:0] (RW)
 *
 * Number of bytes to be transferred in each service request of the channel. As
 * a channel activates, the appropriate TCD contents load into the eDMA engine,
 * and the appropriate reads and writes perform until the minor byte transfer
 * count has transferred. This is an indivisible operation and cannot be halted.
 * (Although, it may be stalled by using the bandwidth control field, or via
 * preemption.) After the minor count is exhausted, the SADDR and DADDR values are
 * written back into the TCD memory, the major iteration count is decremented and
 * restored to the TCD memory. If the major iteration count is completed, additional
 * processing is performed. An NBYTES value of 0x0000_0000 is interpreted as a 4
 * GB transfer.
 */
/*@{*/
#define BP_DMA_TCDn_NBYTES_MLNO_NBYTES (0U) /*!< Bit position for DMA_TCDn_NBYTES_MLNO_NBYTES. */
#define BM_DMA_TCDn_NBYTES_MLNO_NBYTES (0xFFFFFFFFU) /*!< Bit mask for DMA_TCDn_NBYTES_MLNO_NBYTES. */
#define BS_DMA_TCDn_NBYTES_MLNO_NBYTES (32U) /*!< Bit field size in bits for DMA_TCDn_NBYTES_MLNO_NBYTES. */

/*! @brief Read current value of the DMA_TCDn_NBYTES_MLNO_NBYTES field. */
#define BR_DMA_TCDn_NBYTES_MLNO_NBYTES(x, n) (HW_DMA_TCDn_NBYTES_MLNO(x, n).U)

/*! @brief Format value for bitfield DMA_TCDn_NBYTES_MLNO_NBYTES. */
#define BF_DMA_TCDn_NBYTES_MLNO_NBYTES(v) ((uint32_t)((uint32_t)(v) << BP_DMA_TCDn_NBYTES_MLNO_NBYTES) & BM_DMA_TCDn_NBYTES_MLNO_NBYTES)

/*! @brief Set the NBYTES field to a new value. */
#define BW_DMA_TCDn_NBYTES_MLNO_NBYTES(x, n, v) (HW_DMA_TCDn_NBYTES_MLNO_WR(x, n, v))
/*@}*/
/*******************************************************************************
 * HW_DMA_TCDn_NBYTES_MLOFFNO - TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled)
 ******************************************************************************/

/*!
 * @brief HW_DMA_TCDn_NBYTES_MLOFFNO - TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) (RW)
 *
 * Reset value: 0x00000000U
 *
 * One of three registers (this register, TCD_NBYTES_MLNO, or
 * TCD_NBYTES_MLOFFYES), defines the number of bytes to transfer per request. Which register to use
 * depends on whether minor loop mapping is disabled, enabled but not used for
 * this channel, or enabled and used. TCD word 2 is defined as follows if: Minor
 * loop mapping is enabled (CR[EMLM] = 1) and SMLOE = 0 and DMLOE = 0 If minor
 * loop mapping is enabled and SMLOE or DMLOE is set, then refer to the
 * TCD_NBYTES_MLOFFYES register description. If minor loop mapping is disabled, then refer to
 * the TCD_NBYTES_MLNO register description.
 */
typedef union _hw_dma_tcdn_nbytes_mloffno
{
    uint32_t U;
    struct _hw_dma_tcdn_nbytes_mloffno_bitfields
    {
        uint32_t NBYTES : 30;          /*!< [29:0] Minor Byte Transfer Count */
        uint32_t DMLOE : 1;            /*!< [30] Destination Minor Loop Offset enable */
        uint32_t SMLOE : 1;            /*!< [31] Source Minor Loop Offset Enable */
    } B;
} hw_dma_tcdn_nbytes_mloffno_t;

/*!
 * @name Constants and macros for entire DMA_TCDn_NBYTES_MLOFFNO register
 */
/*@{*/
#define HW_DMA_TCDn_NBYTES_MLOFFNO_COUNT (16U)

#define HW_DMA_TCDn_NBYTES_MLOFFNO_ADDR(x, n) ((x) + 0x1008U + (0x20U * (n)))

#define HW_DMA_TCDn_NBYTES_MLOFFNO(x, n) (*(__IO hw_dma_tcdn_nbytes_mloffno_t *) HW_DMA_TCDn_NBYTES_MLOFFNO_ADDR(x, n))
#define HW_DMA_TCDn_NBYTES_MLOFFNO_RD(x, n) (HW_DMA_TCDn_NBYTES_MLOFFNO(x, n).U)
#define HW_DMA_TCDn_NBYTES_MLOFFNO_WR(x, n, v) (HW_DMA_TCDn_NBYTES_MLOFFNO(x, n).U = (v))
#define HW_DMA_TCDn_NBYTES_MLOFFNO_SET(x, n, v) (HW_DMA_TCDn_NBYTES_MLOFFNO_WR(x, n, HW_DMA_TCDn_NBYTES_MLOFFNO_RD(x, n) |  (v)))
#define HW_DMA_TCDn_NBYTES_MLOFFNO_CLR(x, n, v) (HW_DMA_TCDn_NBYTES_MLOFFNO_WR(x, n, HW_DMA_TCDn_NBYTES_MLOFFNO_RD(x, n) & ~(v)))
#define HW_DMA_TCDn_NBYTES_MLOFFNO_TOG(x, n, v) (HW_DMA_TCDn_NBYTES_MLOFFNO_WR(x, n, HW_DMA_TCDn_NBYTES_MLOFFNO_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DMA_TCDn_NBYTES_MLOFFNO bitfields
 */

/*!
 * @name Register DMA_TCDn_NBYTES_MLOFFNO, field NBYTES[29:0] (RW)
 *
 * Number of bytes to be transferred in each service request of the channel. As
 * a channel activates, the appropriate TCD contents load into the eDMA engine,
 * and the appropriate reads and writes perform until the minor byte transfer
 * count has transferred. This is an indivisible operation and cannot be halted;
 * although, it may be stalled by using the bandwidth control field, or via
 * preemption. After the minor count is exhausted, the SADDR and DADDR values are written
 * back into the TCD memory, the major iteration count is decremented and
 * restored to the TCD memory. If the major iteration count is completed, additional
 * processing is performed.
 */
/*@{*/
#define BP_DMA_TCDn_NBYTES_MLOFFNO_NBYTES (0U) /*!< Bit position for DMA_TCDn_NBYTES_MLOFFNO_NBYTES. */
#define BM_DMA_TCDn_NBYTES_MLOFFNO_NBYTES (0x3FFFFFFFU) /*!< Bit mask for DMA_TCDn_NBYTES_MLOFFNO_NBYTES. */
#define BS_DMA_TCDn_NBYTES_MLOFFNO_NBYTES (30U) /*!< Bit field size in bits for DMA_TCDn_NBYTES_MLOFFNO_NBYTES. */

/*! @brief Read current value of the DMA_TCDn_NBYTES_MLOFFNO_NBYTES field. */
#define BR_DMA_TCDn_NBYTES_MLOFFNO_NBYTES(x, n) (HW_DMA_TCDn_NBYTES_MLOFFNO(x, n).B.NBYTES)

/*! @brief Format value for bitfield DMA_TCDn_NBYTES_MLOFFNO_NBYTES. */
#define BF_DMA_TCDn_NBYTES_MLOFFNO_NBYTES(v) ((uint32_t)((uint32_t)(v) << BP_DMA_TCDn_NBYTES_MLOFFNO_NBYTES) & BM_DMA_TCDn_NBYTES_MLOFFNO_NBYTES)

/*! @brief Set the NBYTES field to a new value. */
#define BW_DMA_TCDn_NBYTES_MLOFFNO_NBYTES(x, n, v) (HW_DMA_TCDn_NBYTES_MLOFFNO_WR(x, n, (HW_DMA_TCDn_NBYTES_MLOFFNO_RD(x, n) & ~BM_DMA_TCDn_NBYTES_MLOFFNO_NBYTES) | BF_DMA_TCDn_NBYTES_MLOFFNO_NBYTES(v)))
/*@}*/

/*!
 * @name Register DMA_TCDn_NBYTES_MLOFFNO, field DMLOE[30] (RW)
 *
 * Selects whether the minor loop offset is applied to the destination address
 * upon minor loop completion.
 *
 * Values:
 * - 0 - The minor loop offset is not applied to the DADDR
 * - 1 - The minor loop offset is applied to the DADDR
 */
/*@{*/
#define BP_DMA_TCDn_NBYTES_MLOFFNO_DMLOE (30U) /*!< Bit position for DMA_TCDn_NBYTES_MLOFFNO_DMLOE. */
#define BM_DMA_TCDn_NBYTES_MLOFFNO_DMLOE (0x40000000U) /*!< Bit mask for DMA_TCDn_NBYTES_MLOFFNO_DMLOE. */
#define BS_DMA_TCDn_NBYTES_MLOFFNO_DMLOE (1U) /*!< Bit field size in bits for DMA_TCDn_NBYTES_MLOFFNO_DMLOE. */

/*! @brief Read current value of the DMA_TCDn_NBYTES_MLOFFNO_DMLOE field. */
#define BR_DMA_TCDn_NBYTES_MLOFFNO_DMLOE(x, n) (BITBAND_ACCESS32(HW_DMA_TCDn_NBYTES_MLOFFNO_ADDR(x, n), BP_DMA_TCDn_NBYTES_MLOFFNO_DMLOE))

/*! @brief Format value for bitfield DMA_TCDn_NBYTES_MLOFFNO_DMLOE. */
#define BF_DMA_TCDn_NBYTES_MLOFFNO_DMLOE(v) ((uint32_t)((uint32_t)(v) << BP_DMA_TCDn_NBYTES_MLOFFNO_DMLOE) & BM_DMA_TCDn_NBYTES_MLOFFNO_DMLOE)

/*! @brief Set the DMLOE field to a new value. */
#define BW_DMA_TCDn_NBYTES_MLOFFNO_DMLOE(x, n, v) (BITBAND_ACCESS32(HW_DMA_TCDn_NBYTES_MLOFFNO_ADDR(x, n), BP_DMA_TCDn_NBYTES_MLOFFNO_DMLOE) = (v))
/*@}*/

/*!
 * @name Register DMA_TCDn_NBYTES_MLOFFNO, field SMLOE[31] (RW)
 *
 * Selects whether the minor loop offset is applied to the source address upon
 * minor loop completion.
 *
 * Values:
 * - 0 - The minor loop offset is not applied to the SADDR
 * - 1 - The minor loop offset is applied to the SADDR
 */
/*@{*/
#define BP_DMA_TCDn_NBYTES_MLOFFNO_SMLOE (31U) /*!< Bit position for DMA_TCDn_NBYTES_MLOFFNO_SMLOE. */
#define BM_DMA_TCDn_NBYTES_MLOFFNO_SMLOE (0x80000000U) /*!< Bit mask for DMA_TCDn_NBYTES_MLOFFNO_SMLOE. */
#define BS_DMA_TCDn_NBYTES_MLOFFNO_SMLOE (1U) /*!< Bit field size in bits for DMA_TCDn_NBYTES_MLOFFNO_SMLOE. */

/*! @brief Read current value of the DMA_TCDn_NBYTES_MLOFFNO_SMLOE field. */
#define BR_DMA_TCDn_NBYTES_MLOFFNO_SMLOE(x, n) (BITBAND_ACCESS32(HW_DMA_TCDn_NBYTES_MLOFFNO_ADDR(x, n), BP_DMA_TCDn_NBYTES_MLOFFNO_SMLOE))

/*! @brief Format value for bitfield DMA_TCDn_NBYTES_MLOFFNO_SMLOE. */
#define BF_DMA_TCDn_NBYTES_MLOFFNO_SMLOE(v) ((uint32_t)((uint32_t)(v) << BP_DMA_TCDn_NBYTES_MLOFFNO_SMLOE) & BM_DMA_TCDn_NBYTES_MLOFFNO_SMLOE)

/*! @brief Set the SMLOE field to a new value. */
#define BW_DMA_TCDn_NBYTES_MLOFFNO_SMLOE(x, n, v) (BITBAND_ACCESS32(HW_DMA_TCDn_NBYTES_MLOFFNO_ADDR(x, n), BP_DMA_TCDn_NBYTES_MLOFFNO_SMLOE) = (v))
/*@}*/
/*******************************************************************************
 * HW_DMA_TCDn_NBYTES_MLOFFYES - TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled)
 ******************************************************************************/

/*!
 * @brief HW_DMA_TCDn_NBYTES_MLOFFYES - TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) (RW)
 *
 * Reset value: 0x00000000U
 *
 * One of three registers (this register, TCD_NBYTES_MLNO, or
 * TCD_NBYTES_MLOFFNO), defines the number of bytes to transfer per request. Which register to use
 * depends on whether minor loop mapping is disabled, enabled but not used for
 * this channel, or enabled and used. TCD word 2 is defined as follows if: Minor
 * loop mapping is enabled (CR[EMLM] = 1) and Minor loop offset is enabled (SMLOE
 * or DMLOE = 1) If minor loop mapping is enabled and SMLOE and DMLOE are cleared,
 * then refer to the TCD_NBYTES_MLOFFNO register description. If minor loop
 * mapping is disabled, then refer to the TCD_NBYTES_MLNO register description.
 */
typedef union _hw_dma_tcdn_nbytes_mloffyes
{
    uint32_t U;
    struct _hw_dma_tcdn_nbytes_mloffyes_bitfields
    {
        uint32_t NBYTES : 10;          /*!< [9:0] Minor Byte Transfer Count */
        uint32_t MLOFF : 20;           /*!< [29:10] If SMLOE or DMLOE is set, this
                                        * field represents a sign-extended offset applied to the source or destination
                                        * address to form the next-state value after the minor loop completes. */
        uint32_t DMLOE : 1;            /*!< [30] Destination Minor Loop Offset enable */
        uint32_t SMLOE : 1;            /*!< [31] Source Minor Loop Offset Enable */
    } B;
} hw_dma_tcdn_nbytes_mloffyes_t;

/*!
 * @name Constants and macros for entire DMA_TCDn_NBYTES_MLOFFYES register
 */
/*@{*/
#define HW_DMA_TCDn_NBYTES_MLOFFYES_COUNT (16U)

#define HW_DMA_TCDn_NBYTES_MLOFFYES_ADDR(x, n) ((x) + 0x1008U + (0x20U * (n)))

#define HW_DMA_TCDn_NBYTES_MLOFFYES(x, n) (*(__IO hw_dma_tcdn_nbytes_mloffyes_t *) HW_DMA_TCDn_NBYTES_MLOFFYES_ADDR(x, n))
#define HW_DMA_TCDn_NBYTES_MLOFFYES_RD(x, n) (HW_DMA_TCDn_NBYTES_MLOFFYES(x, n).U)
#define HW_DMA_TCDn_NBYTES_MLOFFYES_WR(x, n, v) (HW_DMA_TCDn_NBYTES_MLOFFYES(x, n).U = (v))
#define HW_DMA_TCDn_NBYTES_MLOFFYES_SET(x, n, v) (HW_DMA_TCDn_NBYTES_MLOFFYES_WR(x, n, HW_DMA_TCDn_NBYTES_MLOFFYES_RD(x, n) |  (v)))
#define HW_DMA_TCDn_NBYTES_MLOFFYES_CLR(x, n, v) (HW_DMA_TCDn_NBYTES_MLOFFYES_WR(x, n, HW_DMA_TCDn_NBYTES_MLOFFYES_RD(x, n) & ~(v)))
#define HW_DMA_TCDn_NBYTES_MLOFFYES_TOG(x, n, v) (HW_DMA_TCDn_NBYTES_MLOFFYES_WR(x, n, HW_DMA_TCDn_NBYTES_MLOFFYES_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DMA_TCDn_NBYTES_MLOFFYES bitfields
 */

/*!
 * @name Register DMA_TCDn_NBYTES_MLOFFYES, field NBYTES[9:0] (RW)
 *
 * Number of bytes to be transferred in each service request of the channel. As
 * a channel activates, the appropriate TCD contents load into the eDMA engine,
 * and the appropriate reads and writes perform until the minor byte transfer
 * count has transferred. This is an indivisible operation and cannot be halted.
 * (Although, it may be stalled by using the bandwidth control field, or via
 * preemption.) After the minor count is exhausted, the SADDR and DADDR values are
 * written back into the TCD memory, the major iteration count is decremented and
 * restored to the TCD memory. If the major iteration count is completed, additional
 * processing is performed.
 */
/*@{*/
#define BP_DMA_TCDn_NBYTES_MLOFFYES_NBYTES (0U) /*!< Bit position for DMA_TCDn_NBYTES_MLOFFYES_NBYTES. */
#define BM_DMA_TCDn_NBYTES_MLOFFYES_NBYTES (0x000003FFU) /*!< Bit mask for DMA_TCDn_NBYTES_MLOFFYES_NBYTES. */
#define BS_DMA_TCDn_NBYTES_MLOFFYES_NBYTES (10U) /*!< Bit field size in bits for DMA_TCDn_NBYTES_MLOFFYES_NBYTES. */

/*! @brief Read current value of the DMA_TCDn_NBYTES_MLOFFYES_NBYTES field. */
#define BR_DMA_TCDn_NBYTES_MLOFFYES_NBYTES(x, n) (HW_DMA_TCDn_NBYTES_MLOFFYES(x, n).B.NBYTES)

/*! @brief Format value for bitfield DMA_TCDn_NBYTES_MLOFFYES_NBYTES. */
#define BF_DMA_TCDn_NBYTES_MLOFFYES_NBYTES(v) ((uint32_t)((uint32_t)(v) << BP_DMA_TCDn_NBYTES_MLOFFYES_NBYTES) & BM_DMA_TCDn_NBYTES_MLOFFYES_NBYTES)

/*! @brief Set the NBYTES field to a new value. */
#define BW_DMA_TCDn_NBYTES_MLOFFYES_NBYTES(x, n, v) (HW_DMA_TCDn_NBYTES_MLOFFYES_WR(x, n, (HW_DMA_TCDn_NBYTES_MLOFFYES_RD(x, n) & ~BM_DMA_TCDn_NBYTES_MLOFFYES_NBYTES) | BF_DMA_TCDn_NBYTES_MLOFFYES_NBYTES(v)))
/*@}*/

/*!
 * @name Register DMA_TCDn_NBYTES_MLOFFYES, field MLOFF[29:10] (RW)
 */
/*@{*/
#define BP_DMA_TCDn_NBYTES_MLOFFYES_MLOFF (10U) /*!< Bit position for DMA_TCDn_NBYTES_MLOFFYES_MLOFF. */
#define BM_DMA_TCDn_NBYTES_MLOFFYES_MLOFF (0x3FFFFC00U) /*!< Bit mask for DMA_TCDn_NBYTES_MLOFFYES_MLOFF. */
#define BS_DMA_TCDn_NBYTES_MLOFFYES_MLOFF (20U) /*!< Bit field size in bits for DMA_TCDn_NBYTES_MLOFFYES_MLOFF. */

/*! @brief Read current value of the DMA_TCDn_NBYTES_MLOFFYES_MLOFF field. */
#define BR_DMA_TCDn_NBYTES_MLOFFYES_MLOFF(x, n) (HW_DMA_TCDn_NBYTES_MLOFFYES(x, n).B.MLOFF)

/*! @brief Format value for bitfield DMA_TCDn_NBYTES_MLOFFYES_MLOFF. */
#define BF_DMA_TCDn_NBYTES_MLOFFYES_MLOFF(v) ((uint32_t)((uint32_t)(v) << BP_DMA_TCDn_NBYTES_MLOFFYES_MLOFF) & BM_DMA_TCDn_NBYTES_MLOFFYES_MLOFF)

/*! @brief Set the MLOFF field to a new value. */
#define BW_DMA_TCDn_NBYTES_MLOFFYES_MLOFF(x, n, v) (HW_DMA_TCDn_NBYTES_MLOFFYES_WR(x, n, (HW_DMA_TCDn_NBYTES_MLOFFYES_RD(x, n) & ~BM_DMA_TCDn_NBYTES_MLOFFYES_MLOFF) | BF_DMA_TCDn_NBYTES_MLOFFYES_MLOFF(v)))
/*@}*/

/*!
 * @name Register DMA_TCDn_NBYTES_MLOFFYES, field DMLOE[30] (RW)
 *
 * Selects whether the minor loop offset is applied to the destination address
 * upon minor loop completion.
 *
 * Values:
 * - 0 - The minor loop offset is not applied to the DADDR
 * - 1 - The minor loop offset is applied to the DADDR
 */
/*@{*/
#define BP_DMA_TCDn_NBYTES_MLOFFYES_DMLOE (30U) /*!< Bit position for DMA_TCDn_NBYTES_MLOFFYES_DMLOE. */
#define BM_DMA_TCDn_NBYTES_MLOFFYES_DMLOE (0x40000000U) /*!< Bit mask for DMA_TCDn_NBYTES_MLOFFYES_DMLOE. */
#define BS_DMA_TCDn_NBYTES_MLOFFYES_DMLOE (1U) /*!< Bit field size in bits for DMA_TCDn_NBYTES_MLOFFYES_DMLOE. */

/*! @brief Read current value of the DMA_TCDn_NBYTES_MLOFFYES_DMLOE field. */
#define BR_DMA_TCDn_NBYTES_MLOFFYES_DMLOE(x, n) (BITBAND_ACCESS32(HW_DMA_TCDn_NBYTES_MLOFFYES_ADDR(x, n), BP_DMA_TCDn_NBYTES_MLOFFYES_DMLOE))

/*! @brief Format value for bitfield DMA_TCDn_NBYTES_MLOFFYES_DMLOE. */
#define BF_DMA_TCDn_NBYTES_MLOFFYES_DMLOE(v) ((uint32_t)((uint32_t)(v) << BP_DMA_TCDn_NBYTES_MLOFFYES_DMLOE) & BM_DMA_TCDn_NBYTES_MLOFFYES_DMLOE)

/*! @brief Set the DMLOE field to a new value. */
#define BW_DMA_TCDn_NBYTES_MLOFFYES_DMLOE(x, n, v) (BITBAND_ACCESS32(HW_DMA_TCDn_NBYTES_MLOFFYES_ADDR(x, n), BP_DMA_TCDn_NBYTES_MLOFFYES_DMLOE) = (v))
/*@}*/

/*!
 * @name Register DMA_TCDn_NBYTES_MLOFFYES, field SMLOE[31] (RW)
 *
 * Selects whether the minor loop offset is applied to the source address upon
 * minor loop completion.
 *
 * Values:
 * - 0 - The minor loop offset is not applied to the SADDR
 * - 1 - The minor loop offset is applied to the SADDR
 */
/*@{*/
#define BP_DMA_TCDn_NBYTES_MLOFFYES_SMLOE (31U) /*!< Bit position for DMA_TCDn_NBYTES_MLOFFYES_SMLOE. */
#define BM_DMA_TCDn_NBYTES_MLOFFYES_SMLOE (0x80000000U) /*!< Bit mask for DMA_TCDn_NBYTES_MLOFFYES_SMLOE. */
#define BS_DMA_TCDn_NBYTES_MLOFFYES_SMLOE (1U) /*!< Bit field size in bits for DMA_TCDn_NBYTES_MLOFFYES_SMLOE. */

/*! @brief Read current value of the DMA_TCDn_NBYTES_MLOFFYES_SMLOE field. */
#define BR_DMA_TCDn_NBYTES_MLOFFYES_SMLOE(x, n) (BITBAND_ACCESS32(HW_DMA_TCDn_NBYTES_MLOFFYES_ADDR(x, n), BP_DMA_TCDn_NBYTES_MLOFFYES_SMLOE))

/*! @brief Format value for bitfield DMA_TCDn_NBYTES_MLOFFYES_SMLOE. */
#define BF_DMA_TCDn_NBYTES_MLOFFYES_SMLOE(v) ((uint32_t)((uint32_t)(v) << BP_DMA_TCDn_NBYTES_MLOFFYES_SMLOE) & BM_DMA_TCDn_NBYTES_MLOFFYES_SMLOE)

/*! @brief Set the SMLOE field to a new value. */
#define BW_DMA_TCDn_NBYTES_MLOFFYES_SMLOE(x, n, v) (BITBAND_ACCESS32(HW_DMA_TCDn_NBYTES_MLOFFYES_ADDR(x, n), BP_DMA_TCDn_NBYTES_MLOFFYES_SMLOE) = (v))
/*@}*/
/*******************************************************************************
 * HW_DMA_TCDn_SLAST - TCD Last Source Address Adjustment
 ******************************************************************************/

/*!
 * @brief HW_DMA_TCDn_SLAST - TCD Last Source Address Adjustment (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_dma_tcdn_slast
{
    uint32_t U;
    struct _hw_dma_tcdn_slast_bitfields
    {
        uint32_t SLAST : 32;           /*!< [31:0] Last source Address Adjustment */
    } B;
} hw_dma_tcdn_slast_t;

/*!
 * @name Constants and macros for entire DMA_TCDn_SLAST register
 */
/*@{*/
#define HW_DMA_TCDn_SLAST_COUNT (16U)

#define HW_DMA_TCDn_SLAST_ADDR(x, n) ((x) + 0x100CU + (0x20U * (n)))

#define HW_DMA_TCDn_SLAST(x, n)  (*(__IO hw_dma_tcdn_slast_t *) HW_DMA_TCDn_SLAST_ADDR(x, n))
#define HW_DMA_TCDn_SLAST_RD(x, n) (HW_DMA_TCDn_SLAST(x, n).U)
#define HW_DMA_TCDn_SLAST_WR(x, n, v) (HW_DMA_TCDn_SLAST(x, n).U = (v))
#define HW_DMA_TCDn_SLAST_SET(x, n, v) (HW_DMA_TCDn_SLAST_WR(x, n, HW_DMA_TCDn_SLAST_RD(x, n) |  (v)))
#define HW_DMA_TCDn_SLAST_CLR(x, n, v) (HW_DMA_TCDn_SLAST_WR(x, n, HW_DMA_TCDn_SLAST_RD(x, n) & ~(v)))
#define HW_DMA_TCDn_SLAST_TOG(x, n, v) (HW_DMA_TCDn_SLAST_WR(x, n, HW_DMA_TCDn_SLAST_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DMA_TCDn_SLAST bitfields
 */

/*!
 * @name Register DMA_TCDn_SLAST, field SLAST[31:0] (RW)
 *
 * Adjustment value added to the source address at the completion of the major
 * iteration count. This value can be applied to restore the source address to the
 * initial value, or adjust the address to reference the next data structure.
 * This register uses two's complement notation; the overflow bit is discarded.
 */
/*@{*/
#define BP_DMA_TCDn_SLAST_SLAST (0U)       /*!< Bit position for DMA_TCDn_SLAST_SLAST. */
#define BM_DMA_TCDn_SLAST_SLAST (0xFFFFFFFFU) /*!< Bit mask for DMA_TCDn_SLAST_SLAST. */
#define BS_DMA_TCDn_SLAST_SLAST (32U)      /*!< Bit field size in bits for DMA_TCDn_SLAST_SLAST. */

/*! @brief Read current value of the DMA_TCDn_SLAST_SLAST field. */
#define BR_DMA_TCDn_SLAST_SLAST(x, n) (HW_DMA_TCDn_SLAST(x, n).U)

/*! @brief Format value for bitfield DMA_TCDn_SLAST_SLAST. */
#define BF_DMA_TCDn_SLAST_SLAST(v) ((uint32_t)((uint32_t)(v) << BP_DMA_TCDn_SLAST_SLAST) & BM_DMA_TCDn_SLAST_SLAST)

/*! @brief Set the SLAST field to a new value. */
#define BW_DMA_TCDn_SLAST_SLAST(x, n, v) (HW_DMA_TCDn_SLAST_WR(x, n, v))
/*@}*/
/*******************************************************************************
 * HW_DMA_TCDn_DADDR - TCD Destination Address
 ******************************************************************************/

/*!
 * @brief HW_DMA_TCDn_DADDR - TCD Destination Address (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_dma_tcdn_daddr
{
    uint32_t U;
    struct _hw_dma_tcdn_daddr_bitfields
    {
        uint32_t DADDR : 32;           /*!< [31:0] Destination Address */
    } B;
} hw_dma_tcdn_daddr_t;

/*!
 * @name Constants and macros for entire DMA_TCDn_DADDR register
 */
/*@{*/
#define HW_DMA_TCDn_DADDR_COUNT (16U)

#define HW_DMA_TCDn_DADDR_ADDR(x, n) ((x) + 0x1010U + (0x20U * (n)))

#define HW_DMA_TCDn_DADDR(x, n)  (*(__IO hw_dma_tcdn_daddr_t *) HW_DMA_TCDn_DADDR_ADDR(x, n))
#define HW_DMA_TCDn_DADDR_RD(x, n) (HW_DMA_TCDn_DADDR(x, n).U)
#define HW_DMA_TCDn_DADDR_WR(x, n, v) (HW_DMA_TCDn_DADDR(x, n).U = (v))
#define HW_DMA_TCDn_DADDR_SET(x, n, v) (HW_DMA_TCDn_DADDR_WR(x, n, HW_DMA_TCDn_DADDR_RD(x, n) |  (v)))
#define HW_DMA_TCDn_DADDR_CLR(x, n, v) (HW_DMA_TCDn_DADDR_WR(x, n, HW_DMA_TCDn_DADDR_RD(x, n) & ~(v)))
#define HW_DMA_TCDn_DADDR_TOG(x, n, v) (HW_DMA_TCDn_DADDR_WR(x, n, HW_DMA_TCDn_DADDR_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DMA_TCDn_DADDR bitfields
 */

/*!
 * @name Register DMA_TCDn_DADDR, field DADDR[31:0] (RW)
 *
 * Memory address pointing to the destination data.
 */
/*@{*/
#define BP_DMA_TCDn_DADDR_DADDR (0U)       /*!< Bit position for DMA_TCDn_DADDR_DADDR. */
#define BM_DMA_TCDn_DADDR_DADDR (0xFFFFFFFFU) /*!< Bit mask for DMA_TCDn_DADDR_DADDR. */
#define BS_DMA_TCDn_DADDR_DADDR (32U)      /*!< Bit field size in bits for DMA_TCDn_DADDR_DADDR. */

/*! @brief Read current value of the DMA_TCDn_DADDR_DADDR field. */
#define BR_DMA_TCDn_DADDR_DADDR(x, n) (HW_DMA_TCDn_DADDR(x, n).U)

/*! @brief Format value for bitfield DMA_TCDn_DADDR_DADDR. */
#define BF_DMA_TCDn_DADDR_DADDR(v) ((uint32_t)((uint32_t)(v) << BP_DMA_TCDn_DADDR_DADDR) & BM_DMA_TCDn_DADDR_DADDR)

/*! @brief Set the DADDR field to a new value. */
#define BW_DMA_TCDn_DADDR_DADDR(x, n, v) (HW_DMA_TCDn_DADDR_WR(x, n, v))
/*@}*/
/*******************************************************************************
 * HW_DMA_TCDn_DOFF - TCD Signed Destination Address Offset
 ******************************************************************************/

/*!
 * @brief HW_DMA_TCDn_DOFF - TCD Signed Destination Address Offset (RW)
 *
 * Reset value: 0x0000U
 */
typedef union _hw_dma_tcdn_doff
{
    uint16_t U;
    struct _hw_dma_tcdn_doff_bitfields
    {
        uint16_t DOFF : 16;            /*!< [15:0] Destination Address Signed offset */
    } B;
} hw_dma_tcdn_doff_t;

/*!
 * @name Constants and macros for entire DMA_TCDn_DOFF register
 */
/*@{*/
#define HW_DMA_TCDn_DOFF_COUNT (16U)

#define HW_DMA_TCDn_DOFF_ADDR(x, n) ((x) + 0x1014U + (0x20U * (n)))

#define HW_DMA_TCDn_DOFF(x, n)   (*(__IO hw_dma_tcdn_doff_t *) HW_DMA_TCDn_DOFF_ADDR(x, n))
#define HW_DMA_TCDn_DOFF_RD(x, n) (HW_DMA_TCDn_DOFF(x, n).U)
#define HW_DMA_TCDn_DOFF_WR(x, n, v) (HW_DMA_TCDn_DOFF(x, n).U = (v))
#define HW_DMA_TCDn_DOFF_SET(x, n, v) (HW_DMA_TCDn_DOFF_WR(x, n, HW_DMA_TCDn_DOFF_RD(x, n) |  (v)))
#define HW_DMA_TCDn_DOFF_CLR(x, n, v) (HW_DMA_TCDn_DOFF_WR(x, n, HW_DMA_TCDn_DOFF_RD(x, n) & ~(v)))
#define HW_DMA_TCDn_DOFF_TOG(x, n, v) (HW_DMA_TCDn_DOFF_WR(x, n, HW_DMA_TCDn_DOFF_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DMA_TCDn_DOFF bitfields
 */

/*!
 * @name Register DMA_TCDn_DOFF, field DOFF[15:0] (RW)
 *
 * Sign-extended offset applied to the current destination address to form the
 * next-state value as each destination write is completed.
 */
/*@{*/
#define BP_DMA_TCDn_DOFF_DOFF (0U)         /*!< Bit position for DMA_TCDn_DOFF_DOFF. */
#define BM_DMA_TCDn_DOFF_DOFF (0xFFFFU)    /*!< Bit mask for DMA_TCDn_DOFF_DOFF. */
#define BS_DMA_TCDn_DOFF_DOFF (16U)        /*!< Bit field size in bits for DMA_TCDn_DOFF_DOFF. */

/*! @brief Read current value of the DMA_TCDn_DOFF_DOFF field. */
#define BR_DMA_TCDn_DOFF_DOFF(x, n) (HW_DMA_TCDn_DOFF(x, n).U)

/*! @brief Format value for bitfield DMA_TCDn_DOFF_DOFF. */
#define BF_DMA_TCDn_DOFF_DOFF(v) ((uint16_t)((uint16_t)(v) << BP_DMA_TCDn_DOFF_DOFF) & BM_DMA_TCDn_DOFF_DOFF)

/*! @brief Set the DOFF field to a new value. */
#define BW_DMA_TCDn_DOFF_DOFF(x, n, v) (HW_DMA_TCDn_DOFF_WR(x, n, v))
/*@}*/
/*******************************************************************************
 * HW_DMA_TCDn_CITER_ELINKNO - TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled)
 ******************************************************************************/

/*!
 * @brief HW_DMA_TCDn_CITER_ELINKNO - TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) (RW)
 *
 * Reset value: 0x0000U
 *
 * If TCDn_CITER[ELINK] is cleared, the TCDn_CITER register is defined as
 * follows.
 */
typedef union _hw_dma_tcdn_citer_elinkno
{
    uint16_t U;
    struct _hw_dma_tcdn_citer_elinkno_bitfields
    {
        uint16_t CITER : 15;           /*!< [14:0] Current Major Iteration Count */
        uint16_t ELINK : 1;            /*!< [15] Enable channel-to-channel linking on
                                        * minor-loop complete */
    } B;
} hw_dma_tcdn_citer_elinkno_t;

/*!
 * @name Constants and macros for entire DMA_TCDn_CITER_ELINKNO register
 */
/*@{*/
#define HW_DMA_TCDn_CITER_ELINKNO_COUNT (16U)

#define HW_DMA_TCDn_CITER_ELINKNO_ADDR(x, n) ((x) + 0x1016U + (0x20U * (n)))

#define HW_DMA_TCDn_CITER_ELINKNO(x, n) (*(__IO hw_dma_tcdn_citer_elinkno_t *) HW_DMA_TCDn_CITER_ELINKNO_ADDR(x, n))
#define HW_DMA_TCDn_CITER_ELINKNO_RD(x, n) (HW_DMA_TCDn_CITER_ELINKNO(x, n).U)
#define HW_DMA_TCDn_CITER_ELINKNO_WR(x, n, v) (HW_DMA_TCDn_CITER_ELINKNO(x, n).U = (v))
#define HW_DMA_TCDn_CITER_ELINKNO_SET(x, n, v) (HW_DMA_TCDn_CITER_ELINKNO_WR(x, n, HW_DMA_TCDn_CITER_ELINKNO_RD(x, n) |  (v)))
#define HW_DMA_TCDn_CITER_ELINKNO_CLR(x, n, v) (HW_DMA_TCDn_CITER_ELINKNO_WR(x, n, HW_DMA_TCDn_CITER_ELINKNO_RD(x, n) & ~(v)))
#define HW_DMA_TCDn_CITER_ELINKNO_TOG(x, n, v) (HW_DMA_TCDn_CITER_ELINKNO_WR(x, n, HW_DMA_TCDn_CITER_ELINKNO_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DMA_TCDn_CITER_ELINKNO bitfields
 */

/*!
 * @name Register DMA_TCDn_CITER_ELINKNO, field CITER[14:0] (RW)
 *
 * This 9-bit (ELINK = 1) or 15-bit (ELINK = 0) count represents the current
 * major loop count for the channel. It is decremented each time the minor loop is
 * completed and updated in the transfer control descriptor memory. After the
 * major iteration count is exhausted, the channel performs a number of operations
 * (e.g., final source and destination address calculations), optionally generating
 * an interrupt to signal channel completion before reloading the CITER field
 * from the beginning iteration count (BITER) field. When the CITER field is
 * initially loaded by software, it must be set to the same value as that contained in
 * the BITER field. If the channel is configured to execute a single service
 * request, the initial values of BITER and CITER should be 0x0001.
 */
/*@{*/
#define BP_DMA_TCDn_CITER_ELINKNO_CITER (0U) /*!< Bit position for DMA_TCDn_CITER_ELINKNO_CITER. */
#define BM_DMA_TCDn_CITER_ELINKNO_CITER (0x7FFFU) /*!< Bit mask for DMA_TCDn_CITER_ELINKNO_CITER. */
#define BS_DMA_TCDn_CITER_ELINKNO_CITER (15U) /*!< Bit field size in bits for DMA_TCDn_CITER_ELINKNO_CITER. */

/*! @brief Read current value of the DMA_TCDn_CITER_ELINKNO_CITER field. */
#define BR_DMA_TCDn_CITER_ELINKNO_CITER(x, n) (HW_DMA_TCDn_CITER_ELINKNO(x, n).B.CITER)

/*! @brief Format value for bitfield DMA_TCDn_CITER_ELINKNO_CITER. */
#define BF_DMA_TCDn_CITER_ELINKNO_CITER(v) ((uint16_t)((uint16_t)(v) << BP_DMA_TCDn_CITER_ELINKNO_CITER) & BM_DMA_TCDn_CITER_ELINKNO_CITER)

/*! @brief Set the CITER field to a new value. */
#define BW_DMA_TCDn_CITER_ELINKNO_CITER(x, n, v) (HW_DMA_TCDn_CITER_ELINKNO_WR(x, n, (HW_DMA_TCDn_CITER_ELINKNO_RD(x, n) & ~BM_DMA_TCDn_CITER_ELINKNO_CITER) | BF_DMA_TCDn_CITER_ELINKNO_CITER(v)))
/*@}*/

/*!
 * @name Register DMA_TCDn_CITER_ELINKNO, field ELINK[15] (RW)
 *
 * As the channel completes the minor loop, this flag enables linking to another
 * channel, defined by the LINKCH field. The link target channel initiates a
 * channel service request via an internal mechanism that sets the TCDn_CSR[START]
 * bit of the specified channel. If channel linking is disabled, the CITER value
 * is extended to 15 bits in place of a link channel number. If the major loop is
 * exhausted, this link mechanism is suppressed in favor of the MAJORELINK
 * channel linking. This bit must be equal to the BITER[ELINK] bit; otherwise, a
 * configuration error is reported.
 *
 * Values:
 * - 0 - The channel-to-channel linking is disabled
 * - 1 - The channel-to-channel linking is enabled
 */
/*@{*/
#define BP_DMA_TCDn_CITER_ELINKNO_ELINK (15U) /*!< Bit position for DMA_TCDn_CITER_ELINKNO_ELINK. */
#define BM_DMA_TCDn_CITER_ELINKNO_ELINK (0x8000U) /*!< Bit mask for DMA_TCDn_CITER_ELINKNO_ELINK. */
#define BS_DMA_TCDn_CITER_ELINKNO_ELINK (1U) /*!< Bit field size in bits for DMA_TCDn_CITER_ELINKNO_ELINK. */

/*! @brief Read current value of the DMA_TCDn_CITER_ELINKNO_ELINK field. */
#define BR_DMA_TCDn_CITER_ELINKNO_ELINK(x, n) (BITBAND_ACCESS16(HW_DMA_TCDn_CITER_ELINKNO_ADDR(x, n), BP_DMA_TCDn_CITER_ELINKNO_ELINK))

/*! @brief Format value for bitfield DMA_TCDn_CITER_ELINKNO_ELINK. */
#define BF_DMA_TCDn_CITER_ELINKNO_ELINK(v) ((uint16_t)((uint16_t)(v) << BP_DMA_TCDn_CITER_ELINKNO_ELINK) & BM_DMA_TCDn_CITER_ELINKNO_ELINK)

/*! @brief Set the ELINK field to a new value. */
#define BW_DMA_TCDn_CITER_ELINKNO_ELINK(x, n, v) (BITBAND_ACCESS16(HW_DMA_TCDn_CITER_ELINKNO_ADDR(x, n), BP_DMA_TCDn_CITER_ELINKNO_ELINK) = (v))
/*@}*/
/*******************************************************************************
 * HW_DMA_TCDn_CITER_ELINKYES - TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled)
 ******************************************************************************/

/*!
 * @brief HW_DMA_TCDn_CITER_ELINKYES - TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) (RW)
 *
 * Reset value: 0x0000U
 *
 * If TCDn_CITER[ELINK] is set, the TCDn_CITER register is defined as follows.
 */
typedef union _hw_dma_tcdn_citer_elinkyes
{
    uint16_t U;
    struct _hw_dma_tcdn_citer_elinkyes_bitfields
    {
        uint16_t CITER : 9;            /*!< [8:0] Current Major Iteration Count */
        uint16_t LINKCH : 4;           /*!< [12:9] Link Channel Number */
        uint16_t RESERVED0 : 2;        /*!< [14:13]  */
        uint16_t ELINK : 1;            /*!< [15] Enable channel-to-channel linking on
                                        * minor-loop complete */
    } B;
} hw_dma_tcdn_citer_elinkyes_t;

/*!
 * @name Constants and macros for entire DMA_TCDn_CITER_ELINKYES register
 */
/*@{*/
#define HW_DMA_TCDn_CITER_ELINKYES_COUNT (16U)

#define HW_DMA_TCDn_CITER_ELINKYES_ADDR(x, n) ((x) + 0x1016U + (0x20U * (n)))

#define HW_DMA_TCDn_CITER_ELINKYES(x, n) (*(__IO hw_dma_tcdn_citer_elinkyes_t *) HW_DMA_TCDn_CITER_ELINKYES_ADDR(x, n))
#define HW_DMA_TCDn_CITER_ELINKYES_RD(x, n) (HW_DMA_TCDn_CITER_ELINKYES(x, n).U)
#define HW_DMA_TCDn_CITER_ELINKYES_WR(x, n, v) (HW_DMA_TCDn_CITER_ELINKYES(x, n).U = (v))
#define HW_DMA_TCDn_CITER_ELINKYES_SET(x, n, v) (HW_DMA_TCDn_CITER_ELINKYES_WR(x, n, HW_DMA_TCDn_CITER_ELINKYES_RD(x, n) |  (v)))
#define HW_DMA_TCDn_CITER_ELINKYES_CLR(x, n, v) (HW_DMA_TCDn_CITER_ELINKYES_WR(x, n, HW_DMA_TCDn_CITER_ELINKYES_RD(x, n) & ~(v)))
#define HW_DMA_TCDn_CITER_ELINKYES_TOG(x, n, v) (HW_DMA_TCDn_CITER_ELINKYES_WR(x, n, HW_DMA_TCDn_CITER_ELINKYES_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DMA_TCDn_CITER_ELINKYES bitfields
 */

/*!
 * @name Register DMA_TCDn_CITER_ELINKYES, field CITER[8:0] (RW)
 *
 * This 9-bit (ELINK = 1) or 15-bit (ELINK = 0) count represents the current
 * major loop count for the channel. It is decremented each time the minor loop is
 * completed and updated in the transfer control descriptor memory. After the
 * major iteration count is exhausted, the channel performs a number of operations
 * (e.g., final source and destination address calculations), optionally generating
 * an interrupt to signal channel completion before reloading the CITER field
 * from the beginning iteration count (BITER) field. When the CITER field is
 * initially loaded by software, it must be set to the same value as that contained in
 * the BITER field. If the channel is configured to execute a single service
 * request, the initial values of BITER and CITER should be 0x0001.
 */
/*@{*/
#define BP_DMA_TCDn_CITER_ELINKYES_CITER (0U) /*!< Bit position for DMA_TCDn_CITER_ELINKYES_CITER. */
#define BM_DMA_TCDn_CITER_ELINKYES_CITER (0x01FFU) /*!< Bit mask for DMA_TCDn_CITER_ELINKYES_CITER. */
#define BS_DMA_TCDn_CITER_ELINKYES_CITER (9U) /*!< Bit field size in bits for DMA_TCDn_CITER_ELINKYES_CITER. */

/*! @brief Read current value of the DMA_TCDn_CITER_ELINKYES_CITER field. */
#define BR_DMA_TCDn_CITER_ELINKYES_CITER(x, n) (HW_DMA_TCDn_CITER_ELINKYES(x, n).B.CITER)

/*! @brief Format value for bitfield DMA_TCDn_CITER_ELINKYES_CITER. */
#define BF_DMA_TCDn_CITER_ELINKYES_CITER(v) ((uint16_t)((uint16_t)(v) << BP_DMA_TCDn_CITER_ELINKYES_CITER) & BM_DMA_TCDn_CITER_ELINKYES_CITER)

/*! @brief Set the CITER field to a new value. */
#define BW_DMA_TCDn_CITER_ELINKYES_CITER(x, n, v) (HW_DMA_TCDn_CITER_ELINKYES_WR(x, n, (HW_DMA_TCDn_CITER_ELINKYES_RD(x, n) & ~BM_DMA_TCDn_CITER_ELINKYES_CITER) | BF_DMA_TCDn_CITER_ELINKYES_CITER(v)))
/*@}*/

/*!
 * @name Register DMA_TCDn_CITER_ELINKYES, field LINKCH[12:9] (RW)
 *
 * If channel-to-channel linking is enabled (ELINK = 1), then after the minor
 * loop is exhausted, the eDMA engine initiates a channel service request to the
 * channel defined by these four bits by setting that channel's TCDn_CSR[START] bit.
 */
/*@{*/
#define BP_DMA_TCDn_CITER_ELINKYES_LINKCH (9U) /*!< Bit position for DMA_TCDn_CITER_ELINKYES_LINKCH. */
#define BM_DMA_TCDn_CITER_ELINKYES_LINKCH (0x1E00U) /*!< Bit mask for DMA_TCDn_CITER_ELINKYES_LINKCH. */
#define BS_DMA_TCDn_CITER_ELINKYES_LINKCH (4U) /*!< Bit field size in bits for DMA_TCDn_CITER_ELINKYES_LINKCH. */

/*! @brief Read current value of the DMA_TCDn_CITER_ELINKYES_LINKCH field. */
#define BR_DMA_TCDn_CITER_ELINKYES_LINKCH(x, n) (HW_DMA_TCDn_CITER_ELINKYES(x, n).B.LINKCH)

/*! @brief Format value for bitfield DMA_TCDn_CITER_ELINKYES_LINKCH. */
#define BF_DMA_TCDn_CITER_ELINKYES_LINKCH(v) ((uint16_t)((uint16_t)(v) << BP_DMA_TCDn_CITER_ELINKYES_LINKCH) & BM_DMA_TCDn_CITER_ELINKYES_LINKCH)

/*! @brief Set the LINKCH field to a new value. */
#define BW_DMA_TCDn_CITER_ELINKYES_LINKCH(x, n, v) (HW_DMA_TCDn_CITER_ELINKYES_WR(x, n, (HW_DMA_TCDn_CITER_ELINKYES_RD(x, n) & ~BM_DMA_TCDn_CITER_ELINKYES_LINKCH) | BF_DMA_TCDn_CITER_ELINKYES_LINKCH(v)))
/*@}*/

/*!
 * @name Register DMA_TCDn_CITER_ELINKYES, field ELINK[15] (RW)
 *
 * As the channel completes the minor loop, this flag enables linking to another
 * channel, defined by the LINKCH field. The link target channel initiates a
 * channel service request via an internal mechanism that sets the TCDn_CSR[START]
 * bit of the specified channel. If channel linking is disabled, the CITER value
 * is extended to 15 bits in place of a link channel number. If the major loop is
 * exhausted, this link mechanism is suppressed in favor of the MAJORELINK
 * channel linking. This bit must be equal to the BITER[ELINK] bit; otherwise, a
 * configuration error is reported.
 *
 * Values:
 * - 0 - The channel-to-channel linking is disabled
 * - 1 - The channel-to-channel linking is enabled
 */
/*@{*/
#define BP_DMA_TCDn_CITER_ELINKYES_ELINK (15U) /*!< Bit position for DMA_TCDn_CITER_ELINKYES_ELINK. */
#define BM_DMA_TCDn_CITER_ELINKYES_ELINK (0x8000U) /*!< Bit mask for DMA_TCDn_CITER_ELINKYES_ELINK. */
#define BS_DMA_TCDn_CITER_ELINKYES_ELINK (1U) /*!< Bit field size in bits for DMA_TCDn_CITER_ELINKYES_ELINK. */

/*! @brief Read current value of the DMA_TCDn_CITER_ELINKYES_ELINK field. */
#define BR_DMA_TCDn_CITER_ELINKYES_ELINK(x, n) (BITBAND_ACCESS16(HW_DMA_TCDn_CITER_ELINKYES_ADDR(x, n), BP_DMA_TCDn_CITER_ELINKYES_ELINK))

/*! @brief Format value for bitfield DMA_TCDn_CITER_ELINKYES_ELINK. */
#define BF_DMA_TCDn_CITER_ELINKYES_ELINK(v) ((uint16_t)((uint16_t)(v) << BP_DMA_TCDn_CITER_ELINKYES_ELINK) & BM_DMA_TCDn_CITER_ELINKYES_ELINK)

/*! @brief Set the ELINK field to a new value. */
#define BW_DMA_TCDn_CITER_ELINKYES_ELINK(x, n, v) (BITBAND_ACCESS16(HW_DMA_TCDn_CITER_ELINKYES_ADDR(x, n), BP_DMA_TCDn_CITER_ELINKYES_ELINK) = (v))
/*@}*/
/*******************************************************************************
 * HW_DMA_TCDn_DLASTSGA - TCD Last Destination Address Adjustment/Scatter Gather Address
 ******************************************************************************/

/*!
 * @brief HW_DMA_TCDn_DLASTSGA - TCD Last Destination Address Adjustment/Scatter Gather Address (RW)
 *
 * Reset value: 0x00000000U
 */
typedef union _hw_dma_tcdn_dlastsga
{
    uint32_t U;
    struct _hw_dma_tcdn_dlastsga_bitfields
    {
        uint32_t DLASTSGA : 32;        /*!< [31:0]  */
    } B;
} hw_dma_tcdn_dlastsga_t;

/*!
 * @name Constants and macros for entire DMA_TCDn_DLASTSGA register
 */
/*@{*/
#define HW_DMA_TCDn_DLASTSGA_COUNT (16U)

#define HW_DMA_TCDn_DLASTSGA_ADDR(x, n) ((x) + 0x1018U + (0x20U * (n)))

#define HW_DMA_TCDn_DLASTSGA(x, n) (*(__IO hw_dma_tcdn_dlastsga_t *) HW_DMA_TCDn_DLASTSGA_ADDR(x, n))
#define HW_DMA_TCDn_DLASTSGA_RD(x, n) (HW_DMA_TCDn_DLASTSGA(x, n).U)
#define HW_DMA_TCDn_DLASTSGA_WR(x, n, v) (HW_DMA_TCDn_DLASTSGA(x, n).U = (v))
#define HW_DMA_TCDn_DLASTSGA_SET(x, n, v) (HW_DMA_TCDn_DLASTSGA_WR(x, n, HW_DMA_TCDn_DLASTSGA_RD(x, n) |  (v)))
#define HW_DMA_TCDn_DLASTSGA_CLR(x, n, v) (HW_DMA_TCDn_DLASTSGA_WR(x, n, HW_DMA_TCDn_DLASTSGA_RD(x, n) & ~(v)))
#define HW_DMA_TCDn_DLASTSGA_TOG(x, n, v) (HW_DMA_TCDn_DLASTSGA_WR(x, n, HW_DMA_TCDn_DLASTSGA_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DMA_TCDn_DLASTSGA bitfields
 */

/*!
 * @name Register DMA_TCDn_DLASTSGA, field DLASTSGA[31:0] (RW)
 *
 * Destination last address adjustment or the memory address for the next
 * transfer control descriptor to be loaded into this channel (scatter/gather). If
 * (TCDn_CSR[ESG] = 0), then: Adjustment value added to the destination address at
 * the completion of the major iteration count. This value can apply to restore the
 * destination address to the initial value or adjust the address to reference
 * the next data structure. This field uses two's complement notation for the
 * final destination address adjustment. Otherwise: This address points to the
 * beginning of a 0-modulo-32-byte region containing the next transfer control
 * descriptor to be loaded into this channel. This channel reload is performed as the
 * major iteration count completes. The scatter/gather address must be
 * 0-modulo-32-byte, else a configuration error is reported.
 */
/*@{*/
#define BP_DMA_TCDn_DLASTSGA_DLASTSGA (0U) /*!< Bit position for DMA_TCDn_DLASTSGA_DLASTSGA. */
#define BM_DMA_TCDn_DLASTSGA_DLASTSGA (0xFFFFFFFFU) /*!< Bit mask for DMA_TCDn_DLASTSGA_DLASTSGA. */
#define BS_DMA_TCDn_DLASTSGA_DLASTSGA (32U) /*!< Bit field size in bits for DMA_TCDn_DLASTSGA_DLASTSGA. */

/*! @brief Read current value of the DMA_TCDn_DLASTSGA_DLASTSGA field. */
#define BR_DMA_TCDn_DLASTSGA_DLASTSGA(x, n) (HW_DMA_TCDn_DLASTSGA(x, n).U)

/*! @brief Format value for bitfield DMA_TCDn_DLASTSGA_DLASTSGA. */
#define BF_DMA_TCDn_DLASTSGA_DLASTSGA(v) ((uint32_t)((uint32_t)(v) << BP_DMA_TCDn_DLASTSGA_DLASTSGA) & BM_DMA_TCDn_DLASTSGA_DLASTSGA)

/*! @brief Set the DLASTSGA field to a new value. */
#define BW_DMA_TCDn_DLASTSGA_DLASTSGA(x, n, v) (HW_DMA_TCDn_DLASTSGA_WR(x, n, v))
/*@}*/
/*******************************************************************************
 * HW_DMA_TCDn_CSR - TCD Control and Status
 ******************************************************************************/

/*!
 * @brief HW_DMA_TCDn_CSR - TCD Control and Status (RW)
 *
 * Reset value: 0x0000U
 */
typedef union _hw_dma_tcdn_csr
{
    uint16_t U;
    struct _hw_dma_tcdn_csr_bitfields
    {
        uint16_t START : 1;            /*!< [0] Channel Start */
        uint16_t INTMAJOR : 1;         /*!< [1] Enable an interrupt when major
                                        * iteration count completes */
        uint16_t INTHALF : 1;          /*!< [2] Enable an interrupt when major counter
                                        * is half complete. */
        uint16_t DREQ : 1;             /*!< [3] Disable Request */
        uint16_t ESG : 1;              /*!< [4] Enable Scatter/Gather Processing */
        uint16_t MAJORELINK : 1;       /*!< [5] Enable channel-to-channel linking
                                        * on major loop complete */
        uint16_t ACTIVE : 1;           /*!< [6] Channel Active */
        uint16_t DONE : 1;             /*!< [7] Channel Done */
        uint16_t MAJORLINKCH : 4;      /*!< [11:8] Link Channel Number */
        uint16_t RESERVED0 : 2;        /*!< [13:12]  */
        uint16_t BWC : 2;              /*!< [15:14] Bandwidth Control */
    } B;
} hw_dma_tcdn_csr_t;

/*!
 * @name Constants and macros for entire DMA_TCDn_CSR register
 */
/*@{*/
#define HW_DMA_TCDn_CSR_COUNT (16U)

#define HW_DMA_TCDn_CSR_ADDR(x, n) ((x) + 0x101CU + (0x20U * (n)))

#define HW_DMA_TCDn_CSR(x, n)    (*(__IO hw_dma_tcdn_csr_t *) HW_DMA_TCDn_CSR_ADDR(x, n))
#define HW_DMA_TCDn_CSR_RD(x, n) (HW_DMA_TCDn_CSR(x, n).U)
#define HW_DMA_TCDn_CSR_WR(x, n, v) (HW_DMA_TCDn_CSR(x, n).U = (v))
#define HW_DMA_TCDn_CSR_SET(x, n, v) (HW_DMA_TCDn_CSR_WR(x, n, HW_DMA_TCDn_CSR_RD(x, n) |  (v)))
#define HW_DMA_TCDn_CSR_CLR(x, n, v) (HW_DMA_TCDn_CSR_WR(x, n, HW_DMA_TCDn_CSR_RD(x, n) & ~(v)))
#define HW_DMA_TCDn_CSR_TOG(x, n, v) (HW_DMA_TCDn_CSR_WR(x, n, HW_DMA_TCDn_CSR_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DMA_TCDn_CSR bitfields
 */

/*!
 * @name Register DMA_TCDn_CSR, field START[0] (RW)
 *
 * If this flag is set, the channel is requesting service. The eDMA hardware
 * automatically clears this flag after the channel begins execution.
 *
 * Values:
 * - 0 - The channel is not explicitly started
 * - 1 - The channel is explicitly started via a software initiated service
 *     request
 */
/*@{*/
#define BP_DMA_TCDn_CSR_START (0U)         /*!< Bit position for DMA_TCDn_CSR_START. */
#define BM_DMA_TCDn_CSR_START (0x0001U)    /*!< Bit mask for DMA_TCDn_CSR_START. */
#define BS_DMA_TCDn_CSR_START (1U)         /*!< Bit field size in bits for DMA_TCDn_CSR_START. */

/*! @brief Read current value of the DMA_TCDn_CSR_START field. */
#define BR_DMA_TCDn_CSR_START(x, n) (BITBAND_ACCESS16(HW_DMA_TCDn_CSR_ADDR(x, n), BP_DMA_TCDn_CSR_START))

/*! @brief Format value for bitfield DMA_TCDn_CSR_START. */
#define BF_DMA_TCDn_CSR_START(v) ((uint16_t)((uint16_t)(v) << BP_DMA_TCDn_CSR_START) & BM_DMA_TCDn_CSR_START)

/*! @brief Set the START field to a new value. */
#define BW_DMA_TCDn_CSR_START(x, n, v) (BITBAND_ACCESS16(HW_DMA_TCDn_CSR_ADDR(x, n), BP_DMA_TCDn_CSR_START) = (v))
/*@}*/

/*!
 * @name Register DMA_TCDn_CSR, field INTMAJOR[1] (RW)
 *
 * If this flag is set, the channel generates an interrupt request by setting
 * the appropriate bit in the INT when the current major iteration count reaches
 * zero.
 *
 * Values:
 * - 0 - The end-of-major loop interrupt is disabled
 * - 1 - The end-of-major loop interrupt is enabled
 */
/*@{*/
#define BP_DMA_TCDn_CSR_INTMAJOR (1U)      /*!< Bit position for DMA_TCDn_CSR_INTMAJOR. */
#define BM_DMA_TCDn_CSR_INTMAJOR (0x0002U) /*!< Bit mask for DMA_TCDn_CSR_INTMAJOR. */
#define BS_DMA_TCDn_CSR_INTMAJOR (1U)      /*!< Bit field size in bits for DMA_TCDn_CSR_INTMAJOR. */

/*! @brief Read current value of the DMA_TCDn_CSR_INTMAJOR field. */
#define BR_DMA_TCDn_CSR_INTMAJOR(x, n) (BITBAND_ACCESS16(HW_DMA_TCDn_CSR_ADDR(x, n), BP_DMA_TCDn_CSR_INTMAJOR))

/*! @brief Format value for bitfield DMA_TCDn_CSR_INTMAJOR. */
#define BF_DMA_TCDn_CSR_INTMAJOR(v) ((uint16_t)((uint16_t)(v) << BP_DMA_TCDn_CSR_INTMAJOR) & BM_DMA_TCDn_CSR_INTMAJOR)

/*! @brief Set the INTMAJOR field to a new value. */
#define BW_DMA_TCDn_CSR_INTMAJOR(x, n, v) (BITBAND_ACCESS16(HW_DMA_TCDn_CSR_ADDR(x, n), BP_DMA_TCDn_CSR_INTMAJOR) = (v))
/*@}*/

/*!
 * @name Register DMA_TCDn_CSR, field INTHALF[2] (RW)
 *
 * If this flag is set, the channel generates an interrupt request by setting
 * the appropriate bit in the INT register when the current major iteration count
 * reaches the halfway point. Specifically, the comparison performed by the eDMA
 * engine is (CITER == (BITER >> 1)). This halfway point interrupt request is
 * provided to support double-buffered (aka ping-pong) schemes or other types of data
 * movement where the processor needs an early indication of the transfer's
 * progress. If BITER is set, do not use INTHALF. Use INTMAJOR instead.
 *
 * Values:
 * - 0 - The half-point interrupt is disabled
 * - 1 - The half-point interrupt is enabled
 */
/*@{*/
#define BP_DMA_TCDn_CSR_INTHALF (2U)       /*!< Bit position for DMA_TCDn_CSR_INTHALF. */
#define BM_DMA_TCDn_CSR_INTHALF (0x0004U)  /*!< Bit mask for DMA_TCDn_CSR_INTHALF. */
#define BS_DMA_TCDn_CSR_INTHALF (1U)       /*!< Bit field size in bits for DMA_TCDn_CSR_INTHALF. */

/*! @brief Read current value of the DMA_TCDn_CSR_INTHALF field. */
#define BR_DMA_TCDn_CSR_INTHALF(x, n) (BITBAND_ACCESS16(HW_DMA_TCDn_CSR_ADDR(x, n), BP_DMA_TCDn_CSR_INTHALF))

/*! @brief Format value for bitfield DMA_TCDn_CSR_INTHALF. */
#define BF_DMA_TCDn_CSR_INTHALF(v) ((uint16_t)((uint16_t)(v) << BP_DMA_TCDn_CSR_INTHALF) & BM_DMA_TCDn_CSR_INTHALF)

/*! @brief Set the INTHALF field to a new value. */
#define BW_DMA_TCDn_CSR_INTHALF(x, n, v) (BITBAND_ACCESS16(HW_DMA_TCDn_CSR_ADDR(x, n), BP_DMA_TCDn_CSR_INTHALF) = (v))
/*@}*/

/*!
 * @name Register DMA_TCDn_CSR, field DREQ[3] (RW)
 *
 * If this flag is set, the eDMA hardware automatically clears the corresponding
 * ERQ bit when the current major iteration count reaches zero.
 *
 * Values:
 * - 0 - The channel's ERQ bit is not affected
 * - 1 - The channel's ERQ bit is cleared when the major loop is complete
 */
/*@{*/
#define BP_DMA_TCDn_CSR_DREQ (3U)          /*!< Bit position for DMA_TCDn_CSR_DREQ. */
#define BM_DMA_TCDn_CSR_DREQ (0x0008U)     /*!< Bit mask for DMA_TCDn_CSR_DREQ. */
#define BS_DMA_TCDn_CSR_DREQ (1U)          /*!< Bit field size in bits for DMA_TCDn_CSR_DREQ. */

/*! @brief Read current value of the DMA_TCDn_CSR_DREQ field. */
#define BR_DMA_TCDn_CSR_DREQ(x, n) (BITBAND_ACCESS16(HW_DMA_TCDn_CSR_ADDR(x, n), BP_DMA_TCDn_CSR_DREQ))

/*! @brief Format value for bitfield DMA_TCDn_CSR_DREQ. */
#define BF_DMA_TCDn_CSR_DREQ(v) ((uint16_t)((uint16_t)(v) << BP_DMA_TCDn_CSR_DREQ) & BM_DMA_TCDn_CSR_DREQ)

/*! @brief Set the DREQ field to a new value. */
#define BW_DMA_TCDn_CSR_DREQ(x, n, v) (BITBAND_ACCESS16(HW_DMA_TCDn_CSR_ADDR(x, n), BP_DMA_TCDn_CSR_DREQ) = (v))
/*@}*/

/*!
 * @name Register DMA_TCDn_CSR, field ESG[4] (RW)
 *
 * As the channel completes the major loop, this flag enables scatter/gather
 * processing in the current channel. If enabled, the eDMA engine uses DLASTSGA as a
 * memory pointer to a 0-modulo-32 address containing a 32-byte data structure
 * loaded as the transfer control descriptor into the local memory. To support the
 * dynamic scatter/gather coherency model, this field is forced to zero when
 * written to while the TCDn_CSR[DONE] bit is set.
 *
 * Values:
 * - 0 - The current channel's TCD is normal format.
 * - 1 - The current channel's TCD specifies a scatter gather format. The
 *     DLASTSGA field provides a memory pointer to the next TCD to be loaded into this
 *     channel after the major loop completes its execution.
 */
/*@{*/
#define BP_DMA_TCDn_CSR_ESG  (4U)          /*!< Bit position for DMA_TCDn_CSR_ESG. */
#define BM_DMA_TCDn_CSR_ESG  (0x0010U)     /*!< Bit mask for DMA_TCDn_CSR_ESG. */
#define BS_DMA_TCDn_CSR_ESG  (1U)          /*!< Bit field size in bits for DMA_TCDn_CSR_ESG. */

/*! @brief Read current value of the DMA_TCDn_CSR_ESG field. */
#define BR_DMA_TCDn_CSR_ESG(x, n) (BITBAND_ACCESS16(HW_DMA_TCDn_CSR_ADDR(x, n), BP_DMA_TCDn_CSR_ESG))

/*! @brief Format value for bitfield DMA_TCDn_CSR_ESG. */
#define BF_DMA_TCDn_CSR_ESG(v) ((uint16_t)((uint16_t)(v) << BP_DMA_TCDn_CSR_ESG) & BM_DMA_TCDn_CSR_ESG)

/*! @brief Set the ESG field to a new value. */
#define BW_DMA_TCDn_CSR_ESG(x, n, v) (BITBAND_ACCESS16(HW_DMA_TCDn_CSR_ADDR(x, n), BP_DMA_TCDn_CSR_ESG) = (v))
/*@}*/

/*!
 * @name Register DMA_TCDn_CSR, field MAJORELINK[5] (RW)
 *
 * As the channel completes the major loop, this flag enables the linking to
 * another channel, defined by MAJORLINKCH. The link target channel initiates a
 * channel service request via an internal mechanism that sets the TCDn_CSR[START]
 * bit of the specified channel. To support the dynamic linking coherency model,
 * this field is forced to zero when written to while the TCDn_CSR[DONE] bit is set.
 *
 * Values:
 * - 0 - The channel-to-channel linking is disabled
 * - 1 - The channel-to-channel linking is enabled
 */
/*@{*/
#define BP_DMA_TCDn_CSR_MAJORELINK (5U)    /*!< Bit position for DMA_TCDn_CSR_MAJORELINK. */
#define BM_DMA_TCDn_CSR_MAJORELINK (0x0020U) /*!< Bit mask for DMA_TCDn_CSR_MAJORELINK. */
#define BS_DMA_TCDn_CSR_MAJORELINK (1U)    /*!< Bit field size in bits for DMA_TCDn_CSR_MAJORELINK. */

/*! @brief Read current value of the DMA_TCDn_CSR_MAJORELINK field. */
#define BR_DMA_TCDn_CSR_MAJORELINK(x, n) (BITBAND_ACCESS16(HW_DMA_TCDn_CSR_ADDR(x, n), BP_DMA_TCDn_CSR_MAJORELINK))

/*! @brief Format value for bitfield DMA_TCDn_CSR_MAJORELINK. */
#define BF_DMA_TCDn_CSR_MAJORELINK(v) ((uint16_t)((uint16_t)(v) << BP_DMA_TCDn_CSR_MAJORELINK) & BM_DMA_TCDn_CSR_MAJORELINK)

/*! @brief Set the MAJORELINK field to a new value. */
#define BW_DMA_TCDn_CSR_MAJORELINK(x, n, v) (BITBAND_ACCESS16(HW_DMA_TCDn_CSR_ADDR(x, n), BP_DMA_TCDn_CSR_MAJORELINK) = (v))
/*@}*/

/*!
 * @name Register DMA_TCDn_CSR, field ACTIVE[6] (RW)
 *
 * This flag signals the channel is currently in execution. It is set when
 * channel service begins, and the eDMA clears it as the minor loop completes or if
 * any error condition is detected. This bit resets to zero.
 */
/*@{*/
#define BP_DMA_TCDn_CSR_ACTIVE (6U)        /*!< Bit position for DMA_TCDn_CSR_ACTIVE. */
#define BM_DMA_TCDn_CSR_ACTIVE (0x0040U)   /*!< Bit mask for DMA_TCDn_CSR_ACTIVE. */
#define BS_DMA_TCDn_CSR_ACTIVE (1U)        /*!< Bit field size in bits for DMA_TCDn_CSR_ACTIVE. */

/*! @brief Read current value of the DMA_TCDn_CSR_ACTIVE field. */
#define BR_DMA_TCDn_CSR_ACTIVE(x, n) (BITBAND_ACCESS16(HW_DMA_TCDn_CSR_ADDR(x, n), BP_DMA_TCDn_CSR_ACTIVE))

/*! @brief Format value for bitfield DMA_TCDn_CSR_ACTIVE. */
#define BF_DMA_TCDn_CSR_ACTIVE(v) ((uint16_t)((uint16_t)(v) << BP_DMA_TCDn_CSR_ACTIVE) & BM_DMA_TCDn_CSR_ACTIVE)

/*! @brief Set the ACTIVE field to a new value. */
#define BW_DMA_TCDn_CSR_ACTIVE(x, n, v) (BITBAND_ACCESS16(HW_DMA_TCDn_CSR_ADDR(x, n), BP_DMA_TCDn_CSR_ACTIVE) = (v))
/*@}*/

/*!
 * @name Register DMA_TCDn_CSR, field DONE[7] (RW)
 *
 * This flag indicates the eDMA has completed the major loop. The eDMA engine
 * sets it as the CITER count reaches zero; The software clears it, or the hardware
 * when the channel is activated. This bit must be cleared to write the
 * MAJORELINK or ESG bits.
 */
/*@{*/
#define BP_DMA_TCDn_CSR_DONE (7U)          /*!< Bit position for DMA_TCDn_CSR_DONE. */
#define BM_DMA_TCDn_CSR_DONE (0x0080U)     /*!< Bit mask for DMA_TCDn_CSR_DONE. */
#define BS_DMA_TCDn_CSR_DONE (1U)          /*!< Bit field size in bits for DMA_TCDn_CSR_DONE. */

/*! @brief Read current value of the DMA_TCDn_CSR_DONE field. */
#define BR_DMA_TCDn_CSR_DONE(x, n) (BITBAND_ACCESS16(HW_DMA_TCDn_CSR_ADDR(x, n), BP_DMA_TCDn_CSR_DONE))

/*! @brief Format value for bitfield DMA_TCDn_CSR_DONE. */
#define BF_DMA_TCDn_CSR_DONE(v) ((uint16_t)((uint16_t)(v) << BP_DMA_TCDn_CSR_DONE) & BM_DMA_TCDn_CSR_DONE)

/*! @brief Set the DONE field to a new value. */
#define BW_DMA_TCDn_CSR_DONE(x, n, v) (BITBAND_ACCESS16(HW_DMA_TCDn_CSR_ADDR(x, n), BP_DMA_TCDn_CSR_DONE) = (v))
/*@}*/

/*!
 * @name Register DMA_TCDn_CSR, field MAJORLINKCH[11:8] (RW)
 *
 * If (MAJORELINK = 0) then No channel-to-channel linking (or chaining) is
 * performed after the major loop counter is exhausted. else After the major loop
 * counter is exhausted, the eDMA engine initiates a channel service request at the
 * channel defined by these six bits by setting that channel's TCDn_CSR[START] bit.
 */
/*@{*/
#define BP_DMA_TCDn_CSR_MAJORLINKCH (8U)   /*!< Bit position for DMA_TCDn_CSR_MAJORLINKCH. */
#define BM_DMA_TCDn_CSR_MAJORLINKCH (0x0F00U) /*!< Bit mask for DMA_TCDn_CSR_MAJORLINKCH. */
#define BS_DMA_TCDn_CSR_MAJORLINKCH (4U)   /*!< Bit field size in bits for DMA_TCDn_CSR_MAJORLINKCH. */

/*! @brief Read current value of the DMA_TCDn_CSR_MAJORLINKCH field. */
#define BR_DMA_TCDn_CSR_MAJORLINKCH(x, n) (HW_DMA_TCDn_CSR(x, n).B.MAJORLINKCH)

/*! @brief Format value for bitfield DMA_TCDn_CSR_MAJORLINKCH. */
#define BF_DMA_TCDn_CSR_MAJORLINKCH(v) ((uint16_t)((uint16_t)(v) << BP_DMA_TCDn_CSR_MAJORLINKCH) & BM_DMA_TCDn_CSR_MAJORLINKCH)

/*! @brief Set the MAJORLINKCH field to a new value. */
#define BW_DMA_TCDn_CSR_MAJORLINKCH(x, n, v) (HW_DMA_TCDn_CSR_WR(x, n, (HW_DMA_TCDn_CSR_RD(x, n) & ~BM_DMA_TCDn_CSR_MAJORLINKCH) | BF_DMA_TCDn_CSR_MAJORLINKCH(v)))
/*@}*/

/*!
 * @name Register DMA_TCDn_CSR, field BWC[15:14] (RW)
 *
 * Throttles the amount of bus bandwidth consumed by the eDMA. In general, as
 * the eDMA processes the minor loop, it continuously generates read/write
 * sequences until the minor count is exhausted. This field forces the eDMA to stall
 * after the completion of each read/write access to control the bus request
 * bandwidth seen by the crossbar switch. If the source and destination sizes are equal,
 * this field is ignored between the first and second transfers and after the
 * last write of each minor loop. This behavior is a side effect of reducing
 * start-up latency.
 *
 * Values:
 * - 00 - No eDMA engine stalls
 * - 01 - Reserved
 * - 10 - eDMA engine stalls for 4 cycles after each r/w
 * - 11 - eDMA engine stalls for 8 cycles after each r/w
 */
/*@{*/
#define BP_DMA_TCDn_CSR_BWC  (14U)         /*!< Bit position for DMA_TCDn_CSR_BWC. */
#define BM_DMA_TCDn_CSR_BWC  (0xC000U)     /*!< Bit mask for DMA_TCDn_CSR_BWC. */
#define BS_DMA_TCDn_CSR_BWC  (2U)          /*!< Bit field size in bits for DMA_TCDn_CSR_BWC. */

/*! @brief Read current value of the DMA_TCDn_CSR_BWC field. */
#define BR_DMA_TCDn_CSR_BWC(x, n) (HW_DMA_TCDn_CSR(x, n).B.BWC)

/*! @brief Format value for bitfield DMA_TCDn_CSR_BWC. */
#define BF_DMA_TCDn_CSR_BWC(v) ((uint16_t)((uint16_t)(v) << BP_DMA_TCDn_CSR_BWC) & BM_DMA_TCDn_CSR_BWC)

/*! @brief Set the BWC field to a new value. */
#define BW_DMA_TCDn_CSR_BWC(x, n, v) (HW_DMA_TCDn_CSR_WR(x, n, (HW_DMA_TCDn_CSR_RD(x, n) & ~BM_DMA_TCDn_CSR_BWC) | BF_DMA_TCDn_CSR_BWC(v)))
/*@}*/
/*******************************************************************************
 * HW_DMA_TCDn_BITER_ELINKNO - TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled)
 ******************************************************************************/

/*!
 * @brief HW_DMA_TCDn_BITER_ELINKNO - TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) (RW)
 *
 * Reset value: 0x0000U
 *
 * If the TCDn_BITER[ELINK] bit is cleared, the TCDn_BITER register is defined
 * as follows.
 */
typedef union _hw_dma_tcdn_biter_elinkno
{
    uint16_t U;
    struct _hw_dma_tcdn_biter_elinkno_bitfields
    {
        uint16_t BITER : 15;           /*!< [14:0] Starting Major Iteration Count */
        uint16_t ELINK : 1;            /*!< [15] Enables channel-to-channel linking on
                                        * minor loop complete */
    } B;
} hw_dma_tcdn_biter_elinkno_t;

/*!
 * @name Constants and macros for entire DMA_TCDn_BITER_ELINKNO register
 */
/*@{*/
#define HW_DMA_TCDn_BITER_ELINKNO_COUNT (16U)

#define HW_DMA_TCDn_BITER_ELINKNO_ADDR(x, n) ((x) + 0x101EU + (0x20U * (n)))

#define HW_DMA_TCDn_BITER_ELINKNO(x, n) (*(__IO hw_dma_tcdn_biter_elinkno_t *) HW_DMA_TCDn_BITER_ELINKNO_ADDR(x, n))
#define HW_DMA_TCDn_BITER_ELINKNO_RD(x, n) (HW_DMA_TCDn_BITER_ELINKNO(x, n).U)
#define HW_DMA_TCDn_BITER_ELINKNO_WR(x, n, v) (HW_DMA_TCDn_BITER_ELINKNO(x, n).U = (v))
#define HW_DMA_TCDn_BITER_ELINKNO_SET(x, n, v) (HW_DMA_TCDn_BITER_ELINKNO_WR(x, n, HW_DMA_TCDn_BITER_ELINKNO_RD(x, n) |  (v)))
#define HW_DMA_TCDn_BITER_ELINKNO_CLR(x, n, v) (HW_DMA_TCDn_BITER_ELINKNO_WR(x, n, HW_DMA_TCDn_BITER_ELINKNO_RD(x, n) & ~(v)))
#define HW_DMA_TCDn_BITER_ELINKNO_TOG(x, n, v) (HW_DMA_TCDn_BITER_ELINKNO_WR(x, n, HW_DMA_TCDn_BITER_ELINKNO_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DMA_TCDn_BITER_ELINKNO bitfields
 */

/*!
 * @name Register DMA_TCDn_BITER_ELINKNO, field BITER[14:0] (RW)
 *
 * As the transfer control descriptor is first loaded by software, this 9-bit
 * (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the value in the CITER
 * field. As the major iteration count is exhausted, the contents of this field
 * are reloaded into the CITER field. When the software loads the TCD, this field
 * must be set equal to the corresponding CITER field; otherwise, a configuration
 * error is reported. As the major iteration count is exhausted, the contents of
 * this field is reloaded into the CITER field. If the channel is configured to
 * execute a single service request, the initial values of BITER and CITER should
 * be 0x0001.
 */
/*@{*/
#define BP_DMA_TCDn_BITER_ELINKNO_BITER (0U) /*!< Bit position for DMA_TCDn_BITER_ELINKNO_BITER. */
#define BM_DMA_TCDn_BITER_ELINKNO_BITER (0x7FFFU) /*!< Bit mask for DMA_TCDn_BITER_ELINKNO_BITER. */
#define BS_DMA_TCDn_BITER_ELINKNO_BITER (15U) /*!< Bit field size in bits for DMA_TCDn_BITER_ELINKNO_BITER. */

/*! @brief Read current value of the DMA_TCDn_BITER_ELINKNO_BITER field. */
#define BR_DMA_TCDn_BITER_ELINKNO_BITER(x, n) (HW_DMA_TCDn_BITER_ELINKNO(x, n).B.BITER)

/*! @brief Format value for bitfield DMA_TCDn_BITER_ELINKNO_BITER. */
#define BF_DMA_TCDn_BITER_ELINKNO_BITER(v) ((uint16_t)((uint16_t)(v) << BP_DMA_TCDn_BITER_ELINKNO_BITER) & BM_DMA_TCDn_BITER_ELINKNO_BITER)

/*! @brief Set the BITER field to a new value. */
#define BW_DMA_TCDn_BITER_ELINKNO_BITER(x, n, v) (HW_DMA_TCDn_BITER_ELINKNO_WR(x, n, (HW_DMA_TCDn_BITER_ELINKNO_RD(x, n) & ~BM_DMA_TCDn_BITER_ELINKNO_BITER) | BF_DMA_TCDn_BITER_ELINKNO_BITER(v)))
/*@}*/

/*!
 * @name Register DMA_TCDn_BITER_ELINKNO, field ELINK[15] (RW)
 *
 * As the channel completes the minor loop, this flag enables the linking to
 * another channel, defined by BITER[LINKCH]. The link target channel initiates a
 * channel service request via an internal mechanism that sets the TCDn_CSR[START]
 * bit of the specified channel. If channel linking is disabled, the BITER value
 * extends to 15 bits in place of a link channel number. If the major loop is
 * exhausted, this link mechanism is suppressed in favor of the MAJORELINK channel
 * linking. When the software loads the TCD, this field must be set equal to the
 * corresponding CITER field; otherwise, a configuration error is reported. As the
 * major iteration count is exhausted, the contents of this field is reloaded
 * into the CITER field.
 *
 * Values:
 * - 0 - The channel-to-channel linking is disabled
 * - 1 - The channel-to-channel linking is enabled
 */
/*@{*/
#define BP_DMA_TCDn_BITER_ELINKNO_ELINK (15U) /*!< Bit position for DMA_TCDn_BITER_ELINKNO_ELINK. */
#define BM_DMA_TCDn_BITER_ELINKNO_ELINK (0x8000U) /*!< Bit mask for DMA_TCDn_BITER_ELINKNO_ELINK. */
#define BS_DMA_TCDn_BITER_ELINKNO_ELINK (1U) /*!< Bit field size in bits for DMA_TCDn_BITER_ELINKNO_ELINK. */

/*! @brief Read current value of the DMA_TCDn_BITER_ELINKNO_ELINK field. */
#define BR_DMA_TCDn_BITER_ELINKNO_ELINK(x, n) (BITBAND_ACCESS16(HW_DMA_TCDn_BITER_ELINKNO_ADDR(x, n), BP_DMA_TCDn_BITER_ELINKNO_ELINK))

/*! @brief Format value for bitfield DMA_TCDn_BITER_ELINKNO_ELINK. */
#define BF_DMA_TCDn_BITER_ELINKNO_ELINK(v) ((uint16_t)((uint16_t)(v) << BP_DMA_TCDn_BITER_ELINKNO_ELINK) & BM_DMA_TCDn_BITER_ELINKNO_ELINK)

/*! @brief Set the ELINK field to a new value. */
#define BW_DMA_TCDn_BITER_ELINKNO_ELINK(x, n, v) (BITBAND_ACCESS16(HW_DMA_TCDn_BITER_ELINKNO_ADDR(x, n), BP_DMA_TCDn_BITER_ELINKNO_ELINK) = (v))
/*@}*/
/*******************************************************************************
 * HW_DMA_TCDn_BITER_ELINKYES - TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled)
 ******************************************************************************/

/*!
 * @brief HW_DMA_TCDn_BITER_ELINKYES - TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) (RW)
 *
 * Reset value: 0x0000U
 *
 * If the TCDn_BITER[ELINK] bit is set, the TCDn_BITER register is defined as
 * follows.
 */
typedef union _hw_dma_tcdn_biter_elinkyes
{
    uint16_t U;
    struct _hw_dma_tcdn_biter_elinkyes_bitfields
    {
        uint16_t BITER : 9;            /*!< [8:0] Starting Major Iteration Count */
        uint16_t LINKCH : 4;           /*!< [12:9] Link Channel Number */
        uint16_t RESERVED0 : 2;        /*!< [14:13]  */
        uint16_t ELINK : 1;            /*!< [15] Enables channel-to-channel linking on
                                        * minor loop complete */
    } B;
} hw_dma_tcdn_biter_elinkyes_t;

/*!
 * @name Constants and macros for entire DMA_TCDn_BITER_ELINKYES register
 */
/*@{*/
#define HW_DMA_TCDn_BITER_ELINKYES_COUNT (16U)

#define HW_DMA_TCDn_BITER_ELINKYES_ADDR(x, n) ((x) + 0x101EU + (0x20U * (n)))

#define HW_DMA_TCDn_BITER_ELINKYES(x, n) (*(__IO hw_dma_tcdn_biter_elinkyes_t *) HW_DMA_TCDn_BITER_ELINKYES_ADDR(x, n))
#define HW_DMA_TCDn_BITER_ELINKYES_RD(x, n) (HW_DMA_TCDn_BITER_ELINKYES(x, n).U)
#define HW_DMA_TCDn_BITER_ELINKYES_WR(x, n, v) (HW_DMA_TCDn_BITER_ELINKYES(x, n).U = (v))
#define HW_DMA_TCDn_BITER_ELINKYES_SET(x, n, v) (HW_DMA_TCDn_BITER_ELINKYES_WR(x, n, HW_DMA_TCDn_BITER_ELINKYES_RD(x, n) |  (v)))
#define HW_DMA_TCDn_BITER_ELINKYES_CLR(x, n, v) (HW_DMA_TCDn_BITER_ELINKYES_WR(x, n, HW_DMA_TCDn_BITER_ELINKYES_RD(x, n) & ~(v)))
#define HW_DMA_TCDn_BITER_ELINKYES_TOG(x, n, v) (HW_DMA_TCDn_BITER_ELINKYES_WR(x, n, HW_DMA_TCDn_BITER_ELINKYES_RD(x, n) ^  (v)))
/*@}*/

/*
 * Constants & macros for individual DMA_TCDn_BITER_ELINKYES bitfields
 */

/*!
 * @name Register DMA_TCDn_BITER_ELINKYES, field BITER[8:0] (RW)
 *
 * As the transfer control descriptor is first loaded by software, this 9-bit
 * (ELINK = 1) or 15-bit (ELINK = 0) field must be equal to the value in the CITER
 * field. As the major iteration count is exhausted, the contents of this field
 * are reloaded into the CITER field. When the software loads the TCD, this field
 * must be set equal to the corresponding CITER field; otherwise, a configuration
 * error is reported. As the major iteration count is exhausted, the contents of
 * this field is reloaded into the CITER field. If the channel is configured to
 * execute a single service request, the initial values of BITER and CITER should
 * be 0x0001.
 */
/*@{*/
#define BP_DMA_TCDn_BITER_ELINKYES_BITER (0U) /*!< Bit position for DMA_TCDn_BITER_ELINKYES_BITER. */
#define BM_DMA_TCDn_BITER_ELINKYES_BITER (0x01FFU) /*!< Bit mask for DMA_TCDn_BITER_ELINKYES_BITER. */
#define BS_DMA_TCDn_BITER_ELINKYES_BITER (9U) /*!< Bit field size in bits for DMA_TCDn_BITER_ELINKYES_BITER. */

/*! @brief Read current value of the DMA_TCDn_BITER_ELINKYES_BITER field. */
#define BR_DMA_TCDn_BITER_ELINKYES_BITER(x, n) (HW_DMA_TCDn_BITER_ELINKYES(x, n).B.BITER)

/*! @brief Format value for bitfield DMA_TCDn_BITER_ELINKYES_BITER. */
#define BF_DMA_TCDn_BITER_ELINKYES_BITER(v) ((uint16_t)((uint16_t)(v) << BP_DMA_TCDn_BITER_ELINKYES_BITER) & BM_DMA_TCDn_BITER_ELINKYES_BITER)

/*! @brief Set the BITER field to a new value. */
#define BW_DMA_TCDn_BITER_ELINKYES_BITER(x, n, v) (HW_DMA_TCDn_BITER_ELINKYES_WR(x, n, (HW_DMA_TCDn_BITER_ELINKYES_RD(x, n) & ~BM_DMA_TCDn_BITER_ELINKYES_BITER) | BF_DMA_TCDn_BITER_ELINKYES_BITER(v)))
/*@}*/

/*!
 * @name Register DMA_TCDn_BITER_ELINKYES, field LINKCH[12:9] (RW)
 *
 * If channel-to-channel linking is enabled (ELINK = 1), then after the minor
 * loop is exhausted, the eDMA engine initiates a channel service request at the
 * channel defined by these four bits by setting that channel's TCDn_CSR[START]
 * bit. When the software loads the TCD, this field must be set equal to the
 * corresponding CITER field; otherwise, a configuration error is reported. As the major
 * iteration count is exhausted, the contents of this field is reloaded into the
 * CITER field.
 */
/*@{*/
#define BP_DMA_TCDn_BITER_ELINKYES_LINKCH (9U) /*!< Bit position for DMA_TCDn_BITER_ELINKYES_LINKCH. */
#define BM_DMA_TCDn_BITER_ELINKYES_LINKCH (0x1E00U) /*!< Bit mask for DMA_TCDn_BITER_ELINKYES_LINKCH. */
#define BS_DMA_TCDn_BITER_ELINKYES_LINKCH (4U) /*!< Bit field size in bits for DMA_TCDn_BITER_ELINKYES_LINKCH. */

/*! @brief Read current value of the DMA_TCDn_BITER_ELINKYES_LINKCH field. */
#define BR_DMA_TCDn_BITER_ELINKYES_LINKCH(x, n) (HW_DMA_TCDn_BITER_ELINKYES(x, n).B.LINKCH)

/*! @brief Format value for bitfield DMA_TCDn_BITER_ELINKYES_LINKCH. */
#define BF_DMA_TCDn_BITER_ELINKYES_LINKCH(v) ((uint16_t)((uint16_t)(v) << BP_DMA_TCDn_BITER_ELINKYES_LINKCH) & BM_DMA_TCDn_BITER_ELINKYES_LINKCH)

/*! @brief Set the LINKCH field to a new value. */
#define BW_DMA_TCDn_BITER_ELINKYES_LINKCH(x, n, v) (HW_DMA_TCDn_BITER_ELINKYES_WR(x, n, (HW_DMA_TCDn_BITER_ELINKYES_RD(x, n) & ~BM_DMA_TCDn_BITER_ELINKYES_LINKCH) | BF_DMA_TCDn_BITER_ELINKYES_LINKCH(v)))
/*@}*/

/*!
 * @name Register DMA_TCDn_BITER_ELINKYES, field ELINK[15] (RW)
 *
 * As the channel completes the minor loop, this flag enables the linking to
 * another channel, defined by BITER[LINKCH]. The link target channel initiates a
 * channel service request via an internal mechanism that sets the TCDn_CSR[START]
 * bit of the specified channel. If channel linking disables, the BITER value
 * extends to 15 bits in place of a link channel number. If the major loop is
 * exhausted, this link mechanism is suppressed in favor of the MAJORELINK channel
 * linking. When the software loads the TCD, this field must be set equal to the
 * corresponding CITER field; otherwise, a configuration error is reported. As the
 * major iteration count is exhausted, the contents of this field is reloaded into
 * the CITER field.
 *
 * Values:
 * - 0 - The channel-to-channel linking is disabled
 * - 1 - The channel-to-channel linking is enabled
 */
/*@{*/
#define BP_DMA_TCDn_BITER_ELINKYES_ELINK (15U) /*!< Bit position for DMA_TCDn_BITER_ELINKYES_ELINK. */
#define BM_DMA_TCDn_BITER_ELINKYES_ELINK (0x8000U) /*!< Bit mask for DMA_TCDn_BITER_ELINKYES_ELINK. */
#define BS_DMA_TCDn_BITER_ELINKYES_ELINK (1U) /*!< Bit field size in bits for DMA_TCDn_BITER_ELINKYES_ELINK. */

/*! @brief Read current value of the DMA_TCDn_BITER_ELINKYES_ELINK field. */
#define BR_DMA_TCDn_BITER_ELINKYES_ELINK(x, n) (BITBAND_ACCESS16(HW_DMA_TCDn_BITER_ELINKYES_ADDR(x, n), BP_DMA_TCDn_BITER_ELINKYES_ELINK))

/*! @brief Format value for bitfield DMA_TCDn_BITER_ELINKYES_ELINK. */
#define BF_DMA_TCDn_BITER_ELINKYES_ELINK(v) ((uint16_t)((uint16_t)(v) << BP_DMA_TCDn_BITER_ELINKYES_ELINK) & BM_DMA_TCDn_BITER_ELINKYES_ELINK)

/*! @brief Set the ELINK field to a new value. */
#define BW_DMA_TCDn_BITER_ELINKYES_ELINK(x, n, v) (BITBAND_ACCESS16(HW_DMA_TCDn_BITER_ELINKYES_ADDR(x, n), BP_DMA_TCDn_BITER_ELINKYES_ELINK) = (v))
/*@}*/

/*
** Start of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #pragma push
  #pragma anon_unions
#elif defined(__CWCC__)
  #pragma push
  #pragma cpp_extensions on
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=extended
#else
  #error Not supported compiler type
#endif

/*******************************************************************************
 * hw_dma_t - module struct
 ******************************************************************************/
/*!
 * @brief All DMA module registers.
 */
#pragma pack(1)
typedef struct _hw_dma
{
    __IO hw_dma_cr_t CR;                   /*!< [0x0] Control Register */
    __I hw_dma_es_t ES;                    /*!< [0x4] Error Status Register */
    uint8_t _reserved0[4];
    __IO hw_dma_erq_t ERQ;                 /*!< [0xC] Enable Request Register */
    uint8_t _reserved1[4];
    __IO hw_dma_eei_t EEI;                 /*!< [0x14] Enable Error Interrupt Register */
    __O hw_dma_ceei_t CEEI;                /*!< [0x18] Clear Enable Error Interrupt Register */
    __O hw_dma_seei_t SEEI;                /*!< [0x19] Set Enable Error Interrupt Register */
    __O hw_dma_cerq_t CERQ;                /*!< [0x1A] Clear Enable Request Register */
    __O hw_dma_serq_t SERQ;                /*!< [0x1B] Set Enable Request Register */
    __O hw_dma_cdne_t CDNE;                /*!< [0x1C] Clear DONE Status Bit Register */
    __O hw_dma_ssrt_t SSRT;                /*!< [0x1D] Set START Bit Register */
    __O hw_dma_cerr_t CERR;                /*!< [0x1E] Clear Error Register */
    __O hw_dma_cint_t CINT;                /*!< [0x1F] Clear Interrupt Request Register */
    uint8_t _reserved2[4];
    __IO hw_dma_int_t INT;                 /*!< [0x24] Interrupt Request Register */
    uint8_t _reserved3[4];
    __IO hw_dma_err_t ERR;                 /*!< [0x2C] Error Register */
    uint8_t _reserved4[4];
    __I hw_dma_hrs_t HRS;                  /*!< [0x34] Hardware Request Status Register */
    uint8_t _reserved5[200];
    __IO hw_dma_dchprin_t DCHPRIn[16];     /*!< [0x100] Channel n Priority Register */
    uint8_t _reserved6[3824];
    struct {
        __IO hw_dma_tcdn_saddr_t TCDn_SADDR; /*!< [0x1000] TCD Source Address */
        __IO hw_dma_tcdn_soff_t TCDn_SOFF; /*!< [0x1004] TCD Signed Source Address Offset */
        __IO hw_dma_tcdn_attr_t TCDn_ATTR; /*!< [0x1006] TCD Transfer Attributes */
        union {
            __IO hw_dma_tcdn_nbytes_mlno_t TCDn_NBYTES_MLNO; /*!< [0x1008] TCD Minor Byte Count (Minor Loop Disabled) */
            __IO hw_dma_tcdn_nbytes_mloffno_t TCDn_NBYTES_MLOFFNO; /*!< [0x1008] TCD Signed Minor Loop Offset (Minor Loop Enabled and Offset Disabled) */
            __IO hw_dma_tcdn_nbytes_mloffyes_t TCDn_NBYTES_MLOFFYES; /*!< [0x1008] TCD Signed Minor Loop Offset (Minor Loop and Offset Enabled) */
        };
        __IO hw_dma_tcdn_slast_t TCDn_SLAST; /*!< [0x100C] TCD Last Source Address Adjustment */
        __IO hw_dma_tcdn_daddr_t TCDn_DADDR; /*!< [0x1010] TCD Destination Address */
        __IO hw_dma_tcdn_doff_t TCDn_DOFF; /*!< [0x1014] TCD Signed Destination Address Offset */
        union {
            __IO hw_dma_tcdn_citer_elinkno_t TCDn_CITER_ELINKNO; /*!< [0x1016] TCD Current Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
            __IO hw_dma_tcdn_citer_elinkyes_t TCDn_CITER_ELINKYES; /*!< [0x1016] TCD Current Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
        };
        __IO hw_dma_tcdn_dlastsga_t TCDn_DLASTSGA; /*!< [0x1018] TCD Last Destination Address Adjustment/Scatter Gather Address */
        __IO hw_dma_tcdn_csr_t TCDn_CSR;   /*!< [0x101C] TCD Control and Status */
        union {
            __IO hw_dma_tcdn_biter_elinkno_t TCDn_BITER_ELINKNO; /*!< [0x101E] TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Disabled) */
            __IO hw_dma_tcdn_biter_elinkyes_t TCDn_BITER_ELINKYES; /*!< [0x101E] TCD Beginning Minor Loop Link, Major Loop Count (Channel Linking Enabled) */
        };
    } TCD[16];
} hw_dma_t;
#pragma pack()

/*! @brief Macro to access all DMA registers. */
/*! @param x DMA module instance base address. */
/*! @return Reference (not a pointer) to the registers struct. To get a pointer to the struct,
 *     use the '&' operator, like <code>&HW_DMA(DMA_BASE)</code>. */
#define HW_DMA(x)      (*(hw_dma_t *)(x))

/*
** End of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #pragma pop
#elif defined(__CWCC__)
  #pragma pop
#elif defined(__GNUC__)
  /* leave anonymous unions enabled */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=default
#else
  #error Not supported compiler type
#endif

#endif /* __HW_DMA_REGISTERS_H__ */
/* EOF */
