#include "mbed.h"
#include "EthernetInterface.h"
#include "SDFileSystem.h"


//#define UDPServer 1
#define UDPClinet 1

#if defined(UDPServer)
    #define MAC     "\x00\x08\xDC\x11\x34\x78"
    #define IP      "192.168.99.100"
    #define MASK    "255.255.255.0"
    #define GATEWAY "192.168.99.1"
#endif
#if defined(UDPClinet)
    #define MAC     "\x00\x08\xDC\x11\x34\x90"
    #define IP      "192.168.99.101"
    #define MASK    "255.255.255.0"
    #define GATEWAY "192.168.99.1"
#endif
const char* ECHO_SERVER_ADDRESS = "192.168.99.100";
const int ECHO_SERVER_PORT = 3000;
const int ECHO_CLIENT_PORT = 2000;
int main (void) {

    EthernetInterface eth;
    Serial (USBTX, USBRX);
    eth.init((uint8_t*)MAC,IP,MASK,GATEWAY);  //IP,mask,Gateway
    printf("Connecting\n");
    eth.connect();
#if defined(UDPServer)
    while (true) 
    {
        printf("\nServer IP Address is %s\n", eth.getIPAddress()); 
        UDPSocket server;
        server.bind(ECHO_SERVER_PORT);
    
        Endpoint client;
        char buffer[256];
        while (true) {
            printf("\nWaiting for UDP packet...\n");
            int n = server.receiveFrom(client, buffer, sizeof(buffer));
            if (n <= 0) break;
            // print received message to terminal
            //buffer[n] = '\0';
            
            printf("Received packet from: %s\n", client.get_address());
            printf("Packet contents : '%s'\n",buffer);
            printf("Sending Packet back to Client\n");
            server.sendTo(client, buffer, n);
            if (n <= 0) break;
        }
    }
#else   //Client
    printf("\nClient IP Address is %s \n", eth.getIPAddress());
    
    UDPSocket sock;
    sock.init();
    sock.bind(ECHO_CLIENT_PORT);
    Endpoint echo_server;
    echo_server.set_address(ECHO_SERVER_ADDRESS, ECHO_SERVER_PORT);
    
    char out_buffer[] = "Hello World";
    printf("Sending  message '%s' to server (%s)\n",out_buffer,ECHO_SERVER_ADDRESS);
    printf("ip= %s,port=%d\r\n",echo_server.get_address(),echo_server.get_port());
    sock.sendTo(echo_server, out_buffer, sizeof(out_buffer));
    
    char in_buffer[256];
   // int n = sock.receiveFrom(echo_server, in_buffer, sizeof(in_buffer));
    
   // in_buffer[n] = '\0';
    //printf("Received message from server: '%s'\n", in_buffer);
    
    sock.close();
    
    eth.disconnect();
    while(1) {}
#endif
}
