#include "mbed.h"
#include "Adafruit_SSD1306.h"
 
DigitalOut myled(LED1);

#if defined(TARGET_WIZwiki_W7500)
#define SDA                  PA_10
#define SCL                  PA_9
#endif

// an SPI sub-class that provides a constructed default
class I2CPreInit : public I2C
{
public:
    I2CPreInit(PinName sda, PinName scl) : I2C(sda, scl)
    {
        frequency(100000);
        start();
    };
};

I2CPreInit gI2C(PA_10,PA_9);
Adafruit_SSD1306_I2c gOled(gI2C,NC,0x78,64,128);
Serial pc(USBTX,USBRX);

int main()
{   uint16_t x=0;
 
    gOled.begin();
    gOled.printf("%ux%u OLED Display\r\n", gOled.width(), gOled.height());
    gOled.display();


    while(1)
    {
        myled = !myled;
        gOled.printf("%u\r",x);
        gOled.display();
        x = x + 1;
        wait(1);
    }
}
