/* Example showing how to hook up to different GPS modules (GlobalSat EM406a and Adafruit Ultimate GPSv3)
*  to emulated serial ports at different speeds */
#include "mbed.h"
#include "GPS.h"
#include "Adafruit_SSD1306.h"

class I2CPreInit : public I2C
{
public:
    I2CPreInit(PinName sda, PinName scl) : I2C(sda, scl)
    {
        frequency(100000);
        start();
    };
};

#ifdef TARGET_WIZwiki_W7500
    GPS gpsAda(D1, D0, 9600);
    I2CPreInit gI2C(PA_10,PA_9);
#else
    GPS gpsAda(P0_12, P0_15, 9600);
    GPS gpsSpark(P0_4, P0_0, 4800);
#endif

// an SPI sub-class that provides a constructed default

Adafruit_SSD1306_I2c gOled(gI2C,NC,0x78,64,128);
Serial pc(USBTX, USBRX);

int main() {
    
    gOled.begin();
    gOled.clearDisplay();
    while (1) {  
#ifndef TARGET_WIZwiki_W7500      
       if(gpsSpark.sample()) {
          pc.printf("set %c\t%f\t%f\t%f\t%f\t%f\n\r", 'Sparkfun Breakout', gpsSpark.longitude, gpsSpark.latitude, gpsSpark.alt, gpsSpark.geoid, gpsSpark.time);
       }
#endif  
       if(gpsAda.sample()) {
           gOled.printf("T  : %Lf\n",  gpsAda.time);
           gOled.printf("LO : %f\n",  gpsAda.longitude);
           gOled.printf("LA : %f\n",  gpsAda.latitude);
           gOled.printf("AL : %f\n",  gpsAda.alt);
           gOled.printf("G  : %f\n",  gpsAda.geoid);
           gOled.display();
           gOled.setTextCursor(0,0);
    }
        
    }
    
}