/* Example showing how to hook up to different GPS modules (GlobalSat EM406a and Adafruit Ultimate GPSv3)
*  to emulated serial ports at different speeds */
#include "mbed.h"
#include "GPS.h"


#ifdef TARGET_WIZwiki_W7500
    GPS gpsAda(D1, D0, 9600);
#else
    GPS gpsAda(P0_12, P0_15, 9600);
    GPS gpsSpark(P0_4, P0_0, 4800);
#endif

Serial pc(USBTX, USBRX);

int main() {
    char ch[] = {"Adafruit"};
    char ch1[] = {"Sparkfun Breakout"};
    
    while (1) {  
#ifndef TARGET_WIZwiki_W7500      
       if(gpsSpark.sample()) {
          pc.printf("set %s\t%f\t%f\t%f\t%f\t%f\n\r", ch1, gpsSpark.longitude, gpsSpark.latitude, gpsSpark.alt, gpsSpark.geoid, gpsSpark.time);
       }
#endif  
       if(gpsAda.sample()) {
          pc.printf("set %s\t%f\t%f\t%f\t%f\t%f\r\n",  ch, gpsAda.longitude, gpsAda.latitude, gpsAda.alt, gpsAda.geoid, gpsAda.time);
        }
        
    }
    
}