#include "mbed.h"


DigitalOut right_led(PA_1);
DigitalOut left_led(PA_2);
Serial bt(P13, P14); // tx, rx

bool left_flag = false;
bool right_flag = false;
 
void left_handler(void) {
    left_flag = true;
}
 
void right_handler(void) {
    right_flag = true;
}
 
int main() {
    // Disable the battery charger unless a battery is attached.
    right_led = 1;
    left_led = 1;

    bt.baud(115200);
    
    InterruptIn leftsw(PC_6);
    InterruptIn rightsw(PC_7);
    leftsw.rise(&left_handler);
    rightsw.rise(&right_handler);

    while (true) {
        if (left_flag) {
            bt.printf("1\n");
            left_flag = false;
            left_led = 0;
              wait_ms(500);
            left_led = 1;
        }
        if (right_flag) {
            bt.printf("2\n");
            right_flag = false;
            right_led = 0;
            wait_ms(500);
            right_led = 1;
        }

    }
}
