#include "stdio.h"
#include "time.h"
#include "stdlib.h"
#include "string.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include "NTPClient.h"
#include "SMTPClient.h"
#include "fonctions.h"
#include <mbed.h>
#include <scmRTOS.h>

#define HOSTNAME "mbedSE"



//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//                      Creation des types                          
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------

//Definition des types process
typedef OS::process<OS::pr0, 300> TProc1;
typedef OS::process<OS::pr1, 300> TProc2;
typedef OS::process<OS::pr2, 300> TProc3;

//Definition du type adresse_IP
typedef struct {
    uint8_t champs1;
    uint8_t champs2;
    uint8_t champs3;
    uint8_t champs4;
} adresse_IP;

// Definition du type de configuration du serveur SMTP pour l'envoi de mail
typedef struct {
    adresse_IP IP;
    int port;
    string user;
    string password;
    string domain;
    string from_address;
    string to_address;

} ConfSMTP;


//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//                      Declaration des variables                           
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------

NTPClient ntp;
LocalFileSystem local("local");
Serial pc(USBTX, USBRX); // tx, rx
EthernetNetIf eth(HOSTNAME);
//HTTPServer svr;

string StationName;

adresse_IP IP;
adresse_IP NM;
adresse_IP GW;
adresse_IP DNS;
adresse_IP NTP;
ConfSMTP SMTP;

//Differents Processus pour le multitache
TProc1 Proc1;
TProc2 Proc2;
TProc3 Proc3;

//Differents evenements pouvant declencher un processus en attente
OS::TEventFlag acquisition_de_lheure;

//Heure machine et heure serveur

time_t timer;
time_t local_time;
int server_time_h=0;
int server_time_m=0;
int server_time_s=0;
int local_time_h=0;
int local_time_min=0;
int local_time_s=0;
char hour [2];
char mins [4];
char sec [6];
struct tm * server_time;

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
//                      Mise en place des fonctions                           
//---------------------------------------------------------------------------
//---------------------------------------------------------------------------


// Creation du fichier de config
void creation_fichier_de_config()
{
    FILE *p_fichier;                                 
    p_fichier = fopen("/local/config.txt", "r");  // Ouverture en lecture pour verifier son existence

    if (p_fichier == NULL)    // Test pour voir si le fichier existe ou pas

    {
        // On utilise le caractere # pour marquer les lignes de commentaires   
        pc.printf("le fichier n' existe pas, il faut le creer  \n");
        p_fichier = fopen("/local/config.txt", "w");  // Ouverture en ecriture pour le creer
        fprintf(p_fichier, "Station:observatoire\n");
        fprintf(p_fichier, "#configuration reseau \n");
        fprintf(p_fichier, "######################################## \n");
        fprintf(p_fichier, "IP:xxx.xxx.xxx.xxx\n");
        fprintf(p_fichier, "NM:xxx.xxx.xxx.xxx\n");
        fprintf(p_fichier, "GW:xxx.xxx.xxx.xxx\n");
        fprintf(p_fichier, "DNS:xxx.xxx.xxx.xxx\n");
        fprintf(p_fichier, "NTPxxx.xxx.xxx.xxx\n");
        fprintf(p_fichier, "SMTP:xxx.xxx.xxx.xxx\n");
        fprintf(p_fichier, "PORT:xx\n");
        fprintf(p_fichier, "USER:xxxxx\n");
        fprintf(p_fichier, "PASSWORD:xxxxx\n");
        fprintf(p_fichier, "DOMAIN:xxxxxxxxxx\n");
        fprintf(p_fichier, "FROM_ADDRESS:xxxxxxxxxxxxxxx\n");
        fprintf(p_fichier, "TO_ADDRESS:xxxxxxxxxxxxxxxx\n");
        fprintf(p_fichier, "######################################## \n");
        fclose(p_fichier);
        pc.printf("le fichier a ete cree\n");
    } else {
        fclose(p_fichier);
        pc.printf("le fichier de configuration existe \n");
    }
}


//Lecture du fichier de config et recuperation des donnees reseaux
void lecture_du_fichier_de_config() {
    FILE *p_fichier;                    
    p_fichier = fopen("/local/config.txt","r");   // Ouverture en lecture seule pour recuperer les donnees
    pc.printf("lecture du fichier de configuration  \n");

    char ligne[100];
    char *ligne_de_commentaire;
          
    while ( feof(p_fichier) != TRUE ) {   // On verifie que le pointeur du fichier n'est pas &#65533; la fin du fichier
                                          //feof() renvoie FALSE si pointeur different de fin de fichier sinon renvoie TRUE
        
        fgets(ligne,100,p_fichier);    // aquisition d'une ligne pour la traiter

        if ( feof(p_fichier))        //on a pas atteint la fin du fichier
        {
            break;
        }

        ligne_de_commentaire = strchr(ligne, '#');     // verification que la ligne ne soit pas du commentaire
                                         // strchhr retourne l'adresse du premier caractere demande trouve
                                         // si il n'y en a pas il retourne NULL

        if (ligne_de_commentaire==NULL) {              // la ligne n'est pas du commentaire
            
            char *s=0;
            char **test;
            int lim1=0;
            int lim2=0;
            
            /******************************/
            /*lecture du nom de la station*/
            /******************************/
            lim1 = str_istr(ligne, "Station:");   //recherche de l'emplacement de la chaine de caractere correspondante   
                                                       
            if (lim1!=-1) {
                lim2 = str_istr(ligne, "\n");
                StationName=str_sub(ligne,lim1+8,lim2);
                pc.printf("Station: %s\n",StationName);
                }
            
            /******************************/
            /*   lecture de l'adresse IP  */
            /******************************/
            lim1 = str_istr(ligne, "IP:");     
            if (lim1!=-1) {
                lim2 = str_istr(ligne, "\n");
                s=str_sub(ligne,lim1+3,lim2);
                test = str_split(s, ".");     //separation de la chaine en sous chaine separee par le caractere "."
               
                //Transfert de l'ip vers la meroire
                IP.champs1=(uint8_t)atoi(test[0]);
                IP.champs2=(uint8_t)atoi(test[1]);
                IP.champs3=(uint8_t)atoi(test[2]);
                IP.champs4=(uint8_t)atoi(test[3]);
                pc.printf("IP: %d.%d.%d.%d\n",IP.champs1,IP.champs2,IP.champs3,IP.champs4);
            }
            
            /******************************/
            /*     lecture du netmask     */
            /******************************/
            lim1 = str_istr(ligne, "NM:");      
            if (lim1!=-1) {
                lim2 = str_istr(ligne, "\n");
                s=str_sub(ligne,lim1+3,lim2);
                test = str_split(s, ".");

                //Transfert du net masque  vers la memoire
                NM.champs1=(uint8_t)atoi(test[0]);
                NM.champs2=(uint8_t)atoi(test[1]);
                NM.champs3=(uint8_t)atoi(test[2]);
                NM.champs4=(uint8_t)atoi(test[3]);
                pc.printf("NM: %d.%d.%d.%d\n",NM.champs1,NM.champs2,NM.champs3,NM.champs4);
            }
            
            /******************************/
            /*  lecture de la passerelle  */
            /******************************/
            lim1 = str_istr(ligne, "GW:");
            if (lim1!=-1) {
                lim2 = str_istr(ligne, "\n");
                s=str_sub(ligne,lim1+3,lim2);
                test = str_split(s, ".");

                //Transfert de la gateway vers la memoire
                GW.champs1=(uint8_t)atoi(test[0]);
                GW.champs2=(uint8_t)atoi(test[1]);
                GW.champs3=(uint8_t)atoi(test[2]);
                GW.champs4=(uint8_t)atoi(test[3]);
                pc.printf("GW: %d.%d.%d.%d\n",GW.champs1,GW.champs2,GW.champs3,GW.champs4);
            }
            
            /******************************/
            /*   lecture IP serveur DNS   */
            /******************************/
            lim1 = str_istr(ligne, "DNS:");
            if (lim1!=-1) {
                lim2 = str_istr(ligne, "\n");
                s=str_sub(ligne,lim1+4,lim2);
                test = str_split(s, ".");

                //Transfert du DNS vers la memoire
                DNS.champs1=(uint8_t)atoi(test[0]);
                DNS.champs2=(uint8_t)atoi(test[1]);
                DNS.champs3=(uint8_t)atoi(test[2]);
                DNS.champs4=(uint8_t)atoi(test[3]);
                pc.printf("DNS: %d.%d.%d.%d\n",DNS.champs1,DNS.champs2,DNS.champs3,DNS.champs4);
            }
            
            /******************************/
            /*   lecture IP serveur NTP   */
            /******************************/
            lim1 = str_istr(ligne, "NTP:");
            if (lim1!=-1) {
                lim2 = str_istr(ligne, "\n");
                s=str_sub(ligne,lim1+4,lim2);
                test = str_split(s, ".");

                //Transfert du NTP vers la memoire
                NTP.champs1=(uint8_t)atoi(test[0]);
                NTP.champs2=(uint8_t)atoi(test[1]);
                NTP.champs3=(uint8_t)atoi(test[2]);
                NTP.champs4=(uint8_t)atoi(test[3]);
                pc.printf("NTP: %d.%d.%d.%d\n",NTP.champs1,NTP.champs2,NTP.champs3,NTP.champs4);
            }
            
            /******************************/
            /* lecture configuration SMTP */
            /******************************/
            lim1 = str_istr(ligne, "SMTP:");
            if (lim1!=-1) {
                lim2 = str_istr(ligne, "\n");
                s=str_sub(ligne,lim1+5,lim2);
                test = str_split(s, ".");
                //Transfert du SMTP vers la memoire
                SMTP.IP.champs1=(uint8_t)atoi(test[0]);
                SMTP.IP.champs2=(uint8_t)atoi(test[1]);
                SMTP.IP.champs3=(uint8_t)atoi(test[2]);
                SMTP.IP.champs4=(uint8_t)atoi(test[3]);
                pc.printf("SMTP: %d.%d.%d.%d\n",SMTP.IP.champs1,SMTP.IP.champs2,SMTP.IP.champs3,SMTP.IP.champs4);
            }
            
            //lecture du port
            lim1 = str_istr(ligne, "PORT:");      
            if (lim1!=-1) {
                lim2 = str_istr(ligne, "\n");
                SMTP.port=(uint8_t)atoi(str_sub(ligne,lim1+5,lim2-1));
                pc.printf("Port: %d\n",SMTP.port);

            }
            //lecture de l'utilisateur
            lim1 = str_istr(ligne, "USER:");      
            if (lim1!=-1) {
                lim2 = str_istr(ligne, "\n");
                SMTP.user=str_sub(ligne,lim1+5,lim2-1);
                pc.printf("User: %s\n",SMTP.user);
            }
            //lecture du mot de passe
            lim1 = str_istr(ligne, "PASSWORD:");      
            if (lim1!=-1) {
                lim2 = str_istr(ligne, "\n");
                SMTP.password=str_sub(ligne,lim1+9,lim2-1);
                pc.printf("Password: %s\n",SMTP.password);
            }
            //lecture du domaine
            lim1 = str_istr(ligne, "DOMAIN:");      
            if (lim1!=-1) {
                lim2 = str_istr(ligne, "\n");
                SMTP.domain=str_sub(ligne,lim1+7,lim2-1);
                pc.printf("Domain: %s\n",SMTP.domain);
            }
             //lecture de l'adresse de destination
            lim1 = str_istr(ligne, "FROM_ADDRESS:");     
            if (lim1!=-1) {
                lim2 = str_istr(ligne, "\n");
                SMTP.from_address=str_sub(ligne,lim1+13,lim2-1);
                pc.printf("From adress: %s\n",SMTP.from_address);
            }
            //lecture de l' adresse de destination
            lim1 = str_istr(ligne, "TO_ADDRESS:");      
            if (lim1!=-1) {
                lim2 = str_istr(ligne, "\n");
                SMTP.to_address=str_sub(ligne,lim1+11,lim2-1);
                pc.printf("To adress: %s\n",SMTP.to_address);
            }
        }
    }
    fclose(p_fichier);
}


// Telechargement de l'heure sur le serveur NTP
int telechargement_heure(int initial) {

    bool connection_etablie = FALSE;

    // Connection au serveur NTP
    pc.printf("Connection au serveur NTP\n");
    pc.printf("Adresse serveur: %d.%d.%d.%d\n",NTP.champs1,NTP.champs2,NTP.champs3,NTP.champs4);
    Host serverNTP(IpAddr(NTP.champs1,NTP.champs2,NTP.champs3,NTP.champs4),123,"");
    
    // Verification de reussite de la connection
     NTPResult ntpResult=ntp.setTime(serverNTP);
     if( ntpResult == NTP_OK )
     {
         pc.printf("Connection etablie\r\n");
         connection_etablie = TRUE;
     }
     else {
     
     pc.printf("Erreur lors de la connection au serveur, description:\n");
     
     if ( ntpResult == NTP_PRTCL )
     {
         pc.printf("NTP Protocol error.\r\n") ;
     }
     else if ( ntpResult == NTP_TIMEOUT )
     {
         pc.printf("Connection timeout.\r\n");
     }
     else if ( ntpResult == NTP_DNS )
     {
         pc.printf("Could not resolve DNS hostname.\r\n") ;
     }
     else if ( ntpResult == NTP_PROCESSING )
     {
         pc.printf("Processing.\r\n");
     }
     else
     {
         pc.printf("Erreur inconnue");
     }
       
     }//Fin du else affichant les erreurs
     
     // Si erreur lors de la premiere tentative: deuxieme essai
     if( ntpResult != NTP_OK )
     {
         pc.printf("\nDeuxieme essai de recuperation de l'heure\n");
         
     NTPResult ntpResult=ntp.setTime(serverNTP);
     if( ntpResult == NTP_OK )
     {
         pc.printf("Connection etablie\r\n");
         connection_etablie = TRUE;
     
     }
     else {
     
     pc.printf("Erreur lors de la connection au serveur, description:\n");
     
     if ( ntpResult == NTP_PRTCL )
     {
         pc.printf("NTP Protocol error.\r\n") ;
     }
     else if ( ntpResult == NTP_TIMEOUT )
     {
         pc.printf("Connection timeout.\r\n");
     }
     else if ( ntpResult == NTP_DNS )
     {
         pc.printf("Could not resolve DNS hostname.\r\n") ;
     }
     else if ( ntpResult == NTP_PROCESSING )
     {
         pc.printf("Processing.\r\n");
     }
     else
     {
         pc.printf("Erreur inconnue");
     }
     }
     }
     
     if( connection_etablie == FALSE )
     {
     pc.printf("Connection impossible");
     ////////////////////////////////////////////////////////////////
     ////////////////////////////////////////////////////////////////
     //Ecrire ici le rapport d'erreur dans le fichier sur carte SD //
     ////////////////////////////////////////////////////////////////
     ////////////////////////////////////////////////////////////////
     return 0;
     }
     else{
     
     //connection etablie, recuperation de l'heure du serveur
     timer=time(NULL);

     //si nous en phase d'initialisation l'heure machine = l'heure serveur
    if( initial == 0)
    {
    local_time = timer;
    }

    server_time =  localtime(&timer);
    
    //Recuperation des differentes composantes de l'heure
    strcpy (hour,"");
    strftime (hour,2,"%H",server_time);
    server_time_h = atoi(hour);

    strcpy (mins,"");
    strftime(mins,4,"%M",server_time);
    server_time_m = atoi(mins);

    strcpy (sec,"");
    strftime (sec,6,"%S",server_time);
    server_time_s = atoi(sec);
    pc.printf("Heure serveur: %dh%dm%ds\n", server_time_h, server_time_m, server_time_s);
    return 1;

    }  
}

//   printf("L'heure courante est: %s\n",asctime(localtime(&timer)));


// Configuration connection reseau Ethernet
void configuration_reseau_static()
{
  EthernetNetIf eth(IpAddr(IP.champs1,IP.champs2,IP.champs3,IP.champs4),
                    IpAddr(NM.champs1,NM.champs2,NM.champs3,NM.champs4),
                    IpAddr(GW.champs1,GW.champs2,GW.champs3,GW.champs4),
                    IpAddr(DNS.champs1,DNS.champs2,DNS.champs3,DNS.champs4));
  
  pc.printf("Debut configuration\n");
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    pc.printf("Echec de la configuration\n");
  }
    pc.printf("Configuration reseau OK\n");
}

// Configuration connection reseau Ethernet
void configuration_reseau_dynamic()
{
  
  pc.printf("Debut configuration\n");
  EthernetErr ethErr = eth.setup();
  if( ethErr == ETH_OK )
    {
        IpAddr ip = eth.getIp();
        pc.printf("Utilisation du protocol DHCP\n");
        pc.printf("IP fournie: %d.%d.%d.%d\r\n", ip[0], ip[1], ip[2], ip[3]);
    }
    else pc.printf ("Echec de la configuration\n");

}



int main(){

    wait(8);
    pc.printf("\n****************************\n");
    pc.printf("Initialisation connection reseau\n");
    pc.printf("****************************\n\n");
    
    wait(2);
    //Generation et lecture fichier de configuration 
    pc.printf("\nFichier de configuration\n");
    creation_fichier_de_config();
    lecture_du_fichier_de_config();
    
    wait(2);
    //configuration reseau
    pc.printf("\nConfiguration reseau\n");
    //configuration_reseau_static();
    configuration_reseau_dynamic();
  
    wait(2);
    //initialisation heure locale
    pc.printf("\nConnection reseau NTP et initialisation de l'heure\n");
    telechargement_heure(0);


    wait(2);
    pc.printf("\n\n****************************\n");
    pc.printf("Lancement de la gestion multitache\n");
    pc.printf("****************************\n\n");
    // run
    OS::Run();
}

//---------------------------------------------------------------------------
template<> OS_PROCESS void TProc1::Exec()
{
    for(;;)
    {
        Sleep(3000);            //Attente 3000ms
        pc.printf("Execution Process 1\n");

    }
}

//---------------------------------------------------------------------------
template<> OS_PROCESS void TProc2::Exec()
{
    for(;;)
    {
        Sleep(5000);                //Attente 5000ms
        pc.printf("Execution Process 2\n");
        
    }
}

//---------------------------------------------------------------------------
template<> OS_PROCESS void TProc3::Exec()
{
    for (;;)
    {
    
            char c = pc.getc();
           if(c == 'a')
            {
              telechargement_heure(1);  
            } 

    
    
    }
}

//---------------------------------------------------------------------------
// Timer des process, c'est ici qu'on peut creer des evenement pour synchro les taches
void OS::SystemTimerUserHook()
{
        //Interrogation du serveur pour maintenir connection
        Net::poll();

}
//---------------------------------------------------------------------------
void OS::IdleProcessUserHook()
{
    __WFI();
}
//-----------------------------------------------------------------------------
