#include "stdio.h"
#include "time.h"
#include "stdlib.h"
#include "string.h"
#include "fonctions.h"

// Fonctions permettant de travailler sur les chaines de caractere (source: http://nicolasj.developpez.com/articles/libc/string/#LII-J)

//Fournit l'index d'une sous chaine
int str_istr (const char *cs, const char *ct) {
    int index = -1;

    if (cs != NULL && ct != NULL) {
        char *ptr_pos = NULL;

        ptr_pos = (char*)strstr(cs, ct);
        if (ptr_pos != NULL) {
            index = ptr_pos - cs;
        }
    }
    return index;
}

//Extrait une sous chaine en fonction d'indices limites
char *str_sub (const char *s, unsigned int start, unsigned int end) {
    char *new_s = NULL;

    if (s != NULL && start < end) {

        new_s =(char*) malloc (sizeof (*new_s) * (end - start + 2));
        if (new_s != NULL) {
            int i;

            for (i = start; i <= end; i++) {
                new_s[i-start] = s[i];
            }
            new_s[i-start] = '\0';
        } else {
            fprintf (stderr, "Memoire insuffisante\n");
            exit (EXIT_FAILURE);
        }
    }
    return new_s;
}

// Extrait en plusieurs sous chaines en fonction d'une chaine de s&#65533;paration
char **str_split (char *s, const char *ct) {
    char **tab = NULL;

    if (s != NULL && ct != NULL) {
        int i;
        char *cs = NULL;
        size_t size = 1;
        
        for (i=0;(cs =(char *) strtok (s, ct)); i++) {
            if (size <= i + 1) {
                void *tmp = NULL;


                size <<= 1;
                tmp = realloc (tab, sizeof (*tab) * size);
                if (tmp != NULL) {
                    tab =(char**) tmp;
                } else {
                    fprintf (stderr, "Memoire insuffisante\n");
                    free (tab);
                    tab = NULL;
                    exit (EXIT_FAILURE);
                }
            }

            tab[i] = cs;
            s = NULL;
        }
        tab[i] = NULL;
    }
    return tab;
}
