#include "mbed.h"
#include "uLCD_4DGL.h"
#include "motordriver.h"
#include "SDFileSystem.h"
#include "wave_player.h"

uLCD_4DGL uLCD(p28, p27, p30); // serial tx, serial rx, reset pin;

Serial xbee1(p13,p14);
DigitalOut rst1(p11);

DigitalOut myled(LED1);
DigitalOut myled2(LED2);

Motor  left(p21, p22, p23, 1); 
Motor right(p26, p25, p24, 1);

SDFileSystem sd(p5, p6, p7, p8, "sd");
AnalogOut DACout(p18);
wave_player waver(&DACout);
int a = 0;
int f = 0;
int b = 0;
int l = 0;
int r = 0;

void thread1(void const *args) {
  while (true) {  
    while (f >0) {
        FILE *wave_file;
        wave_file=fopen("/sd/forward.wav","r");
        waver.play(wave_file);
        fclose(wave_file);
        Thread::wait(100);
    }
  }
}

void thread2(void const *args) {
  while (true) {  
    while (b >0) {
        FILE *wave_file;
        wave_file=fopen("/sd/backward.wav","r");
        waver.play(wave_file);
        fclose(wave_file);
        Thread::wait(100);
    }
  }
}

void thread3(void const *args) {
  while (true) {  
    while (l >0) {
        FILE *wave_file;
        wave_file=fopen("/sd/left.wav","r");
        waver.play(wave_file);
        fclose(wave_file);
        Thread::wait(100);
    }
  }
}

void thread4(void const *args) {
  while (true) {  
    while (r >0) {
        FILE *wave_file;
        wave_file=fopen("/sd/right.wav","r");
        waver.play(wave_file);
        fclose(wave_file);
        Thread::wait(100);
    }
  }
}

int main() {
    Thread t1(thread1);
    Thread t2(thread2);
    Thread t3(thread3);
    Thread t4(thread4);

    uLCD.display_control(PORTRAIT);
    rst1 = 0;   //Set reset pin to 0
    myled = 0;
    myled2= 0;
    wait_ms(1);
    rst1 = 1;   //Set reset pin to 1
    wait_ms(1);

    uLCD.printf("starting");
    wait(2);
    uLCD.cls();

    
    int prev = 0;
    float base = 0.1;
    float lSpeed = 0.0;
    float rSpeed = 0.0;
        while (1) {
        //uLCD.printf("wating");
        if(xbee1.readable()){
            
            prev = a;
            a = xbee1.getc(); //XBee read
            
            if (a !=0) {
            switch(a) {
                case 1 : //forward
                  //uLCD.cls();
                  f++;
                  lSpeed = f*base*-1;
                  rSpeed = f*base*-1;
                  break;
                case 2 : //reverse
                  b++;
                  lSpeed = b*base;
                  rSpeed = b*base;
                  break;
                case 3 : //counter clockwise roation
                  l++;
                  lSpeed = l*base*-1;
                  rSpeed = l*base;
                  break;
                case 4 : //clockwise rotation
                  r++;
                  lSpeed = r*base;
                  rSpeed = r*base*-1;
                  break;
                case 5 : //stop/reset
                  f = 0;
                  b = 0;
                  l = 0;
                  r = 0;
                  lSpeed = 0.0;
                  rSpeed = 0.0;
                  break;
                default :
                  //left.speed(0.0);
                  //right.speed(0.0);
            }
            }
            //uLCD.printf("move");
            left.speed(lSpeed);
            right.speed(rSpeed);
            /*if (a == 1) {
                left.speed(-0.7);
                right.speed(-0.7);
                
                wave_file=fopen("/sd/fire.wav","r");
                waver.play(wave_file);
                fclose(wave_file);
            } else if (a == 2) {
                left.speed(0.7);
                right.speed(0.7);
            } else if (a == 3) {
                left.speed(-0.7);
                right.speed(0.7);
            } else if (a == 4) {
                left.speed(0.7);
                right.speed(-0.7);
            } else if (a == 5) {
                left.speed(0);
                right.speed(0); 
            } */
            if (a != prev){
            
                    uLCD.cls();
                    //uLCD.text_width(3); //1X size text
                    //uLCD.text_height(3);
                    //uLCD.locate(64,64);
                    //uLCD.printf("%d", a);
                    uLCD.printf("%f", lSpeed);
                    uLCD.printf(" ");
                    uLCD.printf("%d", b);
                    uLCD.printf(" ");
                    uLCD.printf("%d", a);
                    uLCD.printf(" ");
                    uLCD.printf("%f", rSpeed);
                
            }
            
        }
        a = 0;
    }
}
