#include "mbed.h"
#include "CCS811.h"
#include "Alphasense.h"
#include "NovaSDS011.h"
#include "PMS7003.h"
#include "HPMA115S0.h"
#include "BME680.h"
#include "Adafruit_SGP30.h"
#include "Teseo-LIV3F.h"

CCS811 ccs811(D14, D15);
BME680 BME(D14,D15,0);
Adafruit_SGP30 SGP30(D14, D15);

Serial HPMA(A0,A1);
HPMA115S0 HoneyWell(&HPMA);

Serial novaSerial(A4,A5);
NovaSDS011 nova(&novaSerial);

Serial PMS(D3,D5);
PMS7003 TowerPlant(&PMS);

DigitalOut set(D5);


InterruptIn button(USER_BUTTON);

DigitalOut led(LED1);

int ordo[20]={151500,0,1,0,151600,1,0,1,151600,1,1,1,151600,1,0,0,151600,0,0,1};

int i=0;
int j=0;

double delay = 0.5; // 500 ms
uint16_t eco2, tvoc;

void pressed()
{
    uint8_t trame[100];
    uint8_t oct=0,oct2=0;
    i++;
    oct2 = ordo[i] << 2;
    oct |= oct2;
    oct2 = ordo[i+1] << 1;
    oct |= oct2;
    oct2 = ordo[i+2];
    oct |= oct2;
    trame[j]=oct;
    j++;
    printf("flag ok\r\n");
    printf("\n!!! ALARM 1 Triggered !!!\r\n");
    if(ordo[i]==1){
        printf("Capteur 0 actif - Erreur \r\n");
        trame[j]=1;
        j++;
    }
    if(ordo[i]==1){
        printf("Capteur 1 actif - Heure\r\n");
        trame[j]=2;
        j++;
    }
    i++;
    if(ordo[i]==1){
        printf("Capteur 2 actif - N/A \r\n");
        trame[j]=12;
        j++;
    }
    i++;
    if(ordo[i]==1){
        printf("Capteur 4 actif - N/A\r\n");
        trame[j]=42;
        j++;
    }
    i++;
    if(ordo[i]==1){
        printf("Capteur 5 actif - GNSS \r\n");
        trame[j]=42;
        j++;
    }
    i++;
    if(ordo[i]==1){
        printf("Capteur 6 actif - O3\r\n"); /* Alphasense */
        trame[j]=42;
        j++;
    }
    i++;
    if(ordo[i]==1){
        printf("Capteur 7 actif - NO2\r\n"); /* Alphasense */
        trame[j]=42;
        j++;
    }
    i++;
    if(ordo[i]==1){
        printf("Capteur 8 actif - CO2\r\n"); /* Rechercher */
        trame[j]=42;
        j++;
    }
    i++;
    if(ordo[i]==1){
        printf("Capteur 9 actif - eCO2 / VOC \r\n"); /* BME690, CCS811, SGP30 */
        trame[j]=42;
        j++;
    }
    i++;
    if(ordo[i]==1){
        printf("Capteur 10 actif - PM2.5 / PM10 \r\n"); /* plantower, omron, sds */
        trame[j]=42;
        j++;
    }
    i++;
    if(ordo[i]==1){
        printf("Capteur 11 actif - Pression \r\n");
        trame[j]=42;
        j++;
    }
    i++;
    if(ordo[i]==1){
        printf("Capteur 12 actif - Humidite\r\n");
        trame[j]=42;
        j++;
    }
    i++;
    if(ordo[i]==1){
        printf("Capteur 13 actif - Temperature\r\n"); /* LM35 */
        trame[j]=42;
        j++;
    }
    printf("Taille = %d La trame = \r\n",j);
    for(uint8_t t=0;t<j;t++){
        printf("%d \r\n",trame[t]);
    }   
    j=0;
}

int main()
{
    ccs811.init();
    // Assign functions to button
    button.fall(&pressed);

    while (1) {
        led = !led;
    }
}
