#include "PMS7003.h"

PMS7003::PMS7003(Serial* serial)
{
    this->serial = serial;
    serial->baud(9600);
    pm10_count = 0;
    pm2_5_count = 0;
}

float PMS7003::getPM10()
{
    return pm10_count;
}

float PMS7003::getPM2_5()
{
    return pm2_5_count;
}

float PMS7003::getPM1()
{
    return pm1_count;
}

void PMS7003::read() 
{
    serial->read(buffer, PACKET_SIZE, NULL);
    if(buffer[1]==0x42){
        if(buffer[2]==0x4d){
            pm10_count = ((buffer[9] << 8) + buffer[10]);
            pm2_5_count = ((buffer[7] << 8) + buffer[8]);
            pm1_count = ((buffer[5] << 8) + buffer[6]);
        }
    }
}