#pragma once

#include "mbed.h"

class HPMA115S0
{

public:
    HPMA115S0(Serial* serial);
    void read();
    void start();
    void stop();
    void set_customer_coef();
    void read_customer_coef();
    void stop_autosend();
    void enable_autosend();
    void read_autosend();
    float getPM10();
    float getPM2_5();
private:
    Serial* serial;
    float pm10_count;
    float pm2_5_count;

    static const uint8_t PACKET_SIZE = 32;
    uint8_t buffer[PACKET_SIZE];

};