#include "HPMA115S0.h"

HPMA115S0::HPMA115S0(Serial* serial)
{
    this->serial = serial;
    serial->baud(9600);
    pm10_count = 0;
    pm2_5_count = 0;
}

float HPMA115S0::getPM10()
{
    return pm10_count;
}

float HPMA115S0::getPM2_5()
{
    return pm2_5_count;
}

void HPMA115S0::read() 
{
    uint8_t msg[4]={0x68,0x01,0x04,0x93};
    uint8_t ack[8]={0,0,0,0,0,0,0,0};
    printf("%d %d  %d %d %d %d\r\n",ack[0],ack[1],ack[2],ack[3],ack[4],ack[5]);
    serial->write(msg, sizeof(msg), NULL);
    while(serial->readable()==0){}
    if(serial->readable()==1){
       //serial->read(ack, sizeof(ack), NULL);
       for(int i=0;i<8;i++){
            ack[i]=serial->getc();
        }
    }
    printf("%d %d %d %d %d %d %d %d\r\n",ack[0],ack[1],ack[2],ack[3],ack[4],ack[5],ack[6],ack[7]);
    pm10_count = ((ack[6] << 8) + ack[7]);
    pm2_5_count = ((ack[4] << 8) + ack[5]);
}

void HPMA115S0::start() 
{
    uint8_t msg[4]={0x68,0x01,0x01,0x96};
    uint8_t ack[2]={0,0};
    printf("%d %d \r\n",ack[0],ack[1]);
    serial->write(msg, sizeof(msg), NULL);
    while(serial->readable()==0){}
    if(serial->readable()==1){
       //serial->read(ack, sizeof(ack), NULL);
        ack[0]=serial->getc();
        ack[1]=serial->getc();
    }
    printf("%d %d \r\n",ack[0],ack[1]);
}


void HPMA115S0::stop() 
{
    uint8_t msg[4]={0x68,0x01,0x02,0x95};
    uint8_t ack[2]={0,0};
    printf("%d %d \r\n",ack[0],ack[1]);
    serial->write(msg, sizeof(msg), NULL);
    while(serial->readable()==0){}
    if(serial->readable()==1){
       //serial->read(ack, sizeof(ack), NULL);
        ack[0]=serial->getc();
        ack[1]=serial->getc();
    }
    printf("%d %d \r\n",ack[0],ack[1]);
}


void HPMA115S0::set_customer_coef() 
{
    uint8_t msg[5]={0x68,0x01,0x08,0x64, 0x2A};
    uint8_t ack[2]={0,0};
    printf("%d %d \r\n",ack[0],ack[1]);
    serial->write(msg, sizeof(msg), NULL);
    while(serial->readable()==0){}
    if(serial->readable()==1){
       //serial->read(ack, sizeof(ack), NULL);
        ack[0]=serial->getc();
        ack[1]=serial->getc();
    }
    printf("%d %d \r\n",ack[0],ack[1]);
}


void HPMA115S0::read_customer_coef() 
{
    uint8_t msg[4]={0x68,0x01,0x10,0x87};
    uint8_t ack[2]={0,0};
    printf("%d %d \r\n",ack[0],ack[1]);
    serial->write(msg, sizeof(msg), NULL);
    while(serial->readable()==0){}
    if(serial->readable()==1){
       //serial->read(ack, sizeof(ack), NULL);
        ack[0]=serial->getc();
        ack[1]=serial->getc();
    }
    printf("%d %d \r\n",ack[0],ack[1]);
}


void HPMA115S0::stop_autosend() 
{
    uint8_t msg[4]={0x68,0x01,0x20,0x77};
    char ack[2]={0,0};
    printf("%d %d \r\n",ack[0],ack[1]);
    serial->write(msg, sizeof(msg), NULL);
    while(serial->readable()==0){}
    if(serial->readable()==1){
       //serial->read(ack, sizeof(ack), NULL);
        ack[0]=serial->getc();
        ack[1]=serial->getc();
    }
    printf("%d %d\r\n",ack[0],ack[1]);
}

void HPMA115S0::enable_autosend() 
{
    uint8_t msg[4]={0x68,0x01,0x40,0x57};
    uint8_t ack[2]={0,0};
    printf("%d %d \r\n",ack[0],ack[1]);
    serial->write(msg, sizeof(msg), NULL);
    while(serial->readable()==0){}
    if(serial->readable()==1){
       //serial->read(ack, sizeof(ack), NULL);
        ack[0]=serial->getc();
        ack[1]=serial->getc();
    }
    printf("%d %d \r\n",ack[0],ack[1]);
}

void HPMA115S0::read_autosend() 
{
    printf("yo\r\n");
    while(serial->readable()==0){}
    if(serial->readable()==1){
        serial->read(buffer, PACKET_SIZE, NULL);
        for(int i=1;i<33;i++){
            printf("%d ",buffer[i]);
        }
        if(buffer[1]==0x42){
            if(buffer[2]==0x4d){
                pm10_count = ((buffer[9] << 8) + buffer[10]);
                pm2_5_count = ((buffer[7] << 8) + buffer[8]);
            }
        }
    }
}