#include "NovaSDS011.h"

NovaSDS011::NovaSDS011(Serial* serial)
{
    this->serial = serial;
    serial->baud(9600);
    pm10_count = 0;
    pm2_5_count = 0;
}

float NovaSDS011::getPM10()
{
    return pm10_count;
}

float NovaSDS011::getPM2_5()
{
    return pm2_5_count;
}

void NovaSDS011::read() 
{
    while(serial->readable()==0){}
    if(serial->readable()==1){
        serial->read(buffer, PACKET_SIZE, NULL);
        printf("%d %d %d %d %d %d %d %d %d %d\r\n",buffer[0],buffer[1],buffer[2],buffer[3],buffer[4],buffer[5],buffer[6],buffer[7],buffer[8],buffer[9]);
    }
    if(buffer[9] == 0xAB) {
        printf("yo\r\n");
        pm10_count = ((buffer[6] << 8) + buffer[3]) / 10.0;
        pm2_5_count = ((buffer[4] << 8) + buffer[3]) / 10.0;
    }
}