#include "Alphasense.h"
#include "Adafruit_ADS1015.h"

ALPHASENSE::ALPHASENSE(I2C* i2c, int num_chan_op1, int num_chan_op2, int we0, int ae0, int sensitivity, int n_sample) : _i2c(i2c), _num_chan_op1(num_chan_op1), _num_chan_op2(num_chan_op2), _we0(we0), _ae0(ae0), _sensitivity(sensitivity), _n_sample(n_sample) {   
}

float ALPHASENSE::measure() {
    double we_result, ae_result;
    float result;
    int we, ae, we_integral, ae_integral;
    
    Adafruit_ADS1115 ads(_i2c); //init ads1115
    ads.setGain(GAIN_TWO); //set range to 2.048 V
    
    for (int i=0; i<_n_sample; i++)
    {
        we = ads.readADC_SingleEnded(_num_chan_op1); // read channel
        ae = ads.readADC_SingleEnded(_num_chan_op2);
        we_integral += we;
        ae_integral += ae;
    }

    we_result = we_integral / _n_sample; //smoothing result
    ae_result = ae_integral / _n_sample;
    
    we_result = we_result * 0.0625; //conversion to mV (2048 / 65536)
    ae_result = ae_result * 0.0625;
    
    we_integral = 0; //reset integral
    ae_integral = 0;
    
    result = (((we_result - _we0) - (ae_result - _ae0)) / _sensitivity) * 1000; //conversion to ppb

    return result;
}