template <class Result>
class handler
{
public:
  virtual inline Result operator() () const {};
};

template <class Result>
class function_handler
: public handler <Result>
{
protected:
  Result (*pfunc)();
public:
  explicit inline function_handler ( Result (*f)() ) : pfunc (f) {}
  virtual inline Result operator() () const { return pfunc(); }
};

template <class Type, class Result>
class member_handler
: public handler <Result>
{
protected:
  Type *inst;
  Result (Type::*pfunc)();
public:
  explicit inline member_handler ( Type *i, Result (Type::*f)() ) : inst(i), pfunc (f) {}
  virtual inline Result operator() () const { return (inst->*pfunc)(); }
};