#define _XBEE_DEBUG 0
#if _XBEE_DEBUG > 0

#include "mbed.h"

#include "XBee.hpp"

XBee xb("TEST_UID", p28, p27, p26, p21);
Serial usb(USBTX, USBRX);

void usbrx() {
    static string msg;
    
    while (usb.readable())
    {
        int ch = usb.getc();
        switch (ch)
        {
            case '\r':
            case '\n':
                if (msg.length() == 0) break;
                xb.broadcast(msg);
                msg = "";
                usb.printf("<sent>\r\n");
                break;
                
            default:
                msg += string(1, ch);
                usb.putc(ch); // echo
                break;
        }
    }
}

void xbrx() {
    while (xb.readable())
    {
        usb.printf("XBEE RX\r\n");
        XBeePacket pkt = xb.read();
        vector<string> data = pkt.split_data();
        for (int i = 0; i < data.size(); ++i)
            usb.printf("> %s\r\n", data[i].c_str());
    }
}

int main() {
    usb.attach(usbrx);
    xb.attach(xbrx);
    
    while(1)
    {
        wait(1);
    }
}

#endif