#ifndef UDP_H
#define UDP_H

#include "net.h"

/**
  \file udp.h
  \brief UDP packet
  
  This file contains the memory map and associated functions for UDP packet
  creation and deconstruction. 
*/

#define IPPROTO_UDP 0x11

/// UDP Packet memory map
typedef struct {
  u16 source_port;       ///< Source port (1-65535)
  u16 destination_port;  ///< Destination port (1-65535) 
  u16 length;            ///< Entire datagram size in bytes
  u16 checksum;          ///< Checksum
  u8 data[];             ///< Data memory map
} UDP_Packet;

/// Convert from wire to host or host to wire endianness
inline void fix_endian_udp(UDP_Packet *segment)
{
  fix_endian_u16(&segment->source_port);
  fix_endian_u16(&segment->destination_port);
  fix_endian_u16(&segment->length);
}

/// Print the UDP packet
inline void print_udp(UDP_Packet *segment)
{
  main_log.printf("UDP Packet:");
  main_log.printf("  Source:    PORT %d", segment->source_port);
  main_log.printf("  Dest:      PORT %d", segment->destination_port);
  main_log.printf("  Length:    %d", segment->length);
}

#endif