#ifndef UTIL_H
#define UTIL_H

#include "types.h"
//#include "log.h"

/**
  \file util.h
  \brief Primary utility header
  
  In addition to providing some utility functions, this file also includes
  the other utility headers automatically.
*/

/// Is any byte memory at start for bytes nonzero?
inline bool is_nonzero_mem(u8 *start, unsigned int bytes)
{
  for (; bytes--; ++start) if (*start) return true;
  return false;
}

/// Are all bytes at start for bytes zero?
inline bool is_zero_mem(u8 *start, unsigned int bytes)
{
  for (; bytes--; ++start) if (*start) return false;
  return true;
}

/// Are the memory locations at and and b equal for bytes?
inline bool is_equal_mem(u8 *a, u8 *b, unsigned int bytes)
{
  for (; bytes--; ++a, ++b) if (*a != *b) return false;
  return true;
}

#endif