#ifndef _AlphaNumDisplayH
#define _AlphaNumDisplayH

#include "mbed.h"
#define ALPHA_NUM_SYMBOLS 39
#define ALPHA_NUM_CHECK '^'
#define ALPHA_NUM_CHECK_I 38
#define ALPHA_NUM_STAR '*'
#define ALPHA_NUM_STAR_I 37
#define ALPHA_NUM_CLEAR ' '
#define ALPHA_NUM_CLEAR_I 10
#define ALPHA_NUM_A_I 11
#define ALPHA_NUM_ZERO_I 0


/** This class creates an 11 pin connection to an 
 *  alpha numeric display. Is capable of displaying
 *  all alphanumeric characters, a check mark ('^'),
 *  a star ('*') or nothing (' ').
 */
class AlphaNumDisplay {

private:
    // Display bars
    DigitalOut m_htop;                          ///< Top Horizontal Bar 
    DigitalOut m_hmiddle;                       ///< Middle Horizontal Bar
    DigitalOut m_hbottom;                       ///< Bottom Horizontal Bar
    DigitalOut m_vtopleft;                      ///< Top Left Vertical Bar
    DigitalOut m_vbottomleft;                   ///< Bottom Left Vertical Bar
    DigitalOut m_vtopmiddle;                    ///< Top Middle Vertical Bar
    DigitalOut m_vbottommiddle;                 ///< Bottom Middle Vertical Bar
    DigitalOut m_vtopright;                     ///< Top Right Vertical Bar
    DigitalOut m_vbottomright;                  ///< Bottom Right Vertical Bar
    DigitalOut m_dtopleft;                      ///< Top left to bottom right
    DigitalOut m_dtopright;                     ///< Bottom left to top right
    static unsigned char m_alphadisplay[][11];  ///< Table of symbols
    
public:
    /** output pins using the naming scheme of h - horizontal, v - vertical,
     *  d - diagonal, t - top, b - bottom, l - left, r - right, m - middle
     */
    AlphaNumDisplay(PinName ht, PinName hm, PinName hb, PinName vtl,
                    PinName vbl, PinName vtm, PinName vbm, PinName vtr,
                    PinName vbr, PinName dtl, PinName dtr);
    /** display the character. Case insensitive. Numerals can be
     *  input either as their numerical value or as characters.
     *  '^' for check mark, '*' for star, ' ' for space.
     */ 
    void display(unsigned char c); 

};    

#endif