#include "mbed.h"
#include "AlphaNumDisplay.hpp"

unsigned char AlphaNumDisplay::m_alphadisplay[][11]= { // < Table of symbols
        {0, 1, 0, 0, 0, 1, 1, 0, 0, 1, 0 }, // 0
        {1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1 }, // 1
        {0, 0, 0, 1, 0, 1, 1, 0, 1, 1, 0 }, // 2
        {0, 0, 0, 1, 1, 1, 1, 0, 0, 1, 1 }, // 3
        {1, 0, 1, 0, 1, 0, 0, 1, 1, 1, 1 }, // 4
        {0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1 }, // 5
        {0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1 }, // 6
        {0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0 }, // 7
        {0, 0, 0, 0, 0, 1, 1, 0, 0, 1, 1 }, // 8
        {0, 0, 1, 0, 1, 1, 1, 0, 0, 1, 1 }, // 9
        {1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 }, // blank
        {0, 0, 1, 0, 0, 1, 1, 0, 0, 1, 1 }, // A
        {1, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1 }, // B
        {0, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1 }, // C
        {1, 0, 0, 1, 0, 1, 1, 0, 0, 1, 1 }, // D
        {0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1 }, // E
        {0, 0, 1, 0, 0, 1, 1, 1, 1, 1, 1 }, // F
        {0, 0, 0, 0, 0, 1, 1, 1, 0, 1, 1 }, // G
        {1, 0, 1, 0, 0, 1, 1, 0, 0, 1, 1 }, // H
        {0, 1, 0, 1, 1, 0, 0, 1, 1, 1, 1 }, // I
        {1, 1, 0, 1, 0, 1, 1, 0, 0, 1, 1 }, // J
        {1, 0, 1, 0, 0, 0, 1, 1, 0, 1, 1 }, // K
        {1, 1, 0, 0, 0, 1, 1, 1, 1, 1, 1 }, // L
        {0, 1, 1, 0, 0, 0, 1, 0, 0, 1, 1 }, // M
        {1, 1, 1, 0, 0, 1, 1, 0, 0, 0, 1 }, // N
        {0, 1, 0, 0, 0, 1, 1, 0, 0, 1, 1 }, // O
        {0, 0, 1, 0, 0, 1, 1, 0, 1, 1, 1 }, // P
        {0, 0, 1, 0, 1, 1, 1, 0, 0, 1, 1 }, // Q
        {0, 0, 1, 0, 0, 1, 1, 0, 1, 0, 1 }, // R
        {0, 0, 0, 0, 1, 1, 1, 1, 0, 1, 1 }, // S
        {0, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1 }, // T
        {1, 1, 0, 0, 0, 1, 1, 0, 0, 1, 1 }, // U
        {1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 1 }, // V
        {1, 1, 0, 0, 0, 1, 0, 0, 0, 1, 1 }, // W
        {1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0 }, // X
        {1, 0, 1, 0, 1, 1, 0, 0, 1, 1, 1 }, // Y
        {0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 0 }, // Z
        {1, 0, 1, 1, 1, 0, 0, 1, 1, 0, 0 }, // *
        {1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0 }  // check mark   
    };
    
    AlphaNumDisplay::AlphaNumDisplay(PinName ht, PinName hm, PinName hb,
        PinName vtl, PinName vbl, PinName vtm, PinName vbm, 
        PinName vtr, PinName vbr, PinName dtl, PinName dtr)
    : m_htop(ht), m_hmiddle(hm), m_hbottom(hb), m_vtopleft(vtl), m_vbottomleft(vbl),
        m_vtopmiddle(vtm),  m_vbottommiddle(vbm),  m_vtopright(vtr),  m_vbottomright(vbr),
        m_dtopleft(dtl), m_dtopright(dtr) 
    {
    }
      
    void AlphaNumDisplay::display(unsigned char c) {
        unsigned char index = ALPHA_NUM_CLEAR_I;
        if(c == ALPHA_NUM_CHECK) index = ALPHA_NUM_CHECK_I;
        if(c == ALPHA_NUM_CLEAR) index = ALPHA_NUM_CLEAR_I;
        if(c == ALPHA_NUM_STAR)  index = ALPHA_NUM_STAR_I;
        if(c < 10)               index = c + ALPHA_NUM_ZERO_I;
        if(c >= '0' && c <= '9') index = c - '0' + ALPHA_NUM_ZERO_I;
        if(c >= 'a' && c <= 'z') index = c - 'a' + ALPHA_NUM_A_I;
        if(c >= 'A' && c <= 'Z') index = c - 'A' + ALPHA_NUM_A_I;
    
        m_htop = AlphaNumDisplay::m_alphadisplay[index][0];
        m_hmiddle = AlphaNumDisplay::m_alphadisplay[index][1];
        m_hbottom = AlphaNumDisplay::m_alphadisplay[index][2];
        m_vtopleft = AlphaNumDisplay::m_alphadisplay[index][3];
        m_vbottomleft = AlphaNumDisplay::m_alphadisplay[index][4];
        m_vtopmiddle = AlphaNumDisplay::m_alphadisplay[index][5];
        m_vbottommiddle = AlphaNumDisplay::m_alphadisplay[index][6];
        m_vtopright = AlphaNumDisplay::m_alphadisplay[index][7];
        m_vbottomright = AlphaNumDisplay::m_alphadisplay[index][8];
        m_dtopleft = AlphaNumDisplay::m_alphadisplay[index][9];
        m_dtopright = AlphaNumDisplay::m_alphadisplay[index][10];        
    }