#ifndef _TAGCONNECTION
#define _TAGCONNECTION

#include "mbed.h"
#include "iHvZ.hpp"
#include "XBee.hpp"

/** Connection between devices for the purpose of tagging and stunning
 */
class Tag {
private:
    iHvZ        *m_game;            //< Maintain a connection to the active game

    DigitalIn    m_tag;             //< Check the status of the tagging/stunning button
    InterruptIn  m_tag_int;         //< Get an interrupt whenever the tag/stun button is hit
    Timeout      m_timeout;         //< Get an interrupt when a timeout occurs

    typedef enum {
      TAG_EVENT_UNKNOWN = 0,
      TAG_EVENT_BUTTON,
      TAG_EVENT_RX,
      TAG_EVENT_TIMEOUT,
    } TagEvent;
    
    typedef enum {
      TAG_STATE_WAITING = 0,
      // Sending states
      TAG_STATE_TX_SEND,
      TAG_STATE_TX_WAITACK,
      TAG_STATE_TX_WAITBTN,
      TAG_STATE_TX_SENDCOMP,
      // Receiving states
      TAG_STATE_RX_RECV,
      TAG_STATE_RX_WAITBTN,
      TAG_STATE_RX_SENDACK,
      TAG_STATE_RX_WAITCOMP
    } TagState;

public:
    /**
     * Create a new Tag
     */
    Tag(iHvZ *game, PinName tagbtn);
    
private:
    inline void rise();
    inline void rx();
    inline void timeout();
    
    // Defined in Tag.cpp
    void event(TagEvent ev = TAG_EVENT_UNKNOWN);

};

#endif