#include "mbed.h"
#include "lib/iHvZ.hpp"
#include "XBee.hpp"
#include "string.h"

iHvZ        game("TEST_UID");
Serial      usb(USBTX, USBRX);
DigitalOut  human_led(LED1);

void dots() {
    usb.printf(".");
}

Ticker      dotter;

int main() {
    dotter.attach(dots, 10);
    
    usb.printf("Starting iHvZ:\r\n");
    
    if (game.load())
    {
        usb.printf(" - Loading state from file\r\n");
    }
    else
    {
        usb.printf(" - Starting as ZOMBIE (no file read)\r\n");
        //game.life("FAKE_TID");
    }
    game.save();
    
    while(1)
    {        
        //(game.alphanumdisplay_device()).display('H');
        human_led = game.status() == STATUS_HUMAN;
        wait(.1);
    }
}
