#ifndef _Stun
#define _Stun

#include "mbed.h"

class Stun {
private:
    
    // Tag status and timing
    bool     m_is_stunned;     //< Whether currently stunned or not
    // Game options
    unsigned m_stun_time;     //< Total duration of current stun
    Timer    m_stun_timer;     //< Current amount of stun
    Timeout  m_stun_timeout;   //< Triggers when the stun is over
    Ticker   m_stun_ticker;    //< Ticks for the duration of the stun
    
    // Tag LED
    DigitalOut m_stun_led;
    
public:
    inline Stun(PinName stun_led)
    : m_is_stunned(false), m_stun_time(0), m_stun_led(stun_led)
    {
    }
    
    /// Get the stun status
    inline bool stunned() { return m_is_stunned; }
    
    /// Get the stun time remaining
    inline int stunleft()
    {
        if (!m_is_stunned) return 0;
        return m_stun_time - m_stun_timer.read();
    }

    /* Actions */
    inline void stun(unsigned duration)
    {
        m_is_stunned = true;
        m_stun_time = duration;
        m_stun_timeout.attach(this, &Stun::stun_expire, m_stun_time);
        m_stun_ticker.attach(this, &Stun::stun_tick, 1);
        m_stun_timer.start();
        m_stun_led = 1;
    }

private:
    inline void stun_tick()
    {
    
    }

    inline void stun_expire()
    {
        m_is_stunned = false;
        m_stun_ticker.detach();
        m_stun_timer.stop();
        m_stun_timer.reset();
        m_stun_led = 0;
        m_stun_time = 0;
        
    }
};


#endif