#ifndef MPU9150_H_
#define MPU9150_H_

#include "mbed.h"
#include "I2CHelper.h"

#define MPU9150_ADDRESS_AD0_LOW         0x68
#define MPU9150_ADDRESS_AD0_HIGH        0x69
#define MPU9150_ADDRESS_DEFAULT         MPU9150_ADDRESS_AD0_LOW

#define MPU9150_RA_SELF_TEST_X          0x0D
#define MPU9150_RA_SELF_TEST_Y          0x0E
#define MPU9150_RA_SELF_TEST_Z          0x0F
#define MPU9150_RA_SELF_TEST_A          0x10
#define MPU9150_RA_SMPRT_DIV            0x19
#define MPU9150_RA_CONFIG               0x1A
#define MPU9150_RA_GYRO_CONFIG          0x1B
#define MPU9150_RA_ACCEL_CONFIG         0x1C
#define MPU9150_RA_FIFO_EN              0x23
#define MPU9150_RA_I2C_MST_CTRL         0x24
#define MPU9150_RA_I2C_SLV0_ADDR        0x25
#define MPU9150_RA_I2C_SLV0_REG         0x26
#define MPU9150_RA_I2C_SLV0_CTRL        0x27
#define MPU9150_RA_I2C_SLV1_ADDR        0x28
#define MPU9150_RA_I2C_SLV1_REG         0x29
#define MPU9150_RA_I2C_SLV1_CTRL        0x2A
#define MPU9150_RA_I2C_SLV2_ADDR        0x2B
#define MPU9150_RA_I2C_SLV2_REG         0x2C
#define MPU9150_RA_I2C_SLV2_CTRL        0x2D
#define MPU9150_RA_I2C_SLV3_ADDR        0x2E
#define MPU9150_RA_I2C_SLV3_REG         0x2F
#define MPU9150_RA_I2C_SLV3_CTRL        0x30
#define MPU9150_RA_I2C_SLV4_ADDR        0x31
#define MPU9150_RA_I2C_SLV4_REG         0x32
#define MPU9150_RA_I2C_SLV4_DO          0x33
#define MPU9150_RA_I2C_SLV4_CTRL        0x34
#define MPU9150_RA_I2C_SLV4_DI          0x35
#define MPU9150_RA_I2C_MST_STATUS       0x36
#define MPU9150_RA_INT_PIN_CFG          0x37
#define MPU9150_RA_INT_ENABLE           0x38
#define MPU9150_RA_INT_STATUS           0x3A
#define MPU9150_RA_ACCEL_XOUT_H         0x3B
#define MPU9150_RA_ACCEL_XOUT_L         0x3C
#define MPU9150_RA_ACCEL_YOUT_H         0x3D
#define MPU9150_RA_ACCEL_YOUT_L         0x3E
#define MPU9150_RA_ACCEL_ZOUT_H         0x3F
#define MPU9150_RA_ACCEL_ZOUT_L         0x40
#define MPU9150_RA_TEMP_OUT_H           0x41
#define MPU9150_RA_TEMP_OUT_L           0x42
#define MPU9150_RA_GYRO_XOUT_H          0x43
#define MPU9150_RA_GYRO_XOUT_L          0x44
#define MPU9150_RA_GYRO_YOUT_H          0x45
#define MPU9150_RA_GYRO_YOUT_L          0x46
#define MPU9150_RA_GYRO_ZOUT_H          0x47
#define MPU9150_RA_GYRO_ZOUT_L          0x48
#define MPU9150_RA_EXT_SENS_DATA_00     0x49
#define MPU9150_RA_EXT_SENS_DATA_01     0x4A
#define MPU9150_RA_EXT_SENS_DATA_02     0x4B
#define MPU9150_RA_EXT_SENS_DATA_03     0x4C
#define MPU9150_RA_EXT_SENS_DATA_04     0x4D
#define MPU9150_RA_EXT_SENS_DATA_05     0x4E
#define MPU9150_RA_EXT_SENS_DATA_06     0x4F
#define MPU9150_RA_EXT_SENS_DATA_07     0x50
#define MPU9150_RA_EXT_SENS_DATA_08     0x51
#define MPU9150_RA_EXT_SENS_DATA_09     0x52
#define MPU9150_RA_EXT_SENS_DATA_10     0x53
#define MPU9150_RA_EXT_SENS_DATA_11     0x54
#define MPU9150_RA_EXT_SENS_DATA_12     0x55
#define MPU9150_RA_EXT_SENS_DATA_13     0x56
#define MPU9150_RA_EXT_SENS_DATA_14     0x57
#define MPU9150_RA_EXT_SENS_DATA_15     0x58
#define MPU9150_RA_EXT_SENS_DATA_16     0x59
#define MPU9150_RA_EXT_SENS_DATA_17     0x5A
#define MPU9150_RA_EXT_SENS_DATA_18     0x5B
#define MPU9150_RA_EXT_SENS_DATA_19     0x5C
#define MPU9150_RA_EXT_SENS_DATA_20     0x5D
#define MPU9150_RA_EXT_SENS_DATA_21     0x5E
#define MPU9150_RA_EXT_SENS_DATA_22     0x5F
#define MPU9150_RA_EXT_SENS_DATA_23     0x60
#define MPU9150_RA_I2C_SLV0_DO          0x63
#define MPU9150_RA_I2C_SLV1_DO          0x64
#define MPU9150_RA_I2C_SLV2_DO          0x65
#define MPU9150_RA_I2C_SLV3_DO          0x66
#define MPU9150_RA_I2C_MST_DELAY_CTRL   0x67
#define MPU9150_RA_SIGNAL_PATH_RESET    0x68
#define MPU9150_RA_USER_CTRL            0x6A
#define MPU9150_RA_PWR_MGMT_1           0x6B
#define MPU9150_RA_PWR_MGMT_2           0x6C
#define MPU9150_RA_FIFO_COUNTH          0x72
#define MPU9150_RA_FIFO_COUNTL          0x73
#define MPU9150_RA_FIFO_R_W             0x74
#define MPU9150_RA_WHO_AM_I             0x75

// CONFIG Register
#define MPU9150_EXT_SYNC_DISABLED       0x00
#define MPU9150_EXT_SYNC_TEMP_OUT_L     0x01
#define MPU9150_EXT_SYNC_GYRO_XOUT_L    0x02
#define MPU9150_EXT_SYNC_GYRO_YOUT_L    0x03
#define MPU9150_EXT_SYNC_GYRO_ZOUT_L    0x04
#define MPU9150_EXT_SYNC_ACCEL_XOUT_L   0x05
#define MPU9150_EXT_SYNC_ACCEL_YOUT_L   0x06
#define MPU9150_EXT_SYNC_ACCEL_ZOUT_L   0x07
#define MPU9150_DLPF_BW_256             0x00
#define MPU9150_DLPF_BW_188             0x01
#define MPU9150_DLPF_BW_98              0x02
#define MPU9150_DLPF_BW_42              0x03
#define MPU9150_DLPF_BW_20              0x04
#define MPU9150_DLPF_BW_10              0x05
#define MPU9150_DLPF_BW_5               0x06

// GYRO_CONFIG Register
#define MPU9150_GYRO_FS_250             0x00
#define MPU9150_GYRO_FS_500             0x01
#define MPU9150_GYRO_FS_1000            0x02
#define MPU9150_GYRO_FS_2000            0x03

// ACCEL_CONFIG Register
#define MPU9150_ACCEL_FS_2              0x00
#define MPU9150_ACCEL_FS_4              0x01
#define MPU9150_ACCEL_FS_8              0x02
#define MPU9150_ACCEL_FS_16             0x03

// SIGNAL_PATH_RESET Register
#define MPU9150_SIGNAL_PATH_GYRO_RESET  0x04
#define MPU9150_SIGNAL_PATH_ACCEL_RESET 0x02
#define MPU9150_SIGNAL_PATH_TEMP_RESET  0x01

// USER_CTRL Register
#define MPU9150_USER_CTRL_FIFO_EN       0x40
#define MPU9150_USER_CTRL_I2C_MST_EN    0x20
#define MPU9150_USER_CTRL_FIFO_RESET    0x04
#define MPU9150_USER_CTRL_I2C_MST_RESET 0x02
#define MPU9150_USER_CTRL_SIG_RESET     0x01

// PWR_MGMT_1 Register
#define MPU9150_PWR_MGMT_DEVICE_RESET   0x80
#define MPU9150_PWR_MGMT_SLEEP          0x40
#define MPU9150_PWR_MGMT_CYCLE          0x20
#define MPU9150_PWR_MGMT_TEMP_DISABLE   0x08
#define MPU9150_PWR_MGMT_CLOCK_INTERNAL 0x00
#define MPU9150_PWR_MGMT_CLOCK_GYRO_X   0x01
#define MPU9150_PWR_MGMT_CLOCK_GYRO_Y   0x02
#define MPU9150_PWR_MGMT_CLOCK_GYRO_Z   0x03
#define MPU9150_PWR_MGMT_CLOCK_EXT_32k  0x04
#define MPU9150_PWR_MGMT_CLOCK_EXT_19M  0x05
#define MPU9150_PWR_MGMT_CLOCK_DISABLE  0x07

// PWR_MGMT_2 Register
#define MPU9150_PWR_MGMT_STBY_GYRO_Z    0x01
#define MPU9150_PWR_MGMT_STBY_GYRO_Y    0x02
#define MPU9150_PWR_MGMT_STBY_GYRO_X    0x04
#define MPU9150_PWR_MGMT_STBY_ACCEL_Z   0x08
#define MPU9150_PWR_MGMT_STBY_ACCEL_Y   0x10
#define MPU9150_PWR_MGMT_STBY_ACCEL_X   0x20
#define MPU9150_PWR_MGMT_CYCLE_1_25HZ   0x00
#define MPU9150_PWR_MGMT_CYCLE_5HZ      0x01
#define MPU9150_PWR_MGMT_CYCLE_20HZ     0x02
#define MPU9150_PWR_MGMT_CYCLE_40HZ     0x03

class MPU9150 {
public:
    MPU9150();
    explicit MPU9150(const bool AD0);
    MPU9150(const PinName sda, const PinName scl, const bool AD0);
    
    void initialize();
    bool test();
    
    // SMPRT_DIV Register
    uint8_t getSampleRateDivider();
    void setSampleRateDivider(const uint8_t divider);
    
    // CONFIG Register
    uint8_t getExternalFrameSync();
    void setExternalFrameSync(const uint8_t sync);
    uint8_t getDLPFBandwidth();
    void setDLPFBandwidth(const uint8_t bandwidth);
    
    // GYRO_CONFIG Register
    uint8_t getGyroFullScaleRange();
    void setGyroFullScaleRange(const uint8_t range);
    
    // ACCEL_CONFIG Register
    uint8_t getAccelFullScaleRange();
    void setAccelFullScaleRange(const uint8_t range);
    
    // ACCEL_OUT_* Registers
    int16_t getAccelX();
    int16_t getAccelY();
    int16_t getAccelZ();
    
    // TEMP_OUT_* Registers
    int16_t getTemp();
    
    // GYRO_OUT_* Registers
    int16_t getGyroX();
    int16_t getGyroY();
    int16_t getGyroZ();
    
    // SIGNAL_PATH_RESET Register
    void resetGyroPath();
    void resetAccelPath();
    void resetTempPath();
    
    // USER_CTRL Register
    bool getFifoEnabled();
    void setFifoEnabled(const bool fifo);
    bool getI2CMasterEnabled();
    void setI2CMasterEnabled(const bool master);
    void resetFifo();
    void resetI2CMaster();
    void resetSensors();
    
    // PWR_MGMT_1 Register
    void reset();
    bool getSleepEnabled();
    void setSleepEnabled(const bool sleep);
    bool getCycleEnabled();
    void setCycleEnabled(const bool cycle);
    bool getTempEnabled();
    void setTempEnabled(const bool temp);
    uint8_t getClockSource();
    void setClockSource(const uint8_t source);
    
    // PWR_MGMT_2 Register
    uint8_t getCycleFrequency();
    void setCycleFrequency(const uint8_t frequency);
    bool getStandbyAccelXEnabled();
    void setStandbyAccelXEnabled(const bool enabled);
    bool getStandbyAccelYEnabled();
    void setStandbyAccelYEnabled(const bool enabled);
    bool getStandbyAccelZEnabled();
    void setStandbyAccelZEnabled(const bool enabled);
    bool getStandbyGyroXEnabled();
    void setStandbyGyroXEnabled(const bool enabled);
    bool getStandbyGyroYEnabled();
    void setStandbyGyroYEnabled(const bool enabled);
    bool getStandbyGyroZEnabled();
    void setStandbyGyroZEnabled(const bool enabled);
    
    // WHO_AM_I Register
    uint8_t getDeviceID();

private:
    I2CHelper i2c_;
    uint8_t address_;
    uint8_t accelRange_;
    uint8_t gyroRange_;
};

#endif