#include "mbed.h"
#include "uLCD_4DGL.h"

AnalogIn input(p20);
uLCD_4DGL lcd(p9, p10, p11);
DigitalOut M(p25);
#include "NeoMatrix.h"

#define Color(r, g, b)  ((r&0xFF)<<16 | (g&0xFF) << 8 | (b&0xFF))   // pack colors

#define Red     (Color(255,0,0))
#define Green   (Color(0,255,0))
#define Blue    (Color(0,0,255))

NeoArr array(p18, 1);   // Initialize the array


void drawSpec (float x)
{
    int y = (x-30)/45.0*8.0;

    for (int i = 0; i<8; i++) {
        if(y<2)
        {M=0;}
        array.setPixel(0, i, 0, 0xff0080);
        if(y>0) {
            array.setPixel(0, i, 1, 0xbf000f);
        }
        if(y>1) {
            array.setPixel(0, i, 2, 0x4000ff);
        }
        if(y>2) {
                 M = 1;
            array.setPixel(0, i, 3, 0x00bfff);
        }
        if(y>3) {
       
            array.setPixel(0, i, 4, 0x00ff00);
        }
        if(y>4) {
            array.setPixel(0, i, 5, 0xffff00);
        }
        if(y>5) {
            
            array.setPixel(0, i, 6, 0xff8000);
        }
        if(y>6) {
            array.setPixel(0, i, 7, 0xff0000);
        }
    }
    array.write();
}

int main()
{
    float bright = 0.2; // 20% is bright enough for most indoor use and should run without need for external power
    array.setBrightness(bright);    // set brightness to default 0.2
    array.clear();

    while(1) {
        array.clear();
        float temp = input.read()*100;
        lcd.printf("%3.3f%%\n", temp);
        drawSpec(temp);
        wait(0.01);
    }
}

/* Code Used for FFT
extern "C" void fftR4(short *y, short *x, int N);

//set up a timer for timing FFT's
Timer timer;
Ticker ticker;

//Set up filesystem so we can write some useful files
LocalFileSystem local("local");
FILE *fp;


//Set up a global buffer for audio data so interrupt can access it
int Counter = 0;
int16_t Buffer[5000];


//Initialise ADC to maximum SAMPLE_RATE and cclk divide set to 1
ADC adc(SAMPLE_RATE, 1);

//Functions to write 16 bit audio data and 32 bit headers to files in au format (cf sndRecorder Cookbook)
void fwrite16(uint16_t v) {
    uint8_t *b = (uint8_t *)&v;

    fprintf(fp,"%c%c", b[1], b[0]);
}
void fwrite32(uint32_t v) {
    uint8_t *b = (uint8_t *)&v;

    fprintf(fp,"%c%c%c%c", b[3], b[2], b[1], b[0]);
}

//Our interrupt handler for audio sampling
void sample_ADC(int chan, uint32_t value) {

    float s;
    s = adc.read(p20);
    int16_t b = (s -2048)*16;
    Buffer[Counter] = b;
    Counter += 1;

    int g = abs(s-2048);
    l1 = g > 0.1f*2048;
    l2 = g > 0.3f*2048;
    l3 = g > 0.6f*2048;
    l4 = g > 0.8f*2048;
}

void drawSpec (int x, int y){
    int realx = x/16;
    int realy = (y/64.0)*7;

    array.setPixel(0, realx, realy, 0xff0000);
    array.write();
    }
    
int main() {
    
    float bright = 0.2; // 20% is bright enough for most indoor use and should run without need for external power
    array.setBrightness(bright);    // set brightness to default 0.2
    array.clear();
    
    lcd.baudrate(3000000);

    while (1) {
        //Prepare for burst mode on all ADC pins and set up interrupt handler (using ADC library from Simon Blandford
        adc.append(sample_ADC);
        adc.startmode(0,0);
        adc.burst(1);
        adc.setup(p20,1);
        //introduce a delay as initial waveform has bias whilst decoupling cap charges
        wait(1);
        //start the interrupt and wait for about 4096 samples
        adc.interrupt_state(p20,1);
        wait(0.1);
        //Finsh up - Unset pin 20
        adc.interrupt_state(p20,0);
        adc.setup(p20,0);
        int actual_rate = adc.actual_sample_rate();

        //now lets try mellen fft
        lcd.background_color(0x0000FF);

        short mx[MN*2]; // input data 16 bit, 4 byte aligned  x0r,x0i,x1r,x1i,....
        short my[MN*2]; // output data 16 bit,4 byte aligned  y0r,y0i,y1r,y1i,....
        float data2[512];
        for (int i=0;i<MN*2;i++) mx[i]=0;

        for (int i=0;i<MN;i=i+1) {
            mx[i*2]=Buffer[i];
        }
        //FILE* mlog = fopen("/local/mellen.csv","w");
        //call functions;
        fftR4(my, mx, MN);
        for (int i=0; i<MN; i=i+2) {
            data2[i]= sqrt(float(   (my[i]*my[i])  +(my[i+1]*my[i+1])));
            //fprintf(mlog, "%d,%f\n", int(actual_rate/MN/2*i),sqrt(float(   (my[i]*my[i])  +(my[i+1]*my[i+1])) )   );
        }
        //fclose(mlog);

        //Display amplitude on LCD
        lcd.cls();
        array.clear();
        
        for (int i=0; i<128; i++) {
            data2[i+1] = 20*log10(data2[i+1]);
            drawSpec(i, data2[i+1]);
            lcd.filled_rectangle(i, 0, i+1, data2[i+1], 0x00FF00);
        }
        Counter = 0;
    }
}
*/