
//-------------------Declaration des bibliothèques------------------------------

#include "mbed.h"


//---------------------Declaration des variables--------------------------------

AnalogIn LED_verte(PC_0); // entrée signal de LED verte
AnalogIn LED_rouge(PC_1); // entrée signal de LED rouge
AnalogIn LED_bleue(PC_2); // entrée signal de LED bleue
PwmOut servo_mot(D4);  // sortie vers servomoteur Peinture Bleue
PwmOut servo_mot2(D3); // sortie vers servomoteur Peinture Magenta
PwmOut servo_mot3(D2); // sortie versservomoteur Peinture Jaune
InterruptIn my_bp(PB_10); // Déclaration de l'interruption bouton poussoir 1
InterruptIn my_bp2(PB_4); // Déclaration de l'interruption bouton poussoir 2
InterruptIn my_bp3(PA_8); // Déclaration de l'interruption bouton poussoir 3



SPI spi(D11,D12,D13); // mosi, miso, sck
DigitalOut CS_LCD(D8); //LCD
DigitalOut RS_LCD(D9);//LCD

//---------------------Declaration des fonctions--------------------------------

//                      -----Ecran LCD--------
void LCD_DOG_writeChar(char val){
      CS_LCD = 0;
      spi.write(val);
      CS_LCD=1;
}


void LCD_DOG_setPosition(char ligne, char colonne){
      char adress = 0x80 + ((ligne - 1) * 16) + (colonne - 1);
      CS_LCD = 0;
      RS_LCD = 0;
      spi.write(adress);
      CS_LCD=1;
      RS_LCD = 1;
}


void LCD_DOG_writeStr(char *c, char ligne, char colonne){
        char i = 0;
        LCD_DOG_setPosition(ligne,colonne);
        while(c[i] != '\0') {
            LCD_DOG_writeChar(c[i]);
            i++;
        }
}


void LCD_DOG_clear(void){
        CS_LCD = 0;
        RS_LCD = 0;
        spi.write(0x01); //Clear Display
        wait_ms(2);         //delay 2 ms
        RS_LCD = 1;
        CS_LCD = 1;
}


void LCD_DOG_init(void){
        CS_LCD = 0;
        RS_LCD = 0;
        spi.write(0x29); // Function Set - Table 1
        spi.write(0x1D); // Bias Set
        spi.write(0x50); // Power Control
        spi.write(0x6C); // Follower Control
        spi.write(0x7C); // Contrast Set
        spi.write(0x03); // Function Set - Table 0
        spi.write(0x0F); // Display On
        spi.write(0x01); // Clear Display
        wait_ms(2);
        spi.write(0x06); // Cursor On
        wait_ms(10);
        RS_LCD=1;
        CS_LCD=1;
        wait_ms(10);
}
//              --------Boutons poussoirs---------        

int  etat_bouton=0, etat_bouton2=0, etat_bouton3=0; //initialisation de compteur

void interruptionBP1(void); // Déclaration d'interruption pour le BP 1
void interruptionBP2(void); // Déclaration d'interruption pour le BP 2
void interruptionBP3(void); // Déclaration d'interruption pour le BP 3


//----------------------------Fonction principale-------------------------------
int main() {
    
    
    //     ---------------Initialisation variables-----------------
    char ch0[48], ch1[48], ch2[48], ch3[48], ch4[48], ch5[48], ch6[48], ch7[48];
    //déclaration des chaines de caractère pour écran LCD
    
    int  compteur, i, time = 1500;

    double V, R, B;// variables récupérant les tensions analogiques entre 0 et 1
    
    double tensiontab_V[1000], tensiontab_R[1000], tensiontab_B[1000];
    //tableau permettant le stockage des 1000 valeurs de tensions pour moyenner
    
    double tension_V, tension_R, tension_B, tension_tot; 
    //tensions cumulées sur les 1000 échantillons détectés pour filtre moyenneur 
    
    double  pourcB, pourcR, pourcV;//pourcentage final de couleur R,V,B détectée
    
    double M, C, J; //pourcentage de couleur M,C,J à expulser en peinture
    
    //    ------------Boutons poussoirs interruptions-------------
    my_bp.rise(&interruptionBP1); // interruption si front montant sur BP1
    my_bp2.rise(&interruptionBP2); // interruption si front montant sur BP2
    my_bp3.rise(&interruptionBP3); // interruption si front montant sur BP3
    
    //     ---------------------Servomoteurs----------------------
    servo_mot.period_ms(20);      // Initialisation période servomoteur 1
    servo_mot.pulsewidth_us(800); // Initialisation en position 0 servomoteur 1
    servo_mot2.period_ms(20);     // Initialisation période servomoteur 2
    servo_mot2.pulsewidth_us(800);// Initialisation en position 0 servomoteur 2
    servo_mot3.period_ms(20);     // Initialisation période servomoteur 3
    servo_mot3.pulsewidth_us(800);// Initialisation en position 0 servomoteur 3
    
    //          -------------------Ecran LCD--------------------
    spi.format(8,0);
    spi.frequency(100000);
    RS_LCD = 1;
    CS_LCD = 1;
    wait_ms(50);
    LCD_DOG_init();
    wait_ms(50);
        
    LCD_DOG_clear();
    wait_ms(50);
    
    //----------------------------Boucle infinie--------------------------------
    while(1) {
        
        //            ------------Accueil du Jeu----------------       
        if ((etat_bouton%3==0) && (etat_bouton2%2==0) && (etat_bouton3%2==0)){
            //Etat de départ puisque les 3 BP sont initialisés à 0
            sprintf(ch0, "Bienvenue !     appuyer sur BP1 pour demarrer");
            LCD_DOG_writeStr(ch0, 1, 1);//Affichage sur l'écran LCD utilisateur
            wait(2);
            } 
        
        //         -------------Zone de détection--------------
        if ((etat_bouton%3==1) && (etat_bouton2%2==0) && (etat_bouton3%2==0)){
        // détection d'un appui du bouton poussoir 1 (reste par la division
        // euclidienne est de 1)
        LCD_DOG_clear(); // Nettoyage de l'écran LCD 
        sprintf(ch1, "detection en cours");
        wait(2);
        LCD_DOG_writeStr(ch1, 1, 1);
        
        //               -------Filtre moyenneur------- 
        for (compteur = 0 ; compteur < 1000 ; compteur++){ //lecture et stockage 
        V = LED_verte.read(); //Convertit et lit la tension d'entée analogique
                              //(valeur entre 0.0 et 1.0) de la photodiode Verte
        tensiontab_V[compteur] = V * 3.3; // Change la valeur pour être entre
                                     // 0.0 et 3.3 (qui correspond à 3.3V)
        R = LED_rouge.read(); // Convertit et lit la tension d'entée analogique 
                              //(valeur entre 0.0 et 1.0) de la photodiode Rouge
        tensiontab_R[compteur] = R * 3.3; // Change la valeur pour être entre
                                          // 0.0 et 3.3 (qui correspond à 3.3V)
        B = LED_bleue.read(); // Convertit et lit la tension d'entée analogique 
                              //(valeur entre 0.0 et 1.0) de la photodiode Bleue
        tensiontab_B[compteur] = B * 3.3; // Change la valeur pour être entre 
                                          // 0.0 et 3.3 (qui correspond à 3.3V)
            }
            
        for (compteur = 0 ; compteur < 1000 ; compteur++){ //Moyennage
            tension_R=tensiontab_R[compteur]+tension_R;
            tension_V=tensiontab_V[compteur]+tension_V;
            tension_B=tensiontab_B[compteur]+tension_B;
            }
        tension_B=tension_B/1000;//Valeur moyenne de tension de photodiode Bleue
        tension_V=tension_V/1000;//Valeur moyenne de tension de photodiode Verte
        tension_R=tension_R/1000;//Valeur moyenne de tension de photodiode Rouge
            
        LCD_DOG_clear();
        sprintf(ch2, "detection reussie"); 
        LCD_DOG_writeStr(ch2, 1, 1);
        wait(2.5);
        LCD_DOG_clear();
        sprintf(ch3, "appuyer sur BP1 pour annoncer la couleur");
        LCD_DOG_writeStr(ch3, 1, 1);
        wait(5);
        }
        
        //      --------Détermination de la couleur détectée---------
        if ((etat_bouton%3==2) && (etat_bouton2%2==0) && (etat_bouton3%2==0)){
        // détection d'un appui du bouton poussoir 1 (reste de la division
        // euclidienne est de 2)
        LCD_DOG_clear();
        tension_tot = tension_B + tension_R + tension_V;
        
        pourcB = tension_B/tension_tot; // Ratio moyen de Bleu détecté  
        pourcV = tension_V/tension_tot; // Ratio moyen de Vert détecté
        pourcR = tension_R/tension_tot; // Ratio moyen de Rouge détecté
        
        //     ---------Zone de comparaison à la base de donnée----------
            if(pourcB > 0.15 ){ // Critère de couleur détectée Bleue
                J=0; // Dose de couleur Jaune à injecter pour faire du Bleu 
                M=0; // Dose de couleur Magenta à injecter pour faire du Bleu 
                C=1; // Dose de couleur Cyan à injecter pour faire du Bleu 
                
                sprintf(ch4, "couleur detectee: Bleu");
                LCD_DOG_writeStr(ch4, 1, 1);
                }
            if(pourcV > 0.80 ){ // Critère de couleur détectée Verte
                J=0.5; // Dose de couleur Jaune à injecter pour faire du Vert 
                M=0; // Dose de couleur Magenta à injecter pour faire du Vert
                C=0.5; // Dose de couleur Cyan à injecter pour faire du Vert
                sprintf(ch4, "couleur detectee: Vert");
                LCD_DOG_writeStr(ch4, 1, 1);
                }
            if((0.65 > pourcR) && (pourcR > 0.35) && (pourcB < 0.1) && 
            (0.25 < pourcV) && (pourcV < 0.6)){//Critère de couleur détectée Rouge
                J=0.3; // Dose de couleur Jaune à injecter pour faire du Rouge
                M=0.7; // Dose de couleur Magenta à injecter pour faire du Rouge
                C=0; // Dose de couleur Cyan à injecter pour faire du Rouge
                sprintf(ch4, "couleur detectee: Rouge");
                LCD_DOG_writeStr(ch4, 1, 1);
                }    
            if((0.25 < pourcB) && (pourcB < 0.4) && (0.25 < pourcR) && 
            (pourcR < 0.4) && (0.25 < pourcV) && (pourcV < 0.4)){//Critère de
                                                    // couleur détectée Blanche
                J=0.3; // Dose de couleur Jaune à injecter pour faire du Blanc
                M=0.3; // Dose de couleur Magenta à injecter pour faire du Blanc
                C=0.3; // Dose de couleur Cyan à injecter pour faire du Blanc
                sprintf(ch4, "couleur detectee: Blanc \n pas synthetisable");
                LCD_DOG_writeStr(ch4, 1, 1);
                }
            if((0.4 < pourcB) && (pourcB < 0.6) && (0.4 < pourcR) && 
            (pourcR < 0.6) && (pourcV < 0.1)){//Critère de couleur détectée Orange
                J=0.8; // Dose de couleur Jaune à injecter pour faire du Orange
                M=0.2; // Dose de couleur Magenta à injecter pour faire du Orange
                C=0; // Dose de couleur Cyan à injecter pour faire du Orange
                sprintf(ch4, "couleur detectee: Orange");
                LCD_DOG_writeStr(ch4, 1, 1);
                }
            if((0.1 < pourcV) && (pourcV < 0.28) && (pourcR > 0.50) && 
            (pourcB < 0.12)){ // Critère de couleur détectée Jaune 
                J=1; // Dose de couleur Jaune à injecter pour faire du Jaune
                M=0; // Dose de couleur Magenta à injecter pour faire du Jaune
                C=0; // Dose de couleur Cyan à injecter pour faire du Jaune
                sprintf(ch4, "couleur detectee: Jaune");
                LCD_DOG_writeStr(ch4, 1, 1);
                }
        wait(3);
        LCD_DOG_clear();
        sprintf(ch5, "pressez BP2 si bonne couleur sinon pressez BP1");
                    // possibilité à l'utilisateur de réeffectuer la détection
        LCD_DOG_writeStr(ch5, 1, 1);
        wait(5);
        }
        
        // ------Envoie des informations de rotation aux servomoteurs------
        
        if ((etat_bouton2%2==1) && (etat_bouton%3==2)){
        // détection d'un appui du bouton poussoir 2 (reste de la division
        // euclidienne est de 1)
        
            if ((J==1) && (M==0) && (C==0)){ // Couleur Jaune à synthétiser
                servo_mot3.pulsewidth_us(1400);   // Rotation servomoteur 
                                                  // pour peinture Jaune
                }
            if ((J==0.8) && (M==0.2) && (C==0)){ //Couleur Orange à synthétiser
                servo_mot3.pulsewidth_us(1280);   // Rotation servomoteur
                                                  // pour peinture Jaune
                servo_mot2.pulsewidth_us(920);   // Rotation servomoteur
                                                 // pour peinture Magenta
                }
            if ((J==0.3) && (M==0.7) && (C==0)){ //Couleur Rouge à synthétiser
                servo_mot3.pulsewidth_us(980);   // Rotation servomoteur
                                                 // pour peinture Jaune
                servo_mot2.pulsewidth_us(1220);   // Rotation servomoteur
                                                  // pour peinture Magenta
                }
            if ((J==0.5) && (M==0) && (C==0.5)){ //Couleur Verte à synthétiser
                servo_mot3.pulsewidth_us(1100);   // Rotation servomoteur
                                                  // pour peinture Jaune
                servo_mot.pulsewidth_us(1100);    // Rotation servomoteur
                                                  // pour peinture Cyan
                }
            if ((J==0) && (M==0) && (C==1)){    //Couleur Bleue à synthétiser
                servo_mot.pulsewidth_us(1400);   // Rotation servomoteur
                                                 // pour peinture Cyan
                }
            wait(2);
            LCD_DOG_clear();
            sprintf(ch6, "  enlever les   seringues puis presser BP3");
            LCD_DOG_writeStr(ch6, 1, 1);
            wait(1);

            }
       //    -------Remontée des servomoteurs en position initiale-------     
       if (etat_bouton3%2==1){
       // détection d'un appui du bouton poussoir 3 (reste de la division
       // euclidienne est de 1)
           servo_mot.pulsewidth_us(800); //Servomoteur Cyan en position initiale
           servo_mot2.pulsewidth_us(800);//Servomoteur Magenta en position intiale
           servo_mot3.pulsewidth_us(800);//Servomoteur Jaune en position initiale 
           
           LCD_DOG_clear(); 
           sprintf(ch7, "Felicitations !! Bon atelier peinture !");
           LCD_DOG_writeStr(ch7, 1, 1);
           etat_bouton=0; // Remise à zéro du bouton poussoir 1
           etat_bouton2=0; // Remise à zéro du bouton poussoir 2
           etat_bouton3=0; // Remise à zéro du bouton poussoir 3
           wait(10);
           }  
    }
}


//      ----------- Corps des fonctions d'interruptions------------
void interruptionBP1(){
    wait(1);
    etat_bouton=etat_bouton+1; //compteur du bouton poussoir 1 incrémenté 
                               // lorsqu'un front montant est détecté
}
void interruptionBP2(){
    wait(1);
    etat_bouton2=etat_bouton2+1; //compteur du bouton poussoir 2 incrémenté 
                                 // lorsqu'un front montant est détecté
}
void interruptionBP3(){
    wait(1);
    etat_bouton3=etat_bouton3+1; //compteur du bouton poussoir 3 incrémenté 
                                 // lorsqu'un front montant est détecté
}