#ifndef  __rbuf_h_
 #define __rbuf_h_

#include "mbed.h" 

#define NOT_EMPTY           0x01    // Bit fuer mindestens 1 Frame im Buffer 
#define FAST_VOLL           0x02    // Bit fuer Fuellstandsschwelle ueberschritten 
#define FEHLER              0x04    // Bit fuer Fehler aufgetreten 

typedef struct 
  { 
     uint16_t   buflen;        // Max. Objektanzahl fuer den Buffer 
     uint16_t   bufcnt;        // Bufferfuellstand in Objekten 
     void       * in;          // Zeiger auf char zum Schreiben (Schreibzeiger) 
     void       * out;         // Zeiger auf char zum Lesen     (Lesezeiger) 
     void       * buf;         // Zeiger auf char[LEN]-Buffer   (Buffer an sich) 
     uint32_t   anzahl;        // Anzahl aller geschriebenen Elemente (Absolutanzahl Elementzaehler) 
     uint32_t   fehleranzahl;  // Anzahl aufgetretener Fehler 
     uint16_t   Schwelle;      // Schwelle fuer "fast voll" 
     uint16_t   flags;         // Status-Flags 
     uint16_t   peak_max;      // Schleppzeiger ueber den max. Fuellstand an Elementen 
     uint16_t   blockgroesse;  // Groesse eines Datenobjekts (1 Byte bis Frames) = Objektgroesse 
   } rbuf_t;                   // 

rbuf_t   *rbuf_init (uint16_t b_size, uint16_t b_schwelle, uint16_t blockgroesse); 

rbuf_t   *rbuf_create        (uint16_t Objektanzahl, uint16_t Fast_voll_Schwelle, uint16_t Objektgroesse); 
void     *rbuf_look          (rbuf_t *buffer); 
void     *rbuf_get           (rbuf_t *buffer, void *target); 
void     *rbuf_put           (rbuf_t *buffer, void *source); 
uint32_t  rbuf_getcnt        (rbuf_t *buffer); 
uint32_t  rbuf_getflags      (rbuf_t *buffer); 
uint32_t  rbuf_getfehler     (rbuf_t *buffer); 
uint32_t  rbuf_leer          (rbuf_t *buffer); 
uint32_t  rbuf_fast_voll     (rbuf_t *buffer); 
uint32_t  rbuf_fehler        (rbuf_t *buffer); 
uint32_t  rbuf_get_fehleranz (rbuf_t *buffer); 
uint32_t  rbuf_get_gesendet  (rbuf_t *buffer); 

#endif // von #define __rbuf_h_
