#include "mbed.h"
#define dp23 P0_0


#include "stdio.h"
#include "SPI_TFT_ILI9341.h"
#include "string"
#include "Arial12x12.h"
#include "Arial24x23.h"
#include "Arial28x28.h"
#include "font_big.h"
//#include "SDFileSystem.h"

SPI_TFT_ILI9341 TFT(dp2,dp1,dp6,dp24,dp23,dp25,"TFT"); // mosi, miso, sclk, cs, reset, dc

int main()
{
    int i=0;
    //Inicijalizacija;
    TFT.claim(stdout);
    TFT.set_orientation(1);
    TFT.background(Blue);     // set background to black
    TFT.foreground(White);    // set chars to white
    TFT.cls();                // clear the screen

    while(1) {
        TFT.set_font((unsigned char*) Arial28x28);
        TFT.locate(10,10);
        printf("Mi volimo US!");

        wait(2);
        //Crtanje linija
        TFT.line(0,0,100,0,Green);
        TFT.line(0,0,0,200,Green);
        TFT.line(0,0,100,200,Green);

        //Crtanje dijagrama piksel po poksel
        double s;
        for (i=0; i<320; i++) {
            s =20 * sin((long double) i / 10 );
            TFT.pixel(i,100 + (int)s ,Red);
        }

        wait(2);
        TFT.cls();

    }
}



