#include "mbed.h"

//Analogni ulazi sa dzojstika
AnalogIn    VRx(dp11);
AnalogIn    VRy(dp10);
//Taster sa dzojstika
DigitalIn   SW(dp9);

//Digitalni izlaz za aktivaciju LED buffera
DigitalOut enable(dp14);
//LED prikaz
BusOut  prikazX(dp28,dp6,dp5);
BusOut  prikazY(dp27,dp26,dp25);
DigitalOut  prikazSW(dp23);

int main()
{
    //aktivacija LED dioda
    enable=0;
    //Aktivacija pull-up otpornika
    SW.mode(PullUp);

    while(1) {
        if (VRx<1.0/3.0) prikazX=1;
        else if (VRx<2.0/3.0) prikazX=2;
        else prikazX=4;

        if (VRy<1.0/3.0) prikazY=1;
        else if (VRy<2.0/3.0) prikazY=2;
        else prikazY=4;

        if (SW==1) prikazSW=1;
        else prikazSW=0;

        wait(0.01);
    }
}