#include "mbed.h"
#include "TextLCD.h"
 
// Accelerometer KXP-84 I2C Mode Register 
//#define X_H 0x00
//#define X_L 0x01 

// slave adress 0011 000X  X: 0 send 1 receve

DigitalOut reset(p11);
DigitalIn ff(p12);
DigitalIn mot(p13);
DigitalOut sign(LED1);

TextLCD lcd(p24, p26, p27, p28, p29, p30); // rs, e, d4-d7

I2C i2c(p9, p10);  // sda, scl


int main() {
    char cmd[1];
    char data[6];
    int x,y,z;
    int dx,dy,dz;
    //reset=0;
    i2c.frequency(400000);
//CTRL_REGB 
    i2c.start();
    wait_us(1);
    i2c.write(0x30);
    wait_us(1);
    *cmd=0x06;
    i2c.write(0x0B,cmd,1);
    wait_us(1);
    i2c.stop();
//CTRL_REGC
    i2c.start();
    wait_us(1);    
    i2c.write(0x30);
    wait_us(1);
    *cmd=0x00;
    i2c.write(0x0A,cmd,1);
    wait_us(1);
    i2c.stop();    
//FF_INT
    i2c.start();
    wait_us(1);    
    i2c.write(0x30);
    wait_us(1);
    *cmd=0x14;
    i2c.write(0x06,cmd,1);
    wait_us(1);
    i2c.stop();
//FF_DELAY
    i2c.start();
    wait_us(1);    
    i2c.write(0x30);
    wait_us(1);
    *cmd=0x14;
    i2c.write(0x07,cmd,1);
    wait_us(1);
    i2c.stop();     
//MOT_INT
    i2c.start();
    wait_us(1);    
    i2c.write(0x30);
    wait_us(1);
    *cmd=0x4D;
    i2c.write(0x08,cmd,1);
    wait_us(1);
    i2c.stop();
//MOT_DELAYC
    i2c.start();
    wait_us(1);    
    i2c.write(0x30);
    wait_us(1);
    *cmd=0x14;
    i2c.write(0x09,cmd,1);
    wait_us(1);
    i2c.stop();

//data_OUT
    lcd.locate(0,0);lcd.printf("    x    y    z");     
    while(1){
        i2c.start();
        wait_us(1);   
        i2c.write(0x30);
        wait_us(1);
        i2c.write(0x00);
        wait_us(1);
        i2c.read(0x30,data,6);
        wait_us(1);
        i2c.stop();
    
        dx=data[0]<<4 | data[1]>>4;
        dy=data[2]<<4 | data[3]>>4;
        dz=data[4]<<4 | data[5]>>4;
        
        if(dx>2048)x=dx-2048;
        else x=dx;
        if(dy>2048)y=dy-2048;
        else y=dy;        
        if(dz>2048)z=dz-2048;
        else z=dz;        
        
        lcd.locate(0,1);;lcd.printf("%5d%5d%5d",x,y,z);
        wait_ms(10);
    }
}