#include  "mbed.h"
#include "TextLCD.h"

#define High 1
#define Low  0

DigitalInOut  D(p15);
DigitalOut  Csb(p16);
DigitalOut  Clk(p17);

DigitalOut myled1(LED1);
DigitalOut myled4(LED4);

TextLCD lcd(p24, p26, p27, p28, p29, p30); // rs, e, d4-d7

int flag;   //1100 flag data
int i;      //counter

int  x;     //X
int  y;     //Y

//clock out
void  CLK (char a)
{
    Clk=a;
    myled1=a;
    wait_ms(1);
}
//4bit flag reaD.intput()g
int  READ_FLAG ()
{
    flag=0;
    D.input();
    for(i=0;i<4;i++){
        CLK(High);CLK(Low);     //clock down edge
        flag=flag*10;
        flag=flag+D;        //1100 flag reaD.intput()g
    }
    return  flag;
}
//22bit data reaD.intput()g
void XY_DATA ()
{
    x=0;
    D.input();
    for(i=0;i<11;i++){
        CLK(High);CLK(Low);     //clock down edge
        x=x<<1;
        x=x | D;             //X data reaD.intput()g
    }
    y=0;
        for(i=0;i<11;i++){
        CLK(High);CLK(Low);     //clock down edge
        y=y<<1;
        y=y | D;             //Y data reaD.intput()g
    }
}
// reset sign out
void  RESET(void)
{
    D.output();
    CLK(High);D=0;CLK(Low);
    CLK(High);D=0;CLK(Low);
    CLK(High);D=0;CLK(Low);
    CLK(High);D=0;CLK(Low);            
}
//start sign out
void  START(void)
{
    D.output();
    CLK(High);D=1;CLK(Low);
    CLK(High);D=0;CLK(Low);    
    CLK(High);D=0;CLK(Low);    
    CLK(High);D=0;CLK(Low);    
  }

int  READ_END_FLAG(void)
{
    //int d[4];
    flag=0;
    D.output();
    CLK(High);D=1;CLK(Low);
    CLK(High);D=1;CLK(Low);    
    CLK(High);D=0;CLK(Low);    
    CLK(High);D=0;CLK(Low);
    D.input();    
    for(i=0;i<4;i++){
        CLK(High);
        CLK(Low);     //clock down edge
        //d[i]=D;        //1100 flag reaD
        flag=flag<<1;
        flag=flag+D;
        myled4=D ;
    }
    //flag=d[0]*1000+d[1]*100+d[2]*10+d[3];
        return  flag;
}

int main() {
    int cmd=0;
    int dx=0;char *ax;
    int dy=0;char *ay;
    float atn;
 
    while(1){
        //lcd.cls();  
        Csb=1;
        //wait_ms(1);
        Csb=0;
            RESET(); 
        Csb=1;
        //wait_ms(1);
        Csb=0;
            START(); 
        Csb=1;
        wait_ms(30);        //scanning
        Csb=0;
            cmd=READ_END_FLAG();
            XY_DATA();
        
            if(x>1024){ dx=x-2048;ax="-S";}
            else{ dx=x;ax="+N";}
            if(y>1024){ dy=y-2048;ay="-E";}
            else{ dy=y;ay="+W";}
            atn=(float)dy/(float)dx;
        Csb=1;
        lcd.locate(0,0);lcd.printf(" X   Y   ATN");
        lcd.locate(0,1);lcd.printf(" %2s  %2s  %4.2f",ax,ay,atn);
        wait_ms(40);        //LCD dispaying
    }    
}
