//main.cpp
#include "mbed.h"
#include "CameraC1098.h"
#include "SDFileSystem.h"
#include "TextLCD.h"

// Definitions.
#define USE_JPEG_HIGH_RESOLUTION  1
#define USE_SD_CARD 0

//Variables.
static const int RAWIMG_X = 80;
static const int RAWIMG_Y = 60;
static char buf[RAWIMG_X * RAWIMG_Y * 2];
static FILE *fp_jpeg;
static const int packageSize = 512;
int i=0;
int shutter=0;
//Modules.
#if USE_SD_CARD   //USE_SD_CDARD=0:Local, =1:SD
SDFileSystem sd(p5, p6, p7, p8, "fs");
#else
LocalFileSystem fs("fs");
#endif

//CameraC1098
CameraC1098 camera(p9, p10, CameraC1098::Baud14400);
//ErrorNunber constracture 
bool err;
//
//CameraC1098::NoError = 0x00;

//TextLCD
TextLCD lcd(p24, p26, p27, p28, p29, p30); // rs, e, d4-d7
//LED 
DigitalOut myled1(LED1);
DigitalOut myled4(LED4);
InterruptIn tact(p22);
//setting camera
void camera_set(void) {
    err = camera.sync();    //syncronising
    err = camera.init(CameraC1098::JpegResolution640x480);  //initialising
    err = camera.getnewbaud();  //change baudrate 14400 -> 115200bps
}
//setting packetsize
void packagesize_set(void){
    err = camera.setupPackageSize(packageSize);
}  
//saving image data to fp_jpd
void jpeg_callback(char *buf, size_t siz) {  //*buf:image buffer size, siz:image size
    for (int i = 0; i < (int)siz; i++) {
        fprintf(fp_jpeg, "%c", buf[i]);
    }
}
//getting Jpeg snapshot picture
void snapshot_get(void) 
{
    char fname[64];
    snprintf(fname, sizeof(fname), "/fs/image%02d.jpg",i);
    fp_jpeg = fopen(fname, "w");
    err = camera.getJpegSnapshotPicture(jpeg_callback);
    fclose(fp_jpeg);
 } 
//shutter(p22)
void getshutter(){
    shutter=1;
}
//
int main() 
{
    tact.fall(&getshutter);   
    lcd.cls();lcd.printf("Camera C1098");
    camera_set();
    wait_ms(100);
    packagesize_set();
    lcd.cls();lcd.printf("camera OK");
    while(1){
        if(shutter==1){
            myled1=1;lcd.cls();
                snapshot_get();
                shutter=0;
                i++;
            myled1=0;lcd.cls();lcd.printf("NEXT OK");
        }
        myled4=!myled4;
        wait(0.25);
    }
}
