//CameraC1098.h
//#include "mbed.h"
#include "SerialBuffered.h"

#ifndef _CAMERA_C1098_H_
#define _CAMERA_C1098_H_

// Class: CameraC1098
class CameraC1098 {
public:
    /**
     * Color type.
     */
    enum ColorType {
        Jpeg = 0x07
    };
    /**
     * JPEG resolution.
     */
    enum JpegResolution {
        JpegResolution320x240 = 0x05,
        JpegResolution640x480 = 0x07
    };
    /**
     * Picture type.
     */
    enum PictureType {
        SnapshotPicture = 0x01,
        PreviewPicture = 0x02,
        JpegPreviewPicture = 0x05
    };
    /**
     * Snapshot type.
     */
    enum SnapshotType {
        CompressedPicture = 0x00,
        UncompressedPicture = 0x01
    };
    /**
     * Baud rate.
     */
    enum Baud {
        Baud14400 = 14400,  //Default
        Baud19200 = 19200,
        Baud28800 = 28800,
        Baud38400 = 38400,
        Baud57600 = 57600,
        Baud115200 = 115200, //Default
        Baud230400 = 230400,
        Baud460800 = 460800
    };
    /**
     * Reset type.
     */
    enum ResetType {
        ResetWholeSystem = 0x00,
        ResetStateMachines = 0x01
    };
    /**
     * Data type.
     */
    enum DataType {
        DataTypeSnapshotPicture = 0x01,
        DataTypePreviewPicture = 0x02,
        DataTypeJpegPreviewPicture = 0x05
    };
    /**
     * Constructor.
     *
     * @param tx A pin for transmit.
     * @param rx A pin for receive.
     * @param baud Baud rate. (Default is Baud115200.)
     */
    //CameraC1098(PinName tx, PinName rx, Baud baud = Baud19200);
    CameraC1098(PinName tx, PinName rx, Baud baud = Baud115200);
    /**
     * Destructor.
     */
    ~CameraC1098();
     /**
     * Make a sync. for baud rate.
     */
    bool sync();
    /**
     * Initialize.
     * @param jr JPEG resolution.
     */
    bool init(JpegResolution jr);
    /**
     *set packet size
      */
    bool setupPackageSize(uint16_t packageSize);
    /**
     * Get uncompressed snapshot picture.
     *
     * @param func A pointer to a callback function.
     *             Please do NOT block this callback function.
     *             Because the camera module transmit image datas continuously.
     * @return Status of the error.
     */
    bool getUncompressedSnapshotPicture(void(*func)(size_t done, size_t total, char c));
    /**
     * Get uncompressed preview picture.
     *
     * @param func A pointer to a callback function.
     *             Please do NOT block this callback function.
     *             Because the camera module transmit image datas continuously.
     * @return Status of the error.
     */
    bool getUncompressedPreviewPicture(void(*func)(size_t done, size_t total, char c));
    /**
     * Get JPEG snapshot picture.
     *
     * @param func A pointer to a callback function.
     *             You can block this function until saving the image datas.
     * @return Status of the error.
     */
//    bool getJpegSnapshotPicture(void(*func)(char *buf, size_t siz));
    bool getJpegSnapshotPicture(void(*func)(char *buf, size_t siz));
    /**
     * Get JPEG preview picture.
     *
     * @param func A pointer to a callback function.
     *             You can block this function until saving the image datas.
     * @return Status of the error.
     */
    bool getJpegPreviewPicture(void(*func)(char *buf, size_t siz));
            //NEW
            bool getnewbaud();    
    
private:
    SerialBuffered serial;
    static const int COMMAND_LENGTH = 6;
    static const int SYNCMAX = 60;
    static const int packageSize = 512;

    bool sendInitial(JpegResolution jr);
    bool sendGetPicture(PictureType pt);
    bool sendSnapshot(SnapshotType st, uint16_t skipFrames);
    bool sendSetPackageSize(uint16_t packageSize);
//    bool sendSetBaudrate(Baud baud);
    bool sendReset(ResetType rt, bool specialReset);
    bool sendPowerOff();
    bool recvData(DataType *dt, uint32_t *length);
    bool sendSync();
    bool recvSync();
    bool sendAck(uint8_t commandId, uint16_t packageId);
    bool recvAckOrNck();

    bool sendBytes(char *buf, size_t len, int timeout_us = 20000);
    bool recvBytes(char *buf, size_t len, int timeout_us = 20000);
    bool waitRecv();
    bool waitIdle();
            //NEW
            bool newbaud(); 
};

#endif
