#include "mbed.h"
#include "LSM9DS0.h"

#define LSM9DS0_XM_ADDR  0x1D // Would be 0x1E if SDO_XM is LOW
#define LSM9DS0_G_ADDR   0x6B // Would be 0x6A if SDO_G is LOW

LSM9DS0 imu(p9, p10, LSM9DS0_G_ADDR, LSM9DS0_XM_ADDR);
Serial pc(USBTX, USBRX);

//Extra inputs for 'fake' connections, can ignore
DigitalIn in0(p21);
DigitalIn in1(p22);
DigitalIn in2(p23);
DigitalIn in3(p17);

//Trigger pushbutton
DigitalIn trigger(p15);

int main() {
    //Initialize IMU
    imu.begin();
    //Set pushbutton input mode
    trigger.mode(PullUp);
    while(1) {
        imu.readAccel();
        imu.readGyro();
        imu.readMag();
        //IMPORTANT - Unity only recognizes Unix-style line endings in the context of the C# SerialPort.ReadLine() function
        pc.printf("%f %f %f$%f %f %f$%f %f %f\r\n", imu.ax, imu.ay, imu.az, imu.gx, imu.gy, imu.gz, imu.mx, imu.my, imu.mz);
        wait(.005);
        if (!trigger)   //Print constant fire string
            pc.printf("PEW\r\n");
    }
}

