//eth_tcp_server.cpp
#include "mbed.h"
#include "EthernetInterface.h"

#define HTTP_TCP_PORT 80

Serial pc(USBTX,USBRX);
EthernetInterface eth;

void http();

int main()
{   
    eth.init(); //Use DHCP
    eth.connect();
    pc.printf("\nServer IP Address is %s\n", eth.getIPAddress());
    http();
    eth.disconnect();  
}

void http()
{
    char buf[1024];
    char buf_s[2048];
    char meth_name[16];
    char uri_addr[256];
    char http_ver[64];
    int n;

    //ステップ１　ソケットの生成
    TCPSocketServer server;
    TCPSocketConnection client;

    //ステップ２　ポートの登録
    server.bind(HTTP_TCP_PORT);

    //ステップ３ ソケットの待機準備
    server.listen(5);

    // ステップＢ　HTTPレスポンス作成
    memset(buf_s, 0, sizeof(buf_s));  //HTTPレスポンス用バッファメモリを初期化
    snprintf(buf_s, sizeof(buf_s),    //200のHTTPレスポンスの作成
        "HTTP/1.0 200 Document follows\r\n"      //ステータス行
        "Content-Type: text/html\r\n"
        "\r\n"               //空白行(これ以降、送信したデータはボディ)
        "HELLO\r\n");
                        
    while(true){
        printf("\n\nWait for new connection...\n");

        //ステップ４　ソケットの接続受付
        server.accept(client); 
        client.set_blocking(false, 1500); 
        printf("Connection from: %s\n", client.get_address());

        while (true) {
            // ステップ５　データの受信
            n = client.receive(buf, sizeof(buf));
            pc.printf("%d byte\r\n", n);
            if (n <= 0){
                // データがない場合
                break;
            } else {
                // データがある場合
                buf[n] = '\0';
                printf("Received message from Client :%s",buf);

                // ステップＡ　HTTPリクエストのリクエスト行の分解
                sscanf(buf, "%s %s %s", meth_name, uri_addr, http_ver);
                printf("meth_name:'%s'\n",meth_name);//メソッド(GETのみ)
                printf("uri_addr:'%s'\n",uri_addr);//リクエスト対象(ファイル）
                printf("http_ver:'%s'\n",http_ver);//HTTPのバージョン

                //ステップＣ　ＨＴＴＰレスポンスの送信
                if (strcmp(meth_name, "GET") != 0) {
                    //GET以外のとき
                    pc.printf("HTTP/1.0 501 Not Implemented\r\n");
                    client.send("HTTP/1.0 501 Not Implemented", 28);
                } else {
                    //GETのとき
                    pc.printf("\r\n%s", buf_s);
                    client.send(buf_s, (int)strlen(buf_s));
                }
            }
        }
        
        // ステップ７　ソケット間の通信接続を切断
        client.close();
        pc.printf("client close\r\n");
    }   
}
