#include "mbed.h"
#include "SLCD.h"
#include "TSISensor.h"

#define PROGNAME "lightsense_kl46z_basic v1\n\r"
#define DATATIME 400    // milliseconds
#define LCDLEN 10
#define LIGHTSENSORPORT PTE22
#define TSILIMIT 0.99
#define LBTN PTC12  // port addresses for buttons
#define RBTN PTC3
#define BUTTONTIME 0.2
#define NUMBUTS 2

SLCD slcd; //define LCD display globally define
Serial pc(USBTX, USBRX);
Timer LEDTimer;
Timer ButtonTimer;
TSISensor tsi;

float lightData_f;
float tsidata;

void LCDMess(char *lMess)
{
    slcd.Home();
    slcd.clear();
    slcd.printf(lMess);
}

int main()
{
    AnalogIn LightSensor(LIGHTSENSORPORT);
    DigitalIn buttons[NUMBUTS] = {LBTN, RBTN};

    unsigned lightData_u;
    char lcdData[LCDLEN];
    bool showRawData = false;
    int timeToChangeDF = DATATIME;
    int i = 0;

    LEDTimer.start();
    LEDTimer.reset();
    ButtonTimer.start();
    ButtonTimer.reset();
    pc.printf(PROGNAME);
    PwmOut gled(LED_GREEN);
    PwmOut rled(LED_RED);

    while(true) {
        tsidata = tsi.readPercentage();

        for (i=0; i<NUMBUTS; i++) { // index will be 0 or 1
            if(!buttons[i]) {
                showRawData = i;
            } // if ! buttons
        }// for loop to look at buttons
        ButtonTimer.reset();

        if (LEDTimer.read_ms() > timeToChangeDF) { // check for timer time out transtion
            lightData_f = (1 - LightSensor.read()); //
            lightData_u = (LightSensor.read_u16());
            if(showRawData == true) {
                sprintf(lcdData,"%4.3f",lightData_f);
            } else {
                lightData_u % 100;
                if(tsidata > .75) {
                    lightData_u / 10;
                } else {
                    lightData_u * 10;
                }
                sprintf(lcdData,"%u",lightData_u);
            }
            LCDMess(lcdData);
            gled = lightData_f;
            rled = lightData_f;
            timeToChangeDF = DATATIME;
            LEDTimer.reset();
        }
    }// end while
}