#include "mbed.h"
#include "SLCD.h"

#define LEDON           false
#define LEDOFF          true
#define NUMBUTS         2
#define LBUT            PTC12  // port addresses for buttons
#define RBUT            PTC3
#define LED_ON_TIME     0.2 // in seconds
#define LED_OFF_TIME    0.5 // set delay between blinks
#define BUTTONTIME      0.2
#define LCD_CH_LEN      5
#define PC_CHAR_LEN     25  // add new variable for length of pc serial message
#define NUMMESS         2
#define L_RED           "RED"
#define L_GRN           "GRN"
#define P_RED           "RED BUTTON PUSHED\r\n"       // change red pc serial message
#define P_GRN           "GREEN BUTTON PUSHED\r\n"     // change green pc serial message
#define PROGNAME        "blink_kl46z_button LCD v2\r\n"

// slightly more interesting blinky 140814 sc
SLCD slcd; //define LCD display

// Timer to elliminate wait() function
Timer LEDTimer; // for blinking LEDs
Timer ButtonTimer; // for reading button states

bool ledState = LEDON;

DigitalIn buttons[NUMBUTS] = {RBUT, LBUT};
DigitalOut LEDs[NUMBUTS] = {LED_GREEN, LED_RED};
Serial pc(USBTX, USBRX);    // set up USB as communication is
// to Host PC via USB connectons

void allLEDsOff()
{
    int i;
    for (i=0; i<NUMBUTS; i++) {
        LEDs[i] = LEDOFF;
    }
}

void LCDMess(char *lMess)
{
    slcd.Home();
    slcd.clear();
    slcd.printf(lMess);
}

void initialize_global_vars()
{
    pc.printf(PROGNAME);
    // set up DAQ timers
    ButtonTimer.start();
    ButtonTimer.reset();
    LEDTimer.start();
    LEDTimer.reset();
    allLEDsOff();
}
// --------------------------------
int main()
{
    int i;
    int currentLED = 0;
    char rMess[NUMMESS][LCD_CH_LEN]= {L_GRN, L_RED}; // for LCD
    char pMess[NUMMESS][PC_CHAR_LEN]= {P_GRN, P_RED}; // for pc serial port
    // reverse these message so that the
    // correct one prints to serial port
    initialize_global_vars(); //keep things organized
    LEDs[currentLED] = LEDON;
    LCDMess(rMess[currentLED]);
    pc.printf(pMess[currentLED]);
    // End of setup

    while(true) {
        if (ButtonTimer > BUTTONTIME) {
            for (i = 0; i < NUMBUTS; i++) { // index will be 0 or 1
                if(!buttons[i]) {
                    allLEDsOff();
                    LCDMess(rMess[i]);
                    pc.printf(pMess[i]);
                    currentLED = i;
                } // if ! buttons
            }// for loop to look at buttons
            ButtonTimer.reset();
        }

        if(ledState == 0){ // switch on LED state
            if(LEDTimer.read() > LED_ON_TIME) {
                // if LED state is low wait 500 ms before change
                LEDTimer.reset();
                ledState = !ledState; // Flip the general state
                LEDs[currentLED] = ledState;
            }
        } else {
            // if LED state is not low wait 200 ms before change
            if(LEDTimer.read() > LED_OFF_TIME) {
                LEDTimer.reset();
                ledState = !ledState; // Flip the general state
                LEDs[currentLED] = ledState;
            }
        }
        // Do other things here between times of reading and flashing
    }
}