#include "mbed.h"
#include <math.h>
#include "MMA8451Q.h"
#include "SLCD.h"

/*
Test of the accelerometer, digital I/O, on-board LCD screen.
 Looing at vector product of the x-y components of the accelerometer.
 Works pretty well. Still rough, program wise - sc 140710
 */

#define DATAINTERVAL 0.200
#define LCDDATALEN 10
// buttons
#define NUMBUTS 1
#define LBUT PTC12  // port addresses for buttons
//#define RBUT PTC3
#define BUTTONTIME 0.2
// lcd title
#define LCDTITLE "ACCL"
#define TITLEWAIT .8
// serial title
#define PROGNAME "ACCLCD341-541\r\n"

#define PRINTDBUG
#if defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
PinName const SDA = PTE25;  // Data pins for the accelerometer/magnetometer.
PinName const SCL = PTE24;  // DO NOT CHANGE
#endif
#define MMA8451_I2C_ADDRESS (0x1d<<1)
SLCD slcd; //define LCD display
char lcdData[LCDDATALEN]; //buffer needs places dor decimal pt and colon

MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
Serial pc(USBTX, USBRX);
Timer DataTimer;

Timer ButtonTimer; // for reading button states
DigitalIn buttons[NUMBUTS] = {LBUT};

void LCDMess(char *lMess)
{
    slcd.Home();
    slcd.clear();
    slcd.printf(lMess);
}

void initialize_global_vars()
{
    // print lcd title
    pc.printf(PROGNAME);
    LCDMess(LCDTITLE);
    wait(TITLEWAIT);
    // set up DAQ timers
    DataTimer.start();
    DataTimer.reset();
    // set up button timers
    ButtonTimer.start();
    ButtonTimer.reset();
}

void LCDsignedFloat(float theNumber)
{
    sprintf (lcdData," %3.2f",theNumber);
    if (theNumber < 0.0) sprintf (lcdData,"<%3.2f",fabs(theNumber));
    LCDMess(lcdData);
}

int main()
{
    int displayState = 0;
    char axis = ' ';
    float accl[3] = {0,0,0};

    initialize_global_vars();
    while(true) {
        if(DataTimer.read() > DATAINTERVAL) {
            DataTimer.reset();
            accl[0] = acc.getAccX();
            accl[1] = acc.getAccY();
            accl[2] = acc.getAccZ();
            LCDsignedFloat(accl[displayState]);
        }
        if (ButtonTimer > BUTTONTIME) {
            if(!buttons[0]) {
                // a button is pressed
                switch(displayState) {
                    case 0:
                        axis = 'x';
                        LCDMess(&axis);
                        wait(.5);
                        break;
                    case 1:
                        axis = 'y';
                        LCDMess(&axis);
                        wait(.5);
                        break;
                    case 2:
                        axis = 'z';
                        LCDMess(&axis);
                        wait(.5);
                        break;
                }
                displayState++;
                displayState = displayState%3;
                ButtonTimer.reset();
            }
        }
    }
}