/*----------------------------------------------------------------
-                                                                -
-  Simple twitter demo application                               -
-  http://mbedtweet.appspot.com/                                 -
-  Written by Escalion, based on ArduinoTweetLib by NeoCat       -
-                                                                -
----------------------------------------------------------------*/
#include "mbed.h"
#include "EthernetInterface.h"
#include "HTTPClient.h"

Serial pc(USBTX, USBRX); // tx, rx
EthernetInterface eth;
HTTPClient http;
char str[512];
char ret;
const char *DATA = "Test Tweet From Mbed!";
const char *TOKEN = ""; //get this from http://mbedtweet.appspot.com/

int main() 
{
    eth.init(); //Use DHCP

    eth.connect();
    //POST data
    HTTPMap map;
    HTTPText inText(str, 512);
    map.put("token", TOKEN);
    map.put("status", DATA);
    printf("\nSending server tweet...\n");
    ret = http.post("http://mbedtweet.appspot.com/update", map, &inText);
    if (!ret)
    {
      printf("Executed POST successfully - read %d characters\n", strlen(str));
      printf("Result: %s\n", str);
    }
    else
    {
      printf("Error - ret = %d - HTTP return code = %d\n", str, http.getHTTPResponseCode());
    }
    
    eth.disconnect();  

    while(1) {
    }
}
