#include "mbed.h"
#include "ds1307.h"
#include "TextLCD.h"

TextLCD lcd(D8, D9, D4, D5, D6, D7); // rs, e, d4-d7
DS1307 my_tm(D14, D15); //sda, scl
DigitalOut myled(LED1); // blinking LED
InterruptIn mybutton(USER_BUTTON);  // user button (blue)

int year, month, day, hour, min, sec, dw; // dw - day of week
float delay=1.0; // delay time
float showtime=0.0;

void lcdPrintDate(int row)
{
    lcd.locate(0, row);
    lcd.printf("Data :");
    lcd.locate(6, row);
    lcd.printf("%02d", day);
    lcd.printf("-");
    lcd.printf("%02d", month);
    lcd.printf("-");
    lcd.printf("%04d", 2000+year);
}

void lcdPrintTime(int row)
{
    lcd.locate(0, row);
    lcd.printf("Czas :");
    lcd.locate(6, row);
    lcd.printf("%02d", hour);
    lcd.printf(":");
    lcd.printf("%02d", min);
    lcd.printf(":");
    lcd.printf("%02d", sec);
}

void pressed()
{
    if (delay == 1.0)
    {
        delay = 0.5; // 500 ms
    }
    else
    {
        delay = 1.0; // 1 sec
        lcd.cls();
    }
}



int main() 
{
    lcd.cls();
    my_tm.twentyfour_hour();
    mybutton.fall(&pressed);
    while (1) 
    {
        myled = !myled;
        if (delay == 0.5)
        {
            my_tm.gettime(&sec, &min, &hour, &dw, &day, &month, &year);
            lcdPrintDate(0);
            lcdPrintTime(1);
            showtime = showtime + delay;
            if (showtime > 10)  // after 10 s sleep
            {
                showtime = 0.0;
                delay = 1.0;
                lcd.cls();
            }
        }
        wait(delay);
    }

}
