#include "mbed.h"
#include "EthernetInterface.h"

#define XI_FEED_ID 34525050 // set Xively Feed ID (numerical, no quoutes)
#define XI_API_KEY "MsBCnO8YoVNiDBt3X1WbO5MkxO3No2hzMNx45OwbeHf5CecZ" // set Xively API key (double-quoted string)

#include "app_board_io.h"

#include "xively.h"
#include "xi_err.h"

#include "MMA7660.h"
#include "LM75B.h"
#include "C12832_lcd.h"

LM75B tmp(p28, p27);
DigitalOut fan(p22);
PwmOut progress_led(LED1);
C12832_LCD lcd;

DigitalOut r (p23); // blue?
DigitalOut g (p24); // purple?
DigitalOut b (p25); // yellow?

#include "logo.h"

int main() {
    lcd_print_xively_logo();

    EthernetInterface eth;
      
    int s = eth.init(); //Use DHCP
    
    if( s != NULL )
    {
        lcd_printf( "Could not initialise. Will halt!\n" );        
        exit( 0 );
    }    
        
    s = eth.connect();
    
    if( s != NULL )
    {
        lcd_printf( "Could not connect. Will halt!\n" );
        exit( 0 );
    }
    else 
    {
        lcd_printf( "IP: %s\n", eth.getIPAddress() );    
    }
    
    xi_feed_t output_channels;
    memset( &output_channels, NULL, sizeof( xi_feed_t ) );
    
    output_channels.feed_id = XI_FEED_ID;
    output_channels.datastream_count = 1;
    
    output_channels.datastreams[0].datapoint_count = 1;
    xi_datastream_t* temperature_datastream = &output_channels.datastreams[0];
    strcpy( temperature_datastream->datastream_id, "temp" );
    xi_datapoint_t* temp = &temperature_datastream->datapoints[0];
    
    xi_feed_t input_channels;
    memset( &input_channels, NULL, sizeof( xi_feed_t ) );

    input_channels.feed_id = XI_FEED_ID;
    input_channels.datastream_count = 2;
    
    input_channels.datastreams[0].datapoint_count = 1;
    xi_datastream_t* fan_ctl_datastream = &input_channels.datastreams[0];
    strcpy( fan_ctl_datastream->datastream_id, "fan" );
    xi_datapoint_t* fan_ctl = &fan_ctl_datastream->datapoints[0];

    input_channels.datastreams[1].datapoint_count = 1;
    xi_datastream_t* led_ctl_datastream = &input_channels.datastreams[1];
    strcpy( led_ctl_datastream->datastream_id, "led" );
    xi_datapoint_t* led_ctl = &led_ctl_datastream->datapoints[0];
    
    // create the cosm library context
    xi_context_t* xi_context
        = xi_create_context( XI_HTTP, XI_API_KEY, output_channels.feed_id );

    // check if everything works
    if( xi_context == NULL )
    {
        return -1;
    }

    while( true ) {
      
      xi_set_value_f32( temp, tmp.read() );
        
      printf( "Updating output channels...\r\n" );
      progress_led = 0.6;
      lcd_printf( "updating...\n" );
      xi_feed_update( xi_context, &output_channels );
      progress_led = 0.1;
      printf( "   [ec:%s]\r\n", xi_get_last_error() );
    
      printf( "Reading input channels...\r\n" );
      progress_led = 0.8;
      lcd_printf( "reading...\n" );
      xi_feed_get( xi_context, &input_channels );
      progress_led = 0.1;
      printf( "   [ec:%s]\r\n", xi_get_last_error() );
      
      lcd_printf( "led: %s\nfan: %d\n", xi_value_pointer_str( led_ctl ), xi_get_value_i32( fan_ctl ) );
      
      switch( xi_get_value_i32( fan_ctl ) ) {
        case 0: fan = 0; break;
        case 1: fan = 1; break;
      }
      
      if( strcmp( xi_value_pointer_str( led_ctl ), "RED" ) == 0 )
      {
        r = 1; g = 0; b = 0;
      }
      else if( strcmp( xi_value_pointer_str( led_ctl ), "GREEN" ) == 0 )
      {
        r = 0; g = 1; b = 0;
      }
      else if( strcmp( xi_value_pointer_str( led_ctl ), "BLUE" ) == 0 )
      {
        r = 0; g = 0; b = 1;
      }
      else /* OFF */
      {
        r = 0; g = 0; b = 0;
      }
      
      wait( 5.0 );
      progress_led = 0;
    }
}
