// Student Side.

#include "mbed.h"

#include "SDFileSystem.h"
#include "wave_player.h"
#include "game_synchronizer.h"
#include "globals.h"
#include "playSound.h"
#include "rtos.h"
#include "uLCD_4DGL.h"
#define VOLUME 0.03
#define BPM 100.0


Serial pc(USBTX, USBRX);                    // Serial connection to PC. Useful for debugging!
MMA8452 acc(p28, p27, 100000);              // Accelerometer (SDA, SCL, Baudrate)
uLCD_4DGL uLCD(p9,p10,p11);                 // LCD (tx, rx, reset)
SDFileSystem sd(p5, p6, p7, p8, "sd");      // SD  (mosi, miso, sck, cs)
AnalogOut DACout(p18);                      // speaker
wave_player player(&DACout);                // wav player

DigitalIn pb_u(p22);                        // Up Button
DigitalIn pb_r(p24);                        // Right Button
DigitalIn pb_d(p23);                        // Down Button
DigitalIn pb_l(p21);                        // Left Button
DigitalIn pb_c(p25);

PwmOut pwm_pin(p26);

//InterruptIn button(p21);

int ND=0, NU=0, NL=0, NR=0; 
int dx=6;
int dy=6;
int a,b,c,d;
int i,z;
int cc;
int w;

int N,E,S,W,N1,N2,E1,E2,S1,S2,W1,W2;

int CONVERT_24_TO_16_BPP(int col_24) {
    int p = col_24 & 0xFF;
    int g = (col_24 >> 8) & 0xFF;
    int r = (col_24 >> 16)& 0xFF;
    
    r >>= 3;
    g >>= 2;
    p >>= 3;
    
    return r<<11 | g<<5 | p;
}

bool pixel_eq(int color1, int color2) {
    return (CONVERT_24_TO_16_BPP(color1) == color2 || 
            CONVERT_24_TO_16_BPP(color2) == color1 ||
            color1 == color2);
}

/*
void thread1(void const *args)
{
    while(true) {         // thread loop
        z=rand()%8;
        pc.printf("%d ",z);
        Thread::wait(500); // wait 0.5s
        if (z==0 || z==4 || z==7){ //Move Left
                cc=cx-dx;
                a=uLCD.read_pixel(cc, cy);
                b = pixel_eq(a, BLACK);
                if (b==1){
                    uLCD.filled_rectangle(cx-3,cy-3,cx+3,cy+3, BLACK);
                    cx=cx-dx;
                    uLCD.filled_rectangle(cx-3,cy-3,cx+3,cy+3, YELLOW);
                    pc.printf("C=%d\n",cc);
                }
                t = pixel_eq(a, STONE_COLOR);

            }
        if (z==1 || z==5 ||z==6){ //Move Right
                cc=cx+dx;
                a=uLCD.read_pixel(cc, cy);
                b = pixel_eq(a, BLACK);
                if (b==1){
                    uLCD.filled_rectangle(cx-3,cy-3,cx+3,cy+3, BLACK);
                    cx=cx+dx;
                    uLCD.filled_rectangle(cx-3,cy-3,cx+3,cy+3, YELLOW);
                    pc.printf("C=%d\n",cc);
                }
                t = pixel_eq(a, STONE_COLOR);

            }
        if (z==2|| z==4 || z==5){ //Move up
                cc=cy-dy;
                a=uLCD.read_pixel(cx, cc);
                b = pixel_eq(a, BLACK);
                if (b==1){
                    uLCD.filled_rectangle(cx-3,cy-3,cx+3,cy+3, BLACK);
                    cy=cy-dy;
                    uLCD.filled_rectangle(cx-3,cy-3,cx+3,cy+3, YELLOW);
                    pc.printf("C=%d\n",cc);
                }
                t = pixel_eq(a, STONE_COLOR);

            }
        if (z==3 || z==6 || z==7){ //Move Down
                cc=cy+dy;
                a=uLCD.read_pixel(cx, cc);
                b = pixel_eq(a, BLACK);
                if (b==1){
                    uLCD.filled_rectangle(cx-3,cy-3,cx+3,cy+3, BLACK);
                    cy=cy+dy;
                    uLCD.filled_rectangle(cx-3,cy-3,cx+3,cy+3, YELLOW);
                    pc.printf("C=%d\n",cc);
                }
                t = pixel_eq(a, STONE_COLOR);

            }
    }
}
*/

/*int cl=1;

void flip(void) {
                c=x-dx;
                a=uLCD.read_pixel(c, y);
                b = TREE_COLOR;
                b = pixel_eq(a, TREE_COLOR);
                pc.printf("a= %d",a);
                pc.printf("b= %d",b);
                while (b==1){
                    c=c-dx;
                    a=uLCD.read_pixel(c, y);
                    b = pixel_eq(a, TREE_COLOR);
                    pc.printf("loop:b=%d",b);
                    }
                b = pixel_eq(a, LIGHTBLACK);
                pc.printf("a2= %d",a);
                pc.printf("b2:%d",b);
                if (b==1){
                    goto Main;
                }
                
                a=uLCD.read_pixel(x-dx, y);
                b = pixel_eq(a, BLACK);
                cl=1;
Main:
}*/

void thread1(void const *args)
{
    while(true) {         // thread loop
        playSound("/sd/wavfiles/minecraft0.wav");
    }
}


  int main(){       
Start:      uLCD.cls();
            pb_l.mode(PullUp);
            pb_r.mode(PullUp);
            pb_u.mode(PullUp);
            pb_d.mode(PullUp);
            pb_c.mode(PullUp);
            
            int x=64;
            int y=64;
            int cx=16;
            int cy=64;
            int count=0;
            int t=0;
        /*
        button.mode(PullUp);
        wait(.01);
        button.fall(&flip);
        */
        //Main outer ring
            uLCD.filled_rectangle(0,0,128,6, LIGHTBLACK);        //MAKE STONE COLOR (LIGHT GRAY)
            uLCD.filled_rectangle(0,0,6,128, LIGHTBLACK);      //STONE COLOR
            uLCD.filled_rectangle(0,122,128,128, LIGHTBLACK);       //STONE COLOR
            uLCD.filled_rectangle(122,0,128,128, LIGHTBLACK);       //STONE COLOR
        
            //inner ring
            uLCD.filled_rectangle(26,26,102,102,TREE_COLOR);
            
            //mouse
            uLCD.filled_rectangle(61,61,67,67, STONE_COLOR);
            
            //cat
            uLCD.filled_rectangle(13,61,19,67, YELLOW);
            
            Thread t1(thread1); //start thread4
            pc.printf("before main");
        
Main:  while(1) {
            
            ND=0;
            NU=0;
            NL=0;
            NR=0;
            pc.printf("aftre main");
            if (!pb_c){
                uLCD.filled_circle(x,y,.5, ex1);
                //wait(.5);
                uLCD.filled_circle(x,y,1.0, ex2);
                //wait(.5);
                uLCD.filled_circle(x,y,1.5, ex3);
                //wait(.5);
                uLCD.filled_circle(x,y,2.0, ex4);
                uLCD.filled_circle(x,y,2.5, ex1);
                uLCD.filled_circle(x,y,3.0, ex2);
                uLCD.filled_circle(x,y,3.5, ex3);
                uLCD.filled_circle(x,y,4.0, ex4);
                uLCD.filled_circle(x,y,4.5, ex1);
                uLCD.filled_circle(x,y,5.0, ex2);
                uLCD.filled_circle(x,y,5.5, ex3);
                uLCD.filled_circle(x,y,6.0, ex4);
                uLCD.filled_circle(x,y,6.5, ex1);
                uLCD.filled_circle(x,y,7.0, ex2);
                uLCD.filled_circle(x,y,7.5, ex3);
                uLCD.filled_circle(x,y,8.0, ex4);
                
                uLCD.filled_circle(x,y,8.0, BLACK);
                uLCD.filled_circle(x,y,7.5, ex3);
                //wait(.5);
                uLCD.filled_circle(x,y,7.5, BLACK);
                uLCD.filled_circle(x,y,7.0, ex2);
                //wait(.5);
                uLCD.filled_circle(x,y,7.0, BLACK);
                uLCD.filled_circle(x,y,6.5, ex1);       
                uLCD.filled_circle(x,y,6.5, BLACK);
                uLCD.filled_circle(x,y,6.0, ex3);
                //wait(.5);
                uLCD.filled_circle(x,y,6.0, BLACK);
                uLCD.filled_circle(x,y,5.5, ex2);
                //wait(.5);
                uLCD.filled_circle(x,y,5.5, BLACK);
                uLCD.filled_circle(x,y,5.0, ex1);       
                uLCD.filled_circle(x,y,5.0, BLACK);
                uLCD.filled_circle(x,y,4.5, ex3);
                //wait(.5);
                uLCD.filled_circle(x,y,4.5, BLACK);
                uLCD.filled_circle(x,y,4.0, ex2);
                //wait(.5);
                uLCD.filled_circle(x,y,4.0, BLACK);
                uLCD.filled_circle(x,y,3.5, ex1);      
                uLCD.filled_circle(x,y,3.5, BLACK);
                uLCD.filled_circle(x,y,3.0, ex3);
                //wait(.5);
                uLCD.filled_circle(x,y,3.0, BLACK);
                uLCD.filled_circle(x,y,2.5, ex2);
                //wait(.5);
                uLCD.filled_circle(x,y,2.5, BLACK);
                uLCD.filled_circle(x,y,2.0, ex1);         //
               // wait(.5);
                uLCD.filled_circle(x,y,2.0, BLACK);
                uLCD.filled_circle(x,y,1.5, ex3);
                //wait(.5);
                uLCD.filled_circle(x,y,1.5, BLACK);
                uLCD.filled_circle(x,y,1.0, ex2);
                //wait(.5);
                uLCD.filled_circle(x,y,1.0, BLACK);
                uLCD.filled_circle(x,y,.5, ex1);
                //wait(.5);
                uLCD.filled_circle(x,y,.5, BLACK);
                playSound("/sd/wavfiles/hit.wav");
                t=1;
                //wait(1);
                }
            
            if (t==1){
                uLCD.cls();
                uLCD.locate(4,2);
                uLCD.puts("GAME OVER");
                playSound("/sd/wavfiles/gameover.wav");
                t=0;
                wait(1);
                uLCD.cls();
                while (1){
                    uLCD.media_init();
                    uLCD.set_sector_address(0x003B, 0x5001);
                    uLCD.display_image(0,0);
                    if (!pb_l){
                        goto Start;
                        }
                    }

            }
            /*
            if (cl==1){
                cl=0;
                uLCD.filled_rectangle(x-3,y-3,x+3,y+3, BLACK);
                x=x-dx;
                uLCD.filled_rectangle(x-3,y-3,x+3,y+3, STONE_COLOR);
                pc.printf("C=%d\n",c);
                if (b==0){
                    uLCD.filled_rectangle(c-3,y-3,c+3,y+3,TREE_COLOR);
                }
            }*/
            if (!pb_l){ //Move Left
                c=x-dx;
                a=uLCD.read_pixel(c, y);
                b = TREE_COLOR;
                b = pixel_eq(a, TREE_COLOR);
                pc.printf("a= %d",a);
                pc.printf("b= %d",b);
                while (b==1){
                    c=c-dx;
                    a=uLCD.read_pixel(c, y);
                    b = pixel_eq(a, TREE_COLOR);
                    pc.printf("loop:b=%d",b);
                    }
                b = pixel_eq(a, LIGHTBLACK);
                w= pixel_eq(a, YELLOW);
                pc.printf("a2= %d",a);
                pc.printf("b2:%d",b);
                if (b==1||w==1){
                    goto Main;
                }
                
                a=uLCD.read_pixel(x-dx, y);
                b = pixel_eq(a, BLACK);
                
                uLCD.filled_rectangle(x-3,y-3,x+3,y+3, BLACK);
                x=x-dx;
                uLCD.filled_rectangle(x-3,y-3,x+3,y+3, STONE_COLOR);
                pc.printf("C=%d\n",c);
                if (b==0){
                    uLCD.filled_rectangle(c-3,y-3,c+3,y+3,TREE_COLOR);
                }
                
            }
            if (!pb_r){ //Move Right
                c=x+dx;
                a=uLCD.read_pixel(c, y);
                b = TREE_COLOR;
                b = pixel_eq(a, TREE_COLOR);
                pc.printf("a= %d",a);
                pc.printf("b= %d",b);
                while (b==1){
                    c=c+dx;
                    a=uLCD.read_pixel(c, y);
                    b = pixel_eq(a, TREE_COLOR);
                    pc.printf("loop:b=%d",b);
                    }
                b = pixel_eq(a, LIGHTBLACK);
                w= pixel_eq(a, YELLOW);
                pc.printf("a2= %d",a);
                pc.printf("b2:%d",b);
                if (b==1||w==1){
                    goto Main;
                }
                a=uLCD.read_pixel(x+dx, y);
                b = pixel_eq(a, BLACK);
                
                uLCD.filled_rectangle(x-3,y-3,x+3,y+3, BLACK);
                x=x+dx;
                uLCD.filled_rectangle(x-3,y-3,x+3,y+3, STONE_COLOR);
                pc.printf("C=%d\n",c);
                
                if (b==0){
                    uLCD.filled_rectangle(c-3,y-3,c+3,y+3,TREE_COLOR);
                }
        }
            if (!pb_d){ //Move Right
                c=y+dy;
                a=uLCD.read_pixel(x, c);
                b = TREE_COLOR;
                b = pixel_eq(a, TREE_COLOR);
                pc.printf("a= %d",a);
                pc.printf("b= %d",b);
                while (b==1){
                    c=c+dy;
                    a=uLCD.read_pixel(x, c);
                    b = pixel_eq(a, TREE_COLOR);
                    pc.printf("loop:b=%d",b);
                    }
                b = pixel_eq(a, LIGHTBLACK);
                w= pixel_eq(a, YELLOW);
                pc.printf("a2= %d",a);
                pc.printf("b2:%d",b);
                if (b==1||w==1){
                    goto Main;
                }
                a=uLCD.read_pixel(x, y+dy);
                b = pixel_eq(a, BLACK);
                
                uLCD.filled_rectangle(x-3,y-3,x+3,y+3, BLACK);
                y=y+dy;
                uLCD.filled_rectangle(x-3,y-3,x+3,y+3, STONE_COLOR);
                pc.printf("C=%d\n",c);
                
                if (b==0){
                    uLCD.filled_rectangle(x-3,c-3,x+3,c+3,TREE_COLOR);
                }
        }   
            if (!pb_u){ //Move Right
                c=y-dy;
                a=uLCD.read_pixel(x, c);
                b = TREE_COLOR;
                b = pixel_eq(a, TREE_COLOR);
                pc.printf("a= %d",a);
                pc.printf("b= %d",b);
                while (b==1){
                    c=c-dy;
                    a=uLCD.read_pixel(x, c);
                    b = pixel_eq(a, TREE_COLOR);
                    pc.printf("loop:b=%d",b);
                    }
                b = pixel_eq(a, LIGHTBLACK);
                w= pixel_eq(a, YELLOW);
                pc.printf("a2= %d",a);
                pc.printf("b2:%d",b);
                if (b==1||w==1){
                    goto Main;
                }
                a=uLCD.read_pixel(x, y-dy);
                b = pixel_eq(a, BLACK);
                
                uLCD.filled_rectangle(x-3,y-3,x+3,y+3, BLACK);
                y=y-dy;
                uLCD.filled_rectangle(x-3,y-3,x+3,y+3, STONE_COLOR);
                pc.printf("C=%d\n",c);
                
                if (b==0){
                    uLCD.filled_rectangle(x-3,c-3,x+3,c+3,TREE_COLOR);
                    pc.printf("b2=0 loop"); 
                }
        }   
        
        //Cat Code 
        z=rand()%8;
        pc.printf("%d ",z);
        wait(.005);
        if (z==0 || z==4 || z==7){ //Move Left
               
                cc=cx-dx;
                a=uLCD.read_pixel(cc, cy);
                NL = pixel_eq(a, BLACK);
                if (NL==1){
                    uLCD.filled_rectangle(cx-3,cy-3,cx+3,cy+3, BLACK);
                    cx=cx-dx;
                    uLCD.filled_rectangle(cx-3,cy-3,cx+3,cy+3, YELLOW);
                    pc.printf("C=%d\n",cc);
                }

                t = pixel_eq(a, STONE_COLOR);

            }
        if (z==1 || z==5 ||z==6){ //Move Right
                cc=cx+dx;
                a=uLCD.read_pixel(cc, cy);
                NR = pixel_eq(a, BLACK);
                if (NR==1){
                    uLCD.filled_rectangle(cx-3,cy-3,cx+3,cy+3, BLACK);
                    cx=cx+dx;
                    uLCD.filled_rectangle(cx-3,cy-3,cx+3,cy+3, YELLOW);
                    pc.printf("C=%d\n",cc);
                }

                t = pixel_eq(a, STONE_COLOR);

            }
        if (z==2|| z==4 || z==5){ //Move up
                cc=cy-dy;
                a=uLCD.read_pixel(cx, cc);
                NU = pixel_eq(a, BLACK);
                if (NU==1){
                    uLCD.filled_rectangle(cx-3,cy-3,cx+3,cy+3, BLACK);
                    cy=cy-dy;
                    uLCD.filled_rectangle(cx-3,cy-3,cx+3,cy+3, YELLOW);
                    pc.printf("C=%d\n",cc);
                }
              
                t = pixel_eq(a, STONE_COLOR);

            }
        if (z==3 || z==6 || z==7){ //Move Down
                cc=cy+dy;
                a=uLCD.read_pixel(cx, cc);
                ND = pixel_eq(a, BLACK);
                if (ND==1){
                    uLCD.filled_rectangle(cx-3,cy-3,cx+3,cy+3, BLACK);
                    cy=cy+dy;
                    uLCD.filled_rectangle(cx-3,cy-3,cx+3,cy+3, YELLOW);
                    pc.printf("C=%d\n",cc);
                }

                t = pixel_eq(a, STONE_COLOR);

            }
            
            //CHECK PICS AROUND CAT
            N=uLCD.read_pixel(cx, cy+6);
            N1 = pixel_eq(N, TREE_COLOR);
            N2 = pixel_eq(N, LIGHTBLACK);
            if (N1==1||N2==1){
                NU=2;
                }
            S=uLCD.read_pixel(cx, cy-6);
            S1 = pixel_eq(S, TREE_COLOR);
            S2 = pixel_eq(S, LIGHTBLACK);
            if (S1==1||S2==1){
                ND=2;
                }
            E=uLCD.read_pixel(cx+6, cy);
            E1 = pixel_eq(E, TREE_COLOR);
            E2 = pixel_eq(E, LIGHTBLACK);
            if (E1==1||E2==1){
                NR=2;
                }
            W=uLCD.read_pixel(cx-6, cy);
            W1 = pixel_eq(W, TREE_COLOR);
            W2 = pixel_eq(W, LIGHTBLACK);
            if (W1==1||W2==1){
                NL=2;
                }
                
        pc.printf("NR=%d",NR);
        pc.printf("NL=%d", NL);
        pc.printf("NU=%d", NU);
        pc.printf("ND=%d", ND);
        if (NL==2 && NR==2 && NU==2 && ND==2){
            uLCD.filled_rectangle(cx-3,cy-3,cx+3,cy+3, TANK_RED);
            count++;
            if (count==1){
                wait(3);
                uLCD.cls();
                uLCD.locate(4,2);
                uLCD.puts("Winner!!");
                t=0;
                wait(3);
                while (1){
                    if (!pb_l){
                        goto Start;
                    }
                }
                }
                  
            }         
        }    
    }
