#include "mbed.h"
#include "uLCD_4DGL.h"
#include "rtos.h"
#include "stdio.h"
#include "max31855.h"

uLCD_4DGL uLCD(p9,p10,p11); // serial tx, serial rx, reset pin;
SPI thermoSPI(p5,p6,p7); // setup SPI interface
max31855 max1(thermoSPI, p20); //setup max31855 interface
Mutex lcd_mutex; // mutex to make the lcd lib thread safe
Semaphore four_slots(1); //Activate semaphore


// Thread t1
//  print the elapsed time on line 1 of the uLCD (i.e., HH:MM:SS)
void elapsedtime(void const *args) { //line 2
    int s = 00;
    int m = 00;
    int h = 00;
    
    while(true){
        s++;
        if(s>59){
           s=00;
          m++;
         }
         if(m>59){
           m=00;
           h++;
         }
       four_slots.wait();
       //lcd_mutex.lock();
        uLCD.color(0xFFFF00);
        uLCD.locate(0,0); //col,row
        wait(0.1);
        uLCD.printf("ET: %2d:%2d:%2d", h,m,s);
        //lcd_mutex.unlock();
        four_slots.release();
        Thread::wait(1000); // update once per secon
    }
}


// Thread t2
//  print the temperature from the thermocouple - MAX31855 device
void thermoread(void const *args) { //line 2
    
    float ftemperature = 0; // float variable for temperature
    float ctemperature = 0; // float variable for temperature
    while(true){
        if (max1.ready()==1){
            ctemperature = max1.read_temp(); //Get the reading
            ftemperature = (ctemperature)*(9.0/5.0)+32.0;
            four_slots.wait();    
            uLCD.color(0xFFFF00);
            uLCD.locate(0,2); //col,row
            wait(0.1);
            uLCD.printf("Temp. F: %4.2f", ftemperature);
            uLCD.color(0xFFFF00);
            uLCD.locate(0,4); //col,row
            wait(0.1);
            uLCD.printf("Temp. C: %4.2f", ctemperature);
            four_slots.release();
        
        }
    }
}
 

int main() {
    max1.initialise(); //initialize thermocouple IC    
    uLCD.baudrate(3000000); //set LCD baudrate
    Thread t1(elapsedtime); //run elapsed time counter
    Thread t2(thermoread); //read and display temperature from thermocouple
    
    while(1){ //While so program doesn't end

        }
}
