#include "mbed.h"
#include "uLCD_4DGL.h"
#include "rtos.h"
#include "stdio.h"
#include "max31855.h"
#include <mpr121.h>
#include "Stopwatch.h"


DigitalOut toggle(p30); // toggle for Nichrome wire SSR
DigitalIn up(p19); // User reset button
DigitalOut motor(p22); // motor control

uLCD_4DGL uLCD(p9,p10,p11); // serial tx, serial rx, reset pin;
SPI thermoSPI(p5,p6,p7); // setup SPI interface
max31855 max1(thermoSPI, p20); //setup max31855 interface
InterruptIn interrupt(p26); // Create the interrupt receiver object on pin 26
I2C i2c(p28, p27); // Setup the i2c bus on pins 28 and 27
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS); // Setup the Mpr121: // constructor(i2c object, i2c address of the mpr121)

Mutex lcd_mutex; // mutex to make the lcd lib thread safe
Semaphore four_slots(1); //Activate semaphore
Stopwatch watch = Stopwatch();

int settemp = 1; // initial temperature set
float ftemperature = 0; // float variable for temperature
float ctemperature = 0; // float variable for temperature
int temptemp=1;
int key_code=-1;
int a =0;
int place= 100;
int s = 00;
int m = 00;
int h = 00;


// Thread 1: run stopwatch timer
void elapsedtime(void const *args)   //elapsed timer for when program starts
{
    watch.start();
}


// Thread 2: print the temperature from the thermocouple - MAX31855 device
void thermoread(void const *args)   //line 2
{
    while(true) {
        if (max1.ready()==1) {
            ctemperature = max1.read_temp(); //Get the reading in celsius 
            ftemperature = (ctemperature)*(9.0/5.0)+32.0; //Get the reading in fahrenheit
        }
    }
}


// Thread 3: reset temp
void thermoset(void const *args)   //line 2
{
    while(true) {
        if(up == 1) {
            a = 0;
            temptemp=0;
            while(a<3) { //USER MUST INPUT 3 NUMBERS
                if(key_code>=0 && key_code<=9) {
                    wait(.1);
                    if(a==0)temptemp=key_code*100;
                    if(a==1)temptemp+=key_code*10;
                    if(a==2)temptemp+=key_code*1;
                    a++;
                    key_code = -1; //clear keycode
                }
            }
            settemp=temptemp;
        }
    }
}


void fallInterrupt()
{
    int i=0;
    int value=mpr121.read(0x00);
    value +=mpr121.read(0x01)<<8;
    i=0;
    for (i=0; i<12; i++) {     // puts key number out to 0-12 digits
        if (((value>>i)&0x01)==1) key_code=i;
    }
    if(key_code== 10) {
        motor = 0;
    }
    if(key_code== 11) {
        motor = 1;
    }
}


int main()
{
    max1.initialise(); //initialize thermocouple IC
    uLCD.baudrate(3000000); //set LCD baudrate
    interrupt.fall(&fallInterrupt);
    interrupt.mode(PullUp);
    Thread t1(elapsedtime); //run elapsed time counter
    Thread t2(thermoread); //read and display temperature from thermocouple
    Thread t3(thermoset); // user set temperature

    while(1) { //hystersis program
        char* time = watch.getTime();
        four_slots.wait(); //lock screen
        uLCD.color(0xFFFF00); //set color
        uLCD.locate(0,0); //col,row for time
        uLCD.printf("Time    | %s",time);//%2d:%2d:%2d", h,m,s); // display time
        uLCD.locate(0,5);
        uLCD.printf("Set     | %3d",settemp); // current set temperature
        uLCD.locate(0,6);
        uLCD.printf("Current | %4.2f", ftemperature); // temperature reading
        uLCD.locate(0,2);
        uLCD.printf("Motor   | "); //motor state in "on" or "off" state
        uLCD.locate(0,13);
        uLCD.printf("New Temp| %3d",temptemp); //new user temperature
        if(motor==0) {
            uLCD.locate(11,2); //col,row
            uLCD.printf("OFF");
        }
        if(motor==1) {
            uLCD.locate(11,2); //col,row
            uLCD.printf("ON ");
        }
        four_slots.release(); // release screen resource
        if(ftemperature < settemp-1) { //condition for 1 degree under
            toggle=1; //turn on ssr for nichrome wire
        }
        if(ftemperature > settemp-1) {
            toggle=0; //turn off ssr for nichrome wire
        }
    }
}
