#include "mbed.h"
#include "uLCD_4DGL.h"
#include "rtos.h"
#include "stdio.h"
#include "max31855.h"
#include <mpr121.h>

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4); 
DigitalOut motor(p22); // motor control

uLCD_4DGL uLCD(p9,p10,p11); // serial tx, serial rx, reset pin;
SPI thermoSPI(p5,p6,p7); // setup SPI interface
max31855 max1(thermoSPI, p20); //setup max31855 interface
Mutex lcd_mutex; // mutex to make the lcd lib thread safe
Semaphore four_slots(1); //Activate semaphore
DigitalOut toggle(p30); // toggle for Nichrome wire SSR
DigitalIn up(p19); // User pushbutton up controller
DigitalIn down(p18); // User pushbutton down button controller


int settemp = 85; // initial temperature set
float ftemperature = 0; // float variable for temperature
float ctemperature = 0; // float variable for temperature

int key_code=0;


// Create the interrupt receiver object on pin 26
InterruptIn interrupt(p26);

// Setup the i2c bus on pins 28 and 27
I2C i2c(p28, p27);

// Setup the Mpr121:
// constructor(i2c object, i2c address of the mpr121)
Mpr121 mpr121(&i2c, Mpr121::ADD_VSS);

// Thread 1: print the elapsed time on line 1 of the uLCD (i.e., HH:MM:SS)
void elapsedtime(void const *args) { //elapsed timer for when program starts
    int s = 00; //seconds
    int m = 00; //minutes 
    int h = 00; //hours
    
    while(true){
        s++; 
        if(s>59){
           s=00;
          m++;
         }
         if(m>59){
           m=00;
           h++;
         }
       four_slots.wait(); // lock screen resource
       //lcd_mutex.lock();
        uLCD.color(0xFFFF00); //set text color
        uLCD.locate(0,0); //col,row location of text
        wait(0.1); 
        uLCD.printf("ET: %2d:%2d:%2d", h,m,s); // display time
        //lcd_mutex.unlock();
        four_slots.release(); //unlock screen resource
        Thread::wait(1000); // update once per secon
    }
}


// Thread 2: print the temperature from the thermocouple - MAX31855 device
void thermoread(void const *args) { //line 2
    while(true){
        if (max1.ready()==1){
            ctemperature = max1.read_temp(); //Get the reading
            ftemperature = (ctemperature)*(9.0/5.0)+32.0;
            four_slots.wait();    
            uLCD.color(0xFFFF00);
            uLCD.locate(0,2); //col,row
            wait(0.1);
            uLCD.printf("Current Temp. F");
            uLCD.locate(0,3); //col,row
            uLCD.printf("%4.2f", ftemperature);
            four_slots.release(); 
        }
    }
}


void fallInterrupt() {
  int i=0;
  int value=mpr121.read(0x00);
  value +=mpr121.read(0x01)<<8;
  // LED demo mod
  i=0;
  // puts key number out to LEDs for demo
  for (i=0; i<12; i++) {
  if (((value>>i)&0x01)==1) key_code=i+1;
  }
}


int main() {
    max1.initialise(); //initialize thermocouple IC    
    uLCD.baudrate(3000000); //set LCD baudrate
    
    interrupt.fall(&fallInterrupt);
    interrupt.mode(PullUp);
    
    Thread t1(elapsedtime); //run elapsed time counter
    Thread t2(thermoread); //read and display temperature from thermocouple
    
    while(1){ //hystersis program
        key_code = 0;
        four_slots.wait();    
        uLCD.color(0xFFFF00);
        uLCD.locate(0,10); //col,row
        //wait(0.1);
        uLCD.printf("Test.");
        uLCD.locate(0,11); //col,row
        uLCD.printf("%2d", key_code);
        four_slots.release(); 
             
        if(key_code == 2){
            settemp += 1;
            four_slots.wait();    
            uLCD.color(0xFFFF00);        
            uLCD.locate(0,5); //col,row
            uLCD.printf("Set Temp. F");
            uLCD.locate(0,6); //col,row
            uLCD.printf("%d",settemp);
            four_slots.release();   
            wait(2);
        }
        if(key_code== 1){
            settemp -= 1;
            four_slots.wait();    
            uLCD.color(0xFFFF00);        
            uLCD.locate(0,5); //col,row
            uLCD.printf("Set Temp. F");
            uLCD.locate(0,6); //col,row
            uLCD.printf("%d",settemp);
            four_slots.release();
        }
        
        if(key_code== 9){
            motor = 0;
            settemp -= 1;
            four_slots.wait();    
            uLCD.color(0xFFFF00);        
            uLCD.locate(0,13); //col,row
            uLCD.printf("Motor is OFF");
            four_slots.release();
        }
         if(key_code== 10){
            motor = 1;
            settemp -= 1;
            four_slots.wait();    
            uLCD.color(0xFFFF00);        
            uLCD.locate(0,13); //col,row
            uLCD.printf("Motor is ON ");
            four_slots.release();
        }
    
        if(ftemperature < settemp-1){ //condition for 1 degree under
            toggle=1; //turn on ssr for nichrome wire
        }
        if(ftemperature > settemp+1){  //condition for 1 degree over
            toggle=0; //turn off ssr for nichrome wire
        }
        // wait(.1); //check every 1 second
    }
}
