/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "GPS.h"


GPS gps(PG_14, PG_9);


int main()
{
    // Initialise the digital pin LED1 as an output
    DigitalOut led(LED1);


    while (true) {
        
        bool update = gps.updateCheck();
        if (update) {
            int time = gps.getTime();
            int latitude = static_cast<int>(gps.getLat() * 100000.0f);
            int longitude = static_cast<int>(gps.getLong() * 100000.0f);
            int speed = static_cast<int>(gps.getSpeed() * 100.0f);
            int hdop = static_cast<int>(gps.getHDOP() * 10.0f);
            int sats = gps.getSats();

            printf("time:%d lat:%d long:%d speed:%d hdop:%d sats:%d\r\n", time, latitude, longitude, speed, hdop, sats);
            led = !led;
        }
        ThisThread::sleep_for(100ms);
        
    }
}
